<?php
//require_once("//includes/html/classes/Cpage_mix.class.php");//auto
class Cmodule {
	var $nom = "module sans nom";
	var $identifiant = "identifiant_inexistant" ;
	var $include_rep = "modules/";
	var $modules_dependants = array();
	static $configs = "";

	public $module_visible = false;

	/**
	 * liste en vrac des modules
	 * index du tableau : l'identifiant du module
	 */
	static $liste_modules = array();
	/**
	 * liste des modules pen vue de leur création (identifiant, include,nom_clase,importance
	 * @var unknown_type
	 */
	static $liste_modules_sources = array();
	/**
	 * INDEX DES importances des MODULES, servant au tri.
	 * $index_modules_tries[$id_module]=$importance
	 */
	static $index_modules_tries = array();


	function Cmodule($rep_base) {
		$this->include_rep=$rep_base;
		$this->__init();
	}

	protected function __init() {

	}
	
	protected function __init_apres_action() {
		
	}
	
	function getCrons() {
	}
	
	function get_path() {
		return $this->include_rep.$this->identifiant."/";
	}
	/*
	 * static
	 */

	static function set_module_visible($id_module) {
		if(self::module_existe($id_module)) {
			$mod = self::get_module($id_module);
			$mod->module_visible = true;
		}
	}
	/**
	 * parcourt tous les modules installés, par ordre d'installation (base en 1er).
	 * Si un module retourne ===false, la boucle est stoppée
	 * @param $nom_fonction
	 * @return unknown_type
	 */
	static function dispatch_fonction($nom_fonction) {
		$retours=array();
		$arguments= func_get_args () ;
		array_shift($arguments);
		foreach(Cmodule::$liste_modules as $module) {
			$res = call_user_func_array(array($module,$nom_fonction),$arguments);

			//$res=$module->{$nom_fonction}($arguments[0],$arguments[1],$arguments[2],$arguments[3],$arguments[4]);
			$retours[]=$res;

			if($res===false)
			break;
		}
		return $retours;
	}

	/**
	 * parcourt tous les modules installés, par ordre d'importance.
	 * Si un module retourne ===false, la boucle est stoppée
	 * @param $nom_fonction
	 * @return unknown_type
	 */
	static function dispatch_fonction_importance($nom_fonction) {
		$retours=array();
		$arguments= func_get_args () ;
		array_shift($arguments); // retire $nom_fonction
		foreach(Cmodule::$index_modules_tries as $index_module=>$importance) {
			$module=Cmodule::$liste_modules[$index_module];

			//			echo "$module->identifiant,$nom_fonction";
			$res = call_user_func_array(array($module,$nom_fonction),$arguments);

			//$res=$module->{$nom_fonction}($arguments[0],$arguments[1],$arguments[2],$arguments[3],$arguments[4]);
			$retours[$index_module]=$res;
			if($res===false) {
				break;
			}

		} //print_rr($retours);
		return $retours;
	}

	/**
	 * appelle une fonction d'un module spécifié
	 * @param $id_module = "base"
	 * @param $nom_fonction
	 * @return unknown_type = le retour de la fonction
	 */
	static function dispatch_fonction_module($id_module,$nom_fonction) {
		$arguments= func_get_args () ;
		array_shift($arguments);
		array_shift($arguments);
		$module=Cmodule::$liste_modules[$id_module];

		//		$retour=implode("",call_user_func_array(array("Cmodule","dispatch_fonction_importance"),$parametres_fonction));
		if($module && method_exists($module,$nom_fonction)) {
			return call_user_func_array(array($module,$nom_fonction),$arguments);
		}
		//return $module->{$nom_fonction}($arguments[0],$arguments[1],$arguments[2],$arguments[3],$arguments[4]);
	}

	static function insere_js($id_module,$fichier) {
		$retour="<script type=\"text/javascript\">";
		$module=Cmodule::get_module($id_module);
		$retour.=$module->file_get_contents($fichier);

		$retour.="</script>";
		return $retour;
	}

	static function get_module($id_module) {
		if(isset(Cmodule::$liste_modules[$id_module])){
			return Cmodule::$liste_modules[$id_module];
		}
		if(isset(Cmodule::$liste_modules_sources[$id_module])) {
			$desc_module = Cmodule::$liste_modules_sources[$id_module];
			include_once($desc_module["chemin"]);
			$nom_module=$desc_module["nom_classe"];
			$nouveau_module=new $nom_module($desc_module["repertoire_classe"]);
			Cmodule::$liste_modules[$id_module]=$nouveau_module;
			return $nouveau_module;
		}

		//		return Cmodule::$liste_modules[$id_module];
	}

	static function getModules() {
		return self::$liste_modules;
	}

	static function ajoute_module($id_module,$importance=0,$repertoire_classe="modules/",$cree=false) {
		if(!Cmodule::module_existe($id_module)) {
			$rep_module="$repertoire_classe$id_module/Cmodule_$id_module.class.php";
			$nom_module="Cmodule_$id_module";

			include_once($rep_module);
			$nouveau_module=new $nom_module($repertoire_classe);

//			self::ajouteLigneConfigAvant("include_once(\"$rep_module\");");
			self::ajouteLigneConfig("Cmodule::preindexeModule('$id_module','$rep_module','$nom_module','$importance','$repertoire_classe');");

			Cmodule::indexeModule($nouveau_module,$importance);
				

			/*Cmodule::$liste_modules[$id_module]=$nouveau_module;
			 Cmodule::$index_modules_tries[$id_module]=$importance;*/
			if(count($nouveau_module->modules_dependants)>0) {
				foreach($nouveau_module->modules_dependants as $id_module_dep) {
					Cmodule::ajoute_module($id_module_dep);
				}
			}
			arsort(Cmodule::$index_modules_tries);
			snapTimer("ajoute_module($id_module)");
		}
	}

	static function indexeModule($module,$importance) {
		$id_module=$module->identifiant;
		Cmodule::$liste_modules[$id_module]=$module;
		Cmodule::$index_modules_tries[$id_module]=$importance;
	}

	static function preindexeModule($id_module,$chemin,$nom_classe,$importance,$repertoire_classe,$auto_init = 0) {
		Cmodule::$liste_modules_sources[$id_module]=array("chemin"=>$chemin,
														"nom_classe"=>$nom_classe,
														"importance"=>$importance,
														"repertoire_classe"=>$repertoire_classe);
		self::indexeModule(self::get_module($id_module),$importance);
	}

	static function getStrConfig() {
		self::ajouteLigneConfig("arsort(Cmodule::\$index_modules_tries);");
		echo "<pre>".self::$configs."</pre>";
		return self::$configs;
	}

	static function ajouteLigneConfig($str) {
		self::$configs.=$str."\n";
	}
	static function ajouteLigneConfigAvant($str) {
		self::$configs=$str."\n".self::$configs;
	}

	static function module_existe($id_module) {
		return isset(Cmodule::$liste_modules[$id_module]);
	}
	/*
	 * pas static
	 */


	final function __install() {
		include_once 'includes/BDD/bdd_maj.inc.php';
		Crapport::begin_bloc("<br>Installation module ".$this->identifiant,1,"bleu");
		$this->__creation_tables();
		$this->__modifications_tables();
		Crapport::end_bloc(1);
	}
	function __installe_pages() {

	}
	function __creation_tables() {
		global $id_boutique;
		if(file_exists($f=$this->include_rep.$this->identifiant."/install_".$this->identifiant.".inc.php"))

		include_once($f);
	}

	function __modifications_tables() {
		global $id_boutique;
		if(file_exists($f=$this->include_rep.$this->identifiant."/modifs_".$this->identifiant.".inc.php"))
		include_once($f);
	}

	final function __uninstall() {

	}

	final function JS_files() {
		$js_f=$this->__get_JS_files();
		CSite::ajouteJS($js_f);
		return "";
		//		$retour=array();
		//		foreach($js_f as $f) {
		//			$retour[]="<script type=\"text/javascript\" src=\"/js/$f\"></script>\n";
		//		}
		//		return implode("",$retour);;
	}
	function __get_JS_files() {
		return array();
	}

	final function CSS_files() {
		$js_f=$this->__get_CSS_files();
		CSite::ajouteCSS($js_f);
		return "";
		/*
		 $retour=array();
		 foreach($js_f as $f) {
			$retour[]="<link href=\"/css/$f\" rel=\"stylesheet\" type=\"text/css\" />\n";

			}
			return implode("",$retour);*/
	}
	function __get_CSS_files() {
		return array();
	}
	/*
	 *
	 *
	 *
	 * fonctions d'actions des modules
	 *
	 *
	 *
	 */

	/**
	 * vérifie que le module est apte a recevoir la requete. Si oui, on déclenche "switch_action" du module
	 *
	 * @return false pour stopper les modules suivants (dispatch)
	 */
	final function switch_action_module($module,$action) {
		// $action_module="utilisateurs.xxx";
		//		echo "switch_action_module $module $action".$this->identifiant;
		//TODO : ne jamais remettre cette ligne, sinon les actions faites 2 fois
		//if(($module == $this->identifiant) || ($this->identifiant == CLIENT)){
		if($module == $this->identifiant){
			//			echo "je fais, $this->identifiant";
			return ($this->switch_action($action,$module)!==true);
		}
	}
	/**
	 * exécute une action demandée
	 *
	 * @return false pour stopper la boucle des modules
	 */
	function switch_action($action,$module="") {
		$split=explode(".",$action);
		if(count($split)>=2 ) {
			// sous-classe
			$nom_fonction=array_pop($split);
			ereg("([^(]*)([(]([^)]*)[)]?)?",$nom_fonction,$detail);
			/* Array
				(
				[0] => compile_stats_veille(1,2,3,coucou)
				[1] => compile_stats_veille
				[2] => (1,2,3,coucou)
				[3] => 1,2,3,coucou
				)			 */
			$nom_fonction=$detail[1];
			if($detail[3]!="")
			$parametres=explode(",",$detail[3]);
			$nom_classe=array_pop($split);
			array_unshift($split,"classes");
			$rep=implode("/",$split);
			if(file_exists($this->include_rep.$this->identifiant."/$rep/$nom_classe.class.php")) {
//				include_once $this->include_rep.$this->identifiant."/$rep/$nom_classe.class.php";//auto
				return call_user_func(array($nom_classe,$nom_fonction),$parametres);

				/*$cl=new $nom_classe();
				 return $cl->{$nom_fonction}();*/
			}
		} else {
			// 'tention a la boucle !
			//			$retour=Cmodule::dispatch_fonction_module($module,"switch_action", $action,$module);
			//			if(!$retour) {
			return Cmodule::dispatch_fonction_module($module, $action);
			//			}
		}
		Crapport::trace("switch_action ".$this->identifiant." non défini ($action)");
	}




	/*
	 *
	 *
	 *
	 * fonctions de navigation du site
	 *
	 *
	 *
	 */
	/*public function affichePage($page_demandee) {
		$page_affichee = $this->getPageAffichee($page_demandee);
		Crapport::trace("affiche page module '".$this->identifiant."' : $page_demandee -> $page_affichee");
		if(strlen($page_affichee)>0) {
		echo $this->get_page_html($page_affichee);
		//CSite::affichePageSite($page_affichee);
		return false;
		}
		}
		*/
	function get_page_html($fichier) {
		$extension=substr($fichier,strrpos($fichier,".")+1);
		$fichier_complet=$this->include_rep.$this->identifiant."/www$fichier";
					
		if(file_exists($fichier_complet)) {
			switch($extension) {
				case "php":
					include($fichier_complet);
					break;
				case "php":
				case "html":
				case "htm":
					// recup le fichier
					$retour=(file_get_contents_html($fichier_complet));
					//voit si besoin blocs spéciaux des modules
					Cmodule::ajoute_blocs_html_modules($retour);
					echo $retour;
					break;
			}
		} else {
			if(DEBUGGER) {
				CSite::quick_rapport("erreur 404","erreur 404<br>affichePageSite($fichier)<br>$fichier_complet<br>CLIENT : ".CLIENT."<br>SERVEUR : ".SERVEUR);
			}
			//include_once 'modules/site/classes/CSitemap.class.php';//auto
			CSitemap::efface_url_en_cours_sitemap();
			CSite::erreur404();
		}
	}


	public function file_exists($fichier) {
		return (file_exists($this->file_get_path($fichier)));
	}
	
	/**
	 * renvoie un chemin de fichier d'un module, ou sa version mobile si elle existe
	 * @param $fichier
	 */
	public function file_get_path($fichier) {
		
		$fichier=ltrim($fichier,"/");
		
		if (MOBILE_VERSION === true) {
			$repMobile=$this->include_rep.$this->identifiant.'/www/'.Cmodule_mobile::getPathMobile();

			if(file_exists($repMobile.$fichier))
				return $repMobile.$fichier;
		}
		
		
		$rep=$this->include_rep.$this->identifiant."/www/";
		return $rep.$fichier;
	}
	/**
	 * renvoie le contenu d'un fichier du le module, ou sa version mobile si elle existe
	 */
	public function file_get_contents($fichier,$silent=false) {

		$fichier=ltrim($fichier,"/");
		$rep=$this->include_rep.$this->identifiant."/www/";
		
		//echo $rep.$fichier.'<br>';
		
		if (MOBILE_VERSION === true) {
			$repMobile=$this->include_rep.$this->identifiant.'/www/'.Cmodule_mobile::getPathMobile();

			if(file_exists($repMobile.$fichier))
				return (file_get_contents_ML($repMobile.$fichier));
		}
			
		if(file_exists($rep.$fichier))
			return (file_get_contents_ML($rep.$fichier));
			
		if(DEBUGGER && (!$silent))
		trace_erreur("---=== ".$this->identifiant."->file_get_contents('$rep$fichier') ===---");
		//return "---=== ".$this->identifiant."->file_get_contents('$rep$fichier') ===---";
		return "";
	}
	public function file_get_contents_silent($fichier) {
		return $this->file_get_contents($fichier,true);
	}
	/**
	 * affiche un fichier pris dans le module
	 * et lui applique les balises html
	 */
	public function file_get_contents_html($fichier) {
		$str=$this->file_get_contents($fichier);
		return Cmodule::ajoute_blocs_html_modules($str);
	}


	public function get_image($fichier) {
		$fichier=ltrim($fichier,"/");
		$rep=$this->include_rep.$this->identifiant."/www/";
		//include_once 'modules/base/classes/CImages.class.php';//auto
		$fichier_final = CImages::getImageRedimensionnee($rep.$fichier);
		if(file_exists($fichier_final)) {
			return file_get_contents($fichier_final);
		}
		CSite::erreur404();
	}

	static function ajoute_blocs_html_modules(&$str) {
		//trace($str);
		$patern="({#(([*a-z0-9A-Z_.]*)([\(]([^}]*)[\)])?)#})";
		$str=preg_replace_callback($patern,array('Cmodule',"remplace_bloc_preg"),$str);
		return $str;
	}
	static function remplace_bloc_preg($res_preg) {
		// $res_preg=["{#xxx#}","xxx"];
		$nom_bloc=$res_preg[1];

		preg_match("(([*a-z0-9A-Z_.]*)([\(](.*)[\)])?)",$nom_bloc,$detail);

		$detail[3] =  CSite::remplace_params_page($detail[3]);

		$parametres_fonction=explode(",",$detail[3]);


		$nom_bloc=$detail[1];

		//echo $nom_bloc;
		$split=explode(".",$nom_bloc);
		// pas de module => module CLIENT
		if(count($split)==1) {
			$bloc=$nom_bloc;
			$id_module = CLIENT;
		} else {
			$id_module=array_shift($split);
			$bloc=implode(".",$split);
		}
		// "CLIENT" => client en cours
		if($id_module=="CLIENT") {
			$id_module=CLIENT;
		}
		if($id_module=="*") {
			//$retour="555555";
			//			echo "disp $bloc";
			array_unshift($parametres_fonction,$bloc);
			array_unshift($parametres_fonction,"get_bloc_html");
			$retour=implode("",call_user_func_array(array("Cmodule","dispatch_fonction_importance"),$parametres_fonction));
			//$retour=implode("",Cmodule::dispatch_fonction_importance("get_bloc_html",$bloc,$parametres_fonction[0],$parametres_fonction[1],$parametres_fonction[2],$parametres_fonction[3]));
			Cmodule::ajoute_blocs_html_modules($retour);
			return $retour;

		} else if($module=Cmodule::get_module($id_module)) {
			//print_rr($parametres_fonction);
			$retour=$module->get_bloc_html($bloc,$parametres_fonction);
			Cmodule::ajoute_blocs_html_modules($retour);
			return $retour;

		}
		return "";
	}
	static function get_bloc_module($nom_bloc) {
		return Cmodule::remplace_bloc_preg(array(1=>$nom_bloc));


	}
	public function get_bloc_html($nom_bloc,$parametres_fonction=NULL) {
		return $this->get_bloc_html_generique($nom_bloc,$parametres_fonction);
	}


	/**
	 *
	 * @param $str_fct
	 * @param $params
	 * @return unknown_type
	 */
	final static function execute_fonction_module($str_fct,$params=NULL) {
		//$nom_bloc=$res_preg[1];
		$split=explode(".",$str_fct);
		$id_module=array_shift($split);
		$str_fct=implode(".",$split);
		if($id_module=="*") {
			$retour=implode("",Cmodule::dispatch_fonction_importance($str_fct,$params));
			return $retour;
		} else {
			if($module=Cmodule::get_module($id_module)) {
				$retour=$module->execute_fonction($str_fct,$params);
				return $retour;
			}
		}
		trace_erreur("module $id_module non trouvé (CModule::execute_fonction_module)");
		return false;
	}


	/**
	 * fichier situé dans module/classes/Classe.class.php
	 * execute_fonction("module_x.classe_y.fonction_x(p1,p2[,px])","param supp")
	 * => module_x/classes/classe_y::fonction_x(p1,p2[,px],"param supp");
	 * @param $str_fct module.classe.fonction(p1,p2)
	 * @param $params : array = lsite des parametres en tableau
	 * @return unknown_type
	 */
	final public function execute_fonction($str_fct,$params=NULL) {
		ifNULL($params,array());
		//	print_rr("params : ".$params);
		//echo $nom_bloc;
		// fonction(p1,p2...)
		//print_rr($str_fct."<br>");
		preg_match("(([*a-z0-9A-Z_.]*)([\(](.*)[\)])?)",$str_fct,$detail);
		/* CMembres.remplitFicheUtilisateur(1,2,3) =>
		 * Array
		 (
		 [0] => CMembres.remplitFicheUtilisateur(1,2,3)
		 [1] => CMembres.remplitFicheUtilisateur
		 [2] => (1,2,3)
		 [3] => 1,2,3
		 )
		 */
		if(strlen($detail[3])>0) {
			$parametres_fonction=explode(",",$detail[3]);
		}
		else {
			$parametres_fonction=array();
		}

		$str_fct=$detail[1];
		//print_rr($detail);
		$split=explode(".",$str_fct);
		//
		//	print_rr($detail);
		if(is_array($params))
		$parametres_fonction=array_merge($parametres_fonction,$params);
		else
		array_push($parametres_fonction,$params);

		if(count($split)>=2) {
			// sous-classe
			$nom_fonction=array_pop($split);
			$nom_classe=array_pop($split);
			array_unshift($split,"classes");
			$rep=implode("/",$split);
			//include_once $this->include_rep.$this->identifiant."/$rep/$nom_classe.class.php";//auto
			//		$cl=new $nom_classe();
			// parametres additionnels
			//if(count($parametres_fonction>0))


			$p=$parametres_fonction;
			//			$retour=$cl->{$nom_fonction}($p[0],$p[1],$p[2],$p[3],$p[4],$p[5]);
			//			echo "call_user_func_array(array($nom_classe,$nom_fonction),$p)";
			$retour=call_user_func_array(array($nom_classe,$nom_fonction),$p);
			//echo "!!".htmlentities($retour)."!!";
			return Cmodule::ajoute_blocs_html_modules($retour);
			//return $cl->{$nom_fonction}($params);

		} else {
			if(method_exists($this,$str_fct)) {
				$p=$parametres_fonction;
				//print_rr($p);
				return call_user_func_array(array($this,$str_fct),$p);
				//return $this->$str_fct($p[0],$p[1],$p[2],$p[3],$p[4],$p[5]);
			}
		}

		return false;
	}
	final public function get_bloc_html_generique($nom_bloc,$parametres_fonction=NULL) {
		// $nom_bloc="toto"
		//		echo "<br>".$this->identifiant."get_bloc_html_generique $nom_bloc $parametres_fonction";

		// $nom_bloc="toto.truc" => module_x/classes/Ctoto->truc()
		//echo 1;
		if(($retour=$this->execute_fonction($nom_bloc,$parametres_fonction))!==false)
		return $retour;

		// $this->toto; (variable)
		if(isset($this->$nom_bloc))
		return $this->$nom_bloc;

		// $this->toto(); (methode)
		$p=$parametres_fonction;

		if(method_exists($this,$nom_bloc))
		return call_user_func_array(array($this,$nom_bloc),$p);
		//return $this->$nom_bloc($p[0],$p[1],$p[2],$p[3],$p[4],$p[5]);

		//		return "---=== bloc non défini : ".$this->identifiant."->$nom_bloc ===---";
	}
	
	public function getRegleHTaccess($level)
	{
		$rep=$this->include_rep.$this->identifiant."/htaccess/";
		if(file_exists($rep.'regles.level.'.$level)) return file_get_contents($rep.'regles.level.'.$level);
		
		return "";
	}
}

interface Imodule {

	function liste_menus_lateral();

}
interface ImoduleSite {
	function __installe_pages();

}

?>