<?php
CListes::add_liste2("site_pages_html","site__pages_html","contenus html","Gestion des contenus html du site","contenu HTML","FSE.site");
CListes::add_champ_liste("site_pages_html","identifiant","VARCHAR(255)","identifiant","identifiant","identifiant de la page HTML","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_pages_html","titre","VARCHAR(255)","titre","[META] titre","titre de la page HTML","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_pages_html","mots_cles","TEXT","mots clés","[META] mots clés","mots clés de la page HTML","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_pages_html","description","TEXT","description","[META] description","description de la page HTML","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_pages_html","css","TEXT","css","CSS","CSS supplémentaires de la page HTML","(.*)",NULL,"NOT NULL","longtext",NULL,"short");
CListes::add_champ_liste("site_pages_html","html","TEXT","html","contenu html","contenu HTML de la page","(.*)",NULL,"NOT NULL","longtext",NULL,"short html");
CListes::add_cle_unique("site_pages_html","identifiant");

bdd_cree_table("site__pages_liste","CREATE TABLE IF NOT EXISTS `site__pages_liste` (
  `id_auto` int(11) NOT NULL AUTO_INCREMENT,
  `id_parent` int(11) DEFAULT NULL,
  `priorite` smallint(6) NOT NULL,
  `masque` varchar(500) NOT NULL COMMENT 'expression régulière qui repère la page',
  `identifiant_droit` varchar(32) DEFAULT NULL,
  `id_module` varchar(255) NOT NULL COMMENT 'identifiant du module appelé',
  `fichier` varchar(255) DEFAULT NULL COMMENT 'fichier html du module',
  `fonction` varchar(255) DEFAULT NULL COMMENT 'nom de la fonction dans le module',
  `parametres` varchar(255) DEFAULT NULL COMMENT 'liste des paramètres',
  `continue` tinyint(4) NOT NULL COMMENT 'le repérage du masque ne suffit pas a arrêter la boucle',
  `id_modele` varchar(32) DEFAULT NULL COMMENT 'identifiant du modele html entourant la page',
  `redirige_NOK` varchar(1000) DEFAULT NULL,
  `redirige_OK` varchar(1000) DEFAULT NULL,
  `commentaires` text CHARACTER SET utf8 NOT NULL,
  `actif` tinyint(4) NOT NULL DEFAULT 1,
  `date_debut` datetime DEFAULT NULL,
  `date_fin` datetime DEFAULT NULL,
  PRIMARY KEY (`id_auto`),
  KEY `priorite` (`priorite`),
  KEY `actif` (`actif`),
  KEY `date_debut` (`date_debut`),
  KEY `date_fin` (`date_fin`),
  KEY `id_parent` (`id_parent`)
  ) ENGINE=MyISAM  ");

bdd_change_type_colonne2("masque","site__pages_liste","VARCHAR(500)","NOT NULL");
bdd_renomme_colonne("id_auto","site__pages_liste","ALTER TABLE `site__pages_liste` CHANGE `id` `id_auto` INT( 11 ) NOT NULL AUTO_INCREMENT ");
CListes::add_liste2("site_pages","site__pages_liste","groupes de pages","Gestion des pages du site, par groupe","page","FSE.site");
CListes::add_champ_liste2('site_pages','identifiant_site','varchar(255) DEFAULT NULL AFTER id_parent');
CListes::add_description_champ2('site_pages','identifiant_site',array());
CListes::add_champ_liste("site_pages","identifiant","VARCHAR(255)","identifiant","identifiant","identifiant unique du groupe de pages","(.*)",NULL,"NOT NULL AFTER id_auto",NULL,NULL);

CListes::add_champ_liste_etranger("site_pages","id_modele","site__pages_modeles","identifiant","#IDENTIFIANT#",NULL,false);
CListes::add_description_champ("site_pages","id_modele","modele","modele","modele de la page","(.*)", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "-");
CListes::add_champ_liste_etranger("site_pages","id_page_html","site__pages_html","id_auto","#IDENTIFIANT#",NULL,false,"AFTER id_modele");
CListes::add_description_champ("site_pages","id_page_html","page html","page html","page html","(.*)", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "-");

CListes::add_champ_liste("site_pages","titre","VARCHAR(255)","titre","[META] titre","titre de la page HTML","(.*)",NULL,"NOT NULL",NULL,NULL,"short");
CListes::add_champ_liste("site_pages","mots_cles","TEXT","mots clés","[META] mots clés","mots clés de la page HTML","(.*)",NULL,"NOT NULL",NULL,NULL,"short");
CListes::add_champ_liste("site_pages","description","TEXT","description","[META] description","description de la page HTML","(.*)",NULL,"NOT NULL",NULL,NULL,"short");
CListes::add_champ_liste("site_pages","robots","ENUM('','index, follow, all','noindex, nofollow')","robots","[META] robots","ce que les robots doivent suivre ?","(.*)",NULL,"NOT NULL",NULL,NULL,"short");
CListes::add_champ_liste("site_pages","classe_php","VARCHAR(255)","classe_php","classe_php","chemin vers la Classe qui gère la page HTML","(.*)",NULL,"NOT NULL",NULL,NULL);
CListes::add_champ_liste("site_pages","use_cache","ENUM('NON','FICHIER')","use_cache","use_cache","Méthode de mise en cache de la page","(.*)",NULL,"NOT NULL",NULL,NULL);
CListes::add_champ_liste("site_pages","duree_cache","VARCHAR(20)","duree_cache","duree_cache","Durée du cache (format SQL : 5 MINUTE, 1 DAY...)","(.*)",NULL,"NOT NULL",NULL,NULL);
CListes::add_champ_liste("site_pages","is_flash","TINYINT(1)","is_flash","is_flash","Page Full Flash, avec contenu HTML","(.*)",NULL,"NOT NULL",NULL,NULL);
CListes::add_champ_liste("site_pages","auto_referencable","TINYINT(1)","auto_referencable","auto_referencable","si cette page est referencable automatiquement","(.*)",NULL,"NOT NULL",NULL,NULL);
CListes::add_description_champ("site_pages","classe_page","classe_page","classe page","Classe PHP qui génère la page","(.*)", NULL, NULL, "AFTER id_module", NULL, NULL, NULL, NULL, NULL, "-");

CListes::add_champ_liste("site_pages","use_stats","TINYINT(1)","use_stats","use_stats","utilisation des stats ou non (analytics,...)","(0|1)",NULL,"NOT NULL DEFAULT 1",NULL,NULL);

CListes::add_cle_unique("site_pages","identifiant");
CListes::add_cle_unique("site_pages","masque","masque,identifiant_site");
//CListes::add_champ_liste("site_pages","contenu_html","TEXT","contenu","contenu","contenu html de la page","(.*)",NULL,NULL,"longtext",NULL,"short");


bdd_cree_table("site__pages_droits","CREATE TABLE  `site__pages_droits` (
	`id_auto` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	`identifiant` VARCHAR( 32 ) NOT NULL,
	`redirige_NOK` varchar(1000) DEFAULT NULL,
  	`redirige_OK` varchar(1000) DEFAULT NULL
) ENGINE = MYISAM ;");
bdd_renomme_colonne("id_auto","site__pages_droits","ALTER TABLE `site__pages_droits` CHANGE `id` `id_auto` INT( 11 ) NOT NULL AUTO_INCREMENT ");
CListes::add_liste2("site_pages_droits","site__pages_droits","droits des pages du site","Gestion des droits des pages du site","droit de page","FSE.site");

bdd_cree_table("site__pages_modeles","CREATE TABLE  `site__pages_modeles` (
	`id_auto` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	`identifiant` VARCHAR( 32 ) NOT NULL,
	`id_module` varchar(255) NOT NULL COMMENT 'identifiant du module appelé',
	`fichier` varchar(255) DEFAULT NULL COMMENT 'fichier html du module',
	`defaut` TINYINT(4) NOT NULL DEFAULT 0 COMMENT 'définit un modele par défaut pour toutes les pages du site',
	UNIQUE KEY `identifiant` (`identifiant`),
	KEY `defaut` (`defaut`)
	) ENGINE = MYISAM ;");
CListes::add_liste2("site_pages_modeles","site__pages_modeles","modèles de pages du site","Gestion des différents modèles de pages du site","modèle HTML de page","FSE.site");
CListes::add_champ_liste("site_pages_modeles","css","TEXT","css","CSS","CSS du modele HTML","(.*)",NULL,"NOT NULL","longtext",NULL,"short");
CListes::add_champ_liste("site_pages_modeles","fichier_css","VARCHAR(255)","fichier css","fichier css","fichier css","(.*)",NULL,"NOT NULL");
CListes::add_champ_liste("site_pages_modeles","html","TEXT","html","contenu html","contenu HTML de la page","(.*)",NULL,"NOT NULL","longtext",NULL,"short html");
CListes::add_champ_liste("site_pages_modeles","priorite","SMALLINT","priorite","priorite par défaut","priorite afin de déterminer la mise en pages par défaut","([0-9]+)",NULL,"NOT NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_pages_modeles","rootmodele","varchar(255)","rootmodele","rootmodele html","rootmodele html qui remplacera le normal si renseigné","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_pages_modeles","id_module_rootmodele","varchar(255) DEFAULT NULL","id module rootmodele","id module du rootmodele html","id module du rootmodele html qui remplacera le normal si renseigné","(.*)",NULL,"NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_pages_modeles","type_site","ENUM('standard','mobile') DEFAULT 'standard'","type_site","Type de site","Type de site (mobile ou standard)","(.*)",2,"NOT NULL");

CListes::drop_champ_liste("site_pages_modeles","defaut");
CListes::drop_cle("site_pages_modeles","identifiant");
CListes::add_cle_unique("site_pages_modeles","idx_identifiant", "identifiant, type_site");
CListes::add_description_champ("li","defaut","defaut","defaut","defaut","(0|1)",NULL,NULL,"checkbox");

bdd_cree_table("site__variables_config","CREATE TABLE  `site__variables_config` (
	`id_auto` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
	`identifiant` VARCHAR( 32 ) NOT NULL,
	`contenu` varchar(255) NOT NULL,
	`type` varchar(50) NOT NULL,
	`description` TEXT NOT NULL,
	UNIQUE KEY `identifiant` (`identifiant`)
	) ENGINE = MYISAM ;");

CListes::add_liste2("site_sites","site__sites","Sites","Gestion simple site ou multi-site","site","FSE.site");
CListes::add_champ_liste("site_sites","identifiant","VARCHAR(255)","identifiant","identifiant","identifiant interne du site (unique)","(.*)",1,"NOT NULL");
CListes::add_champ_liste("site_sites","detection","VARCHAR(255)","detection","detection","expression régulière de détection du domaine","(.*)",2,"NOT NULL");
CListes::add_champ_liste("site_sites","titre","VARCHAR(255)","titre","titre","titre du site (se rajoute en fin de titre de la page)","(.*)",3,"NOT NULL");
CListes::add_champ_liste("site_sites","priorite","TINYINT(4)","priorite","priorite","priorite de détection du site (0 = prioritaire , 15 = moins prioritaire)","([0-9]+)",4,"NOT NULL");
CListes::add_champ_liste("site_sites","defaut","TINYINT(1)","defaut","defaut","site par défaut si aucun autre site détecté","(0|1)",5,"NOT NULL","checkbox");
CListes::add_champ_liste("site_sites","actif","TINYINT(1)","actif","actif","site actif","(0|1)",6,"NOT NULL","checkbox");
CListes::add_champ_liste("site_sites","icone","VARCHAR(255)","icone","icone","chemin vers l'icone html","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_sites","copyright","VARCHAR(255)","copyright","[META] copyright","Copyright du site","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_sites","type_site","ENUM('standard','mobile') DEFAULT 'standard'","type_site","Type de site","Type de site (mobile ou standard)","(.*)",2,"NOT NULL");
CListes::add_cle_unique("site_sites","identifiant");
CListes::set_valeurs_defaut("site_sites",array("copyright"=>"e-Frogg","icone"=>"/favicon.ico","detection"=>"(.*)","actif"=>1,"defaut"=>0,"titre"=>"site par défaut","identifiant"=>""));

CListes::insere("site_sites",array("detection"=>"(.*)","priorite"=>15,"titre"=>"site par défaut","defaut"=>1,"actif"=>1,"identifiant"=>"page_defaut"),"identifiant='page_defaut'");

bdd_cree_table("site__urls_sitemap","CREATE TABLE IF NOT EXISTS `site__urls_sitemap` (
  `url` varchar(255) NOT NULL,
  `md5_contenu` varchar(40) NOT NULL,
  `date_modif` DATE NOT NULL,
  KEY `url` (`url`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ");
bdd_ajoute_colonne2("md5_contenu","site__urls_sitemap","varchar(40)","NOT NULL");
bdd_ajoute_colonne2("date_modif","site__urls_sitemap","DATE","NOT NULL");

//include_once 'modules/site/classes/CReferencement.class.php';//auto
CReferencement::__installe();
//$chemin,$identifiant,$titre,$type,$type_param="",$position=0,$valeur_defaut="",$maj = true
COptions::ajouteOption('site.optimise','concat_js', "Mode de prise en compte des librairies js",'TEXT','', 0, 0, false, '1');
COptions::ajouteOption('site.optimise','noconcat_js_liste', "Tous les js non-concaténables séparés par un espace (seront ajoutés à la fin)",'TEXT','', 0, "", false, '1');
COptions::ajouteOption('site.optimise','noconcat_js_url', "les morceaux d'url (strpos) séparées par un espace ou on ne concatene pas les js",'TEXT','', 0, "super_admin fsadmin", false, '1');
COptions::ajouteOption('site.optimise','concat_css', "Mode de prise en compte des css",'TEXT','', 0, 0, false, '1');
COptions::ajouteOption('site.optimise','noconcat_css_liste', "Tous les css non-concaténables séparés par un espace (seront ajoutés à la fin)",'TEXT','', 0, "", false, '1');
COptions::ajouteOption('site.optimise','noconcat_css_url', "les morceaux d'url (strpos) séparées par un espace ou on ne concatene pas les css",'TEXT','', 0, "super_admin fsadmin", false, '1');

// cache header images
COptions::ajouteOption('site.optimise','duree_cache_image', "duree du cache pour les images (secondes)",'int','', 0, "1200", false, '1');
COptions::ajouteOption('site.optimise','duree_cache_fonts', "duree du cache pour les polices en CSS",'int','', 0, "8000", false, '1');
COptions::ajouteOption('site.optimise','duree_cache_css_js', "duree du cache pour les fichiers JS et CSS",'int','', 0, "80000", false, '1');


if(!defined("CONCATFILE_NUMVERSION")) {
	ini_set_client("CONCATFILE_NUMVERSION", 0);
}

CListes::add_liste2("site_fichiers_todo","site__fichiers_todo","Fichiers à générer","les fichiers concaténés (js ou css) a générer","site","FSE.site");
CListes::add_champ_liste("site_fichiers_todo","type","VARCHAR(50)","type","type","type de fichier","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_fichiers_todo","liste_fichiers_pour_nom","TEXT","liste_fichiers_pour_nom","liste_fichiers_pour_nom","les fichiers séparés par un espace sous la forme module/fichier.ext","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
CListes::add_champ_liste("site_fichiers_todo","liste_fichiers_pour_src","TEXT","liste_fichiers_pour_src","liste_fichiers_pour_src","les fichiers séparés par un espace sous la forme path serveur pour get_content","(.*)",NULL,"NOT NULL",NULL,NULL,NULL);
// IMPOSSIBLE DE METTRE UNE CLE UNIQUE SUR UN CHAMP TEXT
//CListes::add_cle_unique("site_fichiers_todo","liste_fichiers_pour_nom");
?>