<?php
/***
*	Classe : TFormElement
*
*   Notes : La classe abstraite TFormElement est la parente de toutes les classes contenues dans le fichier TElements.classes.php.
*   Elle contient tous les attributs et les m�thodes similaires des �l�ments de formulaires
*
*   Licence : Ce code est enti�rement libre de droits. Vous pouvez le copier, le modifier, le partager, et ce sans aucune restriction
*
*   Auteur : Christophe TAFANI-DEREEPER <christophetd@gmail.com>
*
*   Date de cr�ation : 24 juillet 2009
*   Date de derni�re modification : 10 ao�t 2009
* 
*/

abstract class TFormElement
{
	/***
	* La valeur d�faut de l'�l�ment
	* @var protected string value
	*/
	protected $value;
	
	/***
	* La label correspondant � l'�l�ment de formulaire
	* @var protected string label
	*/
	protected $label;
	
	/***
	* Le nom de l'�l�ment de formulaire
	* @var protected string name
	*/
	protected $name;
	
	/***
	* Indique si l'�l�ment de formulaire est indispensable
	* @var protected bool required
	*/
	protected $required;
	
	/***
	* L'id de l'�l�ment de formulaire
	* @var protected string id
	*/
	protected $id;
	
	/***
	* Le choix par d�faut de l'�l�ment de formulaire, si c'est une checkBox, radio, ou liste de s�lection
	* @var protected string defaultChoice
	*/
	protected $defaultChoice;
	
	/***
	* La hauteur du textarea
	* @var protected int height
	*/
	protected $height;
	
	/***
	* La largeur du textarea
	* @var protected int width
	*/
	protected $width;
	
	/***
	* La regex v�rifiant la validit� du contenu de l'�l�ment de formulaire
	* @var protected string regex
	*/
	protected $regex;
	
	/***
	* Le nombre minimal de caract�res que peut contenir l'�l�ment de formulaire
	* @var protected int minlength
	*/
	protected $minlength = NULL;
	
	/***
	* Le nombre maximal de caract�res que peut contenir l'�l�ment de formulaire
	* @var protected int maxlength
	*/
	protected $maxlength = NULL;
	
	/***
	* Le format de l'�l�ment date, o� d = jours, m = mois, et y = ann�e
	* @var protected string format
	*/
	protected $format;
	
	/***
	* Le champs qui doit �tre identique (ex pass et pass valid)
	* @var protected string format
	*/
	protected $equality;
	
	
	protected $readOnly = "";
	
        
        protected $onJS = array();
        
	/***
	* Les erreurs de non-validit� rencontr�es lors de la soumisson du formulaire
	* @var protected array errors
	*/
	protected $errors = array();
	
	
	
	/***
	*
	* Le constructeur de la classe ZFormElement
	* Par d�faut, required vaut TRUE	
	*/
	public function __construct()
	{
		$this->required = TRUE;
	}
	
	/***
	*
	* M�thode accesseur qui renvoie le nom de l'�l�ment de formulaire
	*
	* @return string name
	*/
	public function getName()
	{
		return $this->name;
	}
	
	/*** Les m�thodes suivantes suivent toutes le m�me fonctionnement :
	* public function [nomAttribut]($[nomAttribut])
	* {
	*  		$this->[nomAttribut] = $[nomAttribut];
	*
	*		return $this;
	* }
	* O� [nomAttribut] est le nom de l'�l�ment que la m�thode modifie.
	*
	* @var string/int [nomAttribut]		La nouvelle valeur de l'attribut � modifier
	* @return TFormElement				Retourne l'objet actuel
	*/
	
	public function name($name)
	{
		$this->name = $name;
		
		return $this;
	}
	
	public function label($label)
	{
		$this->label = $label;
		
		return $this;
	}
	
	public function value($value)
	{
		$this->value = $value;
		
		return $this;
	}
	public function required($required)
	{
		$this->required = (bool) $required;
		
		return $this;
	}
	
	public function id($id)
	{
		$this->id = $id;
		
		return $this;
	}
	
	public function defaultChoice($default)
	{
		$this->defaultChoice = $default;
		
		return $this;
	}
	
	public function minlength($min)
	{
		$this->minlength = $min;
		
		return $this;
	}
	
	public function maxlength($max)
	{
		$this->maxlength = $max;
		
		return $this;
	}
	
	public function width($width)
	{
		$this->width = $width;
		
		return $this;
	}
	
	public function height($height)
	{
		$this->height = $height;
		
		return $this;
	}
	
	public function equality($equality){
		$this->equality = $equality;
		
		return $this;
	}
	
	public function readonly($bool = true){
		if($bool){
			$this->readOnly = 'readonly="readonly"';
			$this->required(false);
		}
		return $this;
	}
        
        public function onJS($jsEvent, $jsAction){
            $this->onJS[$jsEvent] = $jsAction;
            
            return $this;
        }
	
	/***
	* regex
	*
	* @var string regex		La regex de validation du contenu de l'�l�ment de formulaire
	*
	*/
	public function regex($regex)
	{
		if(preg_match('#\#.+\#*+#', $regex))
		{
			$this->regex = $regex;
			return $this;
		}
		else return FALSE;
	}
	
	/***
	* idValid
	*
	* @var array array		L'array dans lequel les valeurs doivent �tre recherch�es et valid�es
	* @return bool			Le r�sultat de l'analyse : TRUE si le formulaire est rempli comme l'utilisateur le d�sire, FALSE dans le cas contraire
	*/
	
	public function isValid($array)
	{	
		if($this->required)
		{
			if(!isset($array[$this->name]) OR empty($array[$this->name]))
			{
				$this->errors[] = $this->label;
				return FALSE;
			}
		}
		if(!empty($this->regex))
		{
			if(!preg_match($this->regex, $array[$this->name]))
			{
				$this->errors[] = $this->label;
				return FALSE;
			}
		}
		if(!is_null($this->minlength))
		{
			if(strlen($array[$this->name]) < $this->minlength)
			{	
				$this->errors[] = $this->label;
				return FALSE;
			}
		}
		if(!is_null($this->maxlength))
		{
			if(strlen($array[$this->name]) > $this->maxlength)
			{
				$this->errors[] = $this->label;
				return FALSE;
			}
		}
		if(!is_null($this->equality))
		{
			if($array[$this->name] != $array[$this->equality])
			{
				$this->errors[] = $this->label;
				return FALSE;
			}
		}
		
			return TRUE;
	}
	
	/***
	* getError
	*
	* Retourne une �ventuelle erreur li�e � l'�l�ment de formulaire
	* @return string	L'erreur
	*/
	public function getError()
	{
		if(empty($this->errors)) return NULL;
		$out = '';
		foreach($this->errors as $f)
		{
			$out .= 'Le champ obligatoire <b>'.$f.'</b> est vide ou incorrectement rempli<br />'."\n";
		}
		return $out;
	}	
	
	
	
	public function isHidden(){
		if(get_class($this) == "TFHiddenField")
			return true;
		else
			return false;
	}
	
	
	
	
	
	
}