<?php
class Clients extends Model{
	
	/*
	 * 
	 */
	public $id;
	
	/*
	 * 
	 */
	public $num;
	
	/*
	 * 
	 */
	public $typ;
	
	/*
	 * 
	 */
	public $nom;
	
	/*
	 * 
	 */
	public $mail;
	
	/*
	 * 
	 */
	public $adresse;
	
	/*
	 * 
	 */
	public $cp;
	
	/*
	 * 
	 */
	public $ville;
	
	/*
	 * 
	 */
	public $pays;
	
	/*
	 * 
	 */
	public $tel;
	
	/*
	 * 
	 */
	public $tva = 19.6;
	
	/*
	 * 
	 */
	public $login;
	
	/*
	 * 
	 */
	public $pass;
	
	/*
	 * 
	 */
	public $compte;
	
	public $facturations = array();
	public $hebergements = array();
	public $relances = array();
	
	private $listeConditionPaiement = array();
	
	public function __construct(){
		parent::__construct('clients');
	}
	
	
	public function __toString(){
		return $this->nom;
	}
	
        public function preSave(){

            
            if($this->id == ""){
                $q = new QueryBuilder('Clients');
                
                $q->select('MAX(C.num) as num')
                  ->from('clients C');
                
//                $q->displayQuery = true;
                
                $c = $q->executeQuery('object');
                
                $this->num = $c->num + 1;
            }
            
        }
        
	private function initConditionsPaiement($nextPaiement = null){
		// [duree] [couleur] [message] [action]
		$this->listeConditionsPaiement[] = array('duree'=>'-10000','couleur'=>'rouge','message'=>'Nouvel hébergement, pas encore de facturation','action' => '');
		$this->listeConditionsPaiement[] = array('duree'=>'0','couleur'=>'rouge','message'=>'Date de paiement dépassé de '.abs($nextPaiement).' jours','action' => '');
		$this->listeConditionsPaiement[] = array('duree'=>'14','couleur'=>'orange','message'=>'Paiement dans '.$nextPaiement.' jours','action' => '');
		$this->listeConditionsPaiement[] = array('duree'=>'30','couleur'=>'jaune','message'=>'Paiment dans moins d\'un mois : '. $nextPaiement .' jours restants','action' => '');
		$this->listeConditionsPaiement[] = array('duree'=>'60','couleur'=>'jaune','message'=>'Paiment dans deux mois : '. $nextPaiement.' jours restants','action' => '');
		$this->listeConditionsPaiement[] = array('duree'=>'180','couleur'=>'vert','message'=>'On est large, paiement dans '.$nextPaiement.' jours','action' => '');
		$this->listeConditionsPaiement[] = array('duree'=>'365','couleur'=>'vert','message'=>'Environ un an devant nous, tranquille : '.$nextPaiement.' jours','action' => '');
		$this->listeConditionsPaiement[] = array('duree'=>'10000','couleur'=>'vert','message'=>'Quelques années d\'avance, soit : '.$nextPaiement.' jours','action' => '');
	}
	
	public function getHebergements($force = false){
		if(empty($this->hebergements) || $force == true){
			$h = new Hebergements();
			$h = $h->findActif('id_client',$this->id);
			
			$this->hebergements = $h;
			
			return $h;
		}
		else{
			return $this->hebergements;
		}
	}
	
	public function getHebergementsWithDuree(){
		$q = new QueryBuilder("hebergements");
		
		$q->select("H.*, (to_days(H.date_valid)-to_days(curdate())) as jours_restants")
		  ->from("hebergements H")
		  ->join('INNER JOIN clients C ON C.id = H.id_client')
		  ->where("C.id = ? ", $this->id)
                  ->andWhere("H.actif = ? ", 1)
		  ->orderBy('jours_restants','ASC');
		
//		$q->displayQuery = true; 

		$r = $q->executeQuery(); 
		
		$this->hebergements = $r;
		
		return $r;
	}
	
	public function getHebergementsInactif(){
		$q = new QueryBuilder('hebergements');
		
		$q->select('H.*')
                  ->from('hebergements H')
                  ->where('H.id_client = ?',$this->id)
                  ->andWhere('H.actif = ?',0);
                
                $result = $q->executeQuery();
                
                return $result;
	}
	
	
	private function queryRelances(){
		$q = new QueryBuilder('Relances');
		$q->select('R.*')
			->from('relances R')
			->join("INNER JOIN join_relances_hebergements J ON J.id_relances = R.id")
			->join("INNER JOIN hebergements H ON H.id = J.id_hebergements")
			->join("INNER JOIN clients C ON C.id = H.id_client")
			->where('C.id = ? ', $this->id);
			
		return $q;	
	}
	
	public function getRelancesPourEnvoi($id = null){
		if($id == 'group'){
			//TODO: groupement des relances
//			$id = $this->groupRelance();
		}
		
		$q = $this->queryRelances()
			->select('H.date_valid')
			->where('(R.etat = ? OR R.etat = ?)','p','e');
		
		if($id != null)
			$q->andWhere('R.id = ? ', $id);	
			
		$q->groupBy('R.id');	
			
//		$q->displayQuery = true;	
		
		return $q->executeQuery();
	}	
	
	
	public function getRelances($id = null){
		if(empty($relances)){
			$q = $this->queryRelances();
			
			if($id != null) 
				$q->where('R.id = ?', $id);
			
			$r = $q->executeQuery();
			
			if($id == null)
				$this->relances = $r;
			
			return $r;
		}
		else{
			return $this->relances;
		}
	}
	
	public function getRelancesValide(){
		$q = $this->queryRelances()
			->where('(to_days(H.date_valid)-to_days(curdate())) < ?', NB_JOURS_AVANT_RELANCEMENT)
		   	->andWhere('R.etat != ?','t')
			->orderBy('R.etat','DESC')
		   	->groupBy('R.id');
		//TODO: Modifications ? faire ?
//		->where('R.date > ?', array($lastFacture->date))   	
		   	
//		$q->displayQuery = true;	
		
		return $q->executeQuery();
	}
	
	public function getLastRelanceValide(){
		$relances = $this->getRelancesValide();
		
		if(!empty($relances)) return $relances[0];
		else return false ;
	}
	
	public function getFacturations(){
		if(empty($this->facturations)){
			$f = new Facturations_h();
			$f = $f->findBy('id_client',$this->id);
			
			return $f;
		}
		else{
			return $this->facturations;
		}
	}
	
	
	public function getLastFacture(){
		$f = new Facturations_h();
		$f = $f->findOneBy('id_client', $this->id, array('date','DESC'));
		
		if($f != null)
			return $f;
		else{
			$f = new Facturations_h();
			$f->jours_restants = -10000;
			return $f;
		}
	}
	
	public function getEtatPaiment(){
		$this->getHebergementsWithDuree();
		
		if(!empty($this->hebergements)){
			$nextPaiement = 10000;
			foreach($this->hebergements as $h){
				if($h->jours_restants < $nextPaiement){
					$nextPaiement = $h->jours_restants;
				}
			}
			
			// recup les relances
			$r = new Relances();
			$liste = $r -> findBy("id_client",$this -> id);
			/*echo "<pre>";
			print_r($liste); // toutes les relances actives du client
			echo "</pre>";*/
			$priorite_etats=array("t","p","e");
			$libelles_etats=array("","relance faite, non envoyé","relance envoyée");
			$maxEtape=0;
			foreach($liste as $f) {
				$maxEtape = max($maxEtape,array_search($f -> etat,$priorite_etats));
			}
			$libelleEtape = $libelles_etats[$maxEtape];
			$etape = $priorite_etats[$maxEtape];
			
			$this->initConditionsPaiement($nextPaiement);
			
			foreach($this->listeConditionsPaiement as $liste => $cond){
				if($nextPaiement <= $cond['duree']){
					if($cond['couleur'] == "rouge" && $etape=="t") {
						$etape="c";
						$libelleEtape="relance a créer";
					}
					return array('couleur' => $cond['couleur'],'title' => $cond['message'],'action' => $cond['action'],'libelle_etape'=>$libelleEtape,"etape"=>$etape);
				}
			}
		}
		else{
			return  array('couleur' => 'gris','title' => 'Pas d\'hébergement','action' => '');
		}
	}
	
	public function addFacturation($relance,$facturation = null){
		
//		print_r_html($relance);
//		print_r_html($facturation);
		
//		print_r_html($relance->elems );
		
		$relance->getElems();
				
		//Add Facuration
		$facturation->id_client = $this->id;
		$facturation->etat = 'p';
		$facturation->tva = $this->tva;
		$facturation->save();
		
		$facturation->id = $facturation->getLastInsertId();
	
		//Ajout des elems ? la fact et maj
		$relance->elems = $facturation->addElems($relance->elems);
		
		$facturation->getTotaux($relance->elems);
		$facturation->save();
		
		//MAJ relances
		$relance->id_facturations_h = $facturation->id;
		$relance->etat = 't';
		$relance->getTotaux();
		$relance->save();
		
		
		//MAJ h?bergements
		$hebergements = $relance->getHebergements();
		
		foreach($hebergements as $h){
			$date_valid_int = strtotime($h->date_valid);
			
			$duree = 1;
			foreach($facturation->getElems() as $e){
				if($e->designation == $h->designation){
					$duree = $e->qte;
					break;
				}
			}

			//Calcul de la nouvelle date de validation avec les ann?es bisex...
			$jours_duree_annee =  nb_jours_les_prochaines_annees(round($duree), $h->date_valid);
			$jours_duree = ($jours_duree_annee * $duree) / round($duree);
			$annees = 60 * 60 * 24 * round($jours_duree, 0 );
			
			$date_valid_int = $date_valid_int + $annees; 
			$date = date('Y-m-d', $date_valid_int);
			$h->date_valid = $date;
			
			$h->save();
		}
		
		$facturation->createPDF();
	
		return true;
	}
	
	
	public function gestionFactureByClient(){
			$hebergements = $this->getHebergementsWithDuree();
		
//			echo '<h4>Gestion du client : '.$this->nom.'</h4>';
//			print_r_html($hebergements);
			
			$messagePerso = array();
			$newRelances  = array();
			
			if(!empty($hebergements)){
				$this->initConditionsPaiement();
				
				foreach($hebergements as $h){
					if($h->jours_restants < NB_JOURS_AVANT_RELANCEMENT){
						foreach($this->listeConditionsPaiement as $liste => $cond){
							if($h->jours_restants <= $cond['duree']){
								$h->etat = $cond['couleur'];
								switch ($h->etat){
									case 'rouge':
									case 'orange':
									case 'jaune':
										$relance = $h->getLastRelanceValide();
										
										if(!empty($relance)){
											if($relance->jours_depuis > JOUR_AVANT_PROCHAINE_RELANCE){
												//D?j? une relance, mais qui date un peu
												echo 'RELANCE QUI DATE';
												if($relance->etat == 'p' || $relance->etat == 'c'){
													$newRelances[$h->designation] = $h->addCronRelance();
													$messagePerso[$h->designation] = 'Une relance est en attente d\'envoi';
												}
												else if($relance->etat == 'e' || $relance->etat == 't'){
													$messagePerso[$h->designation] = 'Dernière relance il y a '.$relance->jours_depuis.' jours';
													$newRelances[$h->designation] = $h->addCronRelance();
												}
											}
											else{
												echo '<h4>DEJA UNE RELANCE RECENTE</h4>';
												echo $relance->etat;
												
												if($relance->etat == 'p' || $relance->etat == 'c'){
													echo 'EN ATTENTE DENVOI';
													$messagePerso[$h->designation] = 'Une relance est en attente d\'envoi';
												}
												else if($relance->etat == 'e' || $relance->etat == 't'){
													echo 'HOP HOP';
													$messagePerso[$h->designation] = 'Ce client a déjà été relancé il y a moins d\'une semaine';
												}
											}
										}
										else{
											echo '<h4>PAS RELANCES, nouvelle relance</h4>';
											$newRelances[$h->designation] = $h->addCronRelance();
										}
										break;
									case 'vert':
										//Tout va bien, on ne fait rien, pour le moment
										break;
								}
//								break; //Break du foreach
							}	
						}
					}
				}
			}
			
//			print_r_html($newRelances);
//			print_r_html($messagePerso);
			
//			array_merge($this->relances,$newRelances);
			$this->relances = $newRelances;
			$this->messagePerso = $messagePerso;
			
			return $this;
			
			
			
			/*****************************************************/
		
//			exit();
//			$facturations = $this->getFacturationsInvalides();
			
//			print_r_html($facturations);
			
//			echo '<br/>Client : '.$this->nom.'--------------------------<br/>';
//			$messagePerso = array();
//			$newRelances  = array();
//			
//			if(empty($facturations)){
				//Si pas encore de facturation
//				$this->jour_restant = -10000;
//				
//				$newFact = new Facturations_h();
//				$newFact->date_valid = date('Y-m-d');
//				$newFact->id_client = $this->id;
//				$newFact->id_intitule_entete = 3;
//				$newFact->save();
//				
//				
//				
//				$newFact->id = $newFact->getLastInsertId();
//				
//				echo '<br/>GENERATION NOUVELLE FACTURE<br/>';
//				print_r_html($newFact);
//				
//				$newFact->JoinWithHebergement();
//				
//				$hebergements = $newFact->getHebergements();
//				
//				$newFact->addElems();
				
				
//				if(!empty($hebergements)){
//					$newRelances[] = $newFact->addNewRelance();
//					$messagePerso[] = "Nouveau client, hébergement(s) pas encore payé(s)";
//				}
//			}
//			else{
//				echo '<br/>Client : '.$this->nom.'----une facturation<br/>';
				//Pour chaque facturation, on lance les tests
//				foreach($facturations as $fact){
//					$this->jours_restants = $fact->jours_restants;
//					
//					$relance = $fact->getLastRelanceValide();
//					
	//				print_r_html($relance);
					
//					if(empty($relance)){
////						echo '<br/>Client : '.$this->nom.'----Pas de précédente relance<br/>';
//						//Si pas de précédente relance
//						$newRelances[] = $fact->addNewRelance();
//					}
//					else{
////						echo '<br/>Client : '.$this->nom.'----Déjé relancé<br/>';
//						//Test sur la derniére relance
//						if($relance->jours_depuis > JOUR_AVANT_PROCHAINE_RELANCE){
//							//TODO: mettre en place un calcul savant (ratio jour restant/jour prochain) ???	
//							$newRelances[] = $fact->addRelance($relance);
//							$this->hebergements = $fact->getHebergements();
//						}
//						else{
//							if($relance->etat == 'p'){
//								$messagePerso[] = 'Une relance est d?j? en attente d\'envoi';
//							}
//							else if($relance->etat == 'e'){
//								$messagePerso[] = 'Ce client a d?j? ?t? relanc? il y a moins d\'une semaine';
//							}
//						}	
//					}
//				}
//			}
//			
//			$this->relances = $newRelances;
//			$this->messagePerso = $messagePerso;
//			
//			return $this;
	}
	
	public function sendFactureCompta($facture=null) {
		if($facture == null)
			return new Alert("Aucune facture a envoyer");
			
		include_once RACINE_INCLUDE.'classes/class.phpmailer.php';
		$mail = new PHPmailer();
		$mail->IsHTML(true);
		$mail->CharSet = "utf-8";
		
		//$mail->setSubject("Renouvellement de vos services e-frogg");
		$mail->Subject='Facture pour vos services e-frogg';			
		$mail->From='admin@e-frogg.com';
		$mail->FromName='facturation e-frogg';
		$mail->AddReplyTo('reply@e-frogg.com');	
		
		if(DEBUG){
			$mail->AddAddress(DESTINATAIRE_DEBUG);
		}
		else{	
			$mails = explode(',', DESTINATAIRE_COMPTA);
			//$mail->AddAddress(DESTINATAIRE_DEBUG);
			$mailPpal = array_shift($mails);
			$mail->AddAddress($mailPpal);
			foreach($mails as $m){
				$mail->AddCC($m);
			}
			$mails = explode(',', DESTINATAIRES_ADMIN);
			foreach($mails as $m){
				$mail->AddCC($m);
			}
		}
		$html = file_get_contents(RACINE_INCLUDE.'tpl/mail/envoiFactureCompta.mail.html');
		$html = str_replace(array('#CLIENT#'),
							array($this->nom),
							$html);
		
		$mail->Body=$html;
		$mail->AddAttachment('pdf/facturationsh/'.$facture->num.'.pdf');
		if(!$mail->Send()){
		  new Alert('Problème lors de l\'envoi, réessayez plus tard, ou débuggez mon code :D<br>'.$mail->ErrorInfo);
		}
		else{	  
		  //echo 'Mail envoyé avec succès';
			new Alert('Facture envoyée à la compta : '.$this->nom);
			
			//Mise à jour des relances
			$facture->etat = 'c';
			$facture->save();

		}
		$mail->SmtpClose();
		unset($mail);
		
	}
	public function sendFacture($facture=null) {
		if($facture == null)
			return new Alert("Aucune facture a envoyer");
			
		include_once RACINE_INCLUDE.'classes/class.phpmailer.php';
		$mail = new PHPmailer();
		$mail->IsHTML(true);
		$mail->CharSet = "utf-8";
		
		//$mail->setSubject("Renouvellement de vos services e-frogg");
		$mail->Subject='Facture pour vos services e-frogg';			
		$mail->From='admin@e-frogg.com';
		$mail->FromName='facturation e-frogg';
		$mail->AddReplyTo('reply@e-frogg.com');	
		
		if(DEBUG){
			$email = DESTINATAIRE_DEBUG;
		}
		else{	
			$email = $this->mail;
		}

		$mail->AddAddress($email);
		 if(!DEBUG){
			$mails = explode(',', DESTINATAIRES_ADMIN);

			foreach($mails as $m){
				$mail->AddAddress($m);
			}
		}
		$html = file_get_contents(RACINE_INCLUDE.'tpl/mail/envoiFactureClient.mail.html');
		$html = str_replace(array('#CLIENT#'),
							array($this->nom),
							$html);
		
		$mail->Body=$html;			
//		var_dump($facture);
		
		$mail->AddAttachment('pdf/facturationsh/'.$facture->num.'.pdf');
		
		if(!$mail->Send()){
		  //echo $mail->ErrorInfo; 
		  new Alert('Problème lors de l\'envoi, réessayez plus tard, ou débuggez mon code :D');
		}
		else{	  
		  //echo 'Mail envoyé avec succès';
			new Alert('Facture envoyée au client : '.$this->nom);
			
			//Mise à jour des relances
			$facture->etat = 'e';
			$facture->save();

		}
		$mail->SmtpClose();
		unset($mail);
			
			
//		echo "envoi ".$this -> id." - ".$facture -> id;
	
	}
	
	public function sendRelance($relances = null){
		
		if($relances == null)
			$relances = $this->getRelancesPourEnvoi();

//		print_r_html($relances);	
			
		if(!empty($relances)){	
			
			$recap = "";
			$montant_total = 0;
			
			foreach($relances as $r){
				$r->getHebergements();
				
				foreach($r->getElems() as $e){
					if($e->qte != 0){
						$recap .= '<tr>';
						$recap .= '<td>';
						$recap .= "<b>".($e->designation).'</b> pour une durée de '.round($e->qte,0);
						if(round($e->qte,0) < 2)
							$recap .= 'an';
						else
							$recap .= 'ans';	

						$recap .= ' Au prix de '.$e->puht.' &euro; hors taxe l\'année';
						
						foreach($r->hebergements as $h){
							if($e->designation == $h->designation)
								$recap .= '(Expire le '.$h->date_valid.')' ;
						}
						
						$recap .= '</td>';
						$recap .= '</tr>';
					}
				}

			}	

			//Création et envoi du mail
			include_once RACINE_INCLUDE.'classes/class.phpmailer.php';
			//include_once RACINE_INCLUDE.'classes/class.smtp.php';

	//$mail->IsSMTP();
	//$mail->Host='smtp.e-frogg.fr';

			
			//$mail = new Mail();
			$mail = new PHPmailer();
			$mail->IsHTML(true);
			$mail->CharSet = "utf-8";
			
			//$mail->setSubject("Renouvellement de vos services e-frogg");
			$mail->Subject='Renouvellement de vos services e-frogg';			
			
			if(DEBUG){
				$email = DESTINATAIRE_DEBUG;
			}
			else{	
				$email = $this->mail;
			}

			//$mail->addTo($email);
			$mail->AddAddress($email);
			 if(!DEBUG){
				$mails = explode(',', DESTINATAIRES_ADMIN);

				foreach($mails as $m){
					$mail->AddAddress($m);
				}
			}

			
            //echo 'Mail : '.$email.'<br/>';
                        
			//$mail->setFrom('admin@e-frogg.com');
			//$mail->setReplayTo('admin@e-frogg.com');
			$mail->From='admin@e-frogg.com';
			$mail->FromName='facturation e-frogg';
			$mail->AddReplyTo('reply@e-frogg.com');	
			
			
			$html = implode('', file(RACINE_INCLUDE.'tpl/mail/rappelClient.mail.html'));
			$html = str_replace(array('#CLIENT#','#RECAP#'),
								array($this->nom,$recap),
								$html);
	
								
//			echo 'Template du mail : '.$html; 
	
			//$mail->setHtmlBody($html);
			$mail->Body=$html;
	
			$nom = str_replace(' ','_',$this->nom);
			
			foreach($relances as $r){
				//$mail->addAttachment(date('Y').$r->num.'-'.$nom.'.pdf', "application/pdf", 'pdf/relances/'.$r->num.'.pdf');
				$mail->AddAttachment('pdf/relances/'.$r->num.'.pdf');
			}
			
			if(!$mail->Send()){
			  //echo $mail->ErrorInfo; 
			  new Alert('Problème lors de l\'envoi, réessayez plus tard, ou débuggez mon code :D');
			}
			else{	  
			  //echo 'Mail envoy? avec succ?s';
				new Alert('Relance envoyée au client : '.$this->nom);
				
				//Mise ? jour des relances
				foreach($relances as $r){
					//Mise ? jour de la relance
					$r->etat = 'e';
					$r->save();
				}

			}
			$mail->SmtpClose();
			unset($mail);
	
		//	$send = $mail->send();
			
			/*if($send[$email] == true){
			}
			else */
		
		
                  /*      if(!DEBUG){
                            //ENVOI DU MAIL AU ADMIN
                            $mail_admin = new Mail();
                            $mail_admin->setSubject("[COPIE]Renouvellement de vos services e-frogg");
                            $mail_admin->setFrom('admin@e-frogg.com');
                            $mail_admin->setReplayTo('admin@e-frogg.com');
                            $mail_admin->setHtmlBody($html);

                            $mails = explode(',', DESTINATAIRES_ADMIN);

                            foreach($mails as $m){
                                $mail_admin->addTo($m);
                            }

                            $send = $mail_admin->send();
                        }*/
		}
		else{
			new Alert('Aucune relance à envoyer pour ce client');
		}
			
	
	}

	
	/* CREATION RELANCE *********************************/

	private function testRelanceWithHebergement($id){
		$q = $this->queryRelances();
		$q->where('H.id = ?', $id)
			->andWhere('(to_days(R.date) - to_days(curdate())) < ?', NB_JOURS_AVANT_RELANCEMENT)		
			->andWhere('R.etat != ?', 't');		
		$r = $q->executeQuery();
		
		if(!empty($r)) return false;
		else return true;
		
	}
	
	private function getHebergementsSameDate($hebergement){
		$q = new QueryBuilder('hebergements');
		
		$q->select('H.*, (to_days(H.date_valid) - to_days("'.$hebergement->date_valid.'")) as jours_ratio')
		  ->from('hebergements H')
		  ->where('H.date_valid = ?', $hebergement->date_valid)
		  ->andWhere('H.id != ? ',$hebergement->id)
		  ->andWhere('H.id_client = ?', $this->id)
		  ->groupBy('H.id');
		  
//		$q->displayQuery = true;  
		  
		$r = $q->executeQuery();

		return $r;
	}
	
	private function getHebergementsGroup($hebergement){
		$q = new QueryBuilder('hebergements');
		
		$q->select('H.*, (to_days(H.date_valid) - to_days("'.$hebergement->date_valid.'")) as jours_ratio')
		  ->from('hebergements H')
		  ->where('(
		  	 	((to_days(H.date_valid) - to_days("'.$hebergement->date_valid.'")) < ? 
		  	 	AND (to_days(H.date_valid) - to_days("'.$hebergement->date_valid.'")) > ?)
		  	 OR 
		  	 	(to_days(H.date_valid) - to_days(curdate())) < ?)',
		  NB_JOURS_GROUPEMENT_RELANCES,0,NB_JOURS_GROUPEMENT_RELANCES)
		  
		  
//		  ->andWhere('(to_days(H.date_valid) - to_days(curdate())) < ?', NB_JOURS_GROUPEMENT_RELANCES) 
//		  ->andWhere('( 
//		  				OR H.date_valid = ?)', $hebergement->date_valid,0,$hebergement->date_valid)
		  
		  
		  ->andWhere('H.id != ? ', $hebergement->id)
		  ->andWhere('H.id_client = ? ', $this->id)
		  ->andWhere('H.actif = ? ', 1)
		  ->groupBy('H.id');
		
		
//		$q->select('H.*, (to_days(H.date_valid) - to_days("'.$hebergement->date_valid.'")) as jours_ratio')
//		  ->from('hebergements H')
////		  ->where('(to_days(H.date_valid) - to_days(?)) < ?',$hebergement->date_valid, NB_JOURS_GROUPEMENT_RELANCES)
//		  ->andWhere('(to_days(H.date_valid) - to_days(curdate())) < ?', NB_JOURS_GROUPEMENT_RELANCES)
//		  ->andWhere('H.id != ? ', $hebergement->id)
//		  ->andWhere('H.id_client = ? ', $this->id)
//		  ->groupBy('H.id');
		 

// 		$q->displayQuery = true;  
		  
		$r = $q->executeQuery();

		return $r;
	}
	
	
	public function createRelance($hebergement){
		
		//Test si d?j? une relance pour cet h?bergement
		if($this->testRelanceWithHebergement($hebergement->id)){
			
			$duree = $hebergement->duree;
//			print_r_html($hebergement);
			
			//Test si autre(s) h?bergement(s) le m?me jour (date_valid)
//			$hebergements = $this->getHebergementsSameDate($hebergement);
			
//			print_r_html($hebergements);
			
//			$h_valid = array();
//			if(!empty($hebergements)){
//				foreach($hebergements as $h){
//					//Test si d?j? une relance pour ces autres h?bergemetns
//					if($this->testRelanceWithHebergement($h->id)){
//						$h_valid[] = $h;
//					}
//				}
//			}
//			else{
//				new Alert('H?bergement seul, pas d\'autre service ? associer');
//			}
			
			
			//Test si autres h?bergements ? payer dans les 90 jours
			$hebergements = $this->getHebergementsGroup($hebergement);
			$h_g_valid = array();
			if(!empty($hebergements)){
				foreach($hebergements as $h){
					//Test si d?j? une relance pour ces h?bergements		
					if($this->testRelanceWithHebergement($h->id)){
						$ratio = (365 - $h->jours_ratio) / 365;
						$h->qte = $ratio;
						$h->duree = $duree;
						
						$h_g_valid[] = $h;
					}		
				}
			}
			else{
				new Alert('Pas d\'hébergement à grouper');
			}
			
			$allHebergement = array();
			$allHebergement[] = $hebergement;
//			$allHebergement = array_merge($allHebergement, $h_valid, $h_g_valid);
			$allHebergement = array_merge($allHebergement, $h_g_valid);
			
//			print_r_html($allHebergement);
			
			$this->addRelances($allHebergement,$duree);
		}
		else{
			new Alert('Une relance existe déjà pour ce service :'. $hebergement->designation);
		}
		
		return;
	}

	
	private function addRelances($hebergements,$duree = 1){
		
//		print_r_html($hebergements);
		
		$relance = new Relances();
		
		$relance->id_intitule_entete = 3;
		$relance->id_client = $this->id;
		$relance->duree_valid = $duree;
		$relance->tva = $this->tva;
		$relance->save();
		
		$relance->id = $relance->getLastInsertId();
		

		$join = new Join_Relances_Hebergements();
		$join->delete(array('id_relances' => $relance->id));
		$relance->hebergements = array();
		
		$elems = new Elems();
		$elems->delete(array('id_relances' => $relance->id));
		$relance->elems = array();
		
		
		$hebergements = $relance->JoinWithHebergement($hebergements, true);
		$relance->addElems();
		
		
		$relance->getTotaux($hebergements);
		$relance->save();
		
                
                
//		print_r_html($relance);
//		print_r_html($relance->elems);
		
		$relance->createPDF();
		
		return $this;
	}





}
?>