<?php
function bdd_installe_textes_AOL_XML($fichier_xml) {
	if(!file_exists($fichier_xml)) {
		return;
	}

	//bdd_ajoute_texte_boutique();
	include_once("includes/general/XmlParser.class.php");

	$xml=new XmlParser();
	echo "load XML ->$fichier_xml<br>";
	$donnees=$xml->parse($fichier_xml);

	$textes=$donnees[0]["child"];

	if(count($textes)>0) {
		foreach($textes as $texte) {
			if($texte["name"]=="TEXTE") {
				$identifiant=$texte["attrs"]["IDENTIFIANT"];
				$html=$texte["attrs"]["HTML"];
				$id_objet=$texte["attrs"]["ID_OBJET"];
				$id_ensemble=$texte["attrs"]["ID_ENSEMBLE"];
				$nb_lignes=$texte["attrs"]["NB_LIGNES"];
				$node_trads=$texte["child"][0]["child"];
				$trads=array();
				$titre="";
				foreach($node_trads as $trad) {
					$drapeau=strtolower($trad["name"]);
					$trads[$drapeau]=$trad["content"];
				}
				bdd_ajoute_texte_boutique_AOL($identifiant,$trads, $html, $nb_lignes,$id_objet,$id_ensemble,$titre);
			}
		}
	}

}
function bdd_installe_textes_XML($fichier_xml) {
	if(!file_exists($fichier_xml)) {
		return;
	}

	//bdd_ajoute_texte_boutique();
	include_once("includes/general/XmlParser.class.php");

	$xml=new XmlParser();
	echo "load XML ->$fichier_xml<br>";
	$donnees=$xml->parse($fichier_xml);

	$categories=$donnees[0]["child"];
	//	print_rr($categories);
	foreach($categories as $cat) {
		$nom_cat=$cat["attrs"]["NOM"];
		bdd_ajoute_texte_site_categorie2($nom_cat);
		$textes=$cat["child"];
		if(count($textes)>0) {
			foreach($textes as $texte) {
				if($texte["name"]=="TEXTE") {
					$identifiant=$texte["attrs"]["IDENTIFIANT"];
					$html=$texte["attrs"]["HTML"];
					$visible=$texte["attrs"]["VISIBLE"];
					$nb_lignes=$texte["attrs"]["NB_LIGNES"];
					$node_trads=$texte["child"][0]["child"];
					$trads=array();
					$titre="";
					foreach($node_trads as $trad) {
						$drapeau=strtolower($trad["name"]);
						$trads[$drapeau]=$trad["content"];
					}
					//				print_rr($trads);
					bdd_ajoute_texte_boutique($identifiant,$trads,$nom_cat, $html, $nb_lignes,$visible,$titre);
				}
			}
		}
	}
	//exit;
}
function bdd_valeurs_options_XML($fichier_xml) {
	//bdd_ajoute_texte_boutique();
	if(!file_exists($fichier_xml)) {
		return;
	}
	include_once("includes/general/XmlParser.class.php");

	$xml=new XmlParser();
	echo "load XML ->$fichier_xml<br>";
	$donnees=$xml->parse($fichier_xml);

	$options=$donnees[0]["child"];
	foreach($options as $node_option) {

		$variable=$node_option["attrs"]["VARIABLE"];
		$site=$node_option["attrs"]["SITE"];
		$visible=$node_option["attrs"]["VISIBLE"];
		$node_valeur=$node_option["child"][0];
		switch($node_valeur["name"]) {
			case "VALEUR":

				$valeur=$node_valeur["content"];
				break;
			case "VALEURS":
				$valeur=array();
				$node_val_ml = $node_valeur["child"];
				if(count($node_val_ml)>0) {
					foreach($node_val_ml as $node_val_ml) {
						$drapeau=strtolower($node_val_ml["name"]);
						$valeur[$drapeau]=$node_val_ml["content"];
					}
				}
				break;
		}
//		if(is_array($valeur))
//		print_rr($valeur);
		$valeur=str_replace("#BOUTIQUE_REPERTOIRE",BOUTIQUE_REPERTOIRE,$valeur);
		bdd_ajoute_option_valeur_defaut($variable, $valeur, $site, $visible);
		//....
	}
	//$categories=$donnees[0]["child"];

	//ifReq("DROP DATABASE `efroggdemo2`");
	//exit;
}
function bdd_ajoute_texte_boutique_AOL($identifiant,$texte, $html=0, $nb_lignes=0,$id_objet=0,$id_ensemble=0,$titre="") {
	bdd_ajoute_texte_general($identifiant,$texte,"AOL", $html, $nb_lignes,$id_objet,$id_ensemble,$titre);

}
function bdd_ajoute_texte_boutique($identifiant,$texte,$categorie="texte", $html=0, $nb_lignes=0,$visible=0,$titre="") {

	bdd_ajoute_texte_site_categorie2($categorie);
	if($res=testReq2("SELECT id FROM shop_ml_site_categories WHERE nom='$categorie'")) {
		$id_categorie=$res["id"];
	} else {
		echo "Erreur insertion / recup de la catégorie $categorie ...";
		return false;
	}
	$visible=($visible?1:0);
	$html=($html?1:0);
	bdd_ajoute_texte_general($identifiant,$texte,"site", $html, $nb_lignes,$visible,$id_categorie,$titre);
}


function  bdd_ajoute_texte_general($identifiant,$texte, $classement = "",$html=0, $nb_lignes=0,$id_objet=0,$id_ensemble=0,$titre="") {
	global $id_boutique,$langue_defaut;
	if(testReq2("SELECT id FROM shop_ml_champs WHERE identifiant='$identifiant' AND id_boutique=$id_boutique")) {
		// le champ existe, on ne fait rien
		return true;
	}
	// si langue = -1, on remplit toutes les langues
	// sinon, langue="fr", etc ....
	
	
	

	print("<br>creation champ $identifiant...");
	//	print("INSERT INTO shop_ml_champs SET id_boutique=$id_boutique, titre='$titre', classement='site', id_ensemble=$id_categorie, id_objet=$visible, identifiant='$identifiant', html=$html, nb_lignes=$nb_lignes");
	if(ifReq("INSERT INTO shop_ml_champs SET id_boutique=$id_boutique, titre='$titre', classement='$classement', id_ensemble=$id_ensemble, id_objet=$id_objet, identifiant='$identifiant', html=$html, nb_lignes=$nb_lignes")) {
		print("ok...");
		$id_champ=mysql_insert_id();
		/*if(!$query_langues=ifReq("SELECT id,drapeau FROM shop_ml_langues WHERE id_boutique=$id_boutique AND drapeau='fr'")) {
		 $query_langues=ifReq("SELECT id,drapeau FROM shop_ml_langues WHERE id_boutique=$id_boutique AND drapeau='$langue_defaut'");
		 }*/
		$query_langues=ifReq("SELECT id,drapeau FROM shop_ml_langues WHERE id_boutique=$id_boutique");
		if($query_langues) {
			while($res_langue=mysql_fetch_array($query_langues)) {
				print("...$res_langue[drapeau]...");

				// recup la trad
				if(is_array($texte)) {
					if(isset($texte[$res_langue["drapeau"]])) {
						$le_texte=$texte[$res_langue["drapeau"]];
					} else {
						$le_texte=$texte["fr"];
					}
				} else {

					$le_texte=$texte;
				}
				$le_texte=mysql_real_escape_string($le_texte);
				// fin recup

				if(!ifReq("INSERT INTO shop_ml_traductions SET id_boutique=$id_boutique, id_champs=$id_champ, id_langue=$res_langue[id], texte='$le_texte'")) {
					print("ERREUR !");
					return false;
				}
				print("ok");
			}
			return true;
		}
	}
}
function bdd_definit_trigger($nom,$version) {
	bdd_definit_function($nom,$version,"TRIGGER");
}

function bdd_definit_procedure($nom,$version) {
	bdd_definit_function($nom,$version,"PROCEDURE");
}
function bdd_definit_function($nom,$version,$type="FUNCTION") {
	$version="test"; // force la mise a jour a tous les coups ! 
	global $bdd_nombase;
	$req=file_get_contents("includes/admin/actions_bdd/$type/$nom.sql");
	$efface=false;
	if($type=="TRIGGER") {
		if($res_tmp=testReq2("SHOW TRIGGERS LIKE '$nom'")) {
			$efface = true;
		} 
	} else if(testReq2("SHOW $type STATUS WHERE Db =  '$bdd_nombase' AND Name='$nom'")) {
		$efface = true;
	} else {
		// selon les serveurs...
		$req="DROP $type IF EXISTS $nom [||] $req";
	}//drop function bonjour
	
	if($efface) {
		$req="DROP $type $nom [||] $req";
	} else {
		// on ne l'a pas, au cas ou, on efface la mise a jour unique si existe
		bdd_reset_mise_a_jour_unique("$type $nom");
	}
	bdd_mise_a_jour_unique("$type $nom",$req,$version);

}
function bdd_reset_mise_a_jour_unique($identifiant) {
	ifReq("DELETE FROM shop_mises_a_jour WHERE identifiant='$identifiant'");
}
/**
 *
 * @param $identifiant
 * @param $version_attendue
 * @return true si la requete est a faire
 */
function bdd_teste_maj_unique_a_faire($identifiant,$version_attendue=1) {
	return (!$res=testReq2("SELECT faite FROM shop_mises_a_jour WHERE identifiant='$identifiant' AND faite>=$version_attendue"));
}
function bdd_valide_maj_unique($identifiant,$version_attendue=1) {
	if(ifReq("INSERT INTO shop_mises_a_jour SET identifiant='$identifiant', faite='$version_attendue', date_maj=NOW()")) {
		print("sauvegardée<br>");
		return true;
	} else if(ifReq("UPDATE shop_mises_a_jour SET faite='$version_attendue', date_maj=NOW() WHERE identifiant='$identifiant'")) {
		print("sauvegardée<br>");
		return true;
	} else if(strpos($version_attendue,"test")>-1) {
		print("en test");
		return true;
	}
	print("non sauvegardée ! ");
}
function bdd_mise_a_jour_unique($identifiant,$req,$version_attendue=1) {
	// la requete a un identifiant unique.
	// elle ne sera appelée qu'une seule fois
	// sauf si on s'amuse (que ca a faire !!!) a supprimer la table des mises a jour ...
	// faudrait le faire expres.
	if(bdd_teste_maj_unique_a_faire($identifiant,$version_attendue)) {
		// il faut la faire, elle n'existe pas
		print("Mise a jour unique : $identifiant (v$version_attendue) ...");
		$liste_req=explode("[||]",$req);
		$erreur=false;
		$cpt=0;
		for($i=0;$i<count($liste_req);$i++) {
			$req=$liste_req[$i];
			$cpt++;
			//print($req);
			if(!ifReq($req)) {
				$erreur=true;
				break;
			}
			print($cpt."..");
		}

		if(!$erreur) {
			print("ok...");
			bdd_valide_maj_unique($identifiant,$version_attendue);
		}
		print("erreur !!!<br>".mysql_error()."<br><br>");
	}
	return false;
}
function bdd_renomme_colonne($nouveau_nom,$table,$req_insert) {
	if(!ifReq("SELECT $nouveau_nom FROM $table LIMIT 0,1")) {
		print("mise a jour table $table renomme -> $nouveau_nom...");
		if(!ifReq($req_insert)) {
			print("erreur !!");
		}
		print("ok<br>");
	}
}

function bdd_ajoute_colonne($colonne,$table,$req_insert) {
	if(!ifReq("SELECT `$colonne` FROM $table LIMIT 0,1")) {
		// vérification une colonne
		// on n'a pas la colonne $colonne
		print("mise a jour table $table ajout colonne : $colonne...");
		if(!ifReq($req_insert)) {
			print("erreur !!");
		}
		print("ok<br>");
	}

}
function bdd_suppr_colonne($colonne,$table) {
	if(ifReq("SELECT $colonne FROM $table LIMIT 0,1")) {
		//on a la colonne $colonne
		print("mise a jour table $table suppression colonne : $colonne");
		if(!ifReq("ALTER TABLE `$table` DROP `$colonne`")) {
			print("erreur !!");
		}
		print("ok<br>");
	}
}

function bdd_ajoute_option4($variable,$v_nom,$chemin_rubrique,$type,$v_predef,$commentaire,$position=999,$is_constante=-1) {
	bdd_ajoute_option3($variable,$v_nom,$chemin_rubrique,$type,$v_predef,$commentaire,"ne_pas_remplir",0,0,$position,$is_constante) ;
}


function bdd_ajoute_option3($variable,$v_nom,$chemin_rubrique,$type,$v_predef,$commentaire,$val_def="ne_pas_remplir",$site=0,$visible=0,$position=999,$is_constante=-1) {
	$constante=$is_constante==-1?0:$is_constante;
	$predef=mysql_real_escape_string($v_predef);
	$nom=mysql_real_escape_string($v_nom);
	$commentaire=mysql_real_escape_string($commentaire);
	$id_rubrique = bdd_ajoute_rubrique_option2($chemin_rubrique);
	$req="INSERT INTO `shop_options` ( `nom`, `variable`, `id_rubrique`, `type`, `predef`, `commentaire`,`position`,`constante`) VALUES ( '$nom', '$variable', $id_rubrique, '$type', '$predef', '$commentaire','$position','$constante''');";

	if(!($res=testReq2("SELECT id, variable, id_rubrique, position,constante,nom,predef,type FROM shop_options WHERE variable='$variable'"))) {
		print("ajout de l'option : '$variable' ...");
		if(!ifReq($req)) {
			print("erreur !!<br>");
			return false;
		}
		// l'option a été rajoutée
		if($constante) {
			include_once("includes/general/ini_set.inc.php");
			ini_set_boutique("CST_$variable",$val_def);
		}
		print("ok<br>");
	} else {
		//test si l'option a été déplacée
		if($res["id_rubrique"]!=$id_rubrique || $res["position"]!=$position){
			print("déplacement de l'option : '$variable'<br>");
			ifReq("UPDATE shop_options SET id_rubrique=$id_rubrique, position=$position WHERE variable='$variable'");
		}
		// changement dans la constante
		if(($res["constante"]!=$constante) && ($is_constante!=-1)) {
			if($is_constante==1) bdd_set_option_constante($variable);
			else bdd_unset_option_constante($variable);
		}
		// changement dans le nom ou les valeurs prédéfinies
		if($res["nom"]!=$v_nom || $res["predef"]!=$v_predef ||  $res["type"]!=$type ){
			print("mise a jour de l'option : '$variable' <br>");//($res[nom]!=$v_nom || $res[predef]!=$v_predef)
			ifReq("UPDATE shop_options SET predef='$predef', nom='$nom', type='$type' WHERE variable='$variable'");
		}
	}


	if(($val_def!="ne_pas_remplir") && ($val_def!=NULL)) {
		bdd_ajoute_option_valeur_defaut($variable, $val_def, $site, $visible);
	}
}
function bdd_ajoute_option2($variable,$nom,$id_rubrique,$type,$predef,$commentaire,$val_def=NULL,$site=0,$visible=0) {
	$predef=mysql_real_escape_string($predef);
	$nom=mysql_real_escape_string($nom);
	$commentaire=mysql_real_escape_string($commentaire);
	$req="INSERT INTO `shop_options` ( `nom`, `variable`, `id_rubrique`, `type`, `predef`, `commentaire`) VALUES ( '$nom', '$variable', $id_rubrique, '$type', '$predef', '$commentaire');";
	bdd_ajoute_option($variable,$req);
	if(($val_def!="ne_pas_remplir") && ($val_def!=NULL)) {
		bdd_ajoute_option_valeur_defaut($variable, $val_def, $site, $visible);
	}
}
function bdd_ajoute_option($variable,$req) {
	if(!testReq2("SELECT variable FROM shop_options WHERE variable='$variable'")) {
		// vérification un enregistrement
		// on n'a pas l'option MENU_news
		print("ajout de l'option : '$variable' ...");
		if(!ifReq($req)) {
			print("erreur !!<br>");
			return false;
		}
		print("ok<br>");
	}
	return true;
}
function bdd_ajoute_option_image($nom,$texte) {
	bdd_ajoute_option3("IMG_$nom"."_chemin","Chemin pour $texte","Image","texte","","Chemin relatif à la racine du site");
	bdd_ajoute_option3("IMG_$nom"."_hauteur","Hauteur pour $texte","Image","numerique","","La hauteur de l'image");
	bdd_ajoute_option3("IMG_$nom"."_largeur","Largeur pour $texte","Image","numerique","","La largeur de l'image");
	bdd_ajoute_option3("IMG_$nom"."_type","Type pour $texte","Image","liste","EXACT||CONV||MAX||PIXELSMAX||CROPMAX||CROPMAXVERTICAL||CROPMAXHORIZONTAL","Le type de redimmensionnement");
	bdd_ajoute_option3("IMG_$nom"."_zzz","","Image","separateur","","");
}
function bdd_supprime_option($variable) {
	if($res=testReq2("SELECT id FROM shop_options WHERE variable='$variable'")) {
		// vérification un enregistrement
		$id_option = $res["id"];
		print("suppression de l'option : '$variable' ...");
		if(ifReq("DELETE FROM shop_options WHERE id=$id_option")) {
			if(ifReq("DELETE FROM shop_options_valeurs WHERE id_option=$id_option")) {
				print("ok<br>");
				return true;
			}
		}
		print("erreur !!<br>");
		return false;
	}
	return true;
}
function bdd_ajoute_rubrique_option2($chemin_rubrique) {
	global $id_structure_options;
	$liste_noms = explode(".",$chemin_rubrique);
	$liste_id_rubrique = array();
	$liste_positions = array();
	for($i=0;$i<count($liste_noms);$i++) {
		if(count($liste_id_rubrique)==0) {
			$id_parent = 0;
		} else {
			$id_parent = end($liste_id_rubrique);
		}
		$req = "SELECT id, position FROM shop_struct_elems WHERE nom='$liste_noms[$i]' AND id_parent=$id_parent AND id_structure=$id_structure_options";
		if($res = testReq2($req)) {
			$liste_id_rubrique[] = $res["id"];
			$liste_positions[] = $res["position"];
		} else {
			//la rubrique n'existe pas, on l'ajoute
			print("ajout de la rubrique d'option : '");
			for($j=0;$j<$i;$j++) {
				print("$liste_noms[$j].");
			}
			print("$liste_noms[$i]' ...");
			$struct = testReq2("SELECT max_id FROM shop_structures WHERE id=$id_structure_options");
			$id_rubrique = $struct["max_id"]+1;

			$maxPosition = testReq2("SELECT MAX(position)+1 AS maxpos FROM shop_struct_elems WHERE id_parent=$id_parent AND id_structure=$id_structure_options");
			if(!($position = $maxPosition["maxpos"])) {
				$position = "0";
			}
			$liste_positions[] = $position;
			$chemin = implode(".",$liste_positions);
			$liste_id_rubrique[] = $id_rubrique;
			$liste_parents = implode("-",$liste_id_rubrique);
			if(!ifReq("INSERT INTO shop_struct_elems SET id_structure=$id_structure_options, id=$id_rubrique, id_parent=$id_parent, liste_parents='-$liste_parents-', liste_enfants='--', chemin='$chemin', position='$position', nom='$liste_noms[$i]', actif=1")) {
				print("erreur !!<br>");
				return false;
			}
			$liste_parents = implode(",",$liste_id_rubrique);
			ifReq("UPDATE shop_struct_elems SET liste_enfants=CONCAT(liste_enfants,'$id_rubrique-') WHERE id_structure=$id_structure_options AND id!=$id_rubrique AND id IN ($liste_parents)");
			ifReq("UPDATE shop_structures SET max_id = max_id+1 WHERE id=$id_structure_options");
			print("ok<br>");
		}
	}
	return end($liste_id_rubrique);
}
function bdd_nettoyage_rubriques_vides() {
	global $id_structure_options;
	$isSuppression = false;
	$listeRubriques = ifReq("SELECT id, nom FROM shop_struct_elems WHERE liste_enfants='--' AND id_structure=$id_structure_options AND id NOT IN (SELECT DISTINCT id_rubrique FROM shop_options)");
	for($i=0;$i<mysql_num_rows($listeRubriques);$i++) {
		$id_rubrique = mysql_result($listeRubriques,$i,"id");
		$nom = mysql_result($listeRubriques,$i,"nom");
		if(ifReq("DELETE FROM shop_struct_elems WHERE id=$id_rubrique AND id_structure=$id_structure_options")) {
			ifReq("UPDATE shop_struct_elems SET liste_enfants=REPLACE(liste_enfants, '-$id_rubrique-', '-') WHERE liste_enfants LIKE '%-$id_rubrique-%' AND id_structure=$id_structure_options");
			$isSuppression = true;
			print("Suppression de la rubrique $nom<br>");
		}
	}
	if($isSuppression) {
		//on recommence pour vérifier le cas des dossiers parents
		bdd_nettoyage_rubriques_vides();
	}
}
function bdd_ajoute_rubrique_option($nom,$id) {
	// l'id doit étre défini en dur, car apres, on y fait référence. Et ce sont des faimmes qui ne bougent plus
	if(!testReq2("SELECT nom FROM shop_options_rubriques WHERE nom='$nom'")) {
		//on a pas cette rubrique d'option
		print("ajout de la rubrique d'option : '$nom' ...");
		if(!ifReq("INSERT INTO shop_options_rubriques SET id=$id, nom='$nom'")) {
			print("erreur !!<br>");
			return false;
		}
		print("ok<br>");
	}
	return true;
}
function bdd_ajoute_option_valeur_defaut($variable, $valeur, $site, $visible) {
	global $id_boutique, $mabd;
	if($res_option = testReq2("SELECT id, type FROM shop_options WHERE variable = '$variable'")) {
		$id_option = $res_option["id"];
		$type = $res_option["type"];
		$a_une_valeur = testReq2("SELECT valeur FROM shop_options_valeurs WHERE id_boutique=$id_boutique AND id_option=$id_option");
		// TODO : virer les résidus
		if($a_une_valeur && isset($_REQUEST["RAZ_options"])) {
			ifReq("DELETE FROM shop_ml_champs WHERE id_boutique=$id_boutique AND classement='option' AND id_ensemble=0 AND id_objet=$id_option AND identifiant='$variable'");
			ifReq("DELETE FROM shop_options_valeurs WHERE id_option=$id_option AND id_boutique=$id_boutique ");
			$a_une_valeur = false;
		}
			
		if(!$a_une_valeur) {
			//l'option n'a pas de valeur définie
			print("ajoute une valeur par défaut pour l'option : $variable...");
			
			
			if($type=="multilangue" || $type=="multilangue_long") {
				//c'est une option multilangue
				if(ifReq("INSERT INTO shop_options_valeurs SET id_option=$id_option, id_boutique=$id_boutique, valeur='$valeur', site=$site, visible=$visible")) {
					$id_valeur = mysql_insert_id();
					$resultat=mysql_query("SELECT id,drapeau FROM shop_ml_langues WHERE id_boutique=$id_boutique ORDER BY id",$mabd);
					ifReq("INSERT INTO shop_ml_champs SET id_boutique=$id_boutique, classement='option', id_ensemble=0, id_objet=$id_option, identifiant='$variable'");
					$id_champs=mysql_insert_id();
					for($i=0;$i<mysql_num_rows($resultat);$i++) {
						$id_langue = mysql_result($resultat,$i,"id");
						$drapeau = mysql_result($resultat,$i,"drapeau");
						print("...$drapeau...");
						// recup la trad
						if(is_array($valeur)) {
							if(isset($valeur[$drapeau])) {
								$le_texte=$valeur[$drapeau];
							} else {
								$le_texte=$valeur["fr"];
							}
						} else {
							$le_texte=$valeur;
						}
						$le_texte=mysql_real_escape_string($le_texte);
						// fin recup
						ifReq("INSERT INTO shop_ml_traductions SET texte='$le_texte', id_boutique=$id_boutique, id_champs=$id_champs, id_langue=$id_langue");
					}
					if(!ifReq("UPDATE shop_options_valeurs SET valeur = $id_champs WHERE id_option=$id_option AND id_boutique=$id_boutique")) {
						print("erreur !!");
					}
				}
			} else {
				//ce n'est pas une option multilangue
				if(!ifReq("INSERT INTO shop_options_valeurs SET id_option=$id_option, id_boutique=$id_boutique, valeur='$valeur', site=$site, visible=$visible")) {
					print("erreur !!");
				}
			}
			print("ok<br>");
		} else {
			// l'option a deja une valeur 
			
		}
	}
}

function bdd_ajoute_module($identifiant,$actif=0,$ordre=10) {
	global $id_boutique;
	if(!testReq2("SELECT identifiant FROM shop_modules WHERE identifiant='$identifiant' AND id_boutique=$id_boutique")) {
		print("ajout du module '$identifiant'...");
		if(!ifReq("INSERT INTO `shop_modules` ( `identifiant` , `actif`, `id_boutique`, `ordre` ) VALUES ('$identifiant', '$actif','$id_boutique','$ordre');")) {
			print("erreur !!<br>");
			return false;
		}
		print("ok<br>");
		return true;
	}
}

function bdd_cree_table($nom_table,$requete,$version=1) {
	if(!ifReq("ALTER TABLE $nom_table")) {
		// on n'a pas la table $nom_table
		print("création de la table $nom_table...");
		bdd_reset_mise_a_jour_unique("CREATION_TABLE_$nom_table");
		if(bdd_mise_a_jour_unique("CREATION_TABLE_$nom_table",$requete,$version)===false) {
			print("erreur !!");
		}
		print("ok<br>");
	} else {
		if($version!=1) {
			bdd_mise_a_jour_unique("CREATION_TABLE_$nom_table","DROP TABLE $nom_table;[||]$requete",$version);
		}
	}
}

function bdd_ajoute_champs_archive($nom_table) {
	bdd_ajoute_colonne("log_date",$nom_table,"ALTER TABLE `$nom_table` ADD `log_date` DATETIME NOT NULL ;");
	bdd_ajoute_colonne("log_user",$nom_table,"ALTER TABLE `$nom_table` ADD `log_user` VARCHAR(50) NOT NULL ;");

}
function bdd_log_modifs($table_from,$table_to,$where) {
	$login=$_REQUEST["login"];
	if(ifReq("INSERT INTO $table_to SELECT *, NOW() as log_date, '$login' as log_user FROM $table_from WHERE $where")) {

		return true;
	}

	return false;
}

function bdd_ajoute_droit_rubrique($nom) {
	if(!testReq2("SELECT nom FROM shop_droits_rubriques WHERE nom='$nom'")) {
		// vérification un enregistrement
		// on n'a pas la valeur news dans la table shop_droits_rubriques
		print("ajout droits rubriques : $nom ...");
		if(!ifReq("INSERT INTO `shop_droits_rubriques` ( `id` , `nom` ) VALUES ('', '$nom');")) {
			print("erreur !!<br>");
		}
		print("ok<br>");
	}
	return true;
}
function bdd_ajoute_texte_site_categorie2($nom) {
	global $cat_texte_connues;
	if(!isset($cat_texte_connues))
	$cat_texte_connues=array();
	if(!in_array($nom,$cat_texte_connues)){
		if(!testReq2("SELECT nom FROM shop_ml_site_categories WHERE nom='$nom'")) {
			//on a pas cette catégorie de texte
			print("ajout de la catégorie de texte : '$nom' ...");
			if(!ifReq("INSERT INTO `shop_ml_site_categories` ( `id` , `nom` ) VALUES ('', '$nom')")) {
				print("erreur !!<br>");
				return false;
			}
			print("ok<br>");
		}

		$cat_texte_connues[]=$nom;
	}
	return true;

}
function bdd_change_type_colonne($colonne,$table,$nouveau_type) {
	// nouveau type : DECIMAL (9 , 2) NOT NULL
	// les espaces ne comptent pas
	$query = ifReq("SHOW FIELDS FROM $table");
	while($res=mysql_fetch_array($query)) {
		if($res["Field"]=="$colonne") {
			//print_r($res);
			$str_comp = strtoupper(trim($res["Type"]));
			$str_comp.=(($res["Null"]=="YES")?" NULL":"NOT NULL");
			$str_comp=str_replace(" ","",$str_comp);
			$str_nouveau_type=strtoupper(str_replace(" ","",$nouveau_type));
			//print($str_comp." != ".$str_nouveau_type);
			if($str_comp!=$str_nouveau_type) {
				print("modification du type de la colonne $colonne de la table $table : $nouveau_type ... ($str_comp!=$str_nouveau_type)" );
				if(ifReq("ALTER TABLE `$table` CHANGE `$colonne` `$colonne` $nouveau_type")) {
					print("ok<br>");
					return true;
				}
				print("erreur");
				return false;
			};
		}
	}
}

function bdd_change_character_set($colonne, $table, $type, $nouveau_character_set, $nouveau_collation) {
	global $bdd_nombase;
	/*if(!testReq2("SELECT CHARACTER_SET_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA='$bdd_nombase' AND TABLE_NAME='$table' AND COLUMN_NAME='$colonne'
	 AND CHARACTER_SET_NAME='$nouveau_character_set' AND COLLATION_NAME='$nouveau_collation'")) {
	 print("modification du character set de la colonnne $colonne de la table $table : $nouveau_character_set $nouveau_collation ...");
	 if(!ifReq("ALTER TABLE `$table` CHANGE `$colonne` `$colonne` $type CHARACTER SET $nouveau_character_set COLLATE $nouveau_collation")) {
	 print("erreur !!<br>");
	 return false;
	 }
	 print("ok<br>");
	 }
	 return true;*/
}
function bdd_set_cle($table,$champ,$type_index="",$liste_champs="") {
	//$type : UNIQUE / INDEX / ''
	$query=ifReq("SHOW KEYS FROM $table");
	$non_unique_attendu=($type_index=="UNIQUE"?0:1);
	while($res=mysql_fetch_array($query)) {
		if($res["Column_name"]=="$champ") {
			if($type_index=="") {
				if(ifReq("ALTER TABLE `$table` DROP INDEX `$res[Key_name]`")) {
					print("suppression clé $table.$champ ... ok<br>");
					return true;
				}
			} else {
				if($res["Non_unique"]!=$non_unique_attendu) {
					if(strlen($liste_champs)>0) {
						$chpReq = $liste_champs;
					} else {
						$chpReq = "$champ";
					}
					if(ifReq("ALTER TABLE `$table` DROP INDEX `$res[Key_name]` ,
								ADD $type_index `$champ` ($chpReq) ")) {
					print("modification clé $table.$champ : $type_index... ok<br>");
					return true;
								}
								print("modification clé $table.$champ : $type_index... erreur !!(".mysql_error().")<br>");
								return false;
				}
			}
			return true;
		}

	}
	if($type_index!="") {
		// on n'a pas l'index
		if(isset($liste_champs) && (strlen($liste_champs)>0)) {
			$chpReq = $liste_champs;
		} else {
			$chpReq = "$champ";
		}
		if(ifReq("ALTER TABLE `$table` ADD $type_index ($chpReq)")) {
			print("ajout clé $table.$champ : $type_index... ok<br>");
			return true;
		}
		print("ajout clé $table.$champ : $type_index... erreur !!<br>");
		return false;
	}
	// on arrive ici quand on doit retirer une clé, et qu'elle n'y était deja pas
	return true;

}

function bdd_ajoute_langue($langue,$drapeau) {
	global $id_boutique;
	if(!testReq2("SELECT drapeau FROM shop_ml_langues WHERE id_boutique=$id_boutique AND drapeau='$drapeau'")) {
		// la langue n'existe pas
		print("ajoute une langue : $langue...");
		if(!ifReq("INSERT INTO shop_ml_langues SET id_boutique=$id_boutique, nom='$langue', drapeau='$drapeau'")) {
			$id_langue = mysql_insert_id();
			if(!ifReq("INSERT INTO shop_ml_traductions (id_boutique, id_champs, id_langue)
						SELECT id_boutique, id, $id_langue AS id_langue FROM shop_ml_champs WHERE id_boutique=$id_boutique")) {
			// le champ ne s'est pas bien inséré
			print("erreur !!");
			return false;
						}
		}
		print("ok<br>");
	}
}
function bdd_ajoute_pays($pays) {
	global $id_boutique, $mabd;
	if(!$res=testReq2("SELECT tr.id_champs FROM shop_ml_traductions AS tr INNER JOIN shop_ml_champs AS ch ON ch.id = tr.id_champs WHERE tr.id_boutique=$id_boutique AND tr.texte='$pays[0]' AND ch.classement='pays'")) {
		//le pays n'existe pas
		print("ajoute un pays : $pays[0]...");
		if(ifReq("INSERT INTO shop_zones_pays SET id_boutique=$id_boutique")) {
			$id_pays = mysql_insert_id();
			$resultat=mysql_query("SELECT id FROM shop_ml_langues WHERE id_boutique=$id_boutique ORDER BY id",$mabd);
			ifReq("INSERT INTO shop_ml_champs SET id_boutique=$id_boutique, classement='pays', id_ensemble=0, id_objet=$id_pays");
			$id_champs=mysql_insert_id();
			for($i=0;$i<mysql_num_rows($resultat);$i++) {
				$id_langue = mysql_result($resultat,$i,"id");
				ifReq("INSERT INTO shop_ml_traductions SET texte='$pays[$i]', id_boutique=$id_boutique, id_champs=$id_champs, id_langue=$id_langue");
			}
			if(!ifReq("UPDATE shop_zones_pays SET pays = $id_champs WHERE id = $id_pays")) {
				print("erreur !!");
			}
		}
		print("ok<br>");
	} else {
		//le pays existe déjà
		$id_champs = $res["id_champs"];
		$langues=mysql_query("SELECT id FROM shop_ml_langues WHERE id_boutique=$id_boutique ORDER BY id",$mabd);
		for($i=0;$i<mysql_num_rows($langues);$i++) {
			$id_langue = mysql_result($langues,$i,"id");
			if(!testReq2("SELECT texte FROM shop_ml_traductions WHERE id_champs=$id_champs AND id_langue=$id_langue")) {
				//il manque une traductions
				print("complète la traduction du pays : $pays[$i]...");
				if(!ifReq("INSERT INTO shop_ml_traductions SET texte = '$pays[$i]', id_boutique=$id_boutique, id_champs=$id_champs, id_langue=$id_langue")) {
					print("erreur !!");
				}
				print("ok<br>");
			}
		}
	}
}

function bdd_active_module($identifiant,$active=1) {

	global $id_boutique;
	$liste_activer=array();
	if($active==1) {
		// on active aussi les dépendances
		$liste_attente=array($identifiant);
		while(count($liste_attente)>0) {
			$new_liste_attente=array();
			foreach($liste_attente as $module_ajout) {
				if(!in_array($module_ajout,$liste_activer)) {
					$liste_activer[]=$module_ajout;
					// on recupere ses dépendances
					$fichier_include="includes/modules/$module_ajout/Cmodule_$module_ajout.class.php";
					if(file_exists($fichier_include)) {
						include_once("$fichier_include");
						$nom_classe_module="Cmodule_".$module_ajout;
						$module=new $nom_classe_module;
						$dependances=$module->modules_dependants;
						foreach($dependances as $encore_un) {
							$new_liste_attente[]=$encore_un;
						}
					}
				}
			}
			$liste_attente=$new_liste_attente;
		}
	} else {
		$liste_activer=array($identifiant);
	}

	foreach($liste_activer as $identifiant) {
		if($res=testReq2("SELECT actif FROM shop_modules WHERE identifiant='$identifiant' AND id_boutique=$id_boutique")) {
			if($res["actif"]!=$active) {
				ifReq("UPDATE shop_modules SET actif=$active WHERE identifiant='$identifiant' AND id_boutique=$id_boutique");
			}
		} else {
			ifReq("INSERT INTO shop_modules SET identifiant='$identifiant' AND id_boutique=$id_boutique AND actif=$active");
		}
	}
}

function bdd_ajoute_structure($id_boutique,$type) {
	// structure page
	if(!testReq2("SELECT id FROM shop_structures WHERE id_boutique=$id_boutique AND type='$type'")) {
		// l'entrée n'existe pas
		print("ajoute structure $type...");
		if(!ifReq("INSERT INTO shop_structures SET id_boutique=$id_boutique, type='$type'")) {
			// le champ ne s'est pas bien inséré
			print("erreur !!");
			return false;
		}
		print("ok<br>");
	}
}

function bdd_get_structure($id_boutique,$type,$cree=true) {
	if($res=testReq2("SELECT id FROM shop_structures WHERE id_boutique=$id_boutique AND type='$type'")) {
		return $res["id"];
	} else {
		if($cree) {
			ifReq("INSERT INTO shop_structures SET id_boutique = $id_boutique, type = '$type', max_id = 0");
			return mysql_insert_id();
		}
	}
	return false;
}

function bdd_set_option_constante($variable) {
	global $id_boutique;
	if($res_option=testReq2("SELECT o.id,o.constante, v.valeur FROM shop_options o
				LEFT JOIN shop_options_valeurs v ON v.id_option=o.id
				WHERE o.variable='$variable' AND id_boutique=$id_boutique"))	{
	if($res_option["constante"]!=1) {
		print("définition de l'option $variable en constante...");
		include_once("includes/general/ini_set.inc.php");
		ini_set_boutique("CST_".$variable,$res_option["valeur"]);
		if(ifReq("UPDATE shop_options SET constante=1 WHERE id=$res_option[id]")) {
			print("ok<br>");
			return true;
		}
		print("erreur ".mysql_error()."<br>");
		return false;
	}

				}
}
function bdd_unset_option_constante($variable) {
	//print("bdd_unset_option_constante $variable");
	global $id_boutique;
	if($res_option=testReq2("SELECT o.id,o.constante, v.valeur FROM shop_options o
				LEFT JOIN shop_options_valeurs v ON v.id_option=o.id
				WHERE o.variable='$variable' AND id_boutique=$id_boutique"))	{
	if($res_option["constante"]!=0) {
		print("suppression de l'option $variable en constante...");
		include_once("includes/general/ini_set.inc.php");
		ini_unset_boutique("CST_".$variable);
		if(ifReq("UPDATE shop_options SET constante=0 WHERE id=$res_option[id]")) {
			print("ok<br>");
			return true;
		}
		print("erreur ".mysql_error()."<br>");
		return false;
	}

				}
}
function bdd_reset_options_constantes() {
	global $id_boutique;
	if($query_options=ifReq("SELECT o.variable,o.constante, v.valeur FROM shop_options o
				LEFT JOIN shop_options_valeurs v ON v.id_option=o.id
				WHERE o.constante=1 AND id_boutique=$id_boutique"))	{
	while($res_option=mysql_fetch_array($query_options)) {
		include_once("includes/general/ini_set.inc.php");
		ini_set_boutique("CST_".$res_option["variable"],$res_option["valeur"]);

	}
				}

}

?>