<?php
	global $id_boutique;
	bdd_ajoute_colonne("vendable","shop_articles","ALTER TABLE `shop_articles` ADD `vendable` TINYINT( 1 ) DEFAULT '1' NOT NULL");
	bdd_ajoute_colonne("vendable","shop_categories","ALTER TABLE `shop_categories` ADD `vendable` TINYINT( 1 ) DEFAULT '1' NOT NULL");
	// raph 25/09
	bdd_ajoute_colonne("fichier","shop_paiement_modes","ALTER TABLE `shop_paiement_modes` ADD `fichier` VARCHAR( 255 ) NOT NULL");
	bdd_ajoute_colonne("id_zone","shop_transporteurs_tranches","ALTER TABLE `shop_transporteurs_tranches` ADD `id_zone` MEDIUMINT NOT NULL ; ");
	bdd_set_cle("shop_transporteurs_tranches","id_zone","INDEX");
	//	 "ALTER TABLE `shop_transporteurs_tranches` ADD INDEX ( `id_zone` ) ;"
	// remarque de raph !! : on ne peut pas mettre deux requetes dans la meme fonction...
	bdd_suppr_colonne("pays","shop_transporteurs_tranches");
	bdd_suppr_colonne("zones","shop_transporteurs_tranches");
	bdd_ajoute_colonne("id_langue","shop_commandes","ALTER TABLE `shop_commandes` ADD `id_langue` MEDIUMINT NOT NULL ;");
	bdd_change_type_colonne("prix","shop_transporteurs_tranches","DECIMAL( 9, 2 ) NOT NULL");
	bdd_suppr_colonne("delai","shop_transporteurs");
	bdd_ajoute_colonne("delai","shop_transporteurs_tranches","ALTER TABLE `shop_transporteurs_tranches` ADD `delai` MEDIUMINT NOT NULL ; ");
	bdd_ajoute_colonne("pass2","shop_clients","ALTER TABLE `shop_clients` ADD `pass2` VARCHAR( 50 ) NOT NULL AFTER `pass` ;");
	bdd_renomme_colonne("quantite","shop_stocks_encours","ALTER TABLE `shop_stocks_encours` CHANGE `qte` `quantite` MEDIUMINT( 9 ) NOT NULL DEFAULT '0'") ;
	
	bdd_ajoute_colonne("url","shop_articles","ALTER TABLE `shop_articles` ADD `url` TEXT NOT NULL");
	
	
	bdd_definit_function("get_nom_marque","1");
	bdd_definit_function("get_nom_type","2");
	bdd_definit_function("get_prix","1");
	bdd_definit_function("recupere_nom_cat","1");
	bdd_definit_function("get_nb_art_cat","1");
	
	
	bdd_ajoute_colonne("visible","shop_paiements_disponibles","ALTER TABLE `shop_paiements_disponibles` ADD `visible` TINYINT(1) NOT NULL");
	bdd_suppr_colonne("codepromo","shop_operations");
	bdd_suppr_colonne("id_user","shop_operations");
	bdd_suppr_colonne("id_flash","shop_operations");
	bdd_suppr_colonne("id_habillage","shop_operations");
	bdd_ajoute_colonne("mots_cles","shop_categories","ALTER TABLE `shop_categories` ADD `mots_cles` MEDIUMINT NOT NULL DEFAULT '0' AFTER `texte` ;");
	
		bdd_ajoute_colonne("limite_temps","shop_operations","ALTER TABLE `shop_operations` ADD `limite_temps` TINYINT(1) NOT NULL DEFAULT '0' ;");
	bdd_change_type_colonne("debut","shop_operations","DATE NOT NULL");
	bdd_change_type_colonne("fin","shop_operations","DATE NOT NULL");
	bdd_ajoute_colonne("limite_temps","shop_operations_bons","ALTER TABLE `shop_operations_bons` ADD `limite_temps` TINYINT(1) NOT NULL DEFAULT '0' ;");
	bdd_change_type_colonne("debut","shop_operations_bons","DATE NOT NULL");
	bdd_change_type_colonne("fin","shop_operations_bons","DATE NOT NULL");
	bdd_change_type_colonne("etat","shop_operations_bons","ENUM( 'desactive', 'disponible', 'attribue', 'commande', 'encaisse' ) NOT NULL");
	bdd_ajoute_colonne("identifiant","shop_operations_bons","ALTER TABLE `shop_operations_bons` ADD `identifiant` VARCHAR(50) NOT NULL DEFAULT '' AFTER `id` ;");
	bdd_ajoute_colonne("attribue","shop_operations_bons","ALTER TABLE `shop_operations_bons` ADD `attribue` VARCHAR(50) NOT NULL DEFAULT '' ;");
	bdd_ajoute_colonne("produit","shop_operations_bons","ALTER TABLE `shop_operations_bons` ADD `produit` VARCHAR(50) NOT NULL DEFAULT '' ;");
	
	bdd_ajoute_colonne("iso_code_2","shop_zones_pays","ALTER TABLE `shop_zones_pays` ADD `iso_code_2` CHAR(2) NOT NULL DEFAULT '' ;");
	bdd_ajoute_colonne("iso_code_3","shop_zones_pays","ALTER TABLE `shop_zones_pays` ADD `iso_code_3` CHAR(3) NOT NULL DEFAULT '' ;");
	// MAJ shopzilla
	bdd_ajoute_colonne("id_shopzilla","shop_articles_types","ALTER TABLE `shop_articles_types` ADD `id_shopzilla` MEDIUMINT NOT NULL DEFAULT '0' ;");
	bdd_ajoute_colonne("dispo_shopzilla","shop_gamme_reappro","ALTER TABLE `shop_gamme_reappro` ADD `dispo_shopzilla` VARCHAR(50) NOT NULL DEFAULT '' ;");
	bdd_ajoute_colonne("condition","shop_articles","ALTER TABLE `shop_articles` ADD `condition` VARCHAR(50) NOT NULL DEFAULT 'neuf' ;");
	//
	bdd_set_cle("shop_articles","reference","UNIQUE","reference, id_structure");
	bdd_ajoute_colonne("tva", "shop_zones_pays", "ALTER TABLE `shop_zones_pays` ADD `tva` DECIMAL(9,2) NOT NULL DEFAULT '0' ;");
	bdd_ajoute_colonne("tva", "shop_zones_regions", "ALTER TABLE `shop_zones_regions` ADD `tva` DECIMAL(9,2) NOT NULL DEFAULT '0' ;");
	bdd_set_cle("shop_operations_bons","etat","INDEX");
	bdd_set_cle("shop_operations_bons","code","INDEX");
	bdd_set_cle("shop_operations_bons","id_client","INDEX");
	
		bdd_ajoute_colonne("total_promo","shop_commandes","ALTER TABLE `shop_commandes` ADD `total_promo` DECIMAL( 9, 2 ) NOT NULL AFTER `port`;");
	bdd_ajoute_colonne("total_hors_promo","shop_commandes","ALTER TABLE `shop_commandes` ADD `total_hors_promo` DECIMAL( 9, 2 ) NOT NULL AFTER `total_promo`;");
	bdd_ajoute_colonne("mots_cles","shop_articles","ALTER TABLE `shop_articles` ADD `mots_cles` MEDIUMINT(9) NOT NULL DEFAULT '-1' AFTER `description`;");
	bdd_set_cle("shop_articles_association","id_article1","UNIQUE","id_article1, id_article2");
	bdd_ajoute_colonne("id_operation","shop_commandes_bons","ALTER TABLE `shop_commandes_bons` ADD `id_operation` MEDIUMINT NOT NULL ;");
	bdd_ajoute_colonne("ordre","shop_articles","ALTER TABLE `shop_articles` ADD `ordre` MEDIUMINT(9) NOT NULL DEFAULT '0' AFTER `id`;");
	bdd_ajoute_colonne("ordre","shop_articles_virtuels","ALTER TABLE `shop_articles_virtuels` ADD `ordre` MEDIUMINT(9) NOT NULL DEFAULT '0' AFTER `id`;");
	bdd_mise_a_jour_unique("ordre_articles","Update shop_articles SET ordre = id");
	bdd_mise_a_jour_unique("ordre_articles_virtuels","Update shop_articles_virtuels SET ordre = id");
	bdd_ajoute_colonne("accepte_utf8","shop_paiements_disponibles","ALTER TABLE `shop_paiements_disponibles` ADD `accepte_utf8` TINYINT(1) NOT NULL ;");
	bdd_ajoute_colonne("code","shop_zones_regions","ALTER TABLE `shop_zones_regions` ADD `code` VARCHAR(50) NOT NULL ;");
	bdd_change_type_colonne("code_postal","shop_clients_adresses","VARCHAR(10) NOT NULL");
	bdd_change_type_colonne("code_postal","shop_commandes_adresses","VARCHAR(10) NOT NULL");

	bdd_definit_function("get_refs_associes","1");
	bdd_definit_function("get_ids_associes","1");
	
	bdd_change_type_colonne("valeurs_predef","shop_specs_valeurs","MEDIUMINT( 9 ) NOT NULL");

	bdd_mise_a_jour_unique("cle_shop_specs_valeurs","ALTER TABLE `shop_specs_valeurs` DROP PRIMARY KEY ,
ADD PRIMARY KEY ( `id_spec` , `id_article` , `valeurs_predef` ) ");
	
	
		bdd_ajoute_colonne("nom_referencement","shop_categories","ALTER TABLE `shop_categories` ADD `nom_referencement` MEDIUMINT NOT NULL");
	bdd_ajoute_colonne("date_modif","shop_articles","ALTER TABLE `shop_articles` ADD `date_modif` DATETIME NOT NULL AFTER date_ajout ;");
	bdd_ajoute_colonne("date_modif","shop_categories","ALTER TABLE `shop_categories` ADD `date_modif` DATETIME NOT NULL ;");
	bdd_ajoute_colonne("perso","shop_categories","ALTER TABLE `shop_categories` ADD `perso` VARCHAR(255) NOT NULL;");
	bdd_mise_a_jour_unique("date_modif_articles","UPDATE shop_articles SET date_modif=date_ajout ");
	bdd_mise_a_jour_unique("date_modif_categories","UPDATE shop_categories SET date_modif=NOW() ");
	
	
	// correction du retour à la ligne en fin de chaine pour toutes les regions
	bdd_mise_a_jour_unique("correc_regions","UPDATE shop_ml_traductions SET texte=TRIM( TRAILING '
' FROM texte) WHERE id_champs in (SELECT region FROM shop_zones_regions)",1);
	
	/*
	 * les différents formats d'affichage des adresses par pays
	 */
	bdd_ajoute_colonne("format_adresse","shop_zones_pays","ALTER TABLE `shop_zones_pays` ADD `format_adresse` VARCHAR(3) NOT NULL DEFAULT 'STD'");
	bdd_mise_a_jour_unique("adr_US","DELETE FROM shop_zones_format_adresse WHERE id='US'[||]
	INSERT INTO shop_zones_format_adresse SET id_boutique=$id_boutique, id='US', format='[\$adresse]
[\$ville] [\$code_region] [\$code_postal]
[\$pays]'",4);
	bdd_mise_a_jour_unique("adr_STD","DELETE FROM shop_zones_format_adresse WHERE id='STD'[||]
	INSERT INTO shop_zones_format_adresse SET id_boutique=$id_boutique, id='STD', format='[\$adresse]
[\$code_postal] [\$ville] [\$region]
[\$pays]'",3);
	
	bdd_mise_a_jour_unique("adr_ES","DELETE FROM shop_zones_format_adresse WHERE id='ES'[||]
	INSERT INTO shop_zones_format_adresse SET id_boutique=$id_boutique, id='ES', format='[\$adresse]
[\$code_postal] [\$ville] [\$region]
[\$pays]'",1);
	
	bdd_mise_a_jour_unique("adr_UK","DELETE FROM shop_zones_format_adresse WHERE id='UK'[||]
	INSERT INTO shop_zones_format_adresse SET id_boutique=$id_boutique, id='UK', format='[\$adresse]
[\$ville]
[\$region]
[\$code_postal]
[\$pays]'",1);

	bdd_mise_a_jour_unique("reg_USA","UPDATE shop_zones_pays SET format_adresse='US' WHERE iso_code_2='US'");
	bdd_mise_a_jour_unique("reg_UK","UPDATE shop_zones_pays SET format_adresse='UK' WHERE iso_code_2='UK'");
	bdd_mise_a_jour_unique("reg_ES","UPDATE shop_zones_pays SET format_adresse='ES' WHERE iso_code_2='ES'");

	bdd_ajoute_colonne("total_ht","shop_commandes","ALTER TABLE `shop_commandes` ADD `total_ht` DECIMAL( 9, 2 ) NOT NULL AFTER `total");
	bdd_ajoute_colonne("total_tva","shop_commandes","ALTER TABLE `shop_commandes` ADD `total_tva` DECIMAL( 9, 2 ) NOT NULL AFTER `total_ht");
	bdd_ajoute_colonne("prix_unit_HT","shop_commandes_elem","ALTER TABLE `shop_commandes_elem` ADD `prix_unit_HT` FLOAT NOT NULL DEFAULT 0 AFTER `prix_unit`");
	bdd_ajoute_colonne("prix_unit_TVA","shop_commandes_elem","ALTER TABLE `shop_commandes_elem` ADD `prix_unit_TVA` FLOAT NOT NULL DEFAULT 0 AFTER `prix_unit_HT`");
	bdd_ajoute_colonne("port_HT","shop_commandes","ALTER TABLE `shop_commandes` ADD `port_HT` FLOAT NOT NULL DEFAULT 0 AFTER `port`");
	bdd_ajoute_colonne("port_TVA","shop_commandes","ALTER TABLE `shop_commandes` ADD `port_TVA` FLOAT NOT NULL DEFAULT 0 AFTER `port_HT`");
	
	// pour sauver les infos articles ds les commandes	
	bdd_ajoute_colonne("ref_article","shop_commandes_elem","ALTER TABLE `shop_commandes_elem` ADD `ref_article` VARCHAR(50) NOT NULL DEFAULT '' ;");
	bdd_ajoute_colonne("tva","shop_commandes_elem","ALTER TABLE `shop_commandes_elem` ADD `tva` DECIMAL(9,2) NOT NULL DEFAULT 0 ;");
	bdd_ajoute_colonne("designation","shop_commandes_elem","ALTER TABLE `shop_commandes_elem` ADD `designation` VARCHAR(255)  CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' ;");
	
	// correction de la civilité : 
	// avant, enum(M. Mme....)
	bdd_change_type_colonne("civilite","shop_clients_adresses","VARCHAR(10) NOT NULL");
	bdd_change_type_colonne("civilite","shop_commandes_adresses","VARCHAR(10) NOT NULL");
	bdd_change_type_colonne("civilite","shop_clients","VARCHAR(10) NOT NULL");
	
	if(isset($_REQUEST["maj_commandes"])) {
		// rattrappage dees colonnes manquantes
		$query_declin=ifReq("SELECT t_val.id_langue,t_val.texte AS valeur, disp.id_valeur FROM shop_declinaisons_dispo AS disp
				INNER JOIN shop_declinaisons_valeurs AS val ON val.id = disp.id_valeur
				INNER JOIN shop_ml_traductions AS t_val ON t_val.id_champs = val.valeur
				GROUP BY disp.id_valeur ORDER BY disp.id_type ");
		$liste_id_langue=mysql_fetch_column($query_declin,"id_langue");
		$liste_valeur=mysql_fetch_column($query_declin,"valeur");
		$liste_id_valeur=mysql_fetch_column($query_declin,"id_valeur");
		$tab_declin=array(1=>array(),2=>array(),3=>array(),4=>array()); // 4 langues
		foreach($liste_id_valeur AS $i=>$id_valeur) {
			$tab_declin[$liste_id_langue[$i]][$id_valeur]=$liste_valeur[$i];
		}
		
		
		
		ifReq("UPDATE shop_commandes SET id_langue=1 WHERE id_langue=0");
		if($query=ifReq("SELECT com.id_langue,elem.id_commande, elem.id_article, elem.prix_unit, elem.quantite, elem.declinaison, art.reference, art.tva, tr.texte AS nom FROM shop_commandes_elem AS elem
				LEFT JOIN shop_commandes AS com ON com.id=elem.id_commande
				LEFT JOIN shop_articles AS art ON art.id = elem.id_article
				LEFT JOIN shop_ml_traductions AS tr ON tr.id_champs = art.nom AND tr.id_langue = com.id_langue
				WHERE elem.ref_article=''")) {
			while($res_elem=mysql_fetch_assoc($query)) {
				$split_decl=explode("|",$res_elem["declinaison"]);
				$split_decl_aff=array();
				foreach($split_decl as $i=>$id_decl) {
					$v=$tab_declin[$res_elem["id_langue"]][$id_decl];
					if(isset($v)) {
						$split_decl_aff[]=$tab_declin[$res_elem["id_langue"]][$id_decl];
					}
				}
				$design=$res_elem["nom"];
				if(count($split_decl_aff)>0)
					$design.=" (".implode(",",$split_decl_aff).")";
				$req=("UPDATE shop_commandes_elem SET tva=$res_elem[tva], ref_article='$res_elem[reference]' , designation='".mysql_real_escape_string($design)."' 
				WHERE id_commande=$res_elem[id_commande] AND id_article=$res_elem[id_article] AND declinaison='$res_elem[declinaison]'");
				ifReq($req);
				print("<br>rattrappage elem $res_elem[id_commande] $res_elem[id_article] ($res_elem[reference])");;
			}
		}
		ifReq("UPDATE shop_commandes_elem SET prix_unit_HT=prix_unit/(1+(tva/100)), prix_unit_TVA=prix_unit-(prix_unit/(1+(tva/100)))
			WHERE  tva!=0");
	}
?>