<?php

//
//	Familles de specs
//
function SPC_liste_familles_pertinentes($id_boutique, $id_langue_defaut, $id_article_type) {
	//La liste des familles pertinentes pour ce type d'article
	affReq("SELECT fam.*, t_nom.texte FROM shop_specs_familles AS fam
			INNER JOIN shop_specs_familles_pertinentes AS p ON p.id_famille = fam.id
			INNER JOIN shop_ml_traductions AS t_nom ON t_nom.id_champs = fam.nom AND t_nom.id_langue = $id_langue_defaut
			WHERE fam.id_boutique = $id_boutique AND p.id_article_type = $id_article_type ORDER BY t_nom.texte","LIST","auto");
}
function SPC_ajout_famille_pertinente($id_boutique, $id_langue_defaut, $id_article_type, $strFamilles) {
	//Rend une liste de familles existantes pertinentes pour ce type d'article
	$tabFamilles = explode("||",$strFamilles);
	for($i=0;$i<sizeof($tabFamilles);$i++) {
		ifReq("INSERT INTO shop_specs_familles_pertinentes SET id_article_type=$id_article_type, id_famille=$tabFamilles[$i]"); 
	}
	SPC_liste_familles_pertinentes($id_boutique, $id_langue_defaut, $id_article_type);
}
function SPC_suppr_famille_pertinente($id_boutique, $id_langue_defaut, $id_article_type, $id_famille) {
	//Retire la famille de celles qui sont pertinentes pour ce type d'article
	if(ifReq("DELETE FROM shop_specs_familles_pertinentes WHERE id_article_type=$id_article_type AND id_famille=$id_famille")) {
		SPC_liste_familles_pertinentes($id_boutique, $id_langue_defaut, $id_article_type);
	}
}
function SPC_modif_famille_pertinente($id_boutique, $id_langue_defaut, $nom, $textes_nom, $id_article_type) {
	ML_update($textes_nom,$nom,$id_boutique);
	SPC_liste_familles_pertinentes($id_boutique, $id_langue_defaut, $id_article_type);
}
//
function SPC_liste_familles($id_boutique, $id_langue_defaut, $id_article_type) {
	//La liste de toutes les familles sauf celles qui sont pertinentes pour ce type d'article
	affReq("SELECT fam.*, t_nom.texte FROM shop_specs_familles AS fam
			INNER JOIN shop_ml_traductions AS t_nom ON t_nom.id_champs = fam.nom AND t_nom.id_langue = $id_langue_defaut
			WHERE fam.id_boutique = $id_boutique AND fam.id NOT IN (SELECT id_famille FROM shop_specs_familles_pertinentes WHERE id_article_type=$id_article_type)
			ORDER BY t_nom.texte","LIST","auto");
}
function SPC_ajout_famille($id_boutique, $id_langue_defaut, $id_article_type, $textes_nom) {
	//Ajoute une famille de spcification
	if(ifReq("INSERT INTO shop_specs_familles SET id_boutique=$id_boutique")) {
		$id_famille = mysql_insert_id();
		$nom = ML_insert($textes_nom,"specification",$id_boutique,0,$id_famille);
		if(ifReq("UPDATE shop_specs_familles SET nom=$nom WHERE id=$id_famille")) {
			SPC_liste_familles($id_boutique, $id_langue_defaut, $id_article_type);
		}
	}
}
function SPC_suppr_famille($id_boutique, $id_langue_defaut, $id_article_type, $id_famille, $nom) {
	//Supprime une famille
	if(ifReq("DELETE FROM shop_specs_familles WHERE id=$id_famille")) {
		if(ML_delete($nom)) {
			SPC_liste_familles($id_boutique, $id_langue_defaut, $id_article_type);
		}
	}
}
function SPC_recup_famille($id_famille, $nom) {
	$textes = ML_select($nom);
	$textes = str_replace("'","''",$textes);
	affReqUnique("SELECT *, '$textes' AS textes_nom FROM shop_specs_familles WHERE id=$id_famille","FAM","auto");
}
function SPC_modif_famille($id_boutique, $id_langue_defaut, $nom, $textes_nom, $id_article_type) {
	ML_update($textes_nom,$nom,$id_boutique);
	SPC_liste_familles($id_boutique, $id_langue_defaut, $id_article_type);
}
//description
function SPC_description($id_boutique, $id_langue_defaut, $id_article, $id_famille_old, $id_famille_new, $textes_descriptions, $description) {
	if($id_famille_old!=-1) {
		SPC_description_sauve($id_boutique,$id_article,$id_famille_old,$description,$textes_descriptions);
	}
	SPC_description_recup($id_article,$id_famille_new);
	SPC_liste_specs($id_langue_defaut, $id_famille_new);
}
function SPC_description_sauve($id_boutique,$id_article,$id_famille,$description,$textes_descriptions) {
	if($description==-1) {
		//nouvelle description
		$description = ML_insert($textes_descriptions,"specification",$id_boutique,$id_article,$id_famille);
		ifReq("INSERT INTO shop_specs_familles_descriptions SET id_article=$id_article, id_famille=$id_famille, description=$description");
	} else {
		//mise  jour
		ML_update($textes_descriptions,$description,$id_boutique);
	}
}
function SPC_description_recup($id_article,$id_famille) {
	if($descr = testReq2("SELECT * FROM shop_specs_familles_descriptions WHERE id_article=$id_article AND id_famille=$id_famille")) {
		$description = $descr["description"];
		$textes = ML_select($description);
		print("&textes_description=$textes&description=$description&");
	} else {
		print("&description=-1&");
	}
}
//
//	Les spcifications
//
function SPC_liste_specs($id_langue_defaut, $id_famille) {
	//La liste des spcifications pour cette famille
	affReq("SELECT specs.*, t_nom.texte FROM shop_specs_elems AS specs
			INNER JOIN shop_ml_traductions AS t_nom ON t_nom.id_champs = specs.nom AND t_nom.id_langue = $id_langue_defaut
			WHERE specs.id_famille = $id_famille
			ORDER BY specs.numero","SPC","auto");
}
function SPC_ajout_spec($id_boutique,$id_langue_defaut,$id_famille,$textes,$triable,$recherche,$comparable,$filtrable,$affiche_liste,$affiche_fiche,$affiche_famille,$separateur) {
	//Ajoute une spcification
	if(ifReq("INSERT INTO shop_specs_elems (id_boutique,id_famille,numero,triable,recherche,comparable,filtrable,affiche_liste,affiche_fiche,affiche_famille,separateur) 
			  SELECT $id_boutique,$id_famille, MAX(numero)+1,$triable,$recherche,$comparable,$filtrable,$affiche_liste,$affiche_fiche,$affiche_famille,'$separateur' FROM shop_specs_elems WHERE id_famille=$id_famille")) {
		$id_spec = mysql_insert_id();
		$nom = ML_insert($textes,"specification",$id_boutique,$id_famille,$id_spec);
		if(ifReq("UPDATE shop_specs_elems SET nom=$nom WHERE id=$id_spec")) {
			SPC_liste_specs($id_langue_defaut, $id_famille);
		}
	}
}
function SPC_modif_spec($id_langue_defaut,$id_famille,$textes_nom,$nom,$id_boutique,$triable,$recherche,$comparable,$filtrable,$affiche_liste,$affiche_fiche,$affiche_famille,$separateur,$id_spec) {
	//Modifie une spcification
	ML_update($textes_nom,$nom,$id_boutique);
	if(ifReq("UPDATE shop_specs_elems SET triable=$triable,recherche=$recherche, comparable=$comparable, filtrable=$filtrable, 
			affiche_liste=$affiche_liste, affiche_fiche=$affiche_fiche, affiche_famille=$affiche_famille, separateur='$separateur' WHERE id=$id_spec")) {
		SPC_liste_specs($id_langue_defaut, $id_famille);
	}
}
function SPC_suppr_spec($id_spec,$nom,$id_langue_defaut, $id_famille) {
	//Supprime une spcification	
	if(ML_delete($nom)) {
		if(ifReq("DELETE FROM shop_specs_elems WHERE id=$id_spec")) {
			//todo : supprimer les valeurs de la specs 
			SPC_liste_specs($id_langue_defaut, $id_famille);
		}
	}
}
function SPC_recup_spec($id_spec, $nom) {
	$textes = ML_select($nom);
	$textes = str_replace("'","''",$textes);
	affReqUnique("SELECT *, '$textes' AS textes_nom FROM shop_specs_elems WHERE id=$id_spec","SPC","auto");
}
//
//	Les valeurs
//
function SPC_liste_vals($id_langue_defaut, $id_spec, $id_article) {
	//La liste des valeurs des spcifications
	affReq("SELECT pred.*, t_val.texte FROM shop_specs_predef AS pred
			INNER JOIN shop_ml_traductions AS t_val ON t_val.id_champs = pred.valeur AND t_val.id_langue = $id_langue_defaut
			WHERE pred.id_spec = $id_spec","PRD","auto");
	$resValeurs = testReq2("SELECT * FROM shop_specs_valeurs WHERE id_spec = $id_spec AND id_article = $id_article");
	$textes_valeur = ML_select($resValeurs["valeur"]);
	affResUnique($resValeurs,"VAL");
	affChampsRes($resValeurs,"VAL");
	print("&textes_valeur=$textes_valeur&");
}
function SPC_ajout_val($id_boutique,$id_langue_defaut,$id_article,$id_spec,$textes_valeur) {
	//Ajoute une valeur de spcification
	if(ifReq("INSERT INTO shop_specs_predef SET id_spec=$id_spec")) {
		$id_predef = mysql_insert_id();
		$valeur = ML_insert($textes_valeur,"specification",$id_boutique,$id_spec,$id_predef);
		if(ifReq("UPDATE shop_specs_predef SET valeur=$valeur WHERE id=$id_predef")) {
			SPC_liste_vals($id_langue_defaut, $id_spec, $id_article);
		}
	}
}
function SPC_modif_val($id_langue_defaut,$id_spec,$textes_valeur,$valeur,$id_boutique,$id_article) {
	//Modifie une valeur de spcification
	ML_update($textes_valeur,$valeur,$id_boutique);
	SPC_liste_vals($id_langue_defaut, $id_spec, $id_article);
}
function SPC_suppr_val($id_predef,$valeur,$id_langue_defaut, $id_spec, $id_article) {
	//Supprime une valeur de spcification	
	if(ML_delete($valeur)) {
		if(ifReq("DELETE FROM shop_specs_predef WHERE id=$id_predef")) {
			//todo : supprimer les valeurs slectionnes 
			SPC_liste_vals($id_langue_defaut, $id_spec, $id_article);
		}
	}
}
function SPC_recup_val($id_predef, $valeur) {
	$textes = ML_select($valeur);
	$textes = str_replace("'","''",$textes);
	affReqUnique("SELECT *, '$textes' AS textes_valeur FROM shop_specs_predef WHERE id=$id_predef","PRD","auto");
}
function SPC_sauve_val($id_boutique,$id_article,$str_id_spec,$str_valeurs_predef,$str_valeur,$str_textes_valeur,$textes_descriptions,$description,$id_famille) {
	$tab_id_spec = explode("||",$str_id_spec);
	$tab_valeurs_predef = explode("{{",$str_valeurs_predef);
	$tab_valeur = explode("||",$str_valeur);
	$tab_textes_valeur = explode("{{",$str_textes_valeur);
	$succes=true;
	for($i=0;$i<sizeof($tab_id_spec);$i++) {
		if(ifReq("DELETE FROM shop_specs_valeurs WHERE id_article=$id_article AND id_spec=$tab_id_spec[$i]")) {
			if($tab_valeur[$i]>0) {
				ML_update($tab_textes_valeur[$i],$tab_valeur[$i],$id_boutique);	
			} else {
				$tab_valeur[$i] = ML_insert($tab_textes_valeur[$i],"specification",$id_boutique,$id_article,$tab_id_spec[$i]);
			}
			if(!ifReq("INSERT INTO shop_specs_valeurs SET id_article=$id_article, id_spec=$tab_id_spec[$i], valeurs_predef='$tab_valeurs_predef[$i]', valeur=$tab_valeur[$i]")) {
				$succes=false;
			}
		}
	}
	if($succes) {
		SPC_description_sauve($id_boutique,$id_article,$id_famille,$description,$textes_descriptions);
		print("&ok=1&");
	}
}
?>