CREATE TRIGGER trig_commandes_after_update AFTER UPDATE
	ON shop_commandes FOR EACH ROW BEGIN
		# on repere l'etat de la commande
		# si en cours
		# on insere les elements dans le stock en cours (si n'existent pas deja)
		# si pas en cours
		# on efface les elements du stock en cours, le cas chant
#(NEW.etat='VERIFIER') OR
		IF (NEW.etat='PAYEE') OR (NEW.etat='VALIDEE') OR (NEW.etat='VERIFIER') THEN 
				# ne pas inserer si deja inser... ok
				INSERT INTO shop_stocks_encours 
						SELECT NEW.id_boutique AS id_boutique,NEW.id AS id_commande,id_article,declinaison,NEW.ref AS ref_cde,quantite FROM shop_commandes_elem
								WHERE id_commande=NEW.id AND CONCAT(id_article,'-',declinaison) NOT IN (SELECT CONCAT(id_article,'-',declinaison) FROM shop_stocks_encours WHERE id_commande=NEW.id);
		ELSE 
			DELETE FROM shop_stocks_encours WHERE id_commande=NEW.id;
		END IF;
	END

