<?php

/*
flashCompressXML by Ian Turgeon (NewMedia at CDWS, University of Central Florida)
adapted from C# code writen by Mattias Stridsman based on Lempel_Zif LZ77 compression
see http://www.strille.net/tutorials/FlashXMLCompressor/index.php for details
*/

// compress an xml string
class flashCompressXML{

	function encodeXML($originalString, $CheckValid = false){ // $CheckValid used for errorchecking
		// Find a character not in the file to use in the encoding formatting
		$compressedString = substr($originalString, 0, 1);
		for($i = 161; $i<191;$i++){
			$c = chr($i);
			if(!strpos($originalString, $c, strlen($originalString))){
				$encodeChar = $c;
				break;
			}
		}
		if(!$encodeChar) return FALSE;

		$currPos = 1;
		$radix = 114; // the number base
		$bufferSize = $radix*$radix-1; // history buffer size
		$lookAheadBufferSize = $radix-1; // max number of characters to copy in a sequence
		$lookAheadString = substr($originalString, $currPos, min(strlen($originalString)-$currPos, $lookAheadBufferSize));

		while(strlen($lookAheadString) > 0){ // while there are characters to encode
			$findBestResult = $this->encodeFindBest($originalString, max(($currPos-$bufferSize), 0), $currPos-1, $lookAheadString, $findBestResult); // try to find an upcoming sequence in the history buffer and refer to it
			if($findBestResult[0] == -1){ // no sequence found, just move 1 character forward and add the current character to the coded sequence
				$compressedString .= substr($originalString, $currPos, 1);
				$currPos++;
			}
			else{
				$p = $currPos - $findBestResult[0];
				$l = $findBestResult[1];
				$ms = floor($p/$radix);
				$ls = floor($p-($ms*$radix));
				$compressedString .= $encodeChar . chr(14+$ms) . chr(14+$ls) . chr(14+$l);  // special char,  position, position, length
				$currPos += $l;
			}
			$lookAheadString = substr($originalString,  $currPos, min(strlen($originalString)-$currPos, $lookAheadBufferSize));
		}
		$return = "v1.0 {$encodeChar}{$compressedString}";
		if($CheckValid){ // if error checking is turned on
			if($this->checkEncode($originalString, $this->decodeXML($return))) return $return; // return the compressed string if it matches
			else return $originalString; // otherwise return the uncompressed string
		}
		return $return; // return compressed string
	}

	// used by encodeXML
	function encodeFindBest($str, $winStart, $winEnd, $lookAhead,  $res){
		$lookAheadLength = strlen($lookAhead);
		$winStr = substr($str, $winStart, $winEnd-$winStart);
		$sequenceLength = 5;
		$matchLength = $matchPos = 0;

		while ($sequenceLength <= $lookAheadLength){
			$n = strpos($winStr, substr($lookAhead, 0, $sequenceLength));
			if($n == false) break;
			else {
				$matchLength = $sequenceLength;
				$matchPos = $n;
			}
			$sequenceLength++;
		}

		if ($matchLength > 0){
			$res[0] = $winStart+$matchPos;
			$res[1] = $matchLength;
		}
		else $res[0] = -1;
		return $res;
	}

	// decode a compressed xml string
	function decodeXML($Encoded){
		if(substr($Encoded, 0,1) != '<'){
			$ecPos = strpos($Encoded, ' ') + 1;
			$eC = substr($Encoded, $ecPos, 1);
			$Encoded = substr($Encoded, $ecPos+1);
			$o = '';
			$iL = strlen($Encoded);
			for($n = 0; $n<$iL;$n++){
				if( substr($Encoded, $n, 1) == $eC){
					$p = ord(substr($Encoded, $n+1, 1))*114 + ord(substr($Encoded, $n+2, 1)) - 1610;
					$l = ord(substr($Encoded, $n+3, 1))-14;
					$o .= substr($o, -$p, $l);
					$n += 3;
				}
				else $o .= substr($Encoded, $n, 1);
			}
			return $o;
		}
		else return $Encoded;
	}

	// check an encoded string against an unencoded one
	function checkEncode($XML, $Encoded){
		if($XML == $Encoded) return true;
		else return false;
	}
}
?>
