<?php
//include_once 'includes/general/RealTimeProgression.class.php';//auto
class CListesXML{
	public static function installe($fichier_xml) {
		
		//include_once("includes/general/XmlParser.class.php");//auto

		$xml=new XmlParser();
		//		echo "load XML ->$fichier_xml<br>";
		$donnees=$xml->parse($fichier_xml);

		$structure = $donnees[0]["child"];
		$nb=0;
		foreach($structure as $child) {
			RealTimeProgression::setProgression($nb/count($structure));
			$nb++;
			switch($child["name"]) {
				case "LISTE":
					CListesXML::parse_LISTE($child);
					break;
				case "DROPLISTE":
					CListesXML::parse_DROPLISTE($child);
					break;
				case "LISTE_ETRANGERE":
					$attrs=$child["attrs"];
					CListes::add_liste_etrangere($attrs["LISTE_PRINCIPALE"], $attrs["LISTE_SECONDAIRE"], $attrs["POSITION"], $attrs["AFFICHAGE"]);
					break;
			}
		}

	}

	public static function parse_LISTE($noeud) {
		$desc_liste=array();

		$identifiant=$noeud["attrs"]["IDENTIFIANT"];
		$table=$noeud["attrs"]["TABLE"];
		$classement=$noeud["attrs"]["CLASSEMENT"];
		$dossier = $noeud["attrs"]["DOSSIER"]; // facultatif
		$champs=array();
		$champs_etrangers=array();
		$cles=array();

		foreach($noeud["child"] as $child) {
			switch($child["name"]) {
				case "TITRE":
					$titre=$child["content"];
					break;
				case "DESCRIPTION":
					$description=$child["content"];
					break;
				case "ELEMENT":
					$titre_elem=$child["attrs"]["TITRE"];
					break;
				case "CHAMP":
					$champs[] = CListesXML::parse_CHAMP($child);
					break;
				case "CLE_ETRANGERE":
					$champs_etrangers[] = CListesXML::parse_CLE_ETRANGERE($child);
					break;
				case "TRIGGER":
					$desc_liste["fn_".$child["attrs"]["TYPE"]]=$child["attrs"]["FONCTION"];
					break;
				case "CLE":
					$cles[]=$child["attrs"];
					break;
			}
		}


		CListes::add_liste2($identifiant,$table,$titre,$description,$titre_elem,$classement,$dossier);
		if(!empty($desc_liste)) {
			$desc_liste["identifiant"]=$identifiant;
			CListes::update("listes",$desc_liste,"identifiant");
		}
		$vals_defaut=array();
		foreach($champs as $champ) {
			if(isset($champ["DESC_UPLOAD"])) {
				$champ["DESC_UPLOAD"]["id_liste"] = $identifiant;
				CListes::insere_update("description_uploads",$champ["DESC_UPLOAD"],"id_liste,nom_colonne");
				unset($champ["DESC_UPLOAD"]);
			}
			CListes::add_champ_liste2($identifiant,$champ["nom_colonne"],$champ["type"]);
			unset($champ["type"]);
			CListes::add_description_champ2($identifiant,$champ["nom_colonne"],$champ);
			if(isset($champ["valeur_defaut"])) $vals_defaut[$champ["nom_colonne"]]=$champ["valeur_defaut"];
		}
		foreach($champs_etrangers as $champ_etranger) {
			$champ=$champ_etranger["champ"];
			if($champ_etranger["principale"] == 1) {
				CListes::set_champ_liste_etranger($identifiant,$champ["nom_colonne"],$champ_etranger["table_lien"],$champ_etranger["colonne_lien"],$champ_etranger["affichage"],$champ_etranger["where"]);
			} else {
				CListes::add_champ_liste_etranger($identifiant,$champ["nom_colonne"],$champ_etranger["table_lien"],$champ_etranger["colonne_lien"],$champ_etranger["affichage"],$champ_etranger["where"]);
			}
			if(isset($champ["longueur"])) {
				$champ["longueur_associe"] = $champ["longueur"];
				unset($champ["longueur"]);
			}
			if(isset($champ["champs_recherche"])) {
				$champ["champs_recherche_associe"] = $champ["champs_recherche"];
				unset($champ["champs_recherche"]);

			}
			CListes::add_description_champ2($identifiant,$champ["nom_colonne"],$champ);
			if(isset($champ["valeur_defaut"])) $vals_defaut[$champ["nom_colonne"]]=$champ["valeur_defaut"];
		}

		CListes::set_valeurs_defaut($identifiant,$vals_defaut);
		//		print_rr($vals_defaut);
		//		print_rr($cles);
		foreach($cles as $cle) {
			CListes::add_cle($identifiant,$cle["NOM"],$cle["TYPE"],$cle["COLONNES"]);
		}
		//		print_rr($champ);
	}

	public static function parse_CHAMP($noeud) {
		$retour=array();
		if(is_array($noeud["attrs"]))
		foreach($noeud["attrs"] as $attrib=>$val) {
			$retour[strtolower($attrib)]=$val;
		}
		$nom_colonne = $noeud["attrs"]["NOM_COLONNE"];
		if(is_array($noeud["child"]))
		foreach($noeud["child"] as $child) {
			switch($child["name"]) {
				case "DESCRIPTION":
					//case "VALEUR_DEFAUT":
					$retour[strtolower($child["name"])]=$child["content"];
					break;
				case "UPLOAD":
						
					$datas=array("nom_colonne"=>$nom_colonne);
					foreach($child["attrs"] as $attrib=>$val) {
						$datas[strtolower($attrib)]=$val;
					}
					$retour["DESC_UPLOAD"] = $datas;
					break;
					/*case "AFF_LISTE":
					 case "FORMULAIRE":
					 foreach($child["attrs"] as $attrib=>$val) {
						$retour[strtolower($attrib)]=$val;
						}
						break;*/
			}
		}

		if(!isset($retour["intitule_colonne"])) $retour["intitule_colonne"]=$retour["nom_colonne"];
		if(!isset($retour["libelle"]))$retour["libelle"]=$retour["intitule_colonne"];
		return $retour;
	}

	public static function parse_CLE_ETRANGERE($noeud) {
		$retour=array();
		foreach($noeud["attrs"] as $attrib=>$val) {
			$retour[strtolower($attrib)]=$val;
		}
		$retour["champ"]=CListesXML::parse_CHAMP($noeud["child"][0]);
		$retour["champ"]["nom_colonne"] = $retour["nom_colonne"];
		unset($retour["nom_colonne"]);
		return $retour;
	}

	public static function parse_DROPLISTE($noeud) {
		CListes::dropListe($noeud["attrs"]["IDENTIFIANT"]);
	}


}
?>