<?php
class CMultilingue {
	static $langue_multi = "multi";
	static public $langue_defaut = "fr";
	static public $langue = "fr";

	static public $definer = array();

	static public $useML = true;

	static public $temporaire_mode = false;
	static public $langues_tempo = array();
	static public $langue_avant_tempo = '';

	static private $url_page_langues = array();

	public static function setLangueFrom($from , $sigle,$temporaire=false) {
		self::$definer[$from]=$sigle;
		self::setLangue($sigle,$temporaire);
	}
	
	public static function setLangueFromSession() {
		self::setLangueTemporaire($_SESSION["langue"]);
	}
	
	public static function setLangue($sigle,$temporaire=false) {
		//		echo "!! setLangue $sigle !!";
		self::$langue = strtolower($sigle);
		if(!$temporaire) $_SESSION["langue"]=self::$langue;
		//		print_r($_SESSION);
	}

	public static function setLangueTemporaire($langue) {
		//		if (!self::$temporaire_mode) {
		//			self::$temporaire_mode = true;
		//			self::$langue_avant_tempo = self::$langue;
		//		}
		//		self::$langues_tempo[] = $langue;
		//		self::setLangue($langue,true);
		self::$langues_tempo[] = self::$langue;
		self::setLangue($langue,true);

	}

	public static function rollbackLangue() {
		self::setLangue(array_pop(self::$langues_tempo),true);

		//		$cnt = count(self::$langues_tempo);
		//
		//		if ($cnt > 0) {
		//			self::setLangue(self::$langues_tempo[$cnt-1],true);
		//		}
		//		else {
		//			self::$temporaire_mode = false;
		//			self::setLangue(self::$langue_avant_tempo);
		//		}
	}

	public static function isTemporaire() {
		return count(self::$langues_tempo) > 0;
	}

	public static function setUrlPageEnCours($langue, $url) {
		self::$url_page_langues[$langue] = $url;
	}

	public static function urlLangueIsSet($langue) {
		return isset(self::$url_page_langues[$langue]);
	}
	public static function getUrlPageInLangue($langue) {
		return self::$url_page_langues[$langue];
	}

	public static function verifLangueEnCours() {
		if(self::$langue == self::$langue_multi) return true;
		if(!self::langueExists(self::$langue)) {
			setLangue(self::$langue_defaut);
		}
	}

	public static function getDrapeauxAdmin($jq="") {
		$langues = CMultilingue::getListeLangues();
		$retour.=self::getDrapeauLangue("multi",$jq);
		foreach($langues as $langue) {
			$retour.=self::getDrapeauLangue($langue,$jq);
		}
		return $retour;
	}
	public static function getDrapeauLangue($langue,$jq="") {
		$style=($langue==CMultilingue::$langue?"border:solid 2px":"");
		$action=($jq != ""?"/JQajax.php":"");
		$retour="<form id='formlangue$langue' action='$action' method='POST' style='display:inline'>
				<input type='hidden' name='action' value='fsadmin.changeLangue'/>
				<input type='hidden' name='setLangue' value='$langue'/>".
				"<input type='image'  style='display:inline;$style' src='/icones/multilingue/png/$langue.png'/>"
		."</form>";
		if($jq != "") {
			$retour.=CEcho::echo_jsready("$('#formlangue$langue').ajaxForm({success:function(s){
				$('#divLanguesFS').html(s);
			}});",true);
		}
		return $retour;

	}

	function repereLangue() {
		if(isset($_REQUEST["setLangue"])) CMultilingue::setLangueFrom("setLangue",$_REQUEST["setLangue"]);
		else if(isset($_SESSION["langue"])) CMultilingue::setLangueFrom("session",$_SESSION["langue"]);
	}

	public static function langueExists($identifiant_langue) {
		if($identifiant_langue == self::$langue_defaut) return true;
		return testReq3("SELECT identifiant FROM ml__langue WHERE identifiant = '$identifiant_langue'",false);
	}

	public static function champEstMultilingue($table,$champ) {
		if(self::tableEstMultilingue($table)) {
			//			print_rr(self::getListeChampsML($table));
			return in_array($champ,self::getListeChampsML($table));
			//			echo "champ $champ $table ;; ";
		}
		return false;
	}
	public static function tableEstMultilingue($table) {
		return in_array($table,self::getListeTablesML());
	}

	public static function modifSQL($requete) {
		if(self::$langue == self::$langue_multi) return $requete;

		$requete = '§'.str_replace(array(",","."," ","`"),array("§,§","§.§","§ §","§`§"),$requete).'§';
		$langue="de";
		$tables = self::getListeTablesML();
		foreach($tables as &$table) {
			$to[]="view__$table"."_".self::$langue;
			$table='§'.$table.'§';
		}
		$requete=str_replace($tables,$to,$requete);
		$requete = str_replace("§","",$requete);
		return $requete;
	}

	public static function switchLangue() {
		
		$args = func_get_args();
		$langue_def = array_shift($args);
		if (!Cmodule::module_existe('multilingue')) {
			return $langue_def;
		}
		
		if(CMultilingue::$langue == CMultilingue::$langue_defaut) {
			return $langue_def;
		}
		while(count($args)) {
			$langue = array_shift($args);
			if($val = array_shift($args))
			if($langue == CMultilingue::$langue)
			return $val;
		}
		return $langue_def;

	}
	public static function getListeLangues() {
		if(!$retour = get_optim_php("ML","getListeLangues")) {
			$retour= mysql_fetch_column(ifReq("SELECT identifiant FROM ml__langue",false),"identifiant");
			array_unshift($retour,CMultilingue::$langue_defaut);
			set_optim_php("ML","getListeLangues",$retour);
		}
		return $retour;
	}

	public static function getListeChampsML($table) {
		if(!$retour = get_optim_php("ML","getListeChampsML".$table)) {
			$retour= mysql_fetch_column(ifReq("SELECT champ FROM ml__champ WHERE nom_table = '$table'",false),"champ");
			set_optim_php("ML","getListeChampsML".$table,$retour);
		}
		return $retour;
	}
	public static function getListeTablesML() {
		if(!$retour = get_optim_php("ML","getListeTablesML")) {
			// ici pas de ifReq, sinon BOUCLE INFINIE
			$retour = mysql_fetch_column(ifReq("SELECT DISTINCT(nom_table) FROM ml__champ",false),"nom_table");
			set_optim_php("ML","getListeTablesML",$retour);
		}
		return $retour;
	}
	public static function remplaceLiensSiteHTML($str) {
		// if option => patern = ...
		//return $str;

		$patern="#<( *a([^>])* +)href *=['\"]/([^'\"]*)['\"]#i";
		$remplace = "<a $1 href='/en/$2'";
		return preg_replace_callback($patern,'CMultilingue::ajouterLangueLienMatch',$str);
	}

	public static function ajouterLangueLienMatch($match) {

		//		$split = explode('/',$match[3]);
		//
		//		if(strlen($split[0]) == 2 && CMultilingue::langueExists($split[0])) {
		//			if ($split[0] == CMultilingue::$langue_defaut && ML_LANGUE_DEFAUT_INVISIBLE === true)
		//			//on retire la langue de l'url si invisible
		//			array_shift($split);
		//		} else if (CMultilingue::$langue != CMultilingue::$langue_defaut || ML_LANGUE_DEFAUT_INVISIBLE === false) {
		//			//ajout de la langue à l'url (www.../fr/...)
		//			$split[0] = CMultilingue::$langue.'/'.$split[0];
		//		}
		//		return "<$match[1] href='/".implode('/', $split)."'";
		return "<$match[1] href='".self::ajouterLangueLienAbsolu('/'.$match[3])."'";
	}

	/**
	 * toujours des urls avec / au début !
	 * @param unknown_type $url
	 */
	public static function ajouterLangueLienAbsolu($url, $langue=null) {

		if(is_null($langue)) $langue = self::$langue;

		$split = explode('/',$url);
		array_shift($split);

		if(strlen($split[0]) == 2 && CMultilingue::langueExists($split[0])) {
			if ($split[0] == CMultilingue::$langue_defaut && ML_LANGUE_DEFAUT_INVISIBLE === true)
			//on retire la langue de l'url si invisible
			array_shift($split);
		} else if (CMultilingue::$langue != CMultilingue::$langue_defaut || ML_LANGUE_DEFAUT_INVISIBLE === false) {
			//ajout de la langue à l'url (www.../fr/...)
			$split[0] = CMultilingue::$langue.'/'.$split[0];
		}
		return "/".implode('/', $split);
	}

}

?>