<?php
class CWikiSite {

	public static function si($str,$type,$identifiant,$action="autorise") {
		$affiche = false;
		switch(strtolower($type)) {
			case "droitliste":
				$liste = CListes::get_liste($identifiant);
				$droit = usr_get_droit("fsa.liste",$liste["id_auto"]);
				$affiche = $droit[$action];
				break;
			case "droit":
				$id_droit=usr_get_id_droit_generique($identifiant);
				$droit = usr_get_droit_generique($id_droit);
				$affiche = $droit[$action];
				break;
			default:
				
				break;
		}
		if($affiche) return $str;
		return "";

	}

	/**
	 * Utilisé en master une seul fois avant la recursivité des listes
	 * pour remplacer les fonctions |# uniquement apres le fetch des variables
	 * de template
	 * @param string $str
	 */
	public static function parseWikiLangRoot($str) {
		return CWikiListes::remplaceFonctionApresAol(self::parseWikiLang($str));
	}

	public static function parseWikiLang($str) {

		// sans récursivité
		//$patern="#\[{2}((\[([^]]*)])*)([^]]*)]{2}#sU";
		// avec récursivité
		//		$patern="#\[{2}((\[([^]]*)])*)(([^[]]*|(?R))*)]{2}#sU";
		$patern="#\{{2}((\{([^}]*)})*)(([^{]]*|(?R))*)}{2}#sU";
		
		$str=preg_replace_callback($patern,array('CWikiSite',"remplace_match_wiki"),$str);
		
		return $str;
	}
	public static $tabVariablesPages = array();
	public static function remplace_tab_key_pour_variable($val)
	{
		return '@'.$val.'@';
	}
	public static function remplace_variables_page($str)
	{
		$tabVar = array_keys(CWikiSite :: $tabVariablesPages);
		$tabVar = array_map('CWikiSite::remplace_tab_key_pour_variable',$tabVar);
		$tabVal = array_values(CWikiSite :: $tabVariablesPages);
		
		return str_replace($tabVar, $tabVal, $str);
	}
	public static function remplace_match_wiki($regs) {
		//		print_rr($regs);
		// 	remplacement des $1 $2
		foreach($regs as &$reg)
		{
			$reg = CSite::remplace_params_page($reg);
			$reg = CWikiSite::remplace_variables_page($reg);
		}
		preg_match_all("([{]([^}]*)[}])",$regs[1],$params);
		$params = $params[1];
		//						print_rr($params);
		$str = $regs[4];
		$action = array_shift($params);
		
		array_unshift($params,$str);
		// params = array("chaine",autres params en vrac)
		switch(strtolower($action)) {
			case "listeeditable":
				$retour = call_user_func_array('CWikiListes::parseWikiEditable',$params);
				break;
			case "liste":
				$retour = call_user_func_array('CWikiListes::parseWiki',$params);
				//				return CListes::parseWiki($params[0],$params[1],$params[2],$params[3],$str);
				break;
			case "si":
			case "siSuper":
				//			case "si":
				//			case "si":
				//			case "si":
				$retour = call_user_func_array('CWikiSite::'.$action,$params);
				break;
			case "ml":
				$retour = call_user_func_array('CMultilingue::switchLangue',$params);
				
				//				print_rr($params);
				break;
			case "class":
			case "classe":
				//				$str = array_shift($params);
				$fn = array_shift(array_splice($params,1,1));
				$retour = self :: execClass($fn,$params);
				break;
			case "var":
				//				$str = array_shift($params);
				$retour = self :: getClassVar($params[1]);
				break;
			case 'img':
				$retour = $str;
				if(Cmodule::module_existe("aol")) {
					if(preg_match('#src\=\"([^"]*)\"#',$params[0],$matches))
					{
						$idBloc = $params[1];
						$lienOrigine = $matches[1];
						$retour = Cmodule_aol :: get_AOL_Image($idBloc,$lienOrigine,$params[0],$params[2],$params[3],$params[4]);
					}
					else
					return '';
				}
				break;
			case 'set':
				CWikiSite :: $tabVariablesPages[$params[1]] = $params[2];
				return '';
			break;
			default:
				//				if(EST_EFROGG === true) print_rr($regs);
				if(Cmodule::module_existe("aol")) {
					//					$mod_aol = Cmodule::get_module("aol");
					$retour = Cmodule_aol::getBlocAOL_HTML($action,$str,$params);
				}
				break;
					
		}
		
		return self::parseWikiLang($retour);
	}
	public static function checkIsSuper($matches)
	{
		if(usr_est_identifie() && usr_a_droit_generique('aol.acces'))
		{
			return self :: parseWikiLang($matches[1]);
		}
		else
		return '';
	}
	public static function getClassVar($fn) {
		$splitFn = explode(".",$fn);
		$varName = array_pop($splitFn);
		$className = array_pop($splitFn);
		if(class_exists($className)) {
			//			$o = new $className();
			$v = get_class_vars($className);
			return $v[$varName];
		}
		return "";
	}
	public static function execClass($fn,$parametres_fonction) {

		$splitFn = explode(".",$fn);
		$methodName = array_pop($splitFn);
		$className = array_pop($splitFn);
			
		if(class_exists($className)) {
			return call_user_func_array("$className::$methodName",$parametres_fonction);
		} else {
			Crapport::trace("execClass errror : $path inexistant");
		}

		return "";
	}

}