<?php

class FluxRSS {
	
	private $m_flux;
	private $m_titre = 'Titre';
	private $m_lien = 'http://www.monsite.com/';
	private $m_desc = 'Ceci est un flux RSS';
	//optionel:
	private $m_pubDate;
	private $m_img_url;
	private $m_img_title;
	private $m_img_link;
	private $m_img_desc;
	private $m_img_width;
	private $m_img_height;
	private $m_lang;
	private $m_copyright;
	private $m_managingEditor;
	private $m_webMaster;
	private $m_lastBuildDate;
	private $m_category;
	private $m_generator = 'Script by e-Frogg 2007';
	private $m_docs;
	private $m_cloud;
	private $m_ttl;
	private $m_rating;
	private $m_textInput_title;
	private $m_textInput_desc;
	private $m_textInput_name;
	private $m_textInput_link;
	private $m_textInput;
	private $m_skipHours;
	private $m_skipDays;
	//
	private $m_nbItem = 0;
	private $m_itemTab=array();
	
	public function __construct() {
	}
	
	public function setTitle($t) {
		$this->m_titre = $t;
	}
	
	public function setLink ($l) {
		$this->m_lien = $l;
	}
	
	public function setDescription ($d) {
		$this->m_desc = $d;
	}
	
	public function setPubDate ($d) {
		$this->m_pubDate = $d;
	}
	
	public function setImage ($url, $title = '', $link = '', $width = '88', $height = '31') {
		$this->m_img_url = $url;
		$this->m_img_title = $title;
		$this->m_img_link = $link;
		$this->m_img_width = $width;
		$this->m_img_height = $height;
	}
	
	public function setLanguage ($l) {
		$this->m_lang = $l;
	}
	
	public function setCopyright ($l) {
		$this->m_copyright = $l;
	}
	public function setManagingEditor ($l) {
		$this->m_managingEditor = $l;
	}
	public function setWebMaster ($l) {
		$this->m_webMaster = $l;
	}
	public function setLastBuildDate ($l) {
		$this->m_lastBuildDate = $l;
	}
	public function setCategorie ($l) {
		$this->m_category = $l;
	}
	public function setGenerator ($l) {
		$this->m_generator = $l;
	}
	public function setDocs ($l) {
		$this->m_docs = $l;
	}
	
	public function setCloud ($l) {
		$this->m_cloud = $l;
	}
	
	public function setTTL ($l) {
		$this->m_ttl = $l;
	}
	
	public function setRating ($l) {
		$this->m_rating = $l;
	}
	
	public function setTextInput ($title, $desc, $name, $link) {
		$this->m_textInput_title = $title;
		$this->m_textInput_desc = $desc;
		$this->m_textInput_name = $name;
		$this->m_textInput_link = $link;
	}
	
	public function setSkipHours ($l) {
		$this->m_skipHours = $l;
	}
	
	public function setSkipDays ($l) {
		$this->m_skipDays = $l;
	}
		
	public function addItem ($titre, $lien, $desc, $pubDate ='',
			$auteur ='', $categorie ='', $commentaires ='',	$guid = '', 
			$source = '', $source_title ='',
			$enclosure  = '',
			$namespaces ='') {
			/*$enclosure doit tre un tableau avec URL, LENGHT  et TYPE dans cet ordre*/
			
			$this->m_itemTab[$this->m_nbItem] = '<item>
												<title>'.$titre.'</title>'.
												'<link>'.$lien.'</link>'.
												'<description>'.$desc.'</description>';
			if ($pubDate != '') {
			$this->m_itemTab[$this->m_nbItem] .= '<pubDate>'.$pubDate.'</pubDate>';
			}
			if ($auteur != '') {
			$this->m_itemTab[$this->m_nbItem] .= '<author>'.$auteur.'</author>';
			}
			if ($categorie != '') {
			$this->m_itemTab[$this->m_nbItem] .= '<category>'.$categorie.'</category>';
			}
			if ($commentaires != '') {
			$this->m_itemTab[$this->m_nbItem] .= '<comments>'.$commentaires.'</comments>';
			}
			if ($guid != '') {
			$this->m_itemTab[$this->m_nbItem] .= '<guid>'.$guid.'</guid>';
			}
			if ($source != '') {
			$this->m_itemTab[$this->m_nbItem] .= 
							'<source url="'.$source.'">'.$source_title.'</source>';
			}
			if ($enclosure != '') {
			$this->m_itemTab[$this->m_nbItem] .= '<enclosure url="'.$enclosure[0].'" length="'.$enclosure[1].'" type="'.$enclosure[2].'" />';
			}
			if ($namespaces != '') {
			$this->m_itemTab[$this->m_nbItem] .= '<namespaces>'.$namespaces.'</namespaces>';
			}
			
			$this->m_itemTab[$this->m_nbItem] .= '</item>';			
			
			++$this->m_nbItem;
	}
	
	public function getFluxBrut ($order = 'asc') {
		$this->m_flux = '<?xml version="1.0" encoding="iso-8859-1"?'.'><rss version="2.0">
					<channel>
					<title>'.$this->m_titre.'</title>'.
					'<link>'.$this->m_lien.'</link>'.
					'<description>'.$this->m_desc.'</description>';
					
		if ($this->m_pubDate) {
		$this->m_flux .= '<pubDate>'.$this->m_pubDate.'</pubDate>';
		}
		if ($this->m_img_url) {
			$this->m_flux .= '<image><url>'.$this->m_img_url.'</url>';
			if($this->m_img_title) {
				$this->m_flux .= '<title>'.$this->m_img_title.'</title>';
			}
			if($this->m_img_link) {
				$this->m_flux .= '<link>'.$this->m_img_link.'</link>';
			}
			if($this->m_img_desc) {
				$this->m_flux .= '<description>'.$this->m_img_desc.'</description>';
			}
			if($this->m_img_width) {
				$this->m_flux .= '<width>'.$this->m_img_width.'</width>';
			}
			if($this->m_img_height) {
				$this->m_flux .= '<height>'.$this->m_img_height.'</height>';
			}
			$this->m_flux .= '</image>';
		}
		if ($this->m_lang) {
		$this->m_flux .= 	'<language>'.$this->m_lang.'</language>';
		}
		if ($this->m_copyright) {
		$this->m_flux .= 	'<copyright>'.$this->m_copyright.'</copyright>';
		}
		if ($this->m_managingEditor) {
		$this->m_flux .= 	'<managingEditor>'.$this->m_managingEditor.'</managingEditor>';
		}
		if ($this->m_webMaster) {
		$this->m_flux .= 	'<webMaster>'.$this->m_webMaster.'</webMaster>';
		}
		if ($this->m_lastBuildDate) {
		$this->m_flux .= 	'<lastBuildDate>'.$this->m_lastBuildDate.'</lastBuildDate>';
		}
		if ($this->m_category) {
		$this->m_flux .= 	'<category>'.$this->m_category.'</category>';
		}
		if ($this->m_generator) {
		$this->m_flux .= 	'<generator>'.$this->m_generator.'</generator>';
		}
		if ($this->m_docs) {
		$this->m_flux .= 	'<docs>'.$this->m_docs.'</docs>';
		}
		if ($this->m_cloud) {
		$this->m_flux .= 	'<cloud>'.$this->m_cloud.'</cloud>';
		}
		if ($this->m_ttl) {
		$this->m_flux .= 	'<ttl>'.$this->m_ttl.'</ttl>';
		}
		if ($this->m_rating) {
		$this->m_flux .= 	'<rating>'.$this->m_rating.'</rating>';
		}
		if ($this->m_textInput_title && $this->m_textInput_name && $this->m_textInput_link && $this->m_textInput_desc) {
		$this->m_flux .= 	'<textInput>';
		$this->m_flux .= 	'<title>'.$this->m_textInput_title.'</title>';
		$this->m_flux .= 	'<description>'.$this->m_textInput_desc.'</description>';
		$this->m_flux .= 	'<name>'.$this->m_textInput_name.'</name>';
		$this->m_flux .= 	'<link>'.$this->m_textInput_link.'</link>';
		$this->m_flux .= 	'</textInput>';
		}
		if ($this->m_skipHours) {
		$this->m_flux .= 	'<skipHours>'.$this->m_skipHours.'</skipHours>';
		}
		if ($this->m_skipDays) {
		$this->m_flux .= 	'<skipDays>'.$this->m_skipDays.'</skipDays>';
		}					
			
		if ($order == 'asc') {
			for( $i = 0; $i < $this->m_nbItem; ++$i) {
				$this->m_flux .= $this->m_itemTab[$i];
			}
		}
		else if($order == 'desc') {
			for( $i = $this->m_nbItem-1; $i >= 0; --$i) {
				$this->m_flux .= $this->m_itemTab[$i];
			}
		}
		
		$this->m_flux .= '</channel>
					</rss>';
					
		return $this->m_flux;
	}
};//
?>