<?php

require_once("includes/general/optim_php.inc.php");


function declinaison_to_string($declinaison) {
	global $id_langue,$id_boutique;
	$split=explode("|",$declinaison);
	$retour=array();
	for($i=0;$i<count($split);$i++) {
		if($res=testReq2("SELECT t.texte AS decl FROM shop_declinaisons_valeurs v,shop_ml_traductions t WHERE v.valeur=t.id_champs AND t.id_langue=$id_langue AND t.id_boutique=$id_boutique AND v.id=$split[$i]")) {
			array_push($retour,$res["decl"]);
		}
	}
	return implode(", ",$retour);
}
function ART_detaille($id) {
	global $id_structure, $id_boutique, $id_langue;
	// recup�re les textes, traductions, 
	if($retour=get_optim_php("ART_detaille",$id)) {
		return $retour;
	}
	// les specs qui doivent apparaitre en fiche article ?
	$retour=testReq2("SELECT *, get_traduction(nom,$id_boutique,$id_langue) AS nom,
			 get_traduction(soustitre,$id_boutique,$id_langue) AS soustitre,
			 get_traduction(description,$id_boutique,$id_langue) AS description,
			 get_nom_marque(id_marque) AS marque, 
			 get_nom_type(id_type,$id_boutique,$id_langue) AS type FROM shop_articles WHERE id=$id AND id_structure=$id_structure"); 
	set_optim_php("ART_detaille",$id,$retour);
	return $retour;
}

//////////////////////////////////////////////////////////////MODIFICATION JM/////////////////////////////////////////////////////////////////////

/**
 * Conversion d'un tableau PHP en un tableau Javascript
 */
function php2js ($var) 
{
	if(is_array($var)) 
	{
		$res = "[";
		$array = array();
		
		foreach ($var as $a_var) 
			$array[] = php2js($a_var);

		return "[" . join(",", $array) . "]";
	}
	else		
		if(is_bool($var)) 
			return $var ? "true" : "false";
		else
			if (is_int($var) || is_integer($var) || is_double($var) || is_float($var)) 
				return $var;
			else
				if (is_string($var)) 
    				return "\"" . addslashes(stripslashes($var)) . "\"";
	// autres cas: on ne les gère pas
	return FALSE;
} 

/**
 * Initialisation des variables javascript pour la gestion du bouton 'Acheter', de la gamme de réappro, des prix et de la galerie
 */
function javascript_gestion_declinaisons($res_article, $combinaisons, $stocks, $gamme_reappro, $prix, $reste_stock, $galerie_decl, $galerie_defaut)
{			
	//Les options de l'administration pour savoir les cas à traiter et ne pas avoir d'erreurs Javascript
	$aff_btn = (get_option("GES_ventes") && get_option("HTML_fa_btn_ajout")) ? "true" : "false";
	$aff_prix = (get_option("GES_prix") && get_option("HTML_fa_prix")) ? "true" : "false";
	$aff_promo = (get_option("GES_prix_promo") && get_option("HTML_fa_promo")) ? "true" : "false";
	$aff_reappro = (get_option("STO_reappro") && get_option("HTML_fa_reappro")) ? "true" : "false";
	$aff_galerie = (get_option("ART_GAL") && get_option("HTML_fa_galerie")) ? "true" : "false";
	
	$code_javascript = " 					
	var nom_article = '".htmlspecialchars(trad_get_from_id($res_article["nom"]), ENT_QUOTES)."';
	var liste_declinaisons = ".php2js($combinaisons).";
	var liste_stocks = ".php2js($stocks)."; 
	var liste_reappro = ".php2js($gamme_reappro).";
	var liste_prix = ".php2js($prix).";
	var prix_normal_article = '".toPrix($res_article[prix], true)."';
	var prix_promo_article = '".toPrix($res_article[prix_promo], true)."';
	var prix_vente_article = '".get_prix_vente($res_article)."';
	var remise_article = '".get_remise_article($res_article)."';
	var reste_stock = ".$reste_stock.";
	var affiche_bouton = ".$aff_btn.";
	var affiche_prix = ".$aff_prix.";
	var affiche_prix_promo = ".$aff_promo.";
	var affiche_reappro = ".$aff_reappro.";
	var affiche_galerie = ".$aff_galerie.";
	var galerie_declinaison = ".php2js($galerie_decl).";
	galerie_defaut = ".php2js($galerie_defaut).";
	";
	
	return $code_javascript;
}


/**
 * Croisement des tableaux pour obtenir toutes les combinaisons de déclinaisons
 */
function decl_array_croise_2D($t1,$t2) 
{
	$t2temp = $t2;
	$retour = array();
	
	for($i=0; $i<count($t1); $i++) 
	{
		for($j=0;$j<count($t2);$j++) 
		{
			array_push($retour, array_merge($t1[key($t1)], array(key($t2temp))));
			next($t2temp);
		}
		next($t1);
		$t2temp = $t2;
	}
	
	return $retour;
}

/**
 * Génération de toutes les combinaisons possible de déclinaisons ==> utilise decl_array_croise_2D
 */
function decl_array_croise_nD($table) 
{	
	$premiereLigne = array_shift($table);
	
	$tab_combine = array();
	
	for($i=0; $i<count($premiereLigne); $i++) 
	{
		array_push($tab_combine, array(key($premiereLigne)));
		next($premiereLigne);
	}
	
	while($tab = array_shift($table)) 
		$tab_combine = decl_array_croise_2D($tab_combine,$tab);

	return $tab_combine;
}

/**
 * Retourne un tableau de toutes les combinaisons de déclinaisons possibles pour l'article ($declinaisons est un tableau associatif)
 */
function combinaisons_declinaisons($declinaisons)
{	
	$combinaisons = decl_array_croise_nD($declinaisons);
	
	$n = sizeof($combinaisons);
	//parcourt les combinaisons
	$nb = 0;
	$retour = array();
	
	for($j=0;$j<$n;$j++) 
		$retour[] = implode("|",$combinaisons[$j]);
	
	return $retour;
}

/**
 * Retourne vrai si un article ou sa déclinaison est en promotion, faux sinon
 */
function art_is_promo($res_article, $declinaisons="") 
{
	//si l'on traite d'une déclinaison
	if($res_promo = testReq3("SELECT prix, prix_promo FROM shop_articles_prix WHERE id_article = $res_article[id] AND declinaison = '".$declinaisons."'"))
		return (($res_promo["prix_promo"] < $res_promo["prix"]) && ($res_promo["prix_promo"] > 0));
	else
		return (($res_article["prix_promo"] < $res_article["prix"]) && ($res_article["prix_promo"] > 0));
}

/**
 * Retourne le prix de vente d'un article en vérifiant les prix spécifiques pour une déclinaison et si l'article est en promotion
 */
function get_prix_vente($res_article, $declinaisons="")
{
	//la déclinaison de l'article a un prix spécifique
	if($res_prix = testReq3("SELECT prix, prix_promo FROM shop_articles_prix WHERE id_article = $res_article[id] AND declinaison = '".$declinaisons."'"))
		return (art_is_promo($res_article, $declinaisons) ? toPrix($res_prix["prix_promo"], true) : toPrix($res_prix["prix"], true));
	else
		return (art_is_promo($res_article) ? toPrix($res_article["prix_promo"], true) : toPrix($res_article["prix"], true));
}

/**
 * Retourne le prix normal ou le prix promotion($promo=true) d'un article ou de sa déclinaison
 */
function get_prix_article($res_article, $declinaisons="", $promo=false)
{
	//si l'on traite d'une déclinaison
	if($res_prix = testReq3("SELECT prix, prix_promo FROM shop_articles_prix WHERE id_article = $res_article[id] AND declinaison = '".$declinaisons."'"))
		if($promo)
			return ((art_is_promo($res_article, $declinaisons)) ? toPrix($res_prix["prix_promo"], true) : '0,00');
		else
			return (toPrix($res_prix["prix"], true));
	else
		if($promo)
			return ((art_is_promo($res_article))? toPrix($res_article["prix_promo"], true) : '0,00');
		else
			return (toPrix($res_article["prix"], true));
}

/**
 * Retourne la remise effectuée(en %) sur un article lorsque celui-ci est en promotion
 */
function get_remise_article($res_article, $declinaisons="")
{
	$remise = "";
	
	if(art_is_promo($res_article, $declinaisons))
	{
		//article ayant une déclinaison
		if($res_prix = testReq3("SELECT prix, prix_promo FROM shop_articles_prix WHERE id_article = $res_article[id] AND declinaison = '".$declinaisons."'"))
			$remise = ceil((($res_prix["prix"] - $res_prix["prix_promo"])/$res_prix["prix"])*100);
		else
			$remise = ceil((($res_article["prix"] - get_prix_vente($res_article))/$res_article["prix"])*100);
	}
	
	return $remise;
}


/**
 * Retourne le stock total d'un article, le stock de ces déclinaisons et la différence (total_stock-total_declinaison)
 */
function get_stock_article($res_article, $declinaison="")
{
	//récupération du stock total de l'article
	$tab_stock = testReq2("SELECT qte_web FROM shop_stocks_dispo WHERE id_article = $res_article[id] AND declinaison='' ");
	$total_stock   = $tab_stock["qte_web"];

	//récupération du stock total des déclinaisons de l'article
	if(!empty($declinaison) && (get_option("ART_DECL") && get_option("HTML_fa_declinaison")))
	{
		$tab_stock_decl = testReq2("SELECT SUM(qte_web) AS qte_web FROM shop_stocks_dispo WHERE id_article = $res_article[id] AND declinaison IN ('".implode("','",$declinaison)."') ");
		$total_declinaison = $tab_stock_decl["qte_web"];
		
		//vérification si le total des stocks est supérieur au total des déclinaisons
		if($total_stock > $total_declinaison )
			$reste_stock = 1;
		else
			$reste_stock = 0;
			
		return array($total_stock, $total_declinaison, $reste_stock);
	}
	
	return array($total_stock, 0, 0);
}


/**
 * Retourne la galerie d'images pour la déclinaison d'un article
 */
function get_galerie_declinaison($res_article, $declinaison)
{
	$tab_decl = explode("|", $declinaison);
	
	//récupération de la galerie pour la déclinaison passé en paramètre
	$req = 	"SELECT id FROM shop_articles_galerie WHERE id_article = $res_article[id] AND id NOT IN (
			SELECT id_image FROM shop_articles_galerie_declinaison WHERE id_article = $res_article[id]";
			
	for($i=0; $i<count($tab_decl); $i++)
	{
		if($i==0)
			$req .= " AND id_declinaison_valeur = $tab_decl[$i]";
		else
			$req .= " OR id_declinaison_valeur = $tab_decl[$i]";
	}
	
	$req .= ")";
	
	return ifReq($req);
}


function get_galerie_article($res_article)
{
	return ifReq("SELECT * FROM shop_articles_galerie WHERE id_article = $res_article[id]");
}


/**
 * Renseigne sur le stock, le prix, la gamme de réappro et la galerie d'images de chacune des déclinaisons d'un article
 */
function set_infos_article($res_article, $declinaisons, $combinaisons, $reste_stock)
{			
	$stocks = array(); //stocks de l'article pour chaque déclinaisons
	$prix = array(); //prix de chacune des déclinaisons de l'article
	$gamme_reappro = array(); //gamme de réapprovisionnement de chaque déclinaison de l'article
	$galerie_decl = array(); //galerie d'images pour chaque déclinaison de l'article
	$total_declinaison = 0; //stock total des déclinaisons de l'article

	
	//récupération de la gamme de réappro de l'article
	if(get_option("HTML_fa_reappro"))
	{
		$gamme_reappro_article = ART_get_gamme_reappro($res_article);
		$gamme_dispo_article = ART_get_gamme_dispo();
	}
	
	//vérification si l'article à des déclinaisons
	if(!empty($combinaisons))
	{
		//vérification pour toutes les combinaisons de déclinaisons si il y a du stock
		for($i=0; $i<count($combinaisons); $i++)
		{
			$query_stock = "SELECT qte_web FROM shop_stocks_dispo WHERE id_article = ".$res_article[id]." AND declinaison = '".$combinaisons[$i]."'";
			if($result = testReq2($query_stock))
			{
				//déclinaison en stock
				if($result['qte_web'] > 0)
					$stocks[$i] = 1;
				//déclinaison pas en stock
				else
					$stocks[$i] = 0;
			}
			//déclinaison non-renseignée
			else
				$stocks[$i] = -1;
			
				
			//récupération des prix et remise de la déclinaison
			$prix[$i]['prix'] = get_prix_article($res_article, $combinaisons[$i]);
			$prix[$i]['prix_promo'] = get_prix_article($res_article, $combinaisons[$i], true);
			$prix[$i]['remise'] = get_remise_article($res_article, $combinaisons[$i]);
			$prix[$i]['prix_vente'] = get_prix_vente($res_article, $combinaisons[$i]);
			
			//récupération de la gamme de réapprovisionnement de la déclinaison
			if(get_option("HTML_fa_reappro"))
			{
				if(ART_is_en_stock($res_article,$combinaisons[$i], $reste_stock))
					$gamme_reappro[$i] = $gamme_dispo_article; 
				else 
					$gamme_reappro[$i] = $gamme_reappro_article;
			}
			
			//récupération de la galerie d'images de la déclinaison
			if(get_option("ART_GAL") && get_option("HTML_fa_galerie"))
			{
				$query_galerie_declinaison = get_galerie_declinaison($res_article, $combinaisons[$i]);
				for($j=0; $tab =  mysql_fetch_assoc($query_galerie_declinaison); $j++)
					$galerie_decl[$i][$j] = $res_article['reference']."_galerie_".$tab['id'];
					
				$galerie_decl[$i][++$j] =  $res_article['reference']."_visuel";
			}
		}
	}
	return array($stocks, $gamme_reappro, $prix, $galerie_decl);
}


/**
 * Remplit toute la fiche d'un article
 */
function ART_HTML_remplit_fiche($une_fiche, $res_article, $fiche_complete=false, $remplace_retours="") 
{	
	global $chemin_detaille, $id_boutique, $id_langue;

	
//---------- DESCRIPTION DE L'ARTICLE
	$contenu = ART_HTML_remplit_liste($une_fiche,$res_article,$fiche_complete,$remplace_retours);
	

//---------- MON PANIER
	$contenu_mon_panier = "";
	
	if(get_option("GES_ventes") && get_option("HTML_fa_mon_panier"))
	{
		$contenu_mon_panier = recherche_element_par_balise($contenu, "MON_PANIER");
		$bloc_mon_panier = file_get_contents_boutique_ML("html_fichiers/mon_panier.bloc.htm");
		
		$contenu_mon_panier = str_replace("#MON_PANIER", $bloc_mon_panier, $contenu_mon_panier);
	}
	$contenu = remplace_element_par_balise($contenu, "MON_PANIER", $contenu_mon_panier); 
	

//----------LA GALERIE
	$la_galerie = "";
	$galerie_defaut = array();
	if(get_option("ART_GAL") && get_option("HTML_fa_galerie"))
	{		
		$contenu = affiche_element_par_balise($contenu, "ONGLET_GALERIE");
		
		$contenu_galerie = recherche_element_par_balise($contenu, "GALERIE");
		$liste_galerie = recherche_element_par_balise($contenu_galerie, "LISTE_GALERIE");
		
		$bloc_galerie = file_get_contents_boutique_ML("html_fichiers/galerie.bloc.htm");
			
		$query_galerie = get_galerie_article($res_article);

		$art_galerie = "";
		for($i=0; $res_galerie = mysql_fetch_assoc($query_galerie); $i++)
		{
			$image = refToLien(str_replace("&","_",$res_article["reference"]))."_galerie_".$res_galerie["id"]."_CROPMAX_60x60";
			$src = refToLien(str_replace("&","_",$res_article["reference"]))."_galerie_".$res_galerie["id"]."_MAX_320x300";
			
			$galerie_defaut[0][$i] = $res_article['reference']."_galerie_".$res_galerie['id'];
			
			$art_galerie = str_replace("#IMG_ART_GALERIE", $image, $bloc_galerie);
			$art_galerie = str_replace("#ID_ART_GAL", $res_article["reference"]."_".$res_galerie["id"], $art_galerie);
			$art_galerie = str_replace("#SRC_IMG_GALERIE", $src, $art_galerie);
			$art_galerie = str_replace("#ART_NOM", trad_get_from_id($res_article["nom"]), $art_galerie);
			
			$la_galerie .= $art_galerie;
		}
		
		//s'il n'y a pas de galerie, masquage de la galerie et affichage d'un messsage
		if(empty($la_galerie))
		{
			$contenu_galerie = cache_element_par_balise($contenu_galerie, "LISTE_GALERIE");
			$contenu_galerie = affiche_element_par_balise($contenu_galerie, "MESSAGE_AVERT");
		}
		//sinon, ajout de l'image actuelle, affichage de la galerie et masquage du message
		else
		{
			$liste_galerie = affiche_element_par_balise($liste_galerie, "BOUTON_GALERIE_PREC", true, "#BTN_VISIBLE", "visible");
			$liste_galerie = affiche_element_par_balise($liste_galerie, "BOUTON_GALERIE_SUIV", true, "#BTN_VISIBLE", "visible");
			
			$image = refToLien(str_replace("&","_",$res_article["reference"]))."_visuel_CROPMAX_60x60.jpg";
			$src = refToLien(str_replace("&","_",$res_article["reference"]))."_visuel_MAX_320x300.jpg";
			
			$galerie_defaut[0][$i++] = $res_article['reference']."_visuel";
			
			$art_galerie = str_replace("#IMG_ART_GALERIE", $image, $bloc_galerie);
			$art_galerie = str_replace("#ID_ART_GAL", $res_article["reference"], $art_galerie);
			$art_galerie = str_replace("#SRC_IMG_GALERIE", $src, $art_galerie);
			$art_galerie = str_replace("#ART_NOM", trad_get_from_id($res_article["nom"]), $art_galerie);
			
			$la_galerie .= $art_galerie;
			
			$liste_galerie = str_replace("#ARTICLES_GALERIE", $la_galerie, $liste_galerie);
			$contenu_galerie = remplace_element_par_balise($contenu_galerie, "LISTE_GALERIE", $liste_galerie);
			$contenu_galerie = cache_element_par_balise($contenu_galerie, "MESSAGE_AVERT");
		}
	}
	else
		$contenu = cache_element_par_balise($contenu, "ONGLET_GALERIE");
	
	$contenu = remplace_element_par_balise($contenu, "GALERIE", $contenu_galerie);	


	
//---------- LES STOCKS
	$contenu_stock = "";
	$tab_stock = get_stock_article($res_article);
	$total_stock = $tab_stock[0];
	
	//affichage des stocks
	if(get_option("GES_stocks") && get_option("HTML_fa_stock"))
	{
		$max_stock = get_option("HTML_fa_max_stock");
		
		if(empty($max_stock) || $max_stock > $total_stock)
		{
			if($total_stock == 0)
				$contenu = cache_element_par_balise($contenu, "STOCK_ARTICLE");
			else
				$contenu = affiche_element_par_balise($contenu, "STOCK_ARTICLE", true, "#STOCK_ART", $total_stock);
			$contenu = cache_element_par_balise($contenu, "STOCK_MAX_ARTICLE");
		}
		else
		{
			$contenu = cache_element_par_balise($contenu, "STOCK_ARTICLE");
			$contenu = affiche_element_par_balise($contenu, "STOCK_MAX_ARTICLE", true, "#STOCK_ART", $max_stock);
		}
	}
	else
		$contenu = cache_element_par_balise($contenu, "STOCK_MAX_ARTICLE");
	
	$contenu = remplace_element_par_balise($contenu, "STOCK_ARTICLE", $contenu_stock); 
	

//---------- LES DECLINAISONS
	$liste_declinaisons = "";
	
	//vérification des options de l'admin
	//si gestion des déclinaisons et affichage de celles-ci 
	//=> affichage des SELECT, récupération des stocks de l'article et désactivation du bouton 'Acheter'
	if(get_option("ART_DECL") && get_option("HTML_fa_declinaison"))
	{
		$tab_declinaisons = ART_HTML_remplit_declinaisons($res_article);
	
		$liste_declinaisons = $tab_declinaisons[0]; //code HTML: les select
		$declinaisons = $tab_declinaisons[1]; //tableau des déclinaisons
	
		//récupération de toutes les combinaisons de déclinaisons possibles pour cet article
		$combinaisons = combinaisons_declinaisons($declinaisons);
	
		//récupération du reste_stock (total_stock - total_declinaison)
		$tab_stock = get_stock_article($res_article, $combinaisons);
		$reste_stock = $tab_stock[2];
		
		
		//récupération des stocks, gamme de réappro et prix pour chaque déclinaison, et affichage du message en conséquence
		$tab_infos = set_infos_article($res_article, $declinaisons, $combinaisons, $reste_stock);
		$stocks = $tab_infos[0]; 
		$gamme_reappro = $tab_infos[1];
		$prix = $tab_infos[2];
		$galerie_decl = $tab_infos[3];
		
		
		$contenu_mess = recherche_element_par_balise($contenu,"MESSAGE_AVERT");
		
		//s'il y a du stock, pas d'affichage de message
		if($total_stock > 0)
		{
//----------JAVASCRIPT DECLINAISONS
			//Ajout du code javascript initialisant les différentes variables 
			if(get_option("ART_DECL") && get_option("HTML_fa_declinaison"))
				$contenu = str_replace("#JAVASCRIPT_DECLINAISONS", javascript_gestion_declinaisons($res_article, $combinaisons, $stocks, $gamme_reappro, $prix, $reste_stock, $galerie_decl, $galerie_defaut), $contenu);	
			else
				$contenu = str_replace("#JAVASCRIPT_DECLINAISONS", "", $contenu);
				
			//Masquage du message
			$contenu = cache_element_par_balise($contenu, "MESSAGE_AVERT");
		}
		//sinon, pas de génération du javascript et affichage d'un message sur les stocks
		else
		{
			$contenu = affiche_element_par_balise($contenu, "MESSAGE_AVERT");
			$contenu = str_replace("#JAVASCRIPT_DECLINAISONS", "", $contenu);
		}
	}
	else
	{
		if($total_stock > 0)
			$contenu = cache_element_par_balise($contenu, "MESSAGE_AVERT");
		else
			$contenu = affiche_element_par_balise($contenu, "MESSAGE_AVERT");
		$contenu = str_replace("#JAVASCRIPT_DECLINAISONS", "", $contenu);
	} 
	
	$contenu = str_replace("#DECLINAISONS", $liste_declinaisons, $contenu);
	
	
//----------BOUTON AJOUTER ET THICKBOX
	$contenu_ajout = "";
	if(get_option("GES_ventes") && get_option("HTML_fa_btn_ajout"))
	{
		$contenu_ajout = recherche_element_par_balise($contenu, "BTN_AJOUT");
		$bloc_thickbox = file_get_contents_boutique_ML("html_fichiers/thickbox.bloc.htm"); //structure de la thickbox
		$liste_thickbox = ART_HTML_remplit_liste($bloc_thickbox,$res_article);
		
		$contenu_ajout = str_replace("#CONTENU_THICKBOX", $liste_thickbox, $contenu_ajout);			
		
		//pas de stock
		//gestion des déclinaisons et affichage des SELECT et l'article a des déclinaisons
		//pas de gestion des déclinaisons et pas de stock
		//==> BOUTON INACTIF		
		if($total_stock == 0 || (get_option("ART_DECL") && get_option("HTML_fa_declinaison") && count($combinaisons)>1 ) 
		|| (!get_option("ART_DECL") && $total_stock == 0))
			$contenu_ajout = str_replace("#ACTIF", 'disabled="disabled"', $contenu_ajout);
			
		//sinon, le bouton est activé
		else
			$contenu_ajout = str_replace("#ACTIF", '', $contenu_ajout);
	}
	$contenu = remplace_element_par_balise($contenu, "BTN_AJOUT", $contenu_ajout);
	
	

//----------LES ARTICLES ASSOCIES
	//récupération du nombre d'articles associés autorisé à être affiché
	$nb_assoc = get_option("HTML_fa_nb_assoc");
	$contenu_assoc="";	
	
	//si le nombre est > 0 et que l'option association d'articles est cochée, alors on affiche les articles associés
	if($nb_assoc > 0 && get_option("ART_ASSO"))
	{ 
		$contenu_assoc = ART_HTML_remplit_art_assoc($res_article, $nb_assoc, $contenu);
		$contenu = affiche_element_par_balise($contenu, "ONGLET_ART_ASSOC");
	}
	else
		$contenu = cache_element_par_balise($contenu, "ONGLET_ART_ASSOC");

	$contenu = remplace_element_par_balise($contenu,"ARTICLES_ASSSOCIES",$contenu_assoc);
	
	
//----------LES SPECIFICATIONS
	//récupération de l'option d'affichage des spécifications pour un article
	$aff_specs = (get_option("HTML_fa_aff_specs") && get_option("ART_SPEC"));
	$contenu_specs="";
	
	//si l'affichage est autorisé, on les affiche
	if($aff_specs)
	{
		$contenu = affiche_element_par_balise($contenu, "ONGLET_SPEC"); 
		
		$contenu_specs = recherche_element_par_balise($contenu,"SPECIFICATIONS");

		//récupération de la structure du bloc des spécifications
		$structure_spec = file_get_contents_boutique_ML("html_fichiers/specifications.bloc.htm"); 
		
		$query_specs_familles_pertinentes = ifReq("SELECT get_traduction(nom, $id_boutique, $id_langue) nom, id FROM shop_specs_familles_pertinentes ssfp
		INNER JOIN shop_specs_familles ssf ON ssfp.id_famille = ssf.id WHERE ssfp.id_article_type = $res_article[id_type]");
		
		while($res_specs_familles_pertinentes = mysql_fetch_assoc($query_specs_familles_pertinentes))
			$la_specification .= ART_HTML_remplit_specs($res_specs_familles_pertinentes['id'], $res_article, $structure_spec);
		
		//s'il n'y a pas de specs, masquage de la liste des spec et affichage d'un message
		if(empty($la_specification))
		{
			$contenu_specs = cache_element_par_balise($contenu_specs, "LISTE_SPECIFICATIONS");
			$contenu_specs = affiche_element_par_balise($contenu_specs, "MESSAGE_AVERT");
		}
		//sinon, masquage du message et affichage de la liste des specs
		else
		{
			$contenu_specs = affiche_element_par_balise($contenu_specs, "LISTE_SPECIFICATIONS", true, "#SPECIFICATIONS", $la_specification);
			$contenu_specs = cache_element_par_balise($contenu_specs, "MESSAGE_AVERT");
		}
	}
	else
		$contenu = cache_element_par_balise($contenu, "ONGLET_SPEC");
	
	$contenu = remplace_element_par_balise($contenu,"SPECIFICATIONS",$contenu_specs);
		
	return $contenu;
}

/**
 * Remplit les différentes déclinaisons de l'article sous forme de liste SELECT
 */
function ART_HTML_remplit_declinaisons($res_article)
{	
	global $id_boutique, $id_langue;
	
	//stocke tous les types de déclinaisons trouvés pour l'articlé concerné
	$declinaisons = array();
	
	//structure du bloc des déclinaisons
	$bloc_declinaisons = file_get_contents_boutique_ML("html_fichiers/declinaisons.bloc.htm"); 
	$bloc_valeur = recherche_element_par_balise($bloc_declinaisons,"VALEURS_DECLINAISON");

	//récupération des différents types de déclinaisons disponibles pour cet article
	$query_declinaison_dispos = ifReq("SELECT DISTINCT(id_type) FROM shop_declinaisons_dispo WHERE id_article = $res_article[id]");
	$liste_declinaisons = "";
	//s'il y a du stock pour cet article, on recherche les différentes déclinaisons
	if(mysql_num_rows($query_declinaison_dispos) != 0)
	{
		while($res_declinaison_dispos = mysql_fetch_assoc($query_declinaison_dispos))
		{	
			//récupération du nom du type des déclinaisons
			$query_declinaison_type = ifReq("SELECT get_traduction(nom, $id_boutique, $id_langue) nom FROM shop_declinaisons_types 
										WHERE id = $res_declinaison_dispos[id_type] AND id_article_type = $res_article[id_type]");
			
			while($res_declinaison_type = mysql_fetch_assoc($query_declinaison_type))
			{	
				$declinaisons[$res_declinaison_type['nom']] = array();
				
				$la_declinaison = $bloc_declinaisons;
				$la_declinaison = str_replace("#TYPE_DECLINAISON", $res_declinaison_type['nom'], $la_declinaison);
				
				//récupération de la valeur de la déclinaison
				$query_declinaison_valeur = ifReq("SELECT get_traduction(valeur, $id_boutique, $id_langue) valeur, id FROM shop_declinaisons_valeurs sdv
								INNER JOIN shop_declinaisons_dispo sdd ON sdd.id_valeur = sdv.id 
								WHERE sdd.id_article = $res_article[id] AND sdd.id_type = $res_declinaison_dispos[id_type] ORDER BY valeur ASC");
				$liste_valeurs = "";
				while($res_declinaison_valeur = mysql_fetch_assoc($query_declinaison_valeur))
				{
					$declinaisons[$res_declinaison_type['nom']][$res_declinaison_valeur['id']] = $res_declinaison_valeur['valeur'];
					$liste_valeurs .= str_replace("#ID_DECLINAISON", $res_declinaison_valeur['id'], $bloc_valeur);
					$liste_valeurs = str_replace("#VALEUR_DECLINAISON", $res_declinaison_valeur['valeur'], $liste_valeurs);
				}
				
				$la_declinaison = remplace_element_par_balise($la_declinaison,"VALEURS_DECLINAISON",$liste_valeurs);
				$liste_declinaisons .= $la_declinaison;	
			} 
		}
	}
	//s'il n'y a pas de stock, on retourne la structure du message d'information
	else
		$liste_declinaisons = $contenu_mess;

	return array($liste_declinaisons, $declinaisons);
}

/**
 * Remplit la liste des articles associés à l'article choisi sous forme de tableau
 */
function ART_HTML_remplit_art_assoc($res_article, $nb_assoc, $contenu)
{
	$ligne_assoc = "";
		
	if($nb_assoc <= 4) $ligne = 1;	
	else $ligne = 2;
	
	for($i=0; $i<$ligne; $i++) //boucle pour afficher 1 ou 2 lignes d'articles associés
	{
		$contenu_assoc = recherche_element_par_balise($contenu,"ARTICLES_ASSSOCIES");	
		$bloc_ligne_assoc = recherche_element_par_balise($contenu_assoc,"LIGNE_ART_ASSOC");
		
		$bloc_associe = file_get_contents_boutique_ML("html_fichiers/articles_associes.bloc.htm"); //structure du bloc des articles associés
		
		if($ligne==1)
			$query_assoc = ifReq("SELECT art.* FROM shop_articles_association art_ass INNER JOIN shop_articles art 
								ON art_ass.id_article2 = art.id WHERE art_ass.id_article1 = $res_article[id] LIMIT 0, $nb_assoc");
		else
			if($i==0)
				$query_assoc = ifReq("SELECT art.* FROM shop_articles_association art_ass INNER JOIN shop_articles art 
								ON art_ass.id_article2 = art.id WHERE art_ass.id_article1 = $res_article[id] LIMIT 0, 4");
			else
				$query_assoc = ifReq("SELECT art.* FROM shop_articles_association art_ass INNER JOIN shop_articles art 
								ON art_ass.id_article2 = art.id WHERE art_ass.id_article1 = $res_article[id] LIMIT 4, ".($nb_assoc-4));
		
		$liste_assoc = "";
		while($res_assoc = mysql_fetch_assoc($query_assoc))
			$liste_assoc .= ART_HTML_remplit_liste($bloc_associe,$res_assoc);

		//s'il n'y a pas d'articles associés, affichage d'un message
		if(empty($liste_assoc) && $i == 0)
		{
			$contenu_assoc = cache_element_par_balise($contenu_assoc, "LIGNE_ART_ASSOC");
			$contenu_assoc = affiche_element_par_balise($contenu_assoc, "MESSAGE_AVERT");
			break;
		}
		//sinon on affiche les articles et on cache la zone du message
		else
		{
			$bloc_ligne_assoc = str_replace("#ARTICLES_ASSOCIES", $liste_assoc, $bloc_ligne_assoc);
			$ligne_assoc .= $bloc_ligne_assoc;
			$contenu_assoc = cache_element_par_balise($contenu_assoc, "MESSAGE_AVERT");
			
			$contenu_assoc = remplace_element_par_balise($contenu_assoc, "LIGNE_ART_ASSOC", $ligne_assoc);
		}
	}
	return $contenu_assoc;
}

/**
 * Remplit les spécifications associées à un article
 */
function ART_HTML_remplit_specs($id_famille_pertinente, $res_article, $structure_spec)
{
	global $chemin_detaille, $id_boutique, $id_langue;
	
	//récupération du bloc [#LES_SPECS_PREDEFS]
	$bloc_les_specs_predefs = recherche_element_par_balise($structure_spec,"LES_SPECS_PREDEFS");
	$liste_les_specs_predefs = "";
	$query_specs_elems = ifReq("SELECT get_traduction(nom, $id_boutique, $id_langue) nom, id FROM shop_specs_elems WHERE id_famille = $id_famille_pertinente");	
	
	while($res_specs_elems = mysql_fetch_assoc($query_specs_elems))
	{
		$la_specification = $structure_spec;
		
		//récupération des différentes valeurs pour chaque déclinaison
		$query_specs_predef = ifReq("SELECT get_traduction(ssp.valeur, $id_boutique, $id_langue) valeur FROM shop_specs_predef ssp 
		INNER JOIN shop_specs_valeurs ssv ON ssv.id_spec = $res_specs_elems[id]
		AND ssp.id = ssv.valeurs_predef AND ssv.id_article = $res_article[id]");
		
		$liste_specs_predef = "";
		$test_specs = false; //permet de vérifier s'il y a des spécifications
		while($res_specs_predef = mysql_fetch_assoc($query_specs_predef)) 
		{
			$test_specs = true;
			$liste_specs_predef .= str_replace("#SPEC_PREDEF", $res_specs_predef['valeur'], $bloc_les_specs_predefs);
		}
		if($test_specs)
		{
			$la_specification = str_replace("#SPEC_ELEM", $res_specs_elems['nom'], $la_specification);
			$la_specification = remplace_element_par_balise($la_specification,"LES_SPECS_PREDEFS",$liste_specs_predef);
			$la_specification = cache_element_par_balise($la_specification, "MESSAGE_AVERT");
			$liste_specs_predefs .= $la_specification;
		}		
	}
	return $liste_specs_predefs;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/**
 * Renseigne les informations principales concernant un article
 */
function ART_HTML_remplit_liste($une_fiche,$res_article,$fiche_complete=false,$remplace_retours="") {
	include_once("includes/general/nombres.inc.php");
	include_once("includes/general/recherche_remplace.inc.php");
	require_once("includes/html/marques.inc.php");
	require_once("includes/html/types.inc.php");
	require_once("includes/html/url.inc.php");
	$ref=refToLien($res_article["reference"]);
	
	$contenu=str_replace("#ART_REF",$ref,$une_fiche);
	$contenu=str_replace("#ART_TYPE",type_get_nom_from_id($res_article["id_type"]),$contenu);

	/////////////////////////////////////////////////////////MODIFICATION JM//////////////////////////////////////////////////////////////////////
	if(get_option("GES_marques"))
	{
		//affichage du texte
		if(strcmp(get_option("HTML_fa_marque"), "Texte") == 0)
		{
			$contenu = affiche_element_par_balise($contenu, "BLOC_TEXTE_MARQUE", true, "#ART_MARQUE", marque_get_nom_from_id($res_article["id_marque"]));
			$contenu = cache_element_par_balise($contenu, "BLOC_IMG_MARQUE");
		}
		else
			//affichage de l'image	
			if(strcmp(get_option("HTML_fa_marque"), "Image") == 0)
			{
				$contenu = cache_element_par_balise($contenu, "BLOC_TEXTE_MARQUE");
				if($res_article["id_marque"] != 0)
				{
					$bloc_image_marque = recherche_element_par_balise($contenu, "BLOC_IMG_MARQUE");
					
					$image_marque = "marque_CROPMAX_80x60_".refToLien(str_replace("&", "_", $res_article["id_marque"]));
					
					$bloc_image_marque = str_replace("#SRC_IMG_MARQUE", $image_marque, $bloc_image_marque);
					$bloc_image_marque = str_replace("#ART_MARQUE", marque_get_nom_from_id($res_article["id_marque"]),$bloc_image_marque);
					
					$contenu = remplace_element_par_balise($contenu, "BLOC_IMG_MARQUE", $bloc_image_marque);
				}
				else
					$contenu = cache_element_par_balise($contenu, "BLOC_IMG_MARQUE");
			}
			else
				//aucun affichage
				if(strcmp(get_option("HTML_fa_marque"), "Aucun") == 0)
				{
					$contenu = cache_element_par_balise($contenu, "BLOC_TEXTE_MARQUE");
					$contenu = cache_element_par_balise($contenu, "BLOC_IMG_MARQUE");
				}
	}
	else
	{
		$contenu = cache_element_par_balise($contenu, "BLOC_TEXTE_MARQUE");
		$contenu = cache_element_par_balise($contenu, "BLOC_IMG_MARQUE");
	}
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
	if($fiche_complete) 
	{
		$contenu=str_replace("#ART_DESC",str_replace("\r",$remplace_retours,$res_article["description"])	,$contenu);
		$contenu=str_replace("#ART_NOM",($res_article["nom"]),$contenu);
		$contenu=str_replace("#ART_SOUSTITRE",($res_article["soustitre"]),$contenu);
	} 
	else 
	{
		require_once("includes/commun/traductions.inc.php");
		$contenu=str_replace("#ART_DESC",str_replace("\r",$remplace_retours,trad_get_from_id($res_article["description"]))	,$contenu);
		$contenu=str_replace("#ART_NOM",trad_get_from_id($res_article["nom"]),$contenu);
		$contenu=str_replace("#ART_SOUSTITRE",trad_get_from_id($res_article["soustitre"]),$contenu);
	}
	$lien=lien_absolu(get_lien_article_from_res($res_article,$fiche_complete));
	$contenu=str_replace("#ART_LIEN",$lien,$contenu);
	$bloc_visuel=recherche_element_par_balise($contenu,"ART_VIGNETTE");
	
	$bloc_visuel=refToLien(str_replace("&","_",$res_article["reference"]))."_visuel_".$bloc_visuel.".jpg";
	$contenu=remplace_element_par_balise($contenu,"ART_VIGNETTE",$bloc_visuel);

	/////////////////////////////////////////////////////////MODIFICATION JM//////////////////////////////////////////////////////////////////////
	//affichage du prix, de la promotion et de l'éco-participation
	$contenu_prix = "";
	if(get_option("GES_prix") && get_option("HTML_fa_prix"))
	{
		$contenu_prix = recherche_element_par_balise($contenu, "BLOC_PRIX");

		if(art_is_promo($res_article) && get_option("GES_prix_promo") && get_option("HTML_fa_promo")) 
		{
			$contenu_prix = affiche_element_multiple_par_balise($contenu_prix, "BLOC_PROMO", true, array("#REMISE_PROMO","#ART_PRIX_HORS_PROMO"), array(get_remise_article($res_article),toPrix($res_article["prix"],true)));
			//$contenu_prix = affiche_element_par_balise($contenu_prix, "BLOC_PROMO", true, array("#REMISE_PROMO","#ART_PRIX_HORS_PROMO"), array(get_remise_article($res_article),toPrix($res_article["prix"],true)));
			//FIXME:!!! deux blocs !!
			
		}
		else
		{
			$contenu_prix = cache_element_multiple_par_balise($contenu_prix, "BLOC_PROMO");
			//$contenu_prix = cache_element_par_balise($contenu_prix, "BLOC_PROMO");
			//FIXME:!!! deux blocs !!
		}
			
		$contenu_prix = str_replace("#ART_PRIX_TTC", toPrix(get_prix_vente($res_article),true),$contenu_prix);
		
		//affichage de l'éco-part
		$contenu_prix =  affiche_element_par_balise($contenu_prix, "ECO_PARTICIPATION",(get_option("HTML_fa_eco-part") && get_option("ART_ecopart")),"#ECO_PART",$res_article['ecopart']);
		
	} 
	$contenu = remplace_element_par_balise($contenu,"BLOC_PRIX",$contenu_prix);
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	return $contenu;
}



///////////////////////////////////////////////////// MODIFICATION JM ///////////////////////////////////////////////////////////////////////////
/**
 * Récupère la gamme de réapprovisionnement de la catégorie récursivement (remonte à la catégorie parent)
 */
function ART_get_reappro_categorie($id_elem)
{	
	global $id_structure;
	
	$res_gamme = testReq2("SELECT id_gamme FROM shop_categories WHERE id_elem = $id_elem");
	
	//si on est à la racine et que la gamme de réappro est 'Aucune', on retourne la réappro par défaut de la boutique
	//CAS IMPOSSIBLE THEORIQUEMENT !!!!
	if($id_elem == 0 && $res_gamme[id_gamme] == -1)
		return "ERREUR!";
	else
		//si la gamme de réapprovisionnement n'est pas 'Aucune', alors on retourne ça valeur
		if($res_gamme[id_gamme] == -1)
		{
			$res_id_parent = testReq2("SELECT id_parent FROM shop_struct_elems WHERE id = $id_elem AND id_structure = $id_structure");
			return ART_get_reappro_categorie($res_id_parent[id_parent]);
		} 
		else
		{
			if(($res=get_optim_php("gamme",$res_gamme["id_gamme"]))==false) {
				$res = ifReq("SELECT nom, sigle, couleur,  reapprovisionnable FROM shop_gamme_reappro WHERE id = $res_gamme[id_gamme]");
				set_optim_php("gamme",$res_gamme["id_gamme"],$res);
			}
			return mysql_fetch_assoc($res);
		}
}


/**
 * Retourne la gamme de réapprovisionnement correspondant à un article
 */
function ART_get_gamme_reappro($res_article) 
{
	global $id_boutique, $id_langue;
	
	switch($res_article["type_reappro"]) 
	{
		//Réapprovisionnement par fournisseur
		case "fournisseur":
			$res_fournisseur = testReq2("SELECT id_gamme_reappro from shop_fournisseurs WHERE id_boutique = $id_boutique AND id = $res_article[id_fournisseur]");
			return testReq3("SELECT nom, sigle, couleur, reapprovisionnable FROM shop_gamme_reappro WHERE id_boutique=$id_boutique AND id=$res_fournisseur[id_gamme_reappro]");
			break;
		
		//Réapprovisionnement par article
		case "article":
			return testReq3("SELECT nom, sigle, couleur, reapprovisionnable FROM shop_gamme_reappro WHERE id_boutique=$id_boutique AND id=$res_article[id_gamme]");
			break;
		
		//Réapprovisionnement par catégorie
		case "categorie":
			return  ART_get_reappro_categorie($res_article[id_elem]);
			break;
	}
}

/**
 * Retourne la gamme de réapprovisionement disponible 
 */
function ART_get_gamme_dispo() 
{
	global $id_boutique, $id_langue;
	
	//ne pas changer les colonnnes récupérées !!! (car correspondance avec les tableaux JS, voir declinaison.js)
	return testReq3("SELECT nom, sigle, couleur FROM shop_gamme_reappro WHERE id_boutique=$id_boutique AND duree=0 AND reapprovisionnable=1");
}

/**
 * Retourne si la déclinaison d'un article est en stock ou pas
 */
function ART_is_en_stock($res_article, $declinaison="", $reste=0) 
{
	global $id_boutique, $id_langue;
	
	$en_stock = false;
	
	// Vérification de l'option de gestion des stocks
	if(get_option("GES_stocks") && get_option("STO_reappro"))
	{
		//le stock est renseigné
		if($res = testReq2("SELECT qte_web FROM shop_stocks_dispo WHERE id_boutique=$id_boutique AND id_article=$res_article[id] AND declinaison='$declinaison'")) 
			$en_stock = ($res["qte_web"] > 0  );
		//stock non renseigné
		else
			$en_stock = ($reste > 0);
	}
	
	return $en_stock;
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
?>
