CREATE FUNCTION getTradAOL_langue(v_id_champs INT, v_langue CHAR(5),v_id_boutique INT) RETURNS TEXT CHARACTER SET utf8  DETERMINISTIC
BEGIN

  DECLARE retour TEXT;
  SELECT texte INTO retour FROM shop_ml_traductions  AS t
        INNER JOIN shop_ml_langues AS l ON l.id=t.id_langue AND l.drapeau=v_langue
        WHERE t.id_champs=v_id_champs AND t.id_boutique=v_id_boutique AND texte!='' AND texte!=' ';

  IF(ISNULL(retour)) THEN
    /* si on n'a pas la trad dans la langue, on prend la 1ere dispo (dans l'ordre des langues de l'AOL */
    SELECT IFNULL(texte,' ') INTO retour FROM shop_ml_traductions  AS t
        INNER JOIN shop_ml_langues AS l ON l.id=t.id_langue
        WHERE t.id_champs=v_id_champs AND t.id_boutique=v_id_boutique AND texte!='' AND texte!=' '
        ORDER BY l.id_AOL ASC LIMIT 0,1;
    /* */
  END IF;
  RETURN retour;
END;