<?php
/**
 * This Adapter translates the specific Database type links to the data and pulls the data into very
 * specific local variables to later be retrieved by the gateway and returned to the client.
 *
 * pdoAdapter is a contribution of Andrea Giammarchi
 *
 * Now using fast serialization
 * 
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @copyright (c) 2003 amfphp.org
 * @package flashservices
 * @subpackage adapters
 * @version $Id: doctrineAdapter.php,v 1.1.2.1 2009-04-15 10:29:09 raph Exp $
 */

require_once(AMFPHP_BASE . "shared/adapters/RecordSetAdapter.php");

class doctrineAdapter extends RecordSetAdapter 
{
	function doctrineAdapter($d) {
		parent::RecordSetAdapter($d);
		
		if(count($d) > 0)
		{
			$firstRow = true;
			foreach($d as $row)
			{
				$this->rows[] = array_values($row->toArray());
				if($firstRow)
				{
					$this->columns = array_keys($row->toArray());
					$firstRow = false;
				}
			}
		}
	}
}
?>