<?php
abstract class Controller {
	
	protected $function;
	protected $action = 'index';
	protected $contenu;
	
	protected $request;
	
	protected $nextAction = null;
	
	public $moduleName;
	
	abstract protected function executeIndex($request);
	abstract protected function executeShow($request);
	abstract protected function executeNew($request);
	abstract protected function executeEdit($request);
	
	public function __construct($request = null,$action = null){
		
		if(AUTHENTICATED){
			if(!Admin::isAuthenticated()){
				$dir = '../tpl/authenticated.php';
				if(is_readable($dir)){
					$this->contenu = $this->render($dir);
				}
				else exit('Authentification impossible');
				
				return;
			}
		}
		
		
		$this->request = $request;
		
		if($action != null) $this->action = $action;

		$className = get_class($this);
		$trans = array('Controller' =>'');
		$this->moduleName = strtr($className,$trans);
		
		$this->execute($this->request);
	}
	
	
	protected function execute($request){
		
//		TODO: prévoir une boucle ou récursivité pour faire un nextAction ou redirect
		
		$actionToRun = 'execute'.ucfirst($this->action);
	
		if($this->is_action($actionToRun)){
	    
		    //Si pas de template et que l'action existe, on fait l'action et r�cup�re l'action suivante
		    if(!$this->hasTemplate($this->action) && is_callable(array($this, $actionToRun))){
		    	$retour = $this->$actionToRun($request);
		    	
		    	if(!is_null($this->nextAction) && $this->nextAction != $this->action ){
		    		$this->action = $this->nextAction;
		    		$actionToRun = 'execute'.ucfirst($this->action);
		    		$this->nextAction = null;
		    	}
		    	else{
					return;		    		
		    	}
		    }
		    
		    //On relance la fonction si une autre action est envoyée
		    if($this->is_action($actionToRun)){
				$result = $this->$actionToRun($request);
				
				if($this->nextAction != null){
					$this->action = $this->nextAction;
					$this->nextAction = null;
					$this->execute($request);
					return;
				}
				
//				if($result != false){
					
					$dir = '../modules/'.strtolower($this->moduleName).'/templates/'.$this->action.'Success.php';
					if(is_readable($dir)){
						$this->contenu = $this->render($dir,$result);
					}
					else{
						exit('template pas présent');
					}
//				}
//				else{
//					exit('Aucune action de ce nom associée à ce module');
//				}
		    
		    }
		}
	}
	
	protected function render($file,$result = null){
		ob_start();
		include_once($file);
		$str = ob_get_contents();
		ob_end_clean();
		
		return $str;
	}
	
	public function getContenu(){
		return $this->contenu;
	}
	
	private function hasTemplate($action){
		$dir = '../modules/'.strtolower($this->moduleName).'/templates/'.$action.'Success.php';
		if(is_readable($dir)){
			return true;
		}
		else{
			return false;
		}
	}
	
	private function is_action($action){
		if ($action === 'execute')
	    {
	      // no action given
	      exit('L\'action n\'a pas été donnée');
	    }
	    else if (!is_callable(array($this, $action)))
	    {
	      // action not found
	      exit('La m�thode n\'existe pas');
	    }
	    else{
	    	return true;
	    }
	    
	}
	
	
	protected function nextAction($nextAction){
		$this->nextAction = $nextAction;
	}
	
	public function redirect($url){
		
		header("Location: ". $url); /* Redirection du navigateur */
		
		//La suite du code n'est pas executable
		exit;
	}
	
	
	
}