<?php
//include_once 'modules/listes/classes/CListes.class.php';//auto
//include_once 'modules/blog/classes/CBlogableAffichages.class.php';//auto
include_once 'modules/stats/services_flash/SvcStats.php';

class CBlogable
{
	
	private static $categories_crees = false;
	/**
	 * transforme la liste en liste blogable
	 * @param $identifiant_liste
	 * @param $methode_unicite : string 'ip' ou 'session'
	 * @param $nb_autorise_jour : nombre de vote/note autorisée par personne par élément par jour
	 * @return void
	 */
	public static function creeBlogable($identifiant_liste, $dossier_racine, $titre_elem_admin, $methode_unicite = 'ip', $nb_autorise_jour = 1, $url_elem_ss_classement = '', $racine_complete_etr = '')
	{
		$datablog = array('blog_identifiant_liste'=>$identifiant_liste, 'dossier_racine'=>$dossier_racine,'methode_unicite'=>$methode_unicite, 'nb_vote_autorise_jour'=>$nb_autorise_jour, 'url_elem_ss_classement'=>$url_elem_ss_classement, 'racine_complete_etr'=>$racine_complete_etr, 'titre_admin'=>$titre_elem_admin);
		CListes::insere_update('blogable', $datablog, "blog_identifiant_liste ='$identifiant_liste'");

		$infos_liste = CListes::get_liste($identifiant_liste);
		$table = $infos_liste['table'];

		CListes::add_champ_liste($identifiant_liste, 'date_crea', 'DATETIME', 'date_crea', 'date_crea', 'date de creation', NULL, NULL, NULL, 'hidden');
		CListes::add_fn_transfo_champ("$identifiant_liste","date_crea", "base.CColonnes_auto.today_date_heure", true, false);
		CListes::add_champ_liste($identifiant_liste, 'date_modif', 'DATETIME', 'date_modif', 'date_modif', 'date de modif', NULL, NULL, NULL, 'hidden');
		CListes::add_fn_transfo_champ("$identifiant_liste","date_modif", "base.CColonnes_auto.today_date_heure", true, true);
		CListes::add_cle_index($identifiant_liste,'index_date_modif', 'date_modif');
		CListes::add_cle_index($identifiant_liste,'index_date_crea', 'date_crea');

		CListes::add_champ_liste($identifiant_liste, 'nb_vue', 'INT', 'nb_vue', 'nb_vue', 'nombre de consultation', NULL, NULL, "NOT NULL", 'hidden');
		CListes::insere('type_stats', array('table_upd'=>$table, 'colonne_upd'=>'nb_vue', 'colonne_where'=>'id_auto', 'identifiant'=>$identifiant_liste.'_VUE', 'type'=>'CPT'), 'identifiant');
		CListes::add_champ_liste($identifiant_liste, 'nb_partage', 'INT', 'nb_partage', 'nb_partage', 'nombre de partage', NULL, NULL, "NOT NULL", 'hidden');
		CListes::insere('type_stats', array('table_upd'=>$table, 'colonne_upd'=>'nb_partage', 'colonne_where'=>'id_auto', 'identifiant'=>$identifiant_liste.'_PARTAGE', 'type'=>'CPT'), 'identifiant');
		CListes::add_cle_index($identifiant_liste,'index_nb_partage', 'nb_partage');
		CListes::add_cle_index($identifiant_liste,'index_nb_vue', 'nb_vue');

		CBlogableAffichages::ajouteTypeAffichageListe($identifiant_liste, 'blogbase', 'modules/blog/www/html/blocs/blogbase');
		CBlogableAffichages::ajouteTypeAffichageListe($identifiant_liste, 'blogbase_mini', 'modules/blog/www/html/blocs/blogbase_mini');
		self::creeListeClassement();
	}
	
	public static function ajouteAutoActivable($identifiant_liste) {
		CListes::update('listes', array('use_auto_actif'=>'1'), "identifiant = '$identifiant_liste'");
		CListes::add_champ_liste($identifiant_liste, "elem_actif", "BOOL","elem_actif", "elem_actif", "à cocher pour activer l'element", "(.+)", '5', NULL, 'checkbox');
		CListes::set_valeurs_defaut($identifiant_liste, array('elem_actif'=>'1'));
	}
	
	public static function creePageBlogable($identifiant_liste, $dossier_racine, $module_client, $modele, $classe_php, $parametres ='', $use_stats = 0)
	{
		if ($parametres == '') $parametres = "$identifiant_liste,$1";
		site_definit_page("blogable.$identifiant_liste", "$dossier_racine(.+)?", $module_client, NULL, $modele,NULL, $parametres,NULL,NULL,NULL,0,0,"page blogable pour la liste $identifiant_liste",0,1, NULL, NULL,$classe_php, '', 0, $use_stats);
	}
	
//	public static function ajouteArchivage($id_liste_blogable, $url_ajoute)
//	{
//		$datablog = array('url_archivage'=>$url_ajoute);
//		CListes::update('blogable', $datablog, "identifiant_liste ='$id_liste_blogable'");
//	}
	
	/**
	 * ajout la gestion des votes et/ou notes
	 * @param $identifiant_liste
	 * @param $accepte_note : true ou false
	 * @return void
	 */
	public static function ajouteVotes($identifiant_liste, $accepte_note)
	{
		$infos_liste = CListes::get_liste($identifiant_liste);
		$table = $infos_liste['table'];

		if ($accepte_note)
		{
			CListes::update('blogable', array('use_notes'=>1), "blog_identifiant_liste = '$identifiant_liste'");
			CListes::add_champ_liste($identifiant_liste, 'somme_notes', 'INT', 'somme_notes', 'somme_notes', 'somme des notes', NULL, NULL, "NOT NULL", 'hidden');
			CListes::insere('type_stats', array('table_upd'=>$table, 'colonne_upd'=>'somme_notes', 'colonne_where'=>'id_auto', 'identifiant'=>$identifiant_liste.'_NOTE', 'type'=>'CPT'), 'identifiant');
		}

		CListes::update('blogable', array('use_votes'=>1), "blog_identifiant_liste = '$identifiant_liste'");
		CListes::add_champ_liste($identifiant_liste, 'nb_votes', 'INT', 'nb_votes', 'nb_votes', 'nombre de votes recus', NULL, NULL, "NOT NULL", 'hidden');
		CListes::insere('type_stats', array('table_upd'=>$table, 'colonne_upd'=>'nb_votes', 'colonne_where'=>'id_auto', 'identifiant'=>$identifiant_liste.'_VOTE', 'type'=>'CPT'), 'identifiant');
		CListes::add_cle_index($identifiant_liste,'index_nb_votes', 'nb_votes');
	}

	/**
	 * ajoute la gestion des commentaires à une liste
	 * @param $identifiant_liste
	 * @return void
	 */
	public static function ajouteCommentaires($identifiant_liste)
	{
		CListes::update('blogable', array('use_commentaires'=>1), "blog_identifiant_liste = '$identifiant_liste'");
		CListes::add_liste2('blog_commentaire', 'blogable__commentaire', 'Commentaires', 'Commentaires sur une liste devenue blogable', 'commentaire','BLOGABLE');
		CListes::add_champ_liste('blog_commentaire', 'blog_identifiant_liste', 'VARCHAR(255)','identifiant_liste','identifiant_liste', 'identifiant texte de la liste dont un objet a été commenté');
		CListes::add_champ_liste('blog_commentaire', 'id_auto_elem', 'VARCHAR(255)','id_auto_elem','id_auto_elem', 'id_auto de lelement de la liste qui a été commenté');
		CListes::add_champ_liste('blog_commentaire', 'texte', 'TEXT','texte','texte', 'texte du commentaire', NULL, NULL, NULL, 'longtext');
		CListes::add_champ_liste('blog_commentaire', 'nom_prenom', 'VARCHAR(255)','nom_prenom','nom_prenom', 'nom et prenom de lauteur du commentaire');
		CListes::add_champ_liste('blog_commentaire', 'mail', 'VARCHAR(255)','mail','mail', 'mail de lauteur du commentaire');
		CListes::add_champ_liste("blog_commentaire", "ip", "VARCHAR(20)", 'ip','ip', 'ip de lauteur du commentaire', NULL, NULL, NULL, 'hidden');
		CListes::add_champ_liste("blog_commentaire", "actif", "BOOL", 'actif','actif', 'si le commentaire sera actif/visible');
		CListes::add_fn_transfo_champ('blog_commentaire','ip', 'base.CColonnes_auto.ip_client', true, false);
		CListes::add_champ_liste('blog_commentaire', 'date_crea', 'DATETIME', 'date_crea', 'date_crea', 'date de creation', NULL, NULL, NULL, 'hidden');
		CListes::add_fn_transfo_champ('blog_commentaire','date_crea', 'base.CColonnes_auto.today_date_heure', true, false);
		CListes::add_cle_unique("blog_commentaire","UNIQUE_comm", "blog_identifiant_liste, id_auto_elem, date_crea");
		CListes::add_cle_index('blog_commentaire','index_identifiant_liste', 'blog_identifiant_liste');
		CListes::add_cle_index('blog_commentaire','index_id_auto_elem', 'id_auto_elem');
		CListes::add_cle_index('blog_commentaire','index_date_crea', 'date_crea');


		$infos_liste = CListes::get_liste($identifiant_liste);
		$table = $infos_liste['table'];

		CListes::add_champ_liste($identifiant_liste, 'nb_commentaires', 'INT', 'nb_commentaires', 'nb_commentaires', 'nombre de commentaires recus', NULL, NULL, "NOT NULL", 'hidden');
		CListes::insere('type_stats', array('table_upd'=>$table, 'colonne_upd'=>'nb_commentaires', 'colonne_where'=>'id_auto', 'identifiant'=>$identifiant_liste.'_COMMENTAIRE', 'type'=>'CPT'), 'identifiant');

		CBlogableAffichages::ajouteTypeAffichageListe('blog_commentaire', 'blogbase', 'modules/blog/www/html/blocs/commentaire');
	}

	/**
	 * ajoute la gestion des tags à une liste
	 * @param $identifiant_liste
	 * @return void
	 */
	public static function ajouteTags($identifiant_liste)
	{
		CListes::update('blogable', array('use_tags'=>1), "blog_identifiant_liste = '$identifiant_liste'");
		CListes::add_liste2('blog_tag', 'blogable__tag', 'Tags', 'Tags disponibles pour les elements dune liste', 'tag','BLOGABLE');
		CListes::add_champ_liste('blog_tag', 'blog_identifiant_liste', 'VARCHAR(255)','identifiant_liste','identifiant_liste', 'identifiant texte de la liste concernée par ces tags', NULL, NULL, NULL, 'hidden');
		CListes::add_champ_liste('blog_tag', 'nom', 'VARCHAR(255)','nom','nom', 'nom du tag');
		CListes::add_champ_liste('blog_tag', 'nom_url', 'VARCHAR(255)','nom_url','nom_url', 'nom du tag dans url');
		CListes::add_cle_unique("blog_tag","UNIQUE_tagsliste", "blog_identifiant_liste, nom");
		CListes::add_cle_index('blog_tag','index_identifiant_liste', 'blog_identifiant_liste');
		CListes::add_cle_index('blog_tag','index_nom_url', 'nom_url');
		CListes::add_cle_index('blog_tag','index_nom', 'nom');

		CListes::add_liste2('blog_tags_elem', 'blogable__tags_elem', 'Tags', 'Tags sur les elements dune liste', 'tag','BLOGABLE');
		CListes::add_champ_liste('blog_tags_elem', 'blog_identifiant_liste', 'VARCHAR(255)','blog_identifiant_liste','blog_identifiant_liste', 'identifiant texte de la liste contenant cet elem');
		CListes::add_champ_liste('blog_tags_elem', 'id_auto_elem', 'INT','id_auto_elem','id_auto_elem', 'id_auto de lelem');
		//		CListes::add_champ_liste_etranger('blog_tags_elem', 'id_auto_elem', $table, 'id_auto', '#ID_AUTO#');
		CListes::add_champ_liste_etranger('blog_tags_elem', 'id_tag', 'blogable__tag', 'id_auto', '#NOM#','',true,'','', 'court');
		CListes::add_cle_unique("blog_tags_elem","UNIQUE_tagselemsliste", "blog_identifiant_liste, id_auto_elem, id_tag");
		CListes::add_cle_index('blog_tags_elem','index_identifiant_liste', 'blog_identifiant_liste');
		CListes::add_cle_index('blog_tags_elem','index_id_auto_elem', 'id_auto_elem');
		CListes::add_cle_index('blog_tags_elem','index_id_tag', 'id_tag');

		//pourquoi #TITRE# ? c'est pas plutot #NOM# ? -> j'ai mis #NOM#
		CListes::add_liste_etrangere($identifiant_liste, "blog_tags_elem", 1, 'direct','id_auto', 'id_auto_elem', '#NOM#', "blog_identifiant_liste = '$identifiant_liste'", json_encode(array("blog_identifiant_liste"=>$identifiant_liste)));
	}

	/**
	 * ajoute la gestion des catégories à une liste
	 * @param $identifiant_liste
	 * @param $cat_unique : par défaut true, si un élément est dans une seule catégorie ou plusieurs
	 * @return void
	 */
	public static function ajouteCategories($identifiant_liste, $cat_unique = true)
	{
		CListes::update('blogable', array('use_categories'=>1), "blog_identifiant_liste = '$identifiant_liste'");
		

		if(!self::$categories_crees) {
			self::$categories_crees = true;
			
			CListes::add_liste2('blog_categorie', 'blogable__categories', 'Categories', 'Categories disponibles pour les elements dune liste', 'categorie','BLOGABLE');
			CListes::add_champ_liste('blog_categorie', 'blog_identifiant_liste', 'VARCHAR(255)','blog_identifiant_liste','blog_identifiant_liste', 'identifiant texte de la liste concernée par ces tags',"(.+)", NULL, NULL, 'hidden');
			CListes::add_champ_liste('blog_categorie', 'nom', 'VARCHAR(255)','nom','nom', 'nom lisible de la categorie',"(.+)");
			CListes::add_champ_liste('blog_categorie', 'nom_url', 'VARCHAR(255)','nom_url','nom_url', 'nom en version url de la categorie',"(.+)");
			CListes::add_champ_liste('blog_categorie', 'position', 'SMALLINT','position','position', 'position de la categorie');
			CListes::add_cle_unique("blog_categorie","UNIQUE_categoriesliste", "blog_identifiant_liste, nom");
			CListes::add_cle_index('blog_categorie','index_identifiant_liste', 'blog_identifiant_liste');
			CListes::add_cle_index('blog_categorie','index_nom', 'nom');
			CListes::add_cle_index('blog_categorie','index_nom_url', 'nom_url');
		}

		if (!$cat_unique)
		{
		
			CListes::update('blogable', array('categorie_unique'=>0), "blog_identifiant_liste = '$identifiant_liste'");
			$infos_liste = CListes::get_liste($identifiant_liste);
			$table = $infos_liste['table'];
			CListes::add_liste2('blog_categories_elem', 'blogable__categories_elem', 'Categories', 'Categories sur les elements dune liste', 'categorie','BLOGABLE');
			CListes::add_champ_liste('blog_categories_elem', 'blog_identifiant_liste', 'VARCHAR(255)','blog_identifiant_liste','blogidentifiant_liste', 'identifiant texte de la liste contenant cet elem');
			//TODO ! la dessous, ca sert ou ca sert pas ?!
			//CListes::add_champ_liste_etranger('blog_categories_elem', 'id_auto_elem', $table, 'id_auto', '#ID_AUTO#');
			CListes::add_champ_liste_etranger('blog_categories_elem', 'id_categorie', 'blogable__categories', 'id_auto', '#NOM#','',true,'','', 'court');
			CListes::add_cle_unique("blog_categories_elem","UNIQUE_categorieselemsliste", "blog_identifiant_liste, id_auto_elem, id_categorie");
			CListes::add_cle_index('blog_categories_elem','index_identifiant_liste', 'blog_identifiant_liste');
		}
		else
		{
			CListes::update('blogable', array('categorie_unique'=>1), "blog_identifiant_liste = '$identifiant_liste'");
			CListes::add_champ_liste_etranger($identifiant_liste, 'id_categorie', 'blogable__categories', 'id_auto', '#NOM#',"blog_identifiant_liste = '$identifiant_liste'");
			CListes::add_description_champ($identifiant_liste,'id_categorie',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'blogable__categories','id_auto','#NOM#',"blog_identifiant_liste ='$identifiant_liste'","NULL DEFAULT NULL",NULL,NULL, "court");
		}
	}

	/**
	 * fixe l'url suivie lors d'un clic sur un tag
	 * @param $identifiant_liste
	 * @param $url
	 * @return boolean
	 */
	public static function setUrlTag($identifiant_liste, $url)
	{
		if (!testReq3("SELECT * FROM blogable__blog WHERE blog_identifiant_liste = '$identifiant_liste' AND url_tag = '$url'"))
		return ifReq("UPDATE blogable__blog SET url_tag = '$url' WHERE blog_identifiant_liste = '$identifiant_liste'");
		return false;
	}

	public static function ajouteClassement($identifiant_liste, $nom_classement, $nom_lisible, $url, $champ_url_liste_etr, $champ, $liste_etrangere, $est_principale, $url_elem_si_principale, $dossier_classement = '', $multiple = 0, $table_lien = '', $table_lien_champ = '', $titre_associe = '', $where_cle_etrangere = '',$multi_liste=0)
	{
		self::creeListeClassement();
		CListes::insere('blog_classement', array('blog_identifiant_liste'=>$identifiant_liste, 'id_classement'=>$nom_classement, 'nom_lisible'=>$nom_lisible, 'url'=>$url, 'champ_url_liste_etr'=>$champ_url_liste_etr, 'champ'=>$champ, 'liste_etrangere'=>$liste_etrangere, 'est_principale'=>$est_principale, 'url_elem_si_principale'=>$url_elem_si_principale, 'dossier_classement'=>$dossier_classement, 'multiple'=>$multiple, 'table_lien'=>$table_lien, 'table_lien_champ'=>$table_lien_champ,'multi_liste'=>$multi_liste), 'blog_identifiant_liste, id_classement');

		if ($multiple)
		{
			CListes::add_liste_etrangere($identifiant_liste, $liste_etrangere, 1, 'liste','id_auto', $table_lien_champ, $titre_associe, $where_cle_etrangere);
			// 'blogable__categories','id_auto','#NOM#',"identifiant_liste ='$identifiant_liste'"
		}
		else
		{
			$liste_etr = CListes::get_liste($liste_etrangere);
			CListes::add_description_champ($identifiant_liste,$champ,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,$liste_etr['table'],'id_auto',$titre_associe,NULL,NULL,NULL,NULL, "court");
		}
	}

	public static function ajouteClassementCategoriesAuto($identifiant_liste, $url, $est_principale, $url_elem_si_principale, $multiple)
	{
		self::creeListeClassement();
		CListes::insere('blog_classement', array('blog_identifiant_liste'=>$identifiant_liste, 'id_classement'=>'categories', 'nom_lisible'=>'catégorie', 'url'=>$url, 'champ_url_liste_etr'=>'nom_url', 'champ'=>'id_categorie', 'liste_etrangere'=>'blog_categorie', 'est_principale'=>$est_principale, 'url_elem_si_principale'=>$url_elem_si_principale, 'multiple'=>$multiple,'multi_liste'=>1), 'blog_identifiant_liste, id_classement');
	}

	public static function ajouteClassementTagsAuto($identifiant_liste)
	{
		self::creeListeClassement();
		CListes::insere('blog_classement', array('blog_identifiant_liste'=>$identifiant_liste, 'id_classement'=>'tags', 'nom_lisible'=>'tag', 'url'=>'/#NOM_URL#', 'champ_url_liste_etr'=>'nom_url', 'liste_etrangere'=>'blog_tag', 'est_principale'=>0, 'dossier_classement'=>'/tags', 'multiple'=>1, 'table_lien'=>'blogable__tags_elem', 'table_lien_champ'=>'id_tag','multi_liste'=>1), 'blog_identifiant_liste, id_classement');
	}

	private static function creeListeClassement()
	{
		CListes::add_liste2('blog_classement', 'blogable__classement', 'Classements', 'Classements (arborescence) disponibles pour les elements dune liste', 'classement','BLOGABLE');
		CListes::add_champ_liste('blog_classement', 'blog_identifiant_liste', 'VARCHAR(255)','blog_identifiant_liste','blog_identifiant_liste', 'identifiant texte de la liste concernée par ces tags', NULL,NULL,NULL,'hidden');
		CListes::add_champ_liste('blog_classement', 'id_classement', 'VARCHAR(255)','id_classement','id_classement', 'nom identifiant le classement');
		CListes::add_champ_liste('blog_classement', 'nom_lisible', 'VARCHAR(255)','nom_lisible','nom_lisible', 'nom lisible du classement (singulier)');
		CListes::add_champ_liste('blog_classement', 'url', 'VARCHAR(255)','url','url', 'url avec #VARIABLES# de elem dans ce classement sans la racine deja definie dans Blogable');
		CListes::add_champ_liste('blog_classement', 'champ', 'VARCHAR(255)','champ','champ', 'champ de la table de la liste qui contient  i de classement a relier avec la table etrangere');
		CListes::add_champ_liste('blog_classement', 'champ_url_liste_etr', 'VARCHAR(255)','champ_url_liste_etr','champ_url_liste_etr', 'champ du classement qui se retrouve dans url (souvent version sans # du champ url');
		CListes::add_champ_liste('blog_classement', 'liste_etrangere', 'VARCHAR(255)','liste_etrangere','liste_etrangere', 'liste etrangere contenant linfo (ex: nom dune categorie liee a un id_auto) sur lelement de classement');
		CListes::add_champ_liste("blog_classement", "est_principale", "BOOL","est_principale", "est_principale", "si ce classement forme lacces normal a un element");
		CListes::add_champ_liste("blog_classement", "multiple", "BOOL","multiple", "multiple", "si un elem se retrouve dans plusieurs valeurs possibles du classement (ex: une seule categorie ou plusieurs)");
		CListes::add_champ_liste("blog_classement", "url_elem_si_principale", "VARCHAR(255)","url_elem_si_principale", "url_elem_si_principale", "fin de lurl ajoutee au champ url pour acceder a un elem si ce classement est le principal");
		CListes::add_champ_liste("blog_classement", "dossier_classement", "VARCHAR(255)","dossier_classement", "dossier_classement", "si le classement a un dossier racine");
		CListes::add_champ_liste("blog_classement", "table_lien", "VARCHAR(255)","table_lien", "table_lien", "si le classement est multiple, la table qui relie les elems aux valeurs du classement");
		CListes::add_champ_liste("blog_classement", "table_lien_champ", "VARCHAR(255)","table_lien_champ", "table_lien_champ", "si le classement est multiple, le champ de table_lien qui rejoint le id_auto de liste_etrangere");
		CListes::add_champ_liste("blog_classement", "multi_liste", "BOOL","multi_liste", "multi_liste", "si le classement est associé à plusieurs listes, avec des valeurs distinctes selon la liste...");
		CListes::add_cle_unique("blog_classement","UNIQUE_classementsliste", "blog_identifiant_liste, id_classement");
		CListes::add_cle_index('blog_classement','index_identifiant_liste', 'blog_identifiant_liste');
		CListes::add_cle_index('blog_classement','index_url_elem_si_principale', 'url_elem_si_principale');
		CListes::add_cle_index('blog_classement','index_est_principale', 'est_principale');

	}

	/**
	 * retourne toutes les valeurs possibles du classement principal d'une liste, version générique de la fonction getCategories
	 * @param $identifiant_liste
	 * @return array
	 */
	public static function getValsClassements($identifiant_liste, $id_classement)
	{
		$class = CBlogable::getClassement($identifiant_liste, $id_classement);
//		echo "multi=".
		$liste_etr = CListes::get_liste($class['liste_etrangere']);
		$where_identifiant=$class['multi_liste']?"WHERE blog_identifiant_liste = '$identifiant_liste'":"";
		//echo "SELECT * FROM $liste_etr[table] $where_identifiant";
		return mysql_fetch_all(ifReq("SELECT * FROM $liste_etr[table] $where_identifiant"));
	}

	/**
	 * retourne toutes les catégories disponibles pour une liste
	 * @param $identifiant_liste
	 * @return array
	 */
	public static function getCategories($identifiant_liste)
	{
		return mysql_fetch_all(ifReq("SELECT * FROM blogable__categories WHERE blog_identifiant_liste = '$identifiant_liste'"));
	}

	/**
	 * retourne le classement principal vers l'elem de la liste blogable
	 * @param $identifiant_liste
	 * @return array
	 */
	public static function getClassementPrincipalToElem($identifiant_liste)
	{
		return testReq3("SELECT * FROM blogable__classement WHERE blog_identifiant_liste = '$identifiant_liste'
						 AND est_principale = 1 AND url_elem_si_principale != '' AND url_elem_si_principale IS NOT NULL");
	}

	/**
	 * retourne toutes les classements disponibles pour une liste blogable
	 * @param $identifiant_liste
	 * @return array
	 */
	public static function getClassements($identifiant_liste)
	{
		return mysql_fetch_all(ifReq("SELECT * FROM blogable__classement WHERE blog_identifiant_liste = '$identifiant_liste'"));
	}

	/**
	 * retourne les infos d'un classement d'une liste blogable
	 * @param $identifiant_liste
	 * @return array
	 */
	public static function getClassement($identifiant_liste, $id_class)
	{
		include_once("includes/general/optim_php.inc.php");

		if ($retour = get_optim_php("blog.class",$identifiant_liste.$id_class)) return $retour;
		$retour = testReq3("SELECT * FROM blogable__classement WHERE blog_identifiant_liste = '$identifiant_liste' AND id_classement = '$id_class'");
		set_optim_php("blog.class",$identifiant_liste.$id_class,$retour);
		return $retour;
	}

	/**
	 * retourne les infos sur la blogable liste
	 * @param $identifiant_liste
	 * @return array
	 */
	public static function getInfos($identifiant_liste)
	{
		include_once("includes/general/optim_php.inc.php");
		if ($retour = get_optim_php("blog.infos",$identifiant_liste)) return $retour;

		$retour = testReq3("SELECT * FROM blogable__blog WHERE blog_identifiant_liste = '$identifiant_liste'");
		set_optim_php("blog.infos",$identifiant_liste,$retour);
		return $retour;
	}
	
	public static function creeTableBlacklistWords()
	{
		CListes::add_liste2('blog_blacklist_words', 'blogable__blacklist_words', 'Blacklist mots', 'Mots interdits qui passeront un commentaire en spam', 'Mot interdit','BLOGABLE');
		CListes::add_champ_liste('blog_blacklist_words', 'mot', 'VARCHAR(255)','mot','mot', 'le mot interdit');
		
	}
	public static function creeTableBlacklistIPs()
	{
		CListes::add_liste2('blog_blacklist_ips', 'blogable__blacklist_ips', 'Blacklist ips', 'IPs interdites pour les commentaires', 'IP interdite','BLOGABLE');
		CListes::add_champ_liste('blog_blacklist_ips', 'ip', 'VARCHAR(15)','ip','ip', 'ip interdite');
	}
	public static function creePageActivationComms()
	{
		//function site_definit_modele_page($identifiant_modele,$id_module,$fichier,$fichier_css,$priorite=0, $rootmodele = NULL)
		site_definit_modele_page("BLOG_vide","blog","modeles/blog_vide.modele.htm","style.css",10,"modeles/blog_vide.rootmodele.htm");
		//function        $identifiant,      $str_masque,				$id_module,$fichier,$id_modele=NULL,$fonction=NULL,$str_params=NULL,$identifiant_droit=NULL,$redirige_NOK=NULL,$redirige_OK=NULL,$priorite=NULL,$continue=NULL,$commentaires="",$id_parent=NULL,$actif = NULL, $date_debut = NULL, $date_fin = NULL,$classe_php='',$robots='',$is_flash=0) {
		site_definit_page('activationComms','/blogadmin/validcomm.htm', 'blog', NULL, 		'BLOG_vide', 	NULL, 			'',				NULL,					NULL,			   NULL,			 NULL,			NULL,			'',				NULL,			1,			NULL,NULL,								'CPageValidationComm');
		
	}
}


?>