<?php
class Hebergements extends Model{
	
	public $id;
	public $designation;
	public $fournisseur;
	public $date;
	public $date_valid;
	public $montant_ht;
	public $commentaires;
        public $actif;
	public $id_client;
	public $id_type;
	
	public $qte = 1;
	
	public $client;
	
	public $relances = array();
	
	public function __construct(){
		parent::__construct('hebergements');
	}
	
	
	public function __toString(){
		return $this->designation;
	}
	
	public function preSave(){
		
		if($this->id == "") 
			$this->date = date('Y-m-d');
			
		if($this->id == "" && ($this->date_valid == "" || $this->date_valid == '0000-00-00'))
			$this->date_valid = date('Y-m-d');	
		
	}
	
	public function getType(){
		$h_t = new Hebergement_type();
		$h_t = $h_t->findOneBy('id',$this->id_type);

		return $h_t;
	}
	
	public function getClient(){
		if(empty($this->client)){
			$c = new Clients();
			$c = $c->findOneBy('id',$this->id_client);

			$this->client = $c;
			
			return $c;
		}
		else{
			return $this->client;
		}
	}
	
	public function getRelances(){
		if(empty($this->relances)){
			$q =  new QueryBuilder('relances');
			
			$q->select('R.*')
				->from("relances R")
				->join("INNER JOIN join_relances_hebergements J ON J.id_relances = R.id")
				->join("INNER JOIN hebergements H ON H.id = J.id_hebergements")
				->where('H.id = ? ', $this->id);

			$r = $q->executeQuery();
				
			$this->relances = $r;
				
			return $r;
		}
		else{
			return $this->relances;
		}
	}
	
	public function getLastRelanceValide(){
		$q = new QueryBuilder('relances');
		$q ->select('R.*, (to_days(curdate())-to_days(R.date)) as jours_depuis')
			->from('relances R')
			->join("INNER JOIN join_relances_hebergements J ON J.id_relances = R.id")
			->join("INNER JOIN hebergements H ON H.id = J.id_hebergements")
			->where('H.id = ? ', $this->id)
			->orderBy('date','DESC')
			->limit(1);
			
		return $q->executeQuery('object');
	}
	
	public function getDureeRestante(){
		$q = new QueryBuilder("hebergements");
		
		$q->select("(to_days(H.date_valid)-to_days(curdate())) as jours_restants")
		  ->from("hebergements H")
		  ->where("H.id = ? ", $this->id);
		
		$r = $q->executeQuery('object'); 

		return $this->merge($r,$this);
//		return $this;
	}
	
	public function getEtat(){
		
		if($this->jours_restants <= 0)
			return 'rouge';
		if($this->jours_restants < 14)
			return 'orange';
		if($this->jours_restants <= 30)
			return 'jaune';
		if($this->jours_restants > 30)
			return 'vert';
	}
	
	public function addCronRelance($hebergements = null){
//		print_r_html($hebergements);
		$titre = "";
		if($hebergements != null){
			$total = 0;
			foreach($hebergements as $h){
				echo 'Montant hébergement : '. $h->montant_ht.'<br/>';
				
				$total = $total + $h->montant_ht;
				$titre .= $h->designation.' ';
			}
		}
		else{
			$total = $this->montant_ht;
			$titre = $this->designation;
		}
		
		if($this->total != $total){
			new Alert('Le montant de la facture a évolué depuis la dernière fois');
		}

		$relance = new Relances();
		$relance->num = '-';
		$relance->titre = $titre;
		$relance->total = $total;
		$relance->etat = 'c';
		$relance->date = date('Y-m-d');
		$relance->id_intitule_entete = 3;
		$relance->id_client = $this->id_client;
		
		return $relance;
	}
        
        public static function getTotal(){
            
            $q = new QueryBuilder('hebergements');
            
            $q->select('H.montant_ht')
              ->from('hebergements H')
              ->where('H.actif = ?',1);
            
            $hs = $q->executeQuery();
            
            $total = 0;
            foreach($hs as $h){
                $total = $total + $h->montant_ht;
            }
            
            return $total;
            
        }
		
		public static function getTotalImpaye(){
            
            $q = new QueryBuilder('hebergements');
            
            $q->select('H.montant_ht')
              ->from('hebergements H')
			  ->join('INNER JOIN clients C ON H.id_client = C.id')
			  ->join('INNER JOIN relances R ON C.id = R.id_client')
			  ->where('R.etat NOT IN("t")')
              ->where('H.actif = ?',1);
            
            $hs = $q->executeQuery();
            
            $total = 0;
            foreach($hs as $h){
                $total = $total + $h->montant_ht;
            }
            
            return $total;
            
        }
        
        public function findActif($field, $value = NULL){
                $q = new QueryBuilder('hebergements');
		$q->select()
		  ->from('hebergements H')
                  ->where('H.actif = ?',1);
		  
		if(!is_array($field) && $value != NULL){  
		  $q ->andWhere($field. " = ?", $value);
		}  
		else if(is_array($field)){
			foreach($field as $f => $v){
				$q->andWhere($f. "  = ?", $v);
			}
		} 
	
//		$q->displayQuery = true;
		
		$r =  $q->executeQuery();	
		
		return $r ;
        }
	
	
	public function findAllForFormValid($id,$name,$id_client,$selectHebergements = ""){
		$q =  new QueryBuilder('hebergements');
		
		$q->select()
			->from('hebergements H')
			->where('(to_days(H.date_valid)-to_days(curdate())) < ?', 60)
			->andWhere('H.id_client = ?', $id_client)
                        ->andWhere('H.actif = ?', 1);
			
			
			
			
			
		if($selectHebergements != ""){
			foreach($selectHebergements as $h){
				$q->andWhere(' H.id != ? ', $h->id);
			}
		}  
		
//		$q->displayQuery = true;
		
		$obj = $q->executeQuery();

//		print_r_html($obj);
		
		$select['0'] = '--';
		foreach($obj as $s_obj){
			$select[$s_obj->$id] = $s_obj->$name;
		}
		
		return $select;
		
	}
	
	public function findWithQte($field, $value, $ref_h){
		$q = new QueryBuilder('hebergements');
		
		$q->select('H.*, (to_days(H.date_valid)-to_days("'.$ref_h->date_valid.'")) as jours_decalages')
			->from('hebergements H');
			
		$q->andWhere($field.' = ?', $value);	
		
		$obj = $q->executeQuery('object');
                
		$ratio = (365 - $obj->jours_decalages) / 365;
		$obj->qte = $ratio;
		
		return $obj;
	}

	
//	public function addRelance($pRelance){
//		
//		$relance = new Relances();
//		$relance->titre = $pRelance->titre; //Prévoir un compteur dans le titre des relances, par rapport aux ancienne
//		$relance->total = $pRelance->total;
//		$relance->id_intitule_entete = 3;
//		$relance->id_client = $this->id_client;
//		
//		//Need pour le récap mail
//		$relance->jours_restants = $this->jours_restants;
//		
//		$relance->save();
//		
//		$relance->id = $relance->getLastInsertId();
//		
//		$relance->JoinWithHebergement($this->id);
//		$relance->addElems();
//		
//		array_push($this->relances,$relance);
//		
//		$pdf = $this->createPDF($relance);
//		
//		return $relance;
//		
//		
//	}
	
	
	
}

?>