<?php
class CGestionnaireCache {
	private $identifiant ;
	private $type ;
	private $contenu = "";
	private $obj_contenu = null;
	public $secure = false;
	public $CLE_SECURE = "CLE_SEcureCache09!";
	private $is_contenu_objet = false;
	private $contenu_str = false;
	private $a_jour = false;
	private $locked = false;
	private $id_auto = -1;
	/** en secondes */
	public $duree_validite = 60; // secondes
	public $duree_lock = 5; // secondes
	
	public static function reset_cache() {
		ifReq("TRUNCATE TABLE `base__cache`");
	}
	public function CGestionnaireCache($type,$identifiant="") {
		$this->type = $type;
		$this->identifiant = $identifiant;
		$this->load();
	}

	public function write($str) {
		if($this->is_contenu_objet) throw new Exception("CGestionnaireCache Error : tentative de sauvegarde d'un String alors qu'on a deja du Object");
		$this->contenu .= $str;
	}

	public function write_obj($obj) {
		if($this->contenu_str) throw new Exception("CGestionnaireCache Error : tentative de sauvegarde d'un Object alors qu'on a deja du String");
		if($this->is_contenu_objet) throw new Exception("CGestionnaireCache Error : tentative de sauvegarde d'un 2eme Object");
		$this->contenu = serialize($obj);
		$this->obj_contenu = $obj;
		$this->is_contenu_objet = true;
	}

	public function out() {
		return $this->contenu;
	}
	public function out_obj() {
		if($this->obj_contenu) return $this->obj_contenu;
		$this->obj_contenu = unserialize($this->contenu);
		return $this->obj_contenu;
	}

	public function load() {
		if (FORCE_NO_CACHE === true) return false;
		// 1 - si le cache n'existe pas, on le crée, en lock
		$now=time();
		if($res=testReq3("SELECT id_auto,locked,date_lock,contenu,date_valid FROM base__cache WHERE type='$this->type' AND identifiant='$this->identifiant'")) {
			// on l'a en BDD
			if($res["locked"]) {
				$this->a_jour = false; // on la recalculera
				if($res["date_lock"]+$this->duree_lock > $now) {
					// lock en cours de validite
					$this->locked = true; // on ne sauvera pas
				} else {
					//un lock trop vieux pour etre vrai
					if(ifReq("UPDATE base__cache SET locked=1 , date_lock=$now WHERE type='$this->type' AND identifiant='$this->identifiant'")) {
						$this->a_jour = false; // on la recalculera
					}
				}
			} else if($res["date_valid"]>$now) {
				$this->contenu = $res["contenu"]; // on recup le contenu
				$this->a_jour = true; // on ne recalculera pas
			} else {
				if(ifReq("UPDATE base__cache SET locked=1 , date_lock=$now WHERE type='$this->type' AND identifiant='$this->identifiant'")) {
					$this->a_jour = false; // on la recalculera
				}
			}
			$this->id_auto = $res["id_auto"];
		} else {

			if(ifReq("INSERT INTO base__cache SET type='$this->type' , identifiant='$this->identifiant',date_creation=$now,date_lock=$now,locked=1")) {
				$this->id_auto = mysql_insert_id();
			}
		}
		// si pas de id_auto, soucis ??
		return $this->a_jour;
	}

	public function est_a_jour() {
		return $this->a_jour;
	}

	public function save() {
		if (FORCE_NO_CACHE === true) return;
		if(!$this->locked) {
			$str_sauve = $this->contenu;
			if($this->secure) {
				//include_once 'includes/general/FroggCrypt.class.php';//auto
				$crypteur = new FroggCrypt($this->CLE_SECURE);
				$str_sauve = $crypteur->encode($str_sauve);
			}
			$now=time();
			$valid = $now+$this->duree_validite;
			if($this->id_auto) {
				if(ifReq("UPDATE base__cache SET date_creation=$now ,date_lock=0,locked=0, date_valid=$valid , contenu='".mysql_real_escape_string($str_sauve)."' WHERE id_auto=$this->id_auto")) {
					return true;
				} else {
					echo mysql_error();
				}
			} else {
				if(ifReq("INSERT INTO base__cache SET type='$this->type' , identifiant='$this->identifiant',date_creation=$now,date_lock=0,locked=0, date_valid=$valid , contenu='".mysql_real_escape_string($str_sauve)."'")) {
					return true;
				} else {
					echo mysql_error();
				}
			}
			throw new Exception("CGestionnaireCache Error : sauvegarde échouée");
		}
		
		//echo "SAUVE $str_sauve";

	}

}
?>