<?php
class Ticket {
	const STATUT_TICKET_ABANDONNE 	= '0';
	const STATUT_TICKET_FERME 		= '10';
	const STATUT_TICKET_RESOLU 		= '15';
	const STATUT_TICKET_NOUVEAU 	= '20';
	const STATUT_TICKET_QUESTION 	= '23';
	const STATUT_TICKET_REPONDU 	= '25';
	const STATUT_TICKET_EN_COURS 	= '30';
	const STATUT_TICKET_RENVOYE 	= '35';
	
	const STATUT_AUTO_TODO 			= '10';
	
	public static $tabPriorites = array(
		0 => array('lvl-priorite'=>'0', 'color-priorite'=>'#FFE9E9', 'txt-priorite'=>'Si on a le temps'),
		1 => array('lvl-priorite'=>'5', 'color-priorite'=>'#FFE9E9', 'txt-priorite'=>'Basse'),
		2 => array('lvl-priorite'=>'10', 'color-priorite'=>'#FFA4A4', 'txt-priorite'=>'Normale'),
		3 => array('lvl-priorite'=>'30', 'color-priorite'=>'#FF5E5E', 'txt-priorite'=>'Urgente'),
		4 => array('lvl-priorite'=>'40', 'color-priorite'=>'#FD3B3B', 'txt-priorite'=>'Critique'));
	
	public static $tabStatuts = array(
		0 => array('lvl-statut'=>self :: STATUT_TICKET_NOUVEAU, 'color-statut'=>'#', 'txt-statut'=>'Nouveau'),
		1 => array('lvl-statut'=>self :: STATUT_TICKET_QUESTION, 'color-statut'=>'#', 'txt-statut'=>'Question'),
		2 => array('lvl-statut'=>self :: STATUT_TICKET_REPONDU, 'color-statut'=>'#', 'txt-statut'=>'Répondu'),
		3 => array('lvl-statut'=>self :: STATUT_TICKET_EN_COURS, 'color-statut'=>'#', 'txt-statut'=>'En cours'),
		4 => array('lvl-statut'=>self :: STATUT_TICKET_RENVOYE, 'color-statut'=>'#', 'txt-statut'=>'Renvoyé'),
		5 => array('lvl-statut'=>self :: STATUT_TICKET_RESOLU, 'color-statut'=>'#', 'txt-statut'=>'Résolu'),
		6 => array('lvl-statut'=>self :: STATUT_TICKET_FERME, 'color-statut'=>'#', 'txt-statut'=>'Fermé'),
		7 => array('lvl-statut'=>self :: STATUT_TICKET_ABANDONNE, 'color-statut'=>'#', 'txt-statut'=>'Abandonné'));
	
	public static $tabStatutsAuto = array(
		array('index-statut-auto' => self :: STATUT_AUTO_TODO, 'tab-lvls-statut-auto'=>array(self :: STATUT_TICKET_NOUVEAU, self :: STATUT_TICKET_QUESTION, self :: STATUT_TICKET_REPONDU, self :: STATUT_TICKET_EN_COURS, self :: STATUT_TICKET_RENVOYE), 'color-statut-auto'=>'#009DDC', 'txt-statut-auto'=>'TODO'),
		array('index-statut-auto' => '20', 'tab-lvls-statut-auto'=>array(self :: STATUT_TICKET_RESOLU), 'color-statut-auto'=>'#009900', 'txt-statut-auto'=>'A vérifier'),
		array('index-statut-auto' => '25', 'tab-lvls-statut-auto'=>array(self :: STATUT_TICKET_RESOLU,self :: STATUT_TICKET_FERME), 'color-statut-auto'=>'#000099', 'txt-statut-auto'=>'terminés'),
		array('index-statut-auto' => '0', 'tab-lvls-statut-auto'=>array(), 'color-statut-auto'=>'#212121', 'txt-statut-auto'=>'Clear')
	);
	
	public function __construct() {
		
	}
	
	public static function creerNouveau($idCreateur, $idUserAssigne, $idTache, $idPriorite, $idStatut, $titreTicket, $commentaireTicket) {
		if(is_numeric($idCreateur) && is_numeric($idUserAssigne) && is_numeric($idTache) && 
				is_numeric($idStatut) && is_numeric($idPriorite)) {
			$titreTicket 		= mysql_real_escape_string($titreTicket);
			$commentaireTicket 	= mysql_real_escape_string($commentaireTicket);
			
			
			$reqInsertNouv = "
				INSERT INTO wrk_tickets 
					(id_user_ajoute, id_user_attribue, id_tache, priorite, statut, titre, commentaire) 
				VALUE 
					($idCreateur, $idUserAssigne, $idTache, $idPriorite, $idStatut, '$titreTicket', '$commentaireTicket') ";
			
			$retReqInsertNouv = bdd :: exec($reqInsertNouv);
			if($retReqInsertNouv) return mysql_insert_id();
		}
		
		return false;
	}
	
	public static function updateTicket($idTicket, $idUserAssigne, $idTache, $idPriorite, $idStatut, $titreTicket, $commentaireTicket) {
		if(is_numeric($idTicket) && is_numeric($idUserAssigne) && is_numeric($idTache) &&
				is_numeric($idStatut) && is_numeric($idPriorite)) {
			$titreTicket 		= mysql_real_escape_string($titreTicket);
			$commentaireTicket 	= mysql_real_escape_string($commentaireTicket);
			
			$reqUpTicket = "
				UPDATE wrk_tickets 
				SET 
					id_user_attribue = $idUserAssigne, id_tache = $idTache, priorite = $idPriorite, statut = $idStatut, titre = '$titreTicket', commentaire = '$commentaireTicket' 
				WHERE id = $idTicket";
			return bdd :: exec($reqUpTicket);
		}
		
		return false;
	}
	
	public static function getUserTicketsOrderedByClientId($idUser = 0, $orderedByClient = true, $whereSupp = null) {
		$where = "";
		if(is_numeric($idUser) && $idUser != 0) 
			$where = "WHERE (id_user_attribue = $idUser OR (id_user_ajoute = $idUser AND statut = ".self :: STATUT_TICKET_QUESTION."))";
		
		if(!is_null($whereSupp) && $whereSupp != "") 
			$where .= ($where != "") ? " AND $whereSupp" : "WHERE $whereSupp";
		
		$reqGetUserTickets  = "
			SELECT w_tickets.*, 
				w_u_ajoute.nom AS nom_user_ajoute, 
				w_u_attribue.nom AS nom_user_attribue, w_u_attribue.couleur AS couleur_user_attribue, 
				w_taches.nom AS nom_tache,
				w_lots.nom AS nom_lot,
				w_clients.nom AS nom_client, w_clients.id AS id_client, w_clients.couleur AS couleur_client,
				w_lots.comptabilise AS lot_comptabilise
			FROM wrk_tickets as w_tickets
				LEFT JOIN wrk_users AS w_u_ajoute 
					ON w_tickets.id_user_ajoute = w_u_ajoute.id
				LEFT JOIN wrk_users AS w_u_attribue 
					ON w_tickets.id_user_attribue = w_u_attribue.id
				INNER JOIN wrk_taches AS w_taches
					ON w_tickets.id_tache = w_taches.id
				INNER JOIN wrk_lots AS w_lots
					ON w_taches.id_lot = w_lots.id
				INNER JOIN wrk_clients AS w_clients
					ON w_lots.id_client = w_clients.id
			$where
			ORDER BY w_tickets.priorite DESC";
		
		$tabOrderedUserTicketsByClient = array();
		
		if($tabUnorderedUserTickets = bdd :: getResults($reqGetUserTickets)) {
		
			if($orderedByClient == true) {
				foreach($tabUnorderedUserTickets as $ticketClient) {
					$tabOrderedUserTicketsByClient[$ticketClient['id_client']]['tickets_client'][] 	= $ticketClient;
					$tabOrderedUserTicketsByClient[$ticketClient['id_client']]['nom_client'] 		= $ticketClient['nom_client'];
					$tabOrderedUserTicketsByClient[$ticketClient['id_client']]['couleur_client'] 	= $ticketClient['couleur_client'];
					$tabOrderedUserTicketsByClient[$ticketClient['id_client']]['id_client'] 		= $ticketClient['id_client'];
				}
			} else {
				$tabOrderedUserTicketsByClient = $tabUnorderedUserTickets;
			}
			
			return $tabOrderedUserTicketsByClient;
		}
		
		return $tabOrderedUserTicketsByClient;
	}
	
	public static function getTicketInfos($idTicket) {
		if(is_numeric($idTicket)) {
			$reqInfosTicket = "SELECT * FROM wrk_tickets WHERE id = $idTicket";
			return bdd :: getResult($reqInfosTicket);
		}
		
		return false;
	}
	
	public static function getTicketInfosCompletes($idTicket, $sctrict = false) {
		if($sctrict) {
			$reqGetInfosTicket  = "
			SELECT w_tickets.titre, w_tickets.commentaire, w_tickets.priorite, w_tickets.statut, 
				w_u_ajoute.nom AS nom_user_ajoute, 
				w_u_attribue.nom AS nom_user_attribue, 
				w_taches.nom AS nom_tache, 
				w_lots.nom AS nom_lot,
				w_clients.nom AS nom_client, w_clients.couleur AS couleur_client";
		} else {
			$reqGetInfosTicket  = "
			SELECT w_tickets.*,
				w_u_ajoute.nom AS nom_user_ajoute, w_u_ajoute.email as email_user_ajoute, 
				w_u_attribue.nom AS nom_user_attribue, w_u_attribue.couleur AS couleur_user_attribue, w_u_attribue.email as email_user_attribue, 
				w_taches.nom AS nom_tache, w_taches.id AS id_tache, 
				w_lots.nom AS nom_lot, w_lots.id AS id_lot,
				w_clients.nom AS nom_client, w_clients.id AS id_client, w_clients.id AS id_client, w_clients.couleur AS couleur_client";
		}
		
		$reqGetInfosTicket  .= "
			FROM wrk_tickets as w_tickets
				LEFT JOIN wrk_users AS w_u_ajoute
					ON w_tickets.id_user_ajoute = w_u_ajoute.id
				LEFT JOIN wrk_users AS w_u_attribue
					ON w_tickets.id_user_attribue = w_u_attribue.id
				INNER JOIN wrk_taches AS w_taches
					ON w_tickets.id_tache = w_taches.id
				INNER JOIN wrk_lots AS w_lots
					ON w_taches.id_lot = w_lots.id
				INNER JOIN wrk_clients AS w_clients
					ON w_lots.id_client = w_clients.id
			WHERE w_tickets.id = $idTicket";
		
		$tabInfosTicket = bdd :: getResult($reqGetInfosTicket);
		return $tabInfosTicket;
	}
	
	public static function getTicketChangeLog($idTicket) {
		if(is_numeric($idTicket)) {
			$reqGetChangeLog = "
				SELECT * FROM wrk_tickets_changelog WHERE id_ticket = $idTicket ORDER BY date_ajout ASC";
			return bdd :: getResults($reqGetChangeLog);
		}
		
		return false;
	}
	
	public static function saveNewTicketLog($idTicket, $idUser, $Desc, $typeLog = '0') {
		if(is_numeric($idTicket) && is_numeric($idUser) && is_numeric($typeLog)) {
			if(is_array($Desc) && count($Desc) > 0)
				$Desc = implode('<br/>', $Desc);
			else 
				$Desc = mysql_real_escape_string($Desc);
			
			$reqInsertNewLog = "
				INSERT INTO wrk_tickets_changelog
					(id_ticket, id_user, description, type, date_ajout)
				VALUES
					($idTicket, $idUser, '$Desc', $typeLog, NOW())";
			
			return bdd :: exec($reqInsertNewLog);
		}
		
		return false;
	}
	
	public static function changeTicketStatut($idTicket, $statut, $memorizeInLog = false) {
		$retReqChangeStatut = "";
		$oldTicket = self :: getTicketInfosCompletes($idTicket, true);
		
		if(is_numeric($idTicket) && is_numeric($statut)) {
			if($statut == 2)
				$setDateOuverture = ', date_ouverture = NOW()';
			$reqChangeStatutTicket = "UPDATE wrk_tickets SET statut = $statut $setDateOuverture WHERE id = $idTicket";
			$retReqChangeStatut = bdd :: exec($reqChangeStatutTicket);
			
			// On enregistre le changement de statut, seulement si le statut change.
			if($retReqChangeStatut && $statut != $oldTicket['statut'] && $memorizeInLog) {
				$txtNewLog = '<span class="lbl-champs-change">Statut</span> changé de <span>'.mysql_real_escape_string(self :: getInfosStatut($oldTicket['statut'], 'txt')).'</span> à <span>'.mysql_real_escape_string(self :: getInfosStatut($statut, 'txt')).'</span>';
				$retReqChangeStatut = Ticket :: saveNewTicketLog($idTicket, Identification :: getId(), $txtNewLog);
			}
		}
		
		return $retReqChangeStatut;
	}
	
	public static function changeTicketAssignedUser($idTicket, $idUser) {
		$retReqChangeUser = '';
		
		if(is_numeric($idTicket) && is_numeric($idUser)) {
			$reqChangeAssUserTicket = "UPDATE wrk_tickets SET id_user_attribue = $idUser WHERE id = $idTicket";
			$retReqChangeUser = bdd :: exec($reqChangeAssUserTicket);
		}
		
		return $retReqChangeUser;
	}
	
	public static function associerTicketATravail($idTicket, $idTravail) {
		if(is_numeric($idTicket) && is_numeric($idTravail)) {
			$tickAlreadyInTrav = bdd :: getResult("SELECT COUNT(*) AS presence_liaison FROM wrk_liens_tickets_travail WHERE id_ticket = $idTicket AND id_travail = $idTravail");
			
			if($tickAlreadyInTrav['presence_liaison'] < 1) {
				$reqInsertAssocTickTrav = "
					INSERT INTO wrk_liens_tickets_travail 
						(id_ticket, id_travail) 
					VALUES 
						($idTicket, $idTravail)";
				bdd :: exec($reqInsertAssocTickTrav);
				
				return mysql_insert_id();
			} else {
				return true;	// On retourne true, la liaison est seulement déjà existante.
			}
		}
		
		return false;
	}
	
	public static function associerLiveTicketsATravail($idTravail, $tabTickets) {
		$retour = false;
		foreach($tabTickets as $ticketToSave) {
			$retour = self :: associerTicketATravail($ticketToSave, $idTravail);
		}
		
		return $retour;
	}
	
// 	public static function saveTicketIntoLive(&$live) {
// 		if(is_object($live)) {
// 			$live -> tickets[$_REQUEST['idTicket']]['id'] = $_REQUEST['idTicket'];
// 			$live -> tickets[$_REQUEST['idTicket']]['statut'] = $_REQUEST['idStatut'];
// 			$live -> ticket_en_cours = $_REQUEST['idTicket'];
// 		}
		
// 		return false;
// 	}
	
	public static function getTxtPriorite($lvlPriorite) {
		foreach(self :: $tabPriorites as $priorite) {
			if($priorite['lvl-priorite'] == $lvlPriorite)
				return $priorite['txt-priorite'];
		}
			
		return false;
	}
	
	public static function getInfosPriorite($lvlPriorite, $lblInfo) {
		foreach(self :: $tabPriorites as $priorite) {
			if($priorite['lvl-priorite'] == $lvlPriorite)
				return $priorite[$lblInfo.'-priorite'];
		}
			
		return false;
	}
	
	public static function getInfosStatut($lvlStatut, $lblInfo) {
		foreach(self :: $tabStatuts as $statut) {
			if($statut['lvl-statut'] == $lvlStatut)
				return $statut[$lblInfo.'-statut'];
		}
			
		return false;
	}
	
	public static function getTxtStatut($lvlStatut) {
		foreach(self :: $tabStatuts as $statut) {
			if($statut['lvl-statut'] == $lvlStatut)
				return $statut['txt-statut'];
		}
			
		return false;
	}
	
	
	public static function getInfosStatutAuto($indexStatut, $lblInfo) {
		foreach(self :: $tabStatutsAuto as $statutAuto) {
			if($statutAuto['index-statut-auto'] == $indexStatut)
				return $statutAuto[$lblInfo.'-statut-auto'];
		}
		
		return false;
	}
	
	public static function descriptionToHtml($desc) {
		$desc = preg_replace('/\[(http[^]]+)\]/i', "<a href='$1' target='_blank'><img class='img-desc' src='$1' /></a>", $desc);
		return stripslashes(nl2br($desc));
	}
}