<?php
	/**
	 * renvoie la variable telle qu'elle doit �tre ins�r�e dans un script PHP
	 *
	 * @param number/string/boolean $val
	 * @return string
	 */
	function varToPhpvar($val) {
		if($val===true) return "true";
		else if($val===false) return "false";
		else if($val==="$val") return "\"".str_replace("\"","\\\"",$val)."\"";
		else return $val;
	}
	function ini_set_client($variable,$valeur,$rajoute_si_manque=true) {
		ini_set_specifique($variable,$valeur,REP_CLIENT."includes/constantes.inc.php",$rajoute_si_manque);
	}
	function ini_unset_client($variable) {
		ini_unset_specifique($variable,REP_CLIENT."includes/constantes.inc.php");
	}
	
	
	function ini_unset_specifique($variable,$fichier) {
		ini_set_specifique($variable,"suppression de la constante",$fichier,false);
	}
	function ini_set_specifique($variable,$v_valeur,$fichier,$rajoute_si_manque=true) {
		//print("ini_set_specifique($variable,$valeur,$fichier,$rajoute_si_manque) {");
		$mode_efface=($v_valeur==="suppression de la constante");
		if(file_exists($fichier)) {
			$f=fopen($fichier,"r",true);
			include_once($fichier);
		}
		if(defined($variable) && (constant($variable)===$v_valeur)) {
			// print("pas de changement");
			return;
		}
		
		$valeur=varToPhpvar($v_valeur);
		$contenu=array();
		$contenu_old=array();
		$trouve=false;
		$php_ouvert=false;
		$lignes_rajouter="";
		$modif=false;
		if($f) {
			while($ligne=fgets($f)) {
				$ligne_rajoutee=false;
				if(strpos($ligne,"<?php")!==false) {
					$php_ouvert=true;
				} else if(strpos($ligne,"?>")!==false) {
					// on arrive en fin de fichier.
					if(!$trouve && $rajoute_si_manque && !$mode_efface) {
						// on n'avait pas trouv�, alors on rajoute
						$ligne="define(\"$variable\",$valeur);\n".$ligne;
						define($variable,$v_valeur); // pour le cas ou le script sera re-appelé dans le meme script php
						$ligne_rajoutee=true;
						$contenu[]=$ligne;
						$modif=true;
					}
				}
				if(!$ligne_rajoutee) {;
				
					$cherche="define(\"$variable\",";
					if(($pos=strpos($ligne,$cherche))!==false) {
						$trouve=true;
						$deb=$pos+strlen($cherche);
						$fin=strpos($ligne,");",$deb);
						$old_val=substr($ligne,$deb,$fin-$deb);
						$contenu_old[]=$ligne;
						if(!$mode_efface) {
							// c'est la ligne recherchée, on la garde si on est pas en mode "effacement"
							$new_ligne=str_replace(",$old_val)",",$valeur)",$ligne);
							if($new_ligne!=$ligne) {
								$modif=true;
							}
							$contenu[]=$new_ligne;
						} else {
							$modif=true;
						}
					} else {
						// ce n'est pas la ligne recherchée, on la garde pour la prochaine fois
						$contenu_old[]=$ligne;
						$contenu[]=$ligne;
					}
				}
				
			}
			fclose($f);
		} 
//		print_rr($contenu_old);
		if($rajoute_si_manque && (!$php_ouvert)){
			$contenu=array("<?php\n//Fichier de constantes, créé automatiquement. \n //Toute modification manuelle risque d'être effacée\n\n");
			$contenu[]="define(\"$variable\",$valeur);".$ligne."\n";
			$contenu[]="?>";
			$modif=true;
		}
		$include_path="";
		creeRepSiExistePas($include_path.$fichier);
		if($trouve || $rajoute_si_manque) {	
			$f2=fopen($include_path.$fichier.".old","w");
			$f3=fopen($include_path.$fichier.".histo","a");
			fputs($f3,"-------------------------\n");
			fputs($f3,"- avant changement ".date("Y-m-d H:i:s")."\n");
			fputs($f3,"-------------------------\n");
			foreach($contenu_old as $ligne) {
				fputs($f2,$ligne);
				fputs($f3,$ligne);
			}
			fputs($f3,"\n\n");
			fclose($f2);
			fclose($f3);
			/*
			 * fichier d�finitif
			 */
		}
		if($trouve || $rajoute_si_manque) {
			$f2=fopen($include_path.$fichier,"w");
			foreach($contenu as $ligne) {
				fputs($f2,$ligne);
				//print("<br>--".htmlentities($ligne));
			}
			fclose($f2);
		}
		
	}
?>