<?php
//include_once 'modules/listes/classes/CAffichageListe.class.php';//auto
//include_once 'modules/blog/classes/pages/CPageBlogableEtr.class.php';//auto
//include_once 'modules/listes/classes/CTypeAffichage.class.php';//auto
include_once 'modules/stats/services_flash/SvcStats.php';
//include_once 'modules/blog/classes/CBlogable.class.php';//auto

class CBlogableAffichages
{
	/**
	 * génère le html pour afficher des éléments des plus récents aux plus vieux
	 * @param $identifiant_liste
	 * @param $nb_elem
	 * @param $id_affichage : id du type_affichage utilisé
	 * @return string
	 */
	public static function affichePlusRecent($identifiant_liste, $nb_elem, $id_affichage, $autorise_elem_etranger = false, $autorise_pagination = false, $where_bonus = '') //$where viré !
	{
		//lignes ajoutées !!!!
		//		if (CPageBlogable::$instance->infos_classement['location'] == 'racine') $where = '1';
		//		else $where = self::construitWhereFromClassementPage(CPageBlogable::$instance->infos_classement);
		//
		//		if (isset(CPageBlogable::$instance->infos_classement['etr_where']) && !$autorise_elem_etranger)
		//			$where .= ' AND '.CPageBlogable::$instance->infos_classement['etr_where'];
		//
		//		if (isset(CPageBlogable::$instance->infos_classement['filtres']) && count(CPageBlogable::$instance->infos_classement['filtres']) > 0)
		//		{
		//			$tab = CPageBlogable::$instance->infos_classement['filtres'];
		//			$tab_filtres = array();
		//			for ($i = 0; $i < count($tab); $i++) $tab_filtres[] = $tab[$i]['where'];
		//			$where .= ' AND '.implode(' AND ', $tab_filtres);
		//		}
		$where = self::construitWhereComplet(CPageBlogable::$instance->infos_classement, $autorise_elem_etranger);

		$aff = new CAffichageListe();
		$aff->set_id_liste($identifiant_liste);
		$aff->set_type_affichage_par_identifiant(self::creeConcatNom($identifiant_liste, $id_affichage));
		if ($nb_elem == '0' || $nb_elem == 0) $aff->set_where("$where $where_bonus ORDER BY date_crea DESC");
		else {
			$page = self::calculePagination($autorise_pagination, $nb_elem);
			$aff->set_where("$where $where_bonus ORDER BY date_crea DESC LIMIT $page,$nb_elem");
		}

		$fetch = $aff->get_fetch();

		$aff->set_fetch(self::checkAndReplaceUrlElems($identifiant_liste, $fetch));

		$resultat = $aff->render();

		$resultat = self::afficheBalisesOptionnelles($resultat,CPageBlogable::$instance->infos_blog);

		return $resultat;
	}

	public static function getFetchPlusRecent($identifiant_liste, $nb_elem, $where_suppl = '') //$where viré !
	{
		if ($nb_elem == '0' || $nb_elem == 0) $where = 'ORDER BY date_crea DESC';
		else $where = "ORDER BY date_crea DESC LIMIT 0,$nb_elem";

		if ($where_suppl != '') $where = "$where_suppl $where";
		else $where = "1 $where";

		//		echo $where;

		$res = CListes::get_contenu_liste($identifiant_liste, $where);

		if ($res) return mysql_fetch_all($res);
		else return false;
	}

	/**
	 * génère le html pour afficher des éléments des plus consultés aux moins consultés
	 * @param $identifiant_liste
	 * @param $nb_elem
	 * @param $id_affichage : id du type_affichage utilisé
	 * @return string
	 */
	public static function affichePlusLu($identifiant_liste, $nb_elem, $id_affichage, $autorise_elem_etranger = false, $autorise_pagination = false) //$where viré !
	{
		//lignes ajoutée
		//		if (CPageBlogable::$instance->infos_classement['location'] == 'racine') $where = '1';
		//		else $where = self::construitWhereFromClassementPage(CPageBlogable::$instance->infos_classement);
		//
		//		if (isset(CPageBlogable::$instance->infos_classement['etr_where']) && !$autorise_elem_etranger)
		//		$where .= ' AND '.CPageBlogable::$instance->infos_classement['etr_where'];
		//
		//		if (isset(CPageBlogable::$instance->infos_classement['filtres']) && count(CPageBlogable::$instance->infos_classement['filtres']) > 0)
		//		{
		//			$tab = CPageBlogable::$instance->infos_classement['filtres'];
		//			$tab_filtres = array();
		//			for ($i = 0; $i < count($tab); $i++) $tab_filtres[] = $tab[$i]['where'];
		//			$where .= ' AND '.implode(' AND ', $tab_filtres);
		//		}

		$where = self::construitWhereComplet(CPageBlogable::$instance->infos_classement,$autorise_elem_etranger);

		$aff = new CAffichageListe();
		$aff->set_id_liste($identifiant_liste);
		$aff->set_type_affichage_par_identifiant(self::creeConcatNom($identifiant_liste, $id_affichage));
		if ($nb_elem == '0' || $nb_elem == 0) $aff->set_where("$where ORDER BY nb_vue DESC");
		else
		{
			$page = self::calculePagination($autorise_pagination, $nb_elem);
			$aff->set_where("$where ORDER BY nb_vue DESC LIMIT $page,$nb_elem");
			//echo "$where ORDER BY nb_vue DESC LIMIT $page,$nb_elem";
		}

		$fetch = $aff->get_fetch();
		$aff->set_fetch(self::checkAndReplaceUrlElems($identifiant_liste, $fetch));

		$resultat = $aff->render();

		$resultat = self::afficheBalisesOptionnelles($resultat,CPageBlogable::$instance->infos_blog);
		return $resultat;
	}

	public static function getFetchPlusLu($identifiant_liste, $nb_elem, $where_suppl = '') //$where viré !
	{
		if ($nb_elem == '0' || $nb_elem == 0) $where = 'ORDER BY nb_vue DESC';
		else $where = "ORDER BY nb_vue DESC LIMIT 0,$nb_elem";

		if ($where_suppl != '') $where = "$where_suppl $where";
		else $where = "1 $where";

		$res = CListes::get_contenu_liste($identifiant_liste, $where);

		if ($res) return mysql_fetch_all($res);
		else return false;
	}

	public static function afficheElems($identifiant_liste, $id_affichage, $where = '1', $limit_dep = 0, $limit_nb = 1)
	{

		$aff = new CAffichageListe();
		$aff->num_page = floor($limit_dep/$limit_nb)+1;
		$aff->nb_par_page = $limit_nb;


		$aff->set_id_liste($identifiant_liste);
		$aff->set_type_affichage_par_identifiant(self::creeConcatNom($identifiant_liste, $id_affichage));
		$aff->set_where($where." LIMIT $limit_dep, $limit_nb"); //set_where a faire

		$fetch = $aff->get_fetch();
		$aff->set_fetch(self::checkAndReplaceUrlElems($identifiant_liste, $fetch));

		$resultat = $aff->render();

		$resultat = self::afficheBalisesOptionnelles($resultat,CPageBlogable::$instance->infos_blog);
		return $resultat;
	}

	public static function afficheTagsElem($identifiant_liste, $id_auto_elem)
	{
		//include_once 'modules/listes/classes/CListes.class.php';//auto
		$liste = CListes::get_liste($identifiant_liste);
		$blog = CBlogable::getInfos($identifiant_liste);
		$class_tag = CBlogable::getClassement($identifiant_liste, 'tags');

		$q = "SELECT nom, nom_url FROM blogable__tag WHERE id_auto IN (SELECT id_tag FROM blogable__tags_elem
																	   WHERE blog_identifiant_liste= '$identifiant_liste'
																	   AND id_auto_elem = $id_auto_elem)";

		$url_debut = $blog['dossier_racine'].$class_tag['dossier_classement'];
		$str_tags_tab = array();
		if ($res = ifReq($q))
		{
			$tags = mysql_fetch_all($res);
			for ($i = 0; $i < count($tags); $i++)
			{
				$url = $url_debut.'/'.$tags[$i]['nom_url'];
				$str_tags_tab[] = '<a href="'.$url.'">'.$tags[$i]['nom'].'</a>';
			}
			return implode(', ', $str_tags_tab);
		}
	}

	public static function afficheTagsCumulElemsPage($identifiant_liste)
	{
		//include_once 'modules/listes/classes/CListes.class.php';//auto
		$liste = CListes::get_liste($identifiant_liste);
		$blog = CBlogable::getInfos($identifiant_liste);
		$class_tag = CBlogable::getClassement($identifiant_liste, 'tags');

		if (CPageBlogable::$instance->infos_classement['location'] == 'racine') $where = '';
		else $where = self::construitWhereFromClassementPage(CPageBlogable::$instance->infos_classement);

		if ($where == '1') $where = '';
		else $where = " AND $liste[table].$where";

		if (CPageBlogable::$instance->infos_classement['location'] == 'racine')
		$q = "SELECT DISTINCT blogable__tag.* FROM blogable__tags_elem, blogable__tag
				  WHERE blogable__tag.id_auto = id_tag
				  AND blogable__tags_elem.blog_identifiant_liste = '$identifiant_liste'";
		else
		$q = "SELECT DISTINCT blogable__tag.* FROM blogable__tag, blogable__tags_elem, $liste[table]
				  WHERE blogable__tag.id_auto = id_tag
				  AND blogable__tags_elem.id_auto_elem = $liste[table].id_auto 
				  AND blogable__tags_elem.blog_identifiant_liste = '$identifiant_liste' 
		$where";
			
		$url_debut = $blog['dossier_racine'].$class_tag['dossier_classement'];
		$str_tags_tab = array();
		if ($res = ifReq($q))
		{
			$tags = mysql_fetch_all($res);
			for ($i = 0; $i < count($tags); $i++)
			{
				$url = $url_debut.'/'.$tags[$i]['nom_url'];
				$str_tags_tab[] = '<a href="'.$url.'">'.$tags[$i]['nom'].'</a>';
			}
			return implode(', ', $str_tags_tab);
		}
	}

	public static function afficheElemsMemeTags($identifiant_liste, $id_affichage, $nb_max, $pourcentage_coresp_min = 0, $orderby = '')
	{
		//include_once 'modules/listes/classes/CListes.class.php';//auto
		$id_elem = CPageBlogable::$instance->infos_classement['valeur_elem']['id_auto'];
		$liste = CListes::get_liste($identifiant_liste);
		$blog = CBlogable::getInfos($identifiant_liste);
		$class_tag = CBlogable::getClassement($identifiant_liste, 'tags');

		$q = "SELECT $liste[table].id_auto, COUNT(*) AS tags_communs,
			(SELECT COUNT(*) FROM blogable__tags_elem WHERE blog_identifiant_liste = '$identifiant_liste' AND id_auto_elem = $id_elem) AS nb_tags
			FROM $liste[table], blogable__tags_elem
			WHERE blogable__tags_elem.id_auto_elem = $liste[table].id_auto
			AND id_tag in (SELECT id_tag FROM blogable__tags_elem WHERE blog_identifiant_liste = '$identifiant_liste' AND id_auto_elem = $id_elem)
			AND blogable__tags_elem.blog_identifiant_liste = '$identifiant_liste'
			AND $liste[table].id_auto != $id_elem
			GROUP BY $liste[table].id_auto
			ORDER BY tags_communs DESC";

		if ($res = ifReq($q))
		{

			$elems = mysql_fetch_all($res);
			$ids = array();
			for ($i = 0; $i < count($elems); $i++)
			{
				if ($elems[$i]['tags_communs']/$elems[$i]['nb_tags'] >= $pourcentage_coresp_min/100) $ids[] = $elems[$i]['id_auto'];
				else break;
			}

			if (count($ids) > 0)
			{
				$in = implode(',',$ids);
				$where = "$liste[table].id_auto IN ($in) $orderby";

				return self::afficheElems($identifiant_liste, $id_affichage, $where, 0, $nb_max);
			}
			else return '';
		}
		return '';
	}

	public static function nomCatByIdElem($id_blogliste,$id_auto_elem)
	{
		$liste = CListes::get_liste($id_blogliste);
		if ($res = testReq3("SELECT blogable__categories.nom FROM blogable__categories, $liste[table]
							WHERE $liste[table].id_auto = $id_auto_elem AND
							blogable__categories.id_auto = $liste[table].id_categorie"))

		return $res['nom'];

		else return '';
	}

	public static function valClassementUniqueByIdElem($id_blogliste, $id_classement, $id_auto_elem)
	{
		$liste = CListes::get_liste($id_blogliste);
		$class = CBlogable::getClassement($id_blogliste, $id_classement);
		$liste_etr = CListes::get_liste($class['liste_etrangere']);

		if ($res = testReq3("SELECT $liste_etr[table].nom FROM $liste_etr[table], $liste[table]
							WHERE $liste[table].id_auto = $id_auto_elem AND
		$liste_etr[table].id_auto = $liste[table].$class[champ]"))

		return $res['nom'];

		else return '';
	}

	/**
	 * prend un bloc html, le multiplie pour afficher les catégories
	 * @param $id_blogliste : identifiant_liste
	 * @param $bloc_html_variable : bloc avec #URL_VERS_CAT#, et de quoi afficher son nom (#NOM#?) remplacés automatiquement
	 * @return string
	 */
	public static function afficheCatsFromClassement($id_blogliste, $bloc_html_variable)
	{
		$liste = CListes::get_liste($id_blogliste);
		$class = CBlogable::getClassement($id_blogliste, 'categories');
		$blog = CBlogable::getInfos($id_blogliste);

		$return = '';

		$url_variable = $blog['dossier_racine'].$class['dossier_classement'].$class['url'];

		if ($class['multiple'] == '0')
		{
			if ($req = ifReq("SELECT DISTINCT blogable__categories.* FROM blogable__categories, $liste[table]
							WHERE $liste[table].id_categorie = blogable__categories.id_auto"))
			{
				$res = mysql_fetch_all($req);
				for ($i = 0; $i < count($res); $i++)
				{
					//$url_elem
					$res[$i]['url_vers_cat'] = remplace_tous_blocs($url_variable, $res[$i]);
					$return .= remplace_tous_blocs($bloc_html_variable, $res[$i]);
				}
				return $return;
			}
			else return '';
		}
		else
		{
			//TODO!
			return '';
		}

	}

	public static function noteMoyenne($somme_notes, $nb_votes, $precision, $note_si_null = 0)
	{
		if (isNULL($nb_votes) || $nb_votes == '' || $nb_votes == 0) {
			return $note_si_null;
		}
		return round($somme_notes/$nb_votes,$precision);
	}
	public static function noteMoyenneImage($somme_notes, $nb_votes, $note_min, $note_max, $url_img, $largeur_img, $hauteur_img, $note_si_null = 0)
	{
		$retour = '';

		if (isNULL($nb_votes) || $nb_votes == '' || $nb_votes == 0) $note = $note_si_null;
		else $note = is_array($url_img) ? round($somme_notes/$nb_votes,count($url_img)/2) : round($somme_notes/$nb_votes);

		$ind = 0;
		$pas = is_array($url_img) ? 1/count($url_img) : 1;

		for ($i = 0; $i < $note_max; $i += $pas)
		{
			if (is_array($url_img)) $img = $url_img[$ind % count($url_img)];
			else $img = $url_img;

			$decal_y = -$hauteur_img;
			if ($i >= $note) $decal_y = 0;
			$retour .= "<div style='background:url(\"$img\") no-repeat 0px {$decal_y}px; width:{$largeur_img}px; height:{$hauteur_img}px; float:left;'/></div>";

			$ind++;
		}

		return $retour;
	}

	public static function afficheArboFromPageToRacine($txt_base,$separateur,$txt_racine,$txt_classement,$txt_elem)
	{
		$infos_class = CPageBlogable::$instance->infos_classement;

		$tab_arbo = array();

		if ($infos_class['location'] == 'racine') return $txt_base.$txt_racine;
		else $tab_arbo[] = '<a href="'.$infos_class['blogable']['dossier_racine'].'">'.$txt_racine.'</a>';

		if ($infos_class['location'] == 'classement') $tab_arbo[] = remplace_tous_blocs($txt_classement,$infos_class['valeur_classement']);
		else if ($infos_class['blogable']['url_elem_ss_classement'] == '' || isNULL($infos_class['blogable']['url_elem_ss_classement']))
		$tab_arbo[] = '<a href="'.$infos_class['blogable']['dossier_racine'].$infos_class['url_classement'].'">'.remplace_tous_blocs($txt_classement,$infos_class['valeur_classement']).'</a>';

		if ($infos_class['location'] == 'elem') $tab_arbo[] = remplace_tous_blocs($txt_elem,$infos_class['valeur_elem']);

		return $txt_base.implode(" $separateur ",$tab_arbo);
	}

	public static function affichePagination($nb_elem_affichage, $texte_prec = '<< Page précédente', $texte_suiv = 'Page suivante >>', $texte_entre_deux = ' - ')
	{
		$infos_class = CPageBlogable::$instance->infos_classement;
		if ($infos_class['location'] == 'racine') $url = $infos_class['blogable']['dossier_racine'];
		else if ($infos_class['location'] == 'classement') $url = $infos_class['blogable']['dossier_racine'].$infos_class['url_classement'];
		//		$url = $_SERVER[REQUEST_URI];
		//		print_rr($infos_class);
		if (!isset($infos_class['pagination'])) return '';

		if (!isset($infos_class['pagination']['page_demandee']) || $infos_class['pagination']['page_demandee'] == 1)
		if($infos_class['pagination']['nb_elem'] <= $nb_elem_affichage) return '';
		else return "<a href='$url?page=2'>$texte_suiv</a>";

		$nb_pages_aff = ceil($infos_class['pagination']['nb_elem']/$nb_elem_affichage);
		$num_prec = $infos_class['pagination']['page_demandee'] - 1;
		$num_suiv = $infos_class['pagination']['page_demandee'] + 1;

		if ($infos_class['pagination']['page_demandee'] == $nb_pages_aff && $num_prec > 1) return "<a href='$url?page=$num_prec'>$texte_prec</a>";
		else if ($infos_class['pagination']['page_demandee'] == $nb_pages_aff) return "<a href='$url'>$texte_prec</a>";

		if ($num_prec > 1) return "<a href='$url?page=$num_prec'>$texte_prec</a>$texte_entre_deux<a href='$url?page=$num_suiv'>$texte_suiv</a>";
		else return "<a href='$url'>$texte_prec</a>$texte_entre_deux<a href='$url?page=$num_suiv'>$texte_suiv</a>";
	}

	private static function calculePagination($autorise_pagination, $nb_elem)
	{
		$page = 0;
		if (isset(CPageBlogable::$instance->infos_classement['pagination']['page_demandee']) && $autorise_pagination == true)
		{
			if (((CPageBlogable::$instance->infos_classement['pagination']['page_demandee']-1) * $nb_elem) >
			CPageBlogable::$instance->infos_classement['pagination']['nb_elem']) {
				$tmp_limitstart = 0;
				$derniere_page = 0;
				while ($tmp_limitstart < CPageBlogable::$instance->infos_classement['pagination']['nb_elem']) {
					$derniere_page++;
					$tmp_limitstart += $nb_elem;
				}
				$page = $tmp_limitstart - $nb_elem;
				CPageBlogable::$instance->infos_classement['pagination']['page_demandee'] = $derniere_page;
			}
			else if (((CPageBlogable::$instance->infos_classement['pagination']['page_demandee']-1) * $nb_elem) < 0) {
				$page = 0;
				CPageBlogable::$instance->infos_classement['pagination']['page_demandee'] = 1;
			}
			else $page = (CPageBlogable::$instance->infos_classement['pagination']['page_demandee']-1) * $nb_elem;
		}
		return $page;
	}

	/**
	 * ajoute un affichage prédéfini pour une liste blogable
	 * @param $identifiant_liste
	 * @param $nom_affichage : identifiant texte de l'affichage
	 * @param $fichier : chemin du fichier sur le serveur sans extension ".element.htm"
	 * @return void
	 */
	public static function ajouteTypeAffichageListe($identifiant_liste, $nom_affichage, $fichier, $typeSite = 'standard')
	{
		CTypeAffichage::ajoute_type(self::creeConcatNom($identifiant_liste, $nom_affichage),
									"modules/super_admin/www/affichage_listes/CAffichageBasicFichier.class.php","CAffichageBasicFichier",$fichier, $typeSite);
	}

	/**
	 * retourne les infos sur l'affichage d'une liste blogable
	 * @param $identifiant_liste
	 * @param $id_affichage
	 * @return array
	 */
	public static function getInfosAffichage($identifiant_liste, $id_affichage)
	{
		return testReq3("SELECT * FROM blogable__affichage WHERE blog_identifiant_liste = '$identifiant_liste' AND identifiant_aff = '$id_affichage'");
	}

	private static function creeConcatNom($identifiant_liste, $id_affichage)
	{
		return $identifiant_liste.'__'.$id_affichage;
	}

	public static function checkAndReplaceUrlElems($identifiant_liste, $all)
	{
		if ($res = ifReq("SELECT * FROM blogable__classement WHERE est_principale = 1
						  AND blog_identifiant_liste = '$identifiant_liste'
						  AND url_elem_si_principale != '' AND url_elem_si_principale IS NOT NULL"))
		{
			$fetch_classement = mysql_fetch_assoc($res);
			if(is_array($all)) {
				foreach($all as &$fetch) {
					$fetch['blog_url_element'] = self::get_url_elem_from_fetch($identifiant_liste,$fetch_classement,$fetch);
				}
			}
			return $all;
		}
		return $all;
	}

	public static function get_url_elem_from_fetch($identifiant_liste,$fetch_classement,$fetch) {
		$classement = $fetch_classement;
			
		$infos_blogable = CBlogable::getInfos($identifiant_liste);

		if (isset(CPageBlogableEtr::$instance->infos_classement['infos_liste'])) $infos_liste = CPageBlogableEtr::$instance->infos_classement['infos_liste'];
		else $infos_liste = CListes::get_liste($identifiant_liste);
		//		$infos_liste = CPageBlogableEtr::$instance->infos_classement["infos_liste"];
			
		if ($classement == false) {
			if (isset($infos_blogable['racine_complete_etr']) && $infos_blogable['racine_complete_etr'] != '')
			{
				//TODO !!!!
				//ajout du  03/06/2010 ! reste du bordel ici ou en dessous
				$infos_liste['table_lien'] = CPageBlogableEtr::$instance->infos_classement['etr_champ_desc']['table_lien'];
				$infos_liste['champ_lien_associe'] = CPageBlogableEtr::$instance->infos_classement['etr_champ_desc']['champ_lien_associe'];
				///////

				$req_etr = "SELECT * FROM $infos_liste[table_lien] WHERE $infos_liste[champ_lien_associe] = '".$fetch[$infos_liste['champ_lien']]."'";
				//				log_requete_ok('INFOS LISTE!');
				//				log_requete_ok(print_r($infos_liste,true));
				$fetch_etr = testReq3($req_etr);
				//				echo "!!!!!!$req_etr!!!!!!";
				//				print_rr($fetch_etr);

				//					$this->infos_classement['etr_where'] = "";
				//						$this->infos_classement['etr_champ_desc'] = $champ_lien_desc;
				//						$this->infos_classement['infos_liste'] = $infos_liste;
				//						$this->infos_classement['infos_liste_etr'] = $infos_liste_etr;

				$url_elem = $infos_blogable['racine_complete_etr'];
				$url_elem = remplace_tous_blocs($url_elem, $fetch_etr,"#ETR_");
				$url_elem = remplace_tous_blocs($url_elem, $fetch);
			}
			else $url_elem = $infos_blogable['dossier_racine'];
			$url_elem .= remplace_tous_blocs($infos_blogable['url_elem_ss_classement'], $fetch);
			return titreToLien($url_elem, true, false);
		}
			
		if ($classement['multiple'] == 0)
		{
			log_requete_ok('noooooooon');
			$infos_liste = CListes::get_liste($identifiant_liste);
			$table = $infos_liste['table'];
			$champ_lien = $classement['champ'];
			$infos_liste_etr = CListes::get_liste($classement['liste_etrangere']);
			//			print_rr($infos_liste);
			//			print_rr($classement);
			$table_etr = $infos_liste_etr['table'];


			if (isset($infos_blogable['racine_complete_etr']) && $infos_blogable['racine_complete_etr'] != '')
			{
				$url_elem = $infos_blogable['racine_complete_etr'];

				$req_etr = "SELECT * FROM $infos_liste[table_lien] WHERE $infos_liste[champ_lien_associe] = '".$fetch[$infos_liste['champ_lien']]."'";
				//				echo "$req_etr<br/>";
				$fetch_etr = testReq3($req_etr);

				//TODO:.................
				//				CBlogableAffichages::$infos_classement;
				//				echo "url:$url_elem<br/>";
				$url_elem = remplace_tous_blocs($url_elem, $fetch_etr,"#ETR_");
				$url_elem = remplace_tous_blocs($url_elem, $fetch);
			}
			else $url_elem = $infos_blogable['dossier_racine'];
			//si on a bien un classement pour cet elem
			$id_elem = $fetch['id_auto'];
			//			echo "REQ : SELECT $table_etr.* FROM $table, $table_etr WHERE $table.$champ_lien = $table_etr.id_auto AND $table.id_auto = $id_elem <br/>";
			if ($res = testReq3("SELECT $table_etr.* FROM $table, $table_etr WHERE $table.$champ_lien = $table_etr.id_auto AND $table.id_auto = $id_elem"))
			{
				$classement_elem = $res;
				$url_elem .= remplace_tous_blocs($classement['url'], $classement_elem);
			}
			$url_elem .= remplace_tous_blocs($classement['url_elem_si_principale'], $fetch);
			return titreToLien($url_elem, true);

		}
		return "";
	}

	public static function getUrlElem($identifiant_liste, $fetch)
	{
		$retour = '';
		if ($res = ifReq("SELECT * FROM blogable__classement WHERE est_principale = 1
						  AND blog_identifiant_liste = '$identifiant_liste'
						  AND url_elem_si_principale != '' AND url_elem_si_principale IS NOT NULL"))
		{
			$fetch_classement = mysql_fetch_assoc($res);
				
			return self::get_url_elem_from_fetch($identifiant_liste,$fetch_classement,$fetch);
		}

		return $retour;
	}

	public static function construitWhereFromClassementPage($infos_classement)
	{
		if (!isset($infos_classement['classement']))
		{
			return '1';
		}

		$classement = $infos_classement['classement'];
		$val_classement = $infos_classement['valeur_classement'];
		if ($classement['multiple'] == '0')
		{
			//			echo "$classement[champ] = $val_classement[id_auto]<br/>";
			return "$classement[champ] = $val_classement[id_auto]";
		}
		else
		{
			//			echo "id_auto IN (SELECT id_auto_elem FROM $classement[table_lien] WHERE $classement[table_lien_champ] = $val_classement[id_auto]
			//					AND identifiant_liste = '$val_classement[identifiant_liste]')<br/>";
			return "id_auto IN (SELECT id_auto_elem FROM $classement[table_lien] WHERE $classement[table_lien_champ] = $val_classement[id_auto]
					AND blog_identifiant_liste = '$val_classement[blog_identifiant_liste]')";
		}
	}

	public static function construitWhereFromClassementPageToElem($infos_classement)
	{
		$val_elem = $infos_classement['valeur_elem'];
		return "id_auto = $val_elem[id_auto]";
	}

	public static function construitWhereElemCommentaires($blog_id, $id_auto_elem, $where = '1')
	{
		return "$where AND id_auto_elem = $id_auto_elem AND blog_identifiant_liste = '$blog_id' AND blogable__commentaire.actif = 1 ";
	}

	/**
	 * idem que construitWhereFromClassementPage, mais sans le infos_classement (utilisation exterieure)
	 * @param $id_liste
	 * @param $nom_classement
	 * @param $valeur
	 * @return unknown_type
	 */
	public static function construitWhereFromValClassement($id_liste, $nom_classement, $valeur)
	{
		$classement = CBlogable::getClassement($id_liste, $nom_classement);
		$liste_class = CListes::get_liste($classement['liste_etrangere']);


		//champ_url_liste_etr

		if ($classement['multiple'] == '0')
		{
			//			echo "SIMPLE!!!!<br/>$classement[champ] = (SELECT id_auto FROM $liste_class[table] WHERE $classement[champ_url_liste_etr] = '$valeur')<br/>";
			return "$classement[champ] = (SELECT id_auto FROM $liste_class[table] WHERE $classement[champ_url_liste_etr] = '$valeur')";
		}
		else
		{
			//			echo "MULTIPLE!!!!<br/>id_auto IN (SELECT id_auto_elem FROM $classement[table_lien]
			//					WHERE $classement[table_lien].$classement[table_lien_champ] = (SELECT id_auto FROM $liste_class[table] WHERE $classement[champ_url_liste_etr] = '$valeur')
			//					AND $classement[table_lien].identifiant_liste = '$val_classement[identifiant_liste]')<br/>";
			return "id_auto IN (SELECT id_auto_elem FROM $classement[table_lien]
					WHERE $classement[table_lien].$classement[table_lien_champ] = (SELECT id_auto FROM $liste_class[table] WHERE $classement[champ_url_liste_etr] = '$valeur')
					AND $classement[table_lien].blog_identifiant_liste = '$id_liste')";
		}


		$val_elem = $infos_classement['valeur_elem'];
		return "id_auto = $val_elem[id_auto]";
	}

	/**
	 * utilisé dans affichePlusRecent, affichePlusLu, regroupe toute la création du where, encore un souci avec autorise_elem_etranger
	 * (il faudrait le récupérer mais ou...) car la fonction sert dans CPageBlogable dans repereClassement pour le calcul de la pagination
	 * @param $autorise_elem_etranger
	 * @param $infos_classement
	 * @return unknown_type
	 */
	public static function construitWhereComplet($infos_classement, $autorise_elem_etranger = false)
	{
		if ($infos_classement['location'] == 'racine') $where = '1';
		else $where = self::construitWhereFromClassementPage($infos_classement);

		if (isset($infos_classement['etr_where']) && !$autorise_elem_etranger)
		$where .= ' AND '.$infos_classement['etr_where'];
			
		if (isset($infos_classement['filtres']) && count($infos_classement['filtres']) > 0)
		{
			$tab = $infos_classement['filtres'];
			$tab_filtres = array();
			for ($i = 0; $i < count($tab); $i++) $tab_filtres[] = $tab[$i]['where'];
			$where .= ' AND '.implode(' AND ', $tab_filtres);
		}

		return $where;
	}

	public static function afficheBalisesOptionnelles($str, $infos_blog)
	{
		$str=affiche_element_multiple_par_balise($str,"USE_COMMENTAIRES",$infos_blog['use_commentaires'] == '1');
		$str=affiche_element_multiple_par_balise($str,"USE_TAGS",$infos_blog['use_tags'] == '1');
		$str=affiche_element_multiple_par_balise($str,"USE_CATEGORIES",$infos_blog['use_categories'] == '1');
		$str=affiche_element_multiple_par_balise($str,"USE_VOTES",$infos_blog['use_votes'] == '1');
		$str=affiche_element_multiple_par_balise($str,"USE_NOTES",$infos_blog['use_notes'] == '1');
		return $str;
	}
}


?>