<?php
	ini_set('display_errors','on');
	ini_set('include_path','../../');
	define("RACINE_WWW",realpath("../../")."/");
	
	include_once 'includes/Config.inc.php';
	function __autoload($class_name){
		require_once("classes/$class_name.class.php");
	}
	bdd::connect();
?>
<% if(lots.length >0){%>
<div id="selectedLot">
	<h3 class="lot_nom r_edit"><%= selectedLot.nom %></h3>
	<p id="dsp_detailLot">Afficher/Masquer les détails</p>
	<script>
		$("#dsp_detailLot, #selectedLot h3").click(function(){
			$("#selectedLot ul").slideToggle(500);
		});
	</script>
	<% if(selectedLot.type==1){
		%>
		<br>
		<div class='lot_progressbar r_edit'>
		<div style="width:<%= Math.min(Math.round((selectedLot.duree_facture/selectedLot.duree_estimee)*250),250) %>px"></div>
		</div>
		<p class="lot_progressbar_text"><%= Math.round((selectedLot.duree_facture/selectedLot.duree_estimee)*100) %>%</p>
	
	
	<% } %>
	<p style="text-align:center"><%= selectedLot.duree_facture %> h <% if(selectedLot.duree_estimee>0){%> / <%= selectedLot.duree_estimee %><% } %></p>
	<% if(selectedLot.duree_facture != selectedLot.duree){%>
		<p style="text-align:center">réel : <%= selectedLot.duree %> h </p>
	<% } %> 
	<ul>	
		<li>		
			<label class="r_edit">Du </label>
			<span class="r_edit"><%= selectedLot.firstWork %></span>
			<br>
			<label class="r_edit">Au </label>
			<span class="r_edit"><%= selectedLot.lastWork %></span>
		</li>		
		<li>
			<label>Type tache</label>
			<span class="r_edit"><%= selectedLot.nomTypeTache %></span>
		</li>
		<li>
			<label for="tps_e">Temps estime</label>
			<span class="r_edit"><%= selectedLot.duree_estimee %> h</span>
			<br>
			<label class="r_edit">Temps passe dessus</label>
			<span class="r_edit"><%= selectedLot.duree %> h</span>
		
		</li>
		
		<input type="button" id="lotEdit" value="Editer"/>

		<% if(selectedLot.taches.length > 1 || selectedLot.taches[0].count > 0) { %>
			<a class='go_supervision' target="new" href='?page=supervision&idClient=<%= selectedLot.id_client %>&idLot=<%= selectedLot.id %>'>Voir ce lot dans Supervision</a>					
		<% }else{ %>
			<span class="go_supervision" style='color:red;'> Lot sans travail !</span>
			<form method="post" class="inline_form">
				<input type="image" src="img/icones/Delete.png" onClick="return confirm('Etes vous sur ??')" id="delLot_btn"/>			
				<input type="hidden" name="action" value="delLot"/>			
				<input type="hidden" name="id" value="<%= selectedLot.id %>"/>			
			</form>
		<% } %>
	</ul>

	<form method="post" id="editLot">
		<h3>Edition du lot</h3>
		<hr/>
		<input type="hidden" name="action" value="editLot"/>
		<input type="hidden" name="id" value="<%= selectedLot.id %>"/>
		
		<input required type="text" name="nom" value="<%= selectedLot.nom %>"/>
			
		<label>Client</label>
		<select name="idClient">
			<?php
			foreach(bdd::getResults("SELECT id,nom FROM wrk_clients WHERE actif=1") as $client)
			echo "<option value='".$client['id']."'>".$client['nom']."</option>";
		?>
		</select>
		
		<label for="chk">Comptabilise</label>
		<input id="chk" type="checkbox" name="chk" <% if(selectedLot.comptabilise==1){%> checked <%}%> alt="editer"/>
		
		<label>Type tache</label>
		<table><tr>
		<td>
		<select name="idTypeTache" class="edit" id="idTypeTache">
		</select>
		<script>
			$("#idTypeTache").bind('ajaxLoad',function(){	
				$.ajax({
					type: "POST",
					url: "ajax.php",
					dataType : "html",
					data : {
						action: "live_getTt"
					}
				}).done(function(html) {
					$("#idTypeTache").html(html);
				}).fail(function(jqXHR, textStatus) {
					alert("<h1>Erreur Ajax : "+textStatus+"<h1>");
				});
			});
		</script>
		</td><td>

			<img src="img/icones/Refresh.png" alt="Refresh"  id="Tt_refresh_btn" style="cursor:pointer;"/>

		</td><td>
		</td><td>

			<input type="button" value="+ Ajouter" onClick="Javascript:overlay('popup_insert_type_tache.php')" class="small_btn"/>

		</td><td>
  
			<input type="button" value="Editer" onClick="Javascript:overlay('popup_edit_type_tache.php?id_typetache='+$('#idTypeTache').val())" class="small_btn"/>

		</td>
		</tr></table>
		<label for="tps_e">Temps estime</label>
		<input required type="text" class="edit" id="tps_e" name="duree" value="<%= selectedLot.duree_estimee %>" size="5" size="5"/>
			
		<label for="forfait">Forfait</label>
		<input required type="text" class="edit" name="forfait" id="forfait" value="<%= selectedLot.forfait %>" size="5"/>
		
		<br>
		
		<input type="submit" class="edit" id="lotSave" value="Editer le lot"/>
		<img src="img/icones/Exit.png" alt="Annuler edit lot"  id="lotCancel" style="float:right;cursor:pointer;"/>
	
	</form>
</div>

<script>
	// Script edit lot
	$("#lotEdit").click(function(){
		$("#editLot").show();
		$("#lotEdit").hide();
	});
	$("#lotEdit").one('click',function(){
		$('#idTypeTache').trigger('ajaxLoad');
	});
	$("#Tt_refresh_btn").bind('click',function(){
		$('#idTypeTache').trigger('ajaxLoad');
	});
	
	
	
	
	
	$("#lotCancel").click(function(){
		$("#editLot").hide();
		$("#lotEdit").show();
	});
	
	$("#lotCancel").trigger('click');
	
	$("#editLot select[name='idClient'] option").filter("[value='<%= selectedLot.id_client %>']").attr("selected","selected");
	$("#editLot select[name='idTypeTache'] option").filter("[value='<%= selectedLot.id_type_tache %>']").attr("selected","selected");

</script>

<h5>
	Tache
	<span class="h5_recap" id="recap_tache"></span>
</h5>
<ul id='taches'>

<% for(var i in selectedLot.taches) { %>
	<li class='<%= selectedLot.taches[i].selected %> tache'>
		<div>
			<span class="r_edit val_tache_nom" ><%= selectedLot.taches[i].nomDisplay %></span>
			
			<% if(selectedLot.taches[i].count > 0){ %>
				<a class='nbr_travaux' target="new" href='?page=supervision&idClient=<%= selectedLot.id_client %>&idLot=<%= selectedLot.id %>#content'>Voir les <%= selectedLot.taches[i].count %> travaux</a></span>					
			
			<% }else{ %>
			
				<span class="nbr_travaux" style='color:red;'> Tache sans travail !</span>
				<form method="post" class="inline_form">
					<input type="image" src="img/icones/Delete.png" onClick="return confirm('Etes vous sur ??')" id="delTache_btn"/>
					<input type="hidden" name="action" value="delTache"/>
					<input type="hidden" name="id" value="<%= selectedLot.taches[i].id %>"/>
				</form>
			<% } %>
			
			<img src="img/edit.png" alt="editer" class="r_edit btnEdit"/>			
		</div>
		<form class="editTache" method="post">
			<h3>Edition de la tache</h3>
			<hr/>
			<input type="hidden" name="action" value="editTache"/>
			<input type="hidden" name="id" value="<%= selectedLot.taches[i].id %>"/>
			
			<label for="id_lotTache">Nom</label>
			<input id="nom_LotTache" type="text" name="nom" value="<%= selectedLot.taches[i].nom %>" size="5"/>
			
			<br>
			
			<label for="id_lotTache">Lot associe</label>
			<select name="id_lot" id="id_lotTache" class="edit">
			<?php
				foreach(bdd::getResults("SELECT lt.id AS id, CONCAT(cl.nom,' - ',lt.nom) AS nom 
											FROM wrk_lots lt 
											LEFT JOIN wrk_clients cl ON cl.id = lt.id_client 
											WHERE lt.actif=1
											ORDER BY lt.id_client
											") as $tt)
				echo "<option value='".$tt['id']."'>".$tt['nom']."</option>";
			?>
			</select>
			
			<br>

			<label for="id_tache_parent">Tache parent</label>
			<select name="id_tache_parent" id="id_tache_parent" class="edit">
				<option value="" <%= (selectedLot.taches[i].id_tache_parent == null)?"selected":""%> >-- aucune --</option>
				<% for(var ii in selectedLot.taches) { %>
					<option value='<%= selectedLot.taches[ii].id %>' <%= (selectedLot.taches[ii].id == selectedLot.taches[i].id_tache_parent)?"selected":""%> ><%= selectedLot.taches[ii].nomDisplay %></option>
				<% } %>
			</select>

			<br>

            <label for="nomTache">Durée estimée</label>
            <input required type="text" name="duree_estimee" id="duree_estimee" value="<%= selectedLot.taches[i].duree_estimee %>"/>

            <br>

			<label for="id-coef-fact">Coefficient facturation</label>
			<input id="id-coef-fact" type="text" name="coef_facturation" value="<%= selectedLot.taches[i].coef_facturation %>" />
			
			<br>
			
			<input type="submit" value="Editer la tache" class="edit"/>
			<img src="img/icones/Exit.png" alt="annuler" class="edit btnCancel"/>
		</form>
				
	</li>
	
<% } %>

	<li id="addTache">
		<input type="button" id="addTache_btn" class="btn" value="+ Ajouter une tache"/>
		<form method="post">
			<span>Ajouter une tache</span>
			<hr/>
			<input type="hidden" name="action" value="addTache"/>
			<input type="hidden" name="idLot" value="<%= selectedLot.id %>"/>
		
			<label for="nomTache">Nom</label>
			<input required type="text" name="nomTache" id="nomTache"/>
			
			<br/>

            <label for="nomTache">Durée estimée</label>
            <input required type="text" name="duree_estimee" id="duree_estimee"/>

            <br/>

			<label>Coefficient de facturation</label>
			<input type="text" required name="coefFacturation" value="<%= selectedLot.coef_facturation %>"/>

			<input type="submit" value="Ajouter"/>
		</form>
	</li>
</ul>
<script>
// Script Edit Tache

$(".tache .btnEdit").click(function(){
	$(this).parent().parent().find(".editTache").show();
});

$(".tache .btnCancel").click(function(){
	$(this).parent().parent().find(".editTache").hide();
});

$(".tache .btnCancel").trigger('click');

$(".tache select option").filter("[value='<%= selectedLot.id %>']").attr("selected","selected");

$("#addTache form").hide();
$("#addTache_btn").click(function(){
	$("#addTache form").show();
	$("#addTache_btn").hide();
	return false;
});

$("#taches .tache").click(function(){
	$("#taches .tache").removeClass("selected");
	$(this).addClass("selected");

	$("#addWork input[name='idTache']").val(
		$(this).find("input[name='id']").val()
	);
	
	$("#recap_tache").html($(this).find("span.val_tache_nom").html());
});

$("#taches .selected").trigger('click');

</script>

<?php if(isset($_GET['idTravail'])) { $travail = new Travail(mysql_real_escape_string($_GET['idTravail']));	 } ?>


<% if(selectedLot.taches.length > 0){ %>

<h5>Travail</h5>
<div id="addWork">
	<form method="post" id="addWork_form">

<?php if(isset($_GET['idTravail'])) { ?>
		<input type="hidden" name="action" value="editWork"/>
		<input type="hidden" name="id" value="<?php echo $_GET['idTravail']; ?>"/>
<?php }else { ?>
		<input type="hidden" name="action" value="addWork"/>
<?php } ?>
		<input type="hidden" name="idUser" value="" id="input_idUser"/>
		<script>
			$("#addWork_form").submit(function(){
				$("#input_idUser").val($("#selectUser").val());
			});
		</script>
		<input type="hidden" name="idTache"/>
	
		<label>Nombre d'heures</label><br>
		<input type='range' min ="0.5" max="16" step ="0.5" value="<?php echo (isset($_GET['idTravail'])) ? $travail->duree : "0.5" ?>" name="duree" id="rangeDuree">
		<span id="resultRange"></span>

		<br>
		
		<span id="addWork_btnFacture" style="cursor:pointer">Afficher heures facturées</span>
		<div id="addWork_containerFacture">
			<label>Heures Facturées</label><br>
			<input type='range' min ="0" max="16" step ="0.5" value="<?php echo (isset($_GET['idTravail'])) ? $travail->duree_facture : "0.5"; ?>" name="dureeFacture" id="rangeDureeFacture">
			<span id="resultRangeFacture"></span>
		</div>
		<br>
		<br>
		
		<label>Quand</label><br>
		<input required type='date' name="date" value="<?php echo (isset($_GET['idTravail'])) ? $travail->date : date('Y-m-d'); ?>">
		
		<br>
		<br>
	
		<label>Commentaire</label><br>
		<textarea required rows="10" cols="80" name='commentaire'><?php echo (isset($_GET['idTravail'])) ? $travail->commentaire : ""; ?></textarea>
		<br>
		<br>
		<input type='submit' value='<?php echo (isset($_GET['idTravail'])) ? "Valider les modifications" : "Enregistrer"; ?>'>
		
		<script>
			var follow = false;
			$("#rangeDuree").change(function(){
				$("#resultRange").html($(this).val()+" h");
				if(follow)
					$("#rangeDureeFacture").val($(this).val()).trigger('change');
			}).trigger('change');

			follow = true;
			
			$("#rangeDureeFacture").change(function(){
				$("#resultRangeFacture").html($(this).val()+" h");
			}).trigger('change');

			$("#addWork input[name='date']").datepicker({
				dateFormat: 'yy-mm-dd'
			});

			$("#addWork_containerFacture").slideUp(0);
			
			$("#addWork_btnFacture").click(function(){
				follow = false;
				$(this).slideUp(500);
				$("#addWork_containerFacture").slideDown(500);
			});

			
			<% if(selectedLot.duree != selectedLot.duree_facture){ %>
				$("#addWork_btnFacture").trigger("click");
			<% } %>
		</script>
	</form>
</div>
<% } %>




<% } %>