<?php

class HebergementForm{
	
	protected $formulaire;
	
	public function __construct($obj = null){
		
		$form = new TForm('Hebergement');
		$form->setClassCSS('form_edit');
		
		if(!is_null($obj)){
			$form->add('Hidden')->name('edit')->value('edit');
			$form->add('Hidden')->name('id');
		}
		else{
			$form->add('Hidden')->name('new')->value('new');
		}
                
                //Clé étrangère type
		$h_types = new Hebergement_type();
		$select = $h_types->findAllForForm('id','nom');
		$select = $form->add('Select')->label('Type d\'hébergement <br/> ou service')->name('id_type')->options($select);
		
                if(is_null($obj)){
                   $select->onJS('onChange','majTypeH');
                }
                
                $form->add('Checkbox')
			 ->label('Actif')
			 ->id('actif')
			 ->value(!is_null($obj)? $obj->actif : 1)
			 ->name('actif')
			 ->defaultChoice(true)
			 ->required(false);
                
		
		$form->add('Text')->label('Désignation')->name('designation');
		$form->add('Text')->label('Fournisseur')->name('fournisseur')->required(false);
		$form->add('Date')->label('Date de validité :  <span class="little_text"><br/>(yyyy-mm-dd)<br/>Date actuelle si pas renseignée</span>')->name('date_valid')->format('yy-mm-dd')->value(date("Y-m-d"))->required(false);
		$form->add('Text')->label('Montant HT')->name('montant_ht');
		
		$form->add('Textarea')->label('Commentaires')->id('commentaires')->name('commentaires')->required(false);
		
		
		if(isset($_GET['id_client']) && $_GET['id_client']!=""){
			$form->add('Hidden')->name('id_client')->value($_GET['id_client']);
		}
		else{
			//Clé étrangère client
			$clients = new Clients();
			$select = $clients->findAllForForm('id','nom');
			$form->add('Select')->label('Client')->name('id_client')->options($select);
		}
		
		$this->formulaire = $form;
	}
	
	public function getForm(){
		return $this->formulaire;
	}
	
	 
	
	
}


?>