<?php

class OlcJQueryslider extends Module
{
        private $tabUrl = array();
        protected $maxImageSize = 307200;
        
	function __construct()
	{
		$this->name = 'olcjqueryslider';
		$this->tab = 'Olecorre Developpement';
		$this->version = 1.0;

		parent::__construct(); // The parent construct is required for translations

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('OlcSlider Galery');
		$this->description = $this->l('Rotation des images');
	}

	function install()
	{
		if (!parent::install())
			return false;
		if (!$this->registerHook('home'))
			return false;
		return true;
	}

	public function getContent(){
		//$output = '<h2>'.$this->displayName.'</h2>';
		$this->LireXml();
		if (Tools::isSubmit('submitAdd'))
		{
			$this->postProcess();
		}
		if (Tools::getValue('pos', '')!=''){
			$this->supProcess();
		}
		$this->writeXml();
		return $this->displayForm();

	}

	public function displayForm(){
		$tabLangage = Language::getLanguages(false);
		
		echo '<fieldset><legend><img src="../modules/olcjqueryslider/logo.gif" />'.$this->l('Add a image').'</legend>';
		echo '<form action="'.$_SERVER['REQUEST_URI'].'" method="POST" enctype="multipart/form-data">
				<label class="clear">'.$this->l('Langue').' </label>
				<div class="margin-form">
                                <select name="langue" id="langue">';
								foreach($tabLangage as $langue){
									echo '<option value="'.$langue['id_lang'].'">'.$langue['name'].'</option>';
								}
		echo '</select></div>
				<label class="clear">'.$this->l('Image').' </label>
				<div class="margin-form">
						<input name="img" type="file" value="" style="width:500px"/>
				</div>
				<label class="clear">'.$this->l('Url').' </label>
				<div class="margin-form">
						<input name="url" type="text" value=""  style="width:500px"/> '.$this->l('With http://').'
				</div>
				<label class="clear">'.$this->l('Target').' </label>
				<div class="margin-form">
						<select name="target" id="target">
							<option value="_blank">'.$this->l('New window').'</option>
							<option value="_parent">'.$this->l('Idem window').'</option>
						</select>
				</div>
				<label class="clear">'.$this->l('Alt').' </label>
				<div class="margin-form">
						<input name="alt" type="text" value=""  style="width:500px"/>
				</div>
				<div class="margin-form">
						<input type="submit" name="submitAdd" value="'.$this->l('Add').'" class="button" />
				</div>
			</form>
		</fieldset>';

		echo '<fieldset><legend><img src="../modules/olcjqueryslider/logo.gif" />'.$this->l('List of image').'</legend>';

		$xml = simplexml_load_file('../modules/olcjqueryslider/slides.xml');
		$i=0;
		echo '<ul>';
		foreach($xml->slide as $slide){
			echo '<li><img src="'._THEME_LANG_DIR_.$slide->langue.'.jpg" width="16" height="11" /><img src="../modules/olcjqueryslider/slides/'.$slide->img.'" width="100px"'.$slide->target.'"/>'.$slide->url.' <a href="'.$_SERVER['REQUEST_URI'].'&pos='.$i.'" alt="'.$this->l('Delete').'"><img src="../img/admin/delete.gif" title="'.$this->l('Delete').'" /></a></li>';
			$i++;
		}
		echo '</ul></fieldset>';
	}

	public function postProcess(){
		if (Tools::isSubmit('submitAdd')){
			/* upload the image */
			if (isset($_FILES['img']) AND isset($_FILES['img']['tmp_name']) AND !empty($_FILES['img']['tmp_name']))
			{
					Configuration::set('PS_IMAGE_GENERATION_METHOD', 1);
					if ($error = checkImage($_FILES['img'], $this->maxImageSize))
							$errors .= $error;
					elseif (!$tmpName = tempnam(_PS_TMP_IMG_DIR_, 'PS') OR !move_uploaded_file($_FILES['img']['tmp_name'], $tmpName))
							return false;
					elseif (!imageResize($tmpName, dirname(__FILE__).'/slides/'.$_FILES['img']['name']))
							$errors .= $this->displayError($this->l('An error occurred during the image upload.'));
					unlink($tmpName);
			}
			$url = Tools::getValue('url', '');
            $alt = Tools::getValue('alt', '');
			$target = Tools::getValue('target', '_blank');
            $langue = Tools::getValue('langue', '');
			array_push($this->tabUrl, array((string)$langue, $alt, $target, $_FILES['img']['name'],$url));
		}else{
			$this->_errors = $this->l('Image and Url are mandatory');
		}

	}

	public function supProcess(){
		if (Tools::getValue('pos', '')!=''){
			$pos = intval(Tools::getValue('pos', ''));
			unset($this->tabUrl[$pos]);
		}
	}

	public function writeXml(){
		if(count($this->tabUrl)>0){
			$file = fopen('../modules/olcjqueryslider/slides.xml', 'w');
			fwrite($file, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
			fwrite($file, "<slides>\n");
			foreach($this->tabUrl as $value){

				if($value[0]!='' && $value[0]!='/' && $value[1]!='/' && $value[1]!='/'){
					fwrite($file, "<slide>\n");
                    fwrite($file, "<langue>".str_replace('&', '&amp;', $value[0])."</langue>\n");
                    fwrite($file, "<alt>".str_replace('&', '&amp;', $value[1])."</alt>\n");
					fwrite($file, "<img>".str_replace('&', '&amp;', $value[3])."</img>\n");
					fwrite($file, "<url>".str_replace('&', '&amp;', $value[4])."</url>\n");
					fwrite($file, "<target>".str_replace('&', '&amp;', $value[2])."</target>\n");
					fwrite($file, "</slide>\n");
				}
			}
			fwrite($file, "</slides>\n");
			fclose($file);
		}
	}

	public function LireXml(){
		$xml = simplexml_load_file(_PS_MODULE_DIR_.$this->name.'/slides.xml');
		$i=0;
		foreach($xml->slide as $slide){
			array_push($this->tabUrl, array($slide->langue,
											str_replace('&amp;', '&', $slide->alt),
											str_replace('&amp;', '&', $slide->target), 
											str_replace('&amp;', '&', $slide->img), 
											str_replace('&amp;', '&', $slide->url)));
			$i++;
		}
	}

	/**
	* Returns module content
	*
	* @param array $params Parameters
	* @return string Content
	*/
	function hookHome($params)
	{
		global $smarty, $cookie;
                $xml = simplexml_load_file(_PS_MODULE_DIR_.$this->name.'/slides.xml');
                $tabUrl = array();
                foreach($xml->slide as $slid){
                    if($slid->langue==$cookie->id_lang) array_push($tabUrl, array('img' => str_replace('&amp;', '&', $slid->img), 'url' => str_replace('&amp;', '&', $slid->url), 'alt' => str_replace('&amp;', '&', $slid->alt), 'target' => str_replace('&amp;', '&', $slid->target)));
                }
                $smarty->assign(array(
                    'slides' => $tabUrl));

		return $this->display(__FILE__, 'olcjqueryslider.tpl');
	}

}

?>
