<?php
Class Crapport {
	static $quick_destinataire="raph@e-frogg.com,paul@e-frogg.fr";

	public $destinataires ;
	public $traces;
	private $niveaux_traces;
	public $sortie_direct;
	private $deb_bloc="<div style=\"color:#000;width:600px;border:solid 1px #aaa;margin:5px;padding:5px;font-family:Arial;font-size:small;#STYLE\">";
	private $fin_bloc="</div>";
	private $style_normal="background:#eee;";
	private $style_erreur="background:#FDD;";
	private $style_rouge="background:#FDD;";
	private $style_important="background:#CCC;";
	private $style_h1="font-weight:bold;font-size:20px;";
	private $style_plus="background:#DDD;";
	private $style_orange="background:orange;";
	private $style_vert="background:#DFD;";
	private $style_bleu="background:#CCF;";
	public $charset="utf-8";
	static $ISO = "iso-8859-1";
	static $UTF = "utf-8";

	public $en_erreur = false;

	function Crapport() {
		$sortie_direct = false;
		$this->traces = array();
		$this->destinataires = array();
		$this->niveaux_traces = array();

	}

	public function Add_saut_de_ligne($niveau=0) {
		$trace="<div style='height:30px;width:100%'>&nbsp;</div>";
		array_push($this->niveaux_traces,$niveau);
		array_push($this->traces,$trace);
		if($this->sortie_direct) {
			echo $trace;
			ob_flush();
			flush();
		}
	}

	public function Add_trace_tab($str,$niveau=0,$style="normal",$nb_tab=1) {
		$this->Add_trace($str,$niveau,$style,$nb_tab*50);
	}
	/**
	 * @param style : "normal", "erreur","important";
	 */
	public function Add_trace($str,$niveau=0,$style="normal",$dx=0) {
		$this->add_begin_bloc(date("d/m/Y H:i:s")."<br>".$str,$niveau,$style,$dx);
		$this->add_end_bloc($niveau);
	}

	function add_begin_bloc($str="",$niveau=0,$style="normal",$dx=0) {
		$styles=explode(" ",$style);
		$le_style_css="";
		$styledx = "";
		foreach($styles as $un_style) {
			$le_style_css.=$this->{"style_$un_style"};
		}
		$id_trace=count($this->traces);
		if($dx>0) $styledx=";margin-left:{$dx}px;";

		$deb_bloc=str_replace("#STYLE",$styledx.$le_style_css,$this->deb_bloc);
		$this->add_str($deb_bloc,$niveau);
		$this->add_str($str,$niveau);

	}
	function add_end_bloc($niveau=0) {
		$this->add_str($this->fin_bloc,$niveau);
	}
	function add_str($str,$niveau=0) {
		array_push($this->niveaux_traces,$niveau);
		array_push($this->traces,$str);
		if($this->sortie_direct) {
			echo $str;
			ob_flush();
			flush();
		}
	}

	public function Add_destinataire($destinataire) {
		array_push($this->destinataires,$destinataire);
	}
	public function Envoie($titre,$erreur=false,$print=false,$ajoute_infos_serveur=false,$niveau_mini=0,$niveau_maxi=99) {
		$titre=($erreur?"ERREUR":"RAPPORT")." $titre";
		// params get et post
		$msg=$this->out($titre,$erreur,$print,$ajoute_infos_serveur,$niveau_mini,$niveau_maxi);
		// envoi mail

		$header = "From: rapport {$_SERVER[HTTP_HOST]}<rapports@e-frogg.com>\n";
		//		$header .= "MIME-version: 1.0\n";
		$header .= "Content-type: text/html; charset= \"".$this->charset."\"";
		@mail(implode(",",$this->destinataires),$titre,$msg,$header);

	}
	public function outFloating($titre,$erreur=false,$print=false,$ajoute_infos_serveur=false,$niveau_mini=0,$niveau_maxi=99) {
		$id=Crapport::$id_floating++;
		$color=$erreur?"#FFAAAA":"#AAAAFF";
//		$retour= '<script type="text/javascript" src="/js/site/drag.js"></script>
		$retour= '<div style="position: absolute; background-color: '.$color.';border:solid 1px #333; opacity: 0.8; z-index: 99999; top: '.($id*20).'px;width:730px;height:auto;min-width:200px;">
		<div onclick=" var noeud = getElementById(\'contenuStats_'.$id.'\');noeud.style.display=(noeud.style.display==\'none\'?\'block\':\'none\');"
			style="position: relative; cursor:pointer; width: auto; background-color:'.$color.';">'.$titre.'
		<div onclick="this.parentNode.parentNode.style.display=\'none\'" style="position:absolute;right:0;background-color:#F88;color:#000">&nbsp;<b>X</b>&nbsp;</div></div>
		<div id="contenuStats_'.$id.'" style="width:100%;display:none;height:600px;overflow:auto">';
		//<script type="text/javascript">makeDraggable(getElementById(\'contenuStats_'.$id.'\'))</script>';
		$retour.=$this->out($titre,$erreur,false,$ajoute_infos_serveur,$niveau_mini,$niveau_maxi);
		$retour.= "</div></div>";
		if(!$print) return $retour; 
		echo $retour;

	}
	
	public function out($titre,$erreur=false,$print=false,$ajoute_infos_serveur=false,$niveau_mini=0,$niveau_maxi=99) {
		if($ajoute_infos_serveur) {
			$str_params="";
			$tab_params=array_merge($_GET,$_POST);
			$tab_params_out=array();
			foreach($tab_params as $key=>$value) {
				$tab_params_out[]="$key=".urlencode($value);
			}
			$str_params=implode("&",$tab_params_out);
			$str_requete="http://{$_SERVER[HTTP_HOST]}{$_SERVER[SCRIPT_NAME]}?$str_params";
			$this->Add_trace("<h2>requete</h2><a href='$str_requete'>$str_requete</a>");
			//
			$this->Add_trace("<h2>\$_SERVER : </h2>".print_rr($_SERVER,true));
			$this->Add_trace("<h2>\$_REQUEST : </h2>".print_rr($_REQUEST,true));
			$this->Add_trace("<h2>\PILE : </h2>".print_rr(debug_backtrace2(),true));
			//
		}

		$traces_affichees=array();
		for($i=0;$i<count($this->traces);$i++) {
			$niv=$this->niveaux_traces[$i];
			if(($niv>=$niveau_mini) && ($niv<=$niveau_maxi)) {
				$traces_affichees[] = $this->traces[$i];
			}
		}
		$msg="<div align='center'><div style='width:600px' align='left'>";
		$msg.=implode("",$traces_affichees);
		$msg.="</div></div>";
		if($print && !isset($_GET['norapport'])) {
			print( "<h1>$titre</h1><h2>".date("d/m/Y H:i:s")."</h2><p>$msg</p>");
		}
		return "<h1>$titre</h1><h2>".date("d/m/Y H:i:s")."</h2><p>$msg</p>";
	}



	/*
	 * static
	 */

	static function quick_rapport_mail($titre,$str,$erreur=false,$print=false,$infos_serveur=false) {
		$rapport=new Crapport();
		$rapport->Add_destinataire(Crapport::$quick_destinataire);
		$rapport->Add_trace($str);
		$rapport->Envoie($titre,$erreur,$print,$infos_serveur);
	}

	static $static_rapport;
	private static $id_floating = 0;
	static function init() {
		if(!isset(Crapport::$static_rapport)) {
			Crapport::$static_rapport = new Crapport();
		}
	}
	static function trace($str,$niveau=0,$style="normal",$dx=0) {
		Crapport::init();
		Crapport::$static_rapport->Add_trace($str,$niveau,$style,$dx);
	}
	static function print_rr($tab,$niveau=0,$style="normal",$dx=0) {
		Crapport::trace(print_rr($tab,true),$niveau,$style,$dx);
	}
	static function trace_tab($str,$niveau=0,$style="normal",$nbtab=0) {
		trace($str,$niveau,$style,$nbtab*50);
	}
	static function writeFloating($niveau_mini=0,$niveau_maxi=99) {
		if(isset(Crapport::$static_rapport) && DEBUGGER)
		Crapport::$static_rapport->outFloating("Rapport",false,true,false,$niveau_mini,$niveau_maxi);
	}

	static function write($niveau_mini=0,$niveau_maxi=99) {
		if(isset(Crapport::$static_rapport) && DEBUGGER)
		Crapport::$static_rapport->out("Rapport",false,true,false,$niveau_mini,$niveau_maxi);
	}
	static function begin_bloc($str="",$niveau=0,$style="normal") {
		Crapport::init();
		Crapport::$static_rapport->add_begin_bloc($str,$niveau,$style);
	}
	static function end_bloc($niveau=0) {
		Crapport::init();
		Crapport::$static_rapport->add_end_bloc($niveau);
	}
	static function str($str,$niveau=0) {
		Crapport::$static_rapport->add_str($str,$niveau);
	}
}

?>