<?php
/**
 * CBackup.class.php
 *
 * Permet d'effectuer une sauvegarde de la base de données
 * et ou des fichiers
 *
 * Si l'utilisateur est super, lui permet d'avoir un formulaire de
 * gestion des COptions liées à la classe.
 *
 * @Author Leoo
 * @Version 31/04/10
 */

class CBackup
{
	/**
	 * Constante de classe utilisée pour le choix des actions
	 *
	 * @var string
	 */
	const TYPE_SAVE_BDD = 'base';

	/**
	 * Constante de classe utilisée pour le choix des actions
	 *
	 * @var string
	 */
	const TYPE_SAVE_FICHIERS = 'fichier';

	/**
	 * Constante de classe utilisée pour le choix des actions
	 *
	 * @var string
	 */
	const TYPE_SAVE_ALL = 'les deux';

	/**
	 * Constante de classe utilisée pour le choix des actions
	 *
	 * @var string
	 */
	const SAUVE_DL_USER = 'http';

	/**
	 * Constante de classe utilisée pour le choix des actions
	 *
	 * @var string
	 */
	const SAUVE_UP_FTP = 'ftp';

	/**
	 * Constante de classe utilisée pour le choix des actions
	 *
	 * @var string
	 */
	const SAUVE_TMP_BACKUP = 'tmp_backup';

	/**
	 * Nom de la BDD à sauvegarder
	 *
	 * @var string
	 */
	public $nomBDD = null;

	/**
	 * Repertoire de base pour la sauvegarde des fichiers
	 *
	 * @var string
	 */
	public $repertoire = null;

	/**
	 * Type de sauvegarde à effectuer
	 * 1 = BDD uniquement
	 * 2 = Fichiers uniquement
	 * 3 = Les deux
	 *
	 * @var int
	 */
	private $TYPE_BACKUP = 'base';

	/**
	 * Format de la sauvegarde
	 * 1 = Téléchargement pour l'utilisateur
	 * 2 = Transfert sur serveur FTP
	 *
	 * @var int
	 */
	private $FORMAT_SAUVEGARDE = 'http';

	/**
	 * Format de sorti pour le fichier BDD Gzipper
	 *
	 * @var string
	 */
	private $patternFichierSortiBDD = 'BDD_#NOMBASE#_#DATE#.sql.gz';

	/**
	 * Pattern à utiliser pour le nomage du zip de sortie des fichiers
	 *
	 * @var string
	 */
	private $patternFichierSortiFiles = 'FICHIERS_#REPCLI#_#DATE#.zip';

	/**
	 * Nom de sorti final du backup de la BDD
	 *
	 * @var string.sql.gz
	 */
	public $vraiNomSorti = '';

	/**
	 * Nom du fichier zip de sorti
	 *
	 * @var string.zip
	 */
	public $nomZipFichierSorti ='';


	/**
	 * Tableau des pattern de tables à ne pas sauvegarder
	 *
	 * @var array(string)
	 */
	public $tabTableNonValides = array('^view');

	/**
	 * Tableau des pattern de fichiers à ne pas sauvegarder
	 *
	 * @var array(string)
	 */
	public $fichiersNonValides = array('*/redim/*','*.svn','*.cvs*','*/split/*','tmp_upload/*','tmp_backup/*');

	/**
	 * Ip ou Nom de domaine du serveur FTP
	 *
	 * @var string
	 */
	private $ipServeurFtp = null;

	/**
	 * Nom d'utilisateur du serveur FTP
	 *
	 * @var string
	 */
	private $userServeurFtp = null;

	/**
	 * Password du serveur FTP
	 *
	 * @var string
	 */
	private $passServeurFtp = null;

	/**
	 * Repertoire de base de sauvegarde des fichiers ( defaut : REP_CLIENT )
	 *
	 * @var string
	 */
	public $repBaseSauve;

	
	public $validateur;
	/**
	 * Si params null alors utiliser les methodes set
	 *
	 * @param string $nomBDD
	 * @param string $rep
	 */
	public function __construct($nomBDD = null, $rep = null)
	{
		if(!is_null($nomBDD))
		$this -> nomBDD = $nomBDD;
			
		if(!is_null($rep))
		$this -> repertoire = $rep;

		$this -> repBaseSauve = REP_CLIENT;
	}

	/**
	 * Test si une table ne match pas un pattern interdit
	 *
	 * @param string $nomTable
	 */
	private function testSiTableValide($nomTable)
	{
		return $this -> validateur -> isValid($nomTable);
	}

	/**
	 * Affiche le texte des taches à effectuer ( version <form> pour Super )
	 */
	public static function afficheOptionsDefaut()
	{
		if(!Cmodule_fsadmin::usr_a_droit_generique('cBackup.utilisation')) return false;
		if(!usr_est_super_admin())
		{
			$retour = '<input type="hidden" name="goBDD" value="1" /><h3>Taches à éffectuer : </h3>';
			$tab1 = COptions::recupereOption('backup.options.typesauvegarde');
			$tab2 = COptions::recupereOption('backup.options.sauverecuperation');

			switch($tab1['valeur'])
			{
				case self :: TYPE_SAVE_BDD:
					$retour .= '<span><strong>- Sauvegarde de la BDD  </strong></span><br />';
					break;
				case self :: TYPE_SAVE_FICHIERS:
					$retour .= '<span><strong>- Sauvegarde des fichiers  </strong></span><br />';
					break;
				case self :: TYPE_SAVE_ALL:
					$retour .= '<span><strong>- Sauvegarde de la BDD et des Fichiers </strong></span><br />';
					break;
			}

			switch($tab2['valeur'])
			{
				case self :: SAUVE_DL_USER:
					$retour .= '<span><strong>- Téléchargement direct du zip de la base </strong></span><input type="hidden" id="testDDL" value="1" /><br />';

					break;
				case self :: SAUVE_TMP_BACKUP:
					$retour .= '<span><strong>- Stockage sur le disque dur du serveur </strong></span><br />';

					break;
				case self :: SAUVE_UP_FTP:
					$tab3 = COptions::recupereOption('backup.options.ipserveurftp');
					$retour .= '<span><strong>- Transfert vers un serveur FTP distant ('.$tab3['valeur'].') </strong></span><br />';

					break;
			}

			return $retour;
		}
		else
		{
			$tab1 = COptions::recupereOption('backup.options.typesauvegarde');
			$tab2 = COptions::recupereOption('backup.options.sauverecuperation');
			$tab3 = COptions::recupereOption('backup.options.repertoiresauvegarde');
			$tab4 = COptions::recupereOption('backup.options.ipserveurftp');
			$tab5 = COptions::recupereOption('backup.options.userserveurftp');
			$tab6 = COptions::recupereOption('backup.options.passserveurftp');

			// superman
			$html = '<h3>Taches à éffectuer : </h3><hr />';
			$html .= '<input type="hidden" name="iamsuperman" value="1" /><p>';
			$html .= '<label class="labBack">Type de sauvegarde : </label>';
			$html .= '<select name="choixType">';
			$sel = (self :: TYPE_SAVE_BDD == $tab1['valeur'])? 'selected="selected"' : '';
			$html .= '<option '.$sel.' value="'.self :: TYPE_SAVE_BDD.'">'.self :: TYPE_SAVE_BDD.'</option>';
			$sel = (self :: TYPE_SAVE_FICHIERS == $tab1['valeur'])? 'selected="selected"' : '';
			$html .= '<option '.$sel.' value="'.self :: TYPE_SAVE_FICHIERS.'">'.self :: TYPE_SAVE_FICHIERS.'</option>';
			$sel = (self :: TYPE_SAVE_ALL == $tab1['valeur'])? 'selected="selected"' : '';
			$html .= '<option '.$sel.' value="'.self :: TYPE_SAVE_ALL.'">'.self :: TYPE_SAVE_ALL.'</option>';
			$html .= '</select>';
			$html .= '</p>';
			$html .= '<p>';
			$html .= '<label class="labBack">Methode de sauvegarde : </label>';
			$html .= '<select name="choixMeth">';
			$sel = (self :: SAUVE_DL_USER == $tab2['valeur'])? 'selected="selected"' : '';
			$html .= '<option '.$sel.' value="'.self :: SAUVE_DL_USER.'">'.self :: SAUVE_DL_USER.'</option>';
			$sel = (self :: SAUVE_UP_FTP == $tab2['valeur'])? 'selected="selected"' : '';
			$html .= '<option '.$sel.' value="'.self :: SAUVE_UP_FTP.'">'.self :: SAUVE_UP_FTP.'</option>';
			$sel = (self :: SAUVE_TMP_BACKUP == $tab2['valeur'])? 'selected="selected"' : '';
			$html .= '<option '.$sel.' value="'.self :: SAUVE_TMP_BACKUP.'">'.self :: SAUVE_TMP_BACKUP.'</option>';
			$html .= '</select>';
			$html .= '</p>';
			$html .= '<p>';
			$html .= '<label class="labBack">Repertoire à sauvegarder : </label>';
			$html .= '<select name="choixRep">';
			$sel = (REP_CLIENT == $tab3['valeur'])? 'selected="selected"' : '';
			$html .= '<option '.$sel.' value="'.REP_CLIENT.'">'.REP_CLIENT.'</option>';
			$sel = ('./' == $tab3['valeur'])? 'selected="selected"' : '';
			$html .= '<option '.$sel.' value="./">Racine FSE</option>';
			$html .= '</select>';
			$html .= '</p>';
			$html .= '<hr /><p><label><b>Gestion du serveur distant</b></label><br /><br />';
			$html .= '<label class="labBack">Adresse FTP : </label>';
			$html .= '<input type="text" name="ipserveurFTP" value="'.$tab4['valeur'].'" />';
			$html .= '</p>';
			$html .= '<p>';
			$html .= '<label class="labBack">Login FTP : </label>';
			$html .= '<input type="text" name="loginserveurFTP" value="'.$tab5['valeur'].'" />';
			$html .= '</p>';
			$html .= '<p>';
			$html .= '<label class="labBack">Password FTP : </label>';
			$html .= '<input type="password" name="passserveurFTP" value="" />(Pas de changement si vide)';
			$html .= '</p>';
			return $html;
		}
	}
	public static function parseFormResultAjax()
	{
		if(!Cmodule_fsadmin::usr_a_droit_generique('cBackup.utilisation')) return false;
		$var = self :: parseFormResult(true);
		$var = str_replace('<h3 style="color: green;">', '', $var);
		$var = str_replace('</h3>', '', $var);
		echo CMessages :: ajoute_message($var);
	}
	/**
	 * Parse les resultat du formulaire et effectue les opérations demandées
	 */
	public static function parseFormResult($ajax = false)
	{
		if(!Cmodule_fsadmin::usr_a_droit_generique('cBackup.utilisation')) return false;
		$retour = '';
		$o = new CBackup(BDD_BASE);
		
		if(!empty($_POST['choixRep'])){
			$o -> repBaseSauve = $_POST['choixRep'];
		}
		if(isset($_POST['goBDD']) && !usr_est_super_admin())
		{
			$tab1 = COptions::recupereOption('backup.options.typesauvegarde');
			$tab2 = COptions::recupereOption('backup.options.sauverecuperation');

			$o -> setTypeBackup($tab1['valeur']);

			if($tab2['valeur'] == 'ftp')
			{
				$tab3 = COptions::recupereOption('backup.options.ipserveurftp');
				$tab4 = COptions::recupereOption('backup.options.userserveurftp');
				$tab5 = COptions::recupereOption('backup.options.passserveurftp');


				$o -> setIpServeur($tab3['valeur']);
				$o -> setLoginServeur($tab4['valeur']);
				$o -> setPasswordServeur($tab5['valeur']);
			}
			$o -> setFormatBackup($tab2['valeur']);

			$o -> effectueBackup($ajax);


			$retour = '<h3 style="color: green;">Sauvegarde éfféctuée avec succés!</h3>';
		}
		elseif(isset($_POST['iamsuperman']) && usr_est_super_admin())
		{
			if(isset($_POST['saveParamsDefaut']))
			{
				COptions::setChampOption('backup.options.typesauvegarde', array('valeur'), array($_POST['choixType']));
				COptions::setChampOption('backup.options.sauverecuperation', array('valeur'), array($_POST['choixMeth']));
				COptions::setChampOption('backup.options.repertoiresauvegarde', array('valeur'), array($_POST['choixRep']));
				if(isset($_POST['excluTables']))
				COptions::setChampOption('backup.options.exclusiontables', array('valeur'), array($_POST['excluTables']));
				if(isset($_POST['excluFichier']))
				COptions::setChampOption('backup.options.exclusionfichiers', array('valeur'), array($_POST['excluFichier']));
				if(isset($_POST['ipserveurFTP']))
				COptions::setChampOption('backup.options.ipserveurftp', array('valeur'), array($_POST['ipserveurFTP']));
				if(isset($_POST['loginserveurFTP']))
				COptions::setChampOption('backup.options.userserveurftp', array('valeur'), array($_POST['loginserveurFTP']));
				if(!empty($_POST['passserveurFTP']))
				COptions::setChampOption('backup.options.passserveurftp', array('valeur'), array($_POST['passserveurFTP']));

				return '<h3 style="color: green;">Paramètres sauvegardés!</h3>';
			}
			else
			{
				if(!empty($_POST['excluTables']))
				{
					$tab = explode("\n",$_POST['excluTables']);
					$o -> tabTableNonValides = array_merge($o -> tabTableNonValides, $tab);
				}

				if(!empty($_POST['excluFichier']))
				{
					$tab = explode("\n",$_POST['excluFichier']);
					$o -> fichiersNonValides = array_merge($o -> fichiersNonValides, $tab);
				}
				$o -> validateur = new CExclusionManager(implode("\n",$o -> tabTableNonValides));
				$o -> setTypeBackup($_POST['choixType']);
				$o -> setFormatBackup($_POST['choixMeth']);
				if($_POST['choixMeth'] == self :: SAUVE_UP_FTP)
				{
					$tab3 = COptions::recupereOption('backup.options.ipserveurftp');
					$tab4 = COptions::recupereOption('backup.options.userserveurftp');
					$tab5 = COptions::recupereOption('backup.options.passserveurftp');


					$o -> setIpServeur($tab3['valeur']);
					$o -> setLoginServeur($tab4['valeur']);
					$o -> setPasswordServeur($tab5['valeur']);
				}

				$o -> effectueBackup($ajax);
				$retour = '<h3 style="color: green;">Sauvegarde éfféctuée avec succés!</h3>';
			}
		}

		if($_POST['choixMeth'] == self :: SAUVE_TMP_BACKUP)
		{
//			creeRepSiExistePas('tmp_backup');
//			@rename($o -> nomZipFichierSorti,'tmp_backup/'.$o -> nomZipFichierSorti);
//			@rename($o -> vraiNomSorti,'tmp_backup/'.$o -> vraiNomSorti);
//			
			$retour = '<h3 style="color: green;">Sauvegarde éfféctuée avec succés!</h3>';
		}
		else
		{
			if(!empty($o -> nomZipFichierSorti))
			@unlink($o -> nomZipFichierSorti);
			//if(!empty($o -> vraiNomSorti))
			//@unlink($o -> vraiNomSorti);
		}
		return $retour;
	}

	/**
	 * Modifier l'ip du serveur FTP
	 *
	 * @param string $input
	 */
	public function setIpServeur($input)
	{
		$this -> ipServeurFtp = $input;
	}

	/**
	 * Modifier le login ftp
	 *
	 * @param string $input
	 */
	public function setLoginServeur($input)
	{
		$this -> userServeurFtp = $input;
	}

	/**
	 * Modifier le password FTP
	 *
	 * @param string $input
	 */
	public function setPasswordServeur($input)
	{
		$this -> passServeurFtp = $input;
	}

	/**
	 * Affiche les deux textarea avec le contenu des exclusions par defaut
	 */
	public static function getListeExclusion()
	{
		if(usr_est_super_admin())
		{
			$o = new CBackup(BDD_BASE);
			$t1 = COptions::recupereChampsOption('backup.options.exclusionfichiers', 'valeur');
			$t2 = COptions::recupereChampsOption('backup.options.exclusiontables', 'valeur');
			$html = '<p>';
			$html .= '<label><b>Exclusion de tables (Regex PHP)</b></label>';
			$html .= '</p><p><textarea style="width: 250px; height: 100px;" name="excluTables">'.$t2['valeur'].'</textarea>';
			$html .= 'Defaut : '.htmlspecialchars(implode(',',$o ->tabTableNonValides)).'</p>';
			$html .= '<p>';
			$html .= '<label><b>Exclusion de fichier (Pattern linux)</b></label>';
			$html .= '</p><p><textarea style="width: 250px; height: 100px;" name="excluFichier">'.$t1['valeur'].'</textarea>';
			$html .= 'Defaut : '.implode(',',$o ->fichiersNonValides).'</p>';
			$html .= '<div style="display: none;"><hr /><input type="checkbox" id="checkb0xParam" name="saveParamsDefaut"/><label>Enregistrer comme paramètre par defaut pour le client ? <br /><br /><sub style="color: red;">ATTENTION : l\'enregistrement des paramètres empêche la sauvegarde de s\'effectuer</sub></label><hr /><br /><br /></div>';

			return $html;
		}
		return '';
	}

	/**
	 * Type de backup à effectuer
	 *
	 * @param string $newType
	 */
	public function setTypeBackup($newType)
	{
		$this -> TYPE_BACKUP = $newType;
	}

	/**
	 * Format de sauvegarde à affecter
	 *
	 * @param string $newFormat
	 */
	public function setFormatBackup($newFormat)
	{
		$this -> FORMAT_SAUVEGARDE = $newFormat;
	}

	/**
	 * Lance le traitement du backup
	 */
	public function effectueBackup($ajax = false)
	{
		if(!Cmodule_fsadmin::usr_a_droit_generique('cBackup.utilisation')) return false;
		switch($this -> TYPE_BACKUP)
		{
			case self :: TYPE_SAVE_BDD:
				if(!is_null($this -> nomBDD))
				$this -> backupBDD();
				break;
			case self :: TYPE_SAVE_FICHIERS:
				// backup Fichiers
				$this -> creerFichierZip('-1');
				break;
			case self :: TYPE_SAVE_ALL:
				if(!is_null($this -> nomBDD))
				$this -> backupBDD();
				$this -> creerFichierZip('-1');

				break;
		}
		switch($this -> FORMAT_SAUVEGARDE)
		{
			case self :: SAUVE_DL_USER:
				if($ajax)
				echo '<iframe style="display:none" src="/ajax.php?action=base.CBackup.downloadBackupBDD&fich='.$this -> vraiNomSorti.'"></iframe>';
				else
				$this -> downloadBackupBDD($this -> vraiNomSorti);
				//$this -> downloadBackupBDD($this -> nomZipFichierSorti);
				break;
			case self :: SAUVE_UP_FTP:
				if(($this -> TYPE_BACKUP == self :: TYPE_SAVE_BDD) or ($this -> TYPE_BACKUP == self :: TYPE_SAVE_ALL))
				$this -> uploadFTP($this -> ipServeurFtp,$this -> userServeurFtp,$this -> passServeurFtp,$this -> vraiNomSorti);

				if(($this -> TYPE_BACKUP == self :: TYPE_SAVE_FICHIERS) or ($this -> TYPE_BACKUP == self :: TYPE_SAVE_ALL))
				$this -> uploadFTP($this -> ipServeurFtp,$this -> userServeurFtp,$this -> passServeurFtp,$this -> nomZipFichierSorti);
				break;
		}
	}

	/**
	 * Transfert un fichier sur un serveur FTP distant
	 *
	 * @param string $serveur
	 * @param string $user
	 * @param string $password
	 * @param string $nomFichier
	 */
	private function uploadFTP($serveur, $user, $password, $nomFichier)
	{
		$connex = ftp_connect($serveur);
		$login = ftp_login($connex, $user, $password);

		if(!$connex or !$login)
			return false;
		else
		{
			
			ftp_mkdir($connex, 'BACKUP');
			ftp_mkdir($connex, 'BACKUP/auto/');
			ftp_mkdir($connex, 'BACKUP/auto/'.REP_CLIENT);
			ftp_mkdir($connex, 'BACKUP/auto/'.REP_CLIENT.'/'.date('d_m_Y'));
			if(ftp_put($connex, 'BACKUP/auto/'.REP_CLIENT.'/'.date('d_m_Y').'/'.$nomFichier, RACINE_WWW.'tmp_backup/'.$nomFichier,FTP_BINARY))
			{
				if(file_exists(RACINE_WWW.'tmp_backup/'.$nomFichier)) unlink(RACINE_WWW.'tmp_backup/'.$nomFichier);
				return true;
			}
			else
				return false;
		}
	}

	/**
	 * Sauvegarde la base de données choisie et stock le nom du fichier dans la variable membre $vraiNomSorti
	 */
	protected function backupBDD()
	{
		$nomFichierSorti = str_replace(array('#NOMBASE#','#DATE#'),array($this -> nomBDD,date('d_m_Y_H\hi')),$this -> patternFichierSortiBDD);
		$this -> vraiNomSorti = $nomFichierSorti;
		
		@unlink($nomFichierSorti);
		$tables = mysql_list_tables($this -> nomBDD);
		creeRepSiExistePas(RACINE_WWW.'tmp_backup/');
		$zp = gzopen(RACINE_WWW.'tmp_backup/'.$nomFichierSorti, "w6");
		while ($donnees = mysql_fetch_array($tables, MYSQL_NUM))
		{
			if($this -> testSiTableValide($donnees[0]))
			{
				if($res=ifReq('SHOW CREATE TABLE '.$donnees[0]))
				{
					while ($row = mysql_fetch_array($res, MYSQL_NUM))
					{
						$createTable = $row[1].";\n\n";
						gzwrite($zp, $createTable);

						if($res2=ifReq('SELECT * FROM '.$donnees[0]))
						{
							$nbr_champs = mysql_num_fields($res2);
							while ($row2 = mysql_fetch_array($res2, MYSQL_NUM))
							{
								$ecrire ='INSERT INTO '.$donnees[0].' VALUES (';
								foreach($row2 as $uneColonne)
								$ecrire .= '\''.mysql_real_escape_string($uneColonne).'\',';
								$ecrire = substr($ecrire, 0, -1);
								$ecrire .= ");\n";
								gzwrite($zp, $ecrire);
							}
						}
					}
				}
			}
		}
		gzclose($zp);


	}

	/**
	 * Renvoi le fichier au client en forgeant les header HTTP pour un force download
	 * @param string $fichier
	 */
	public function downloadBackupBDD($fichier = '')
	{
		if(!Cmodule_fsadmin::usr_a_droit_generique('cBackup.utilisation')) return false;

		if(empty($fichier)) $fichier = $_REQUEST['fich'];
		if (((strpos($fichier, '.sql.gz') !== false)||(strpos($fichier, '.zip') !== false)) && ($fichier != "") && (file_exists(RACINE_WWW."tmp_backup/" . basename($fichier))))
		{
			$size = filesize(RACINE_WWW."tmp_backup/" . basename($fichier));
			header("Content-Type: application/force-download; name=\"" . basename($fichier) . "\"");
			header("Content-Transfer-Encoding: binary");
			header("Content-Length: $size");
			header("Content-Disposition: attachment; filename=\"" . basename($fichier) . "\"");
			header("Expires: 0");
			header("Cache-Control: no-cache, must-revalidate");
			header("Pragma: no-cache");
			readfile(RACINE_WWW."tmp_backup/" . basename($fichier));

			@unlink(RACINE_WWW."tmp_backup/" .$fichier);
			exit();
		}
		else
		{
			echo 'pas ok';
		}
	}
	public function getHTMLButton()
	{
		$h = '<a href="#" id="btSubmitBack" class="a_bt">Lancer la sauvegarde !</a>';
		if(usr_est_super_admin())
		$h .= '&nbsp;&nbsp;&nbsp;<a href="#" id="btSubmitParam" class="a_bt">Sauver les paramètres</a>';
		return $h;
	}
	/**
	 * Créer un zip en fonction des variables membres
	 *	(utilise 'zip' via shell_exec()
	 */
	public function creerFichierZip($commandeEnPlus = null)
	{
		if(!Cmodule_fsadmin::usr_a_droit_generique('cBackup.utilisation')) return false;
		creeRepSiExistePas(RACINE_WWW.'tmp_backup');
		$listExclusion = $this -> fichiersNonValides;
		$repertoire = $this -> repBaseSauve;
		$nomDuFichierZip = str_replace('/','',str_replace(array('#REPCLI#','#DATE#'),array(REP_CLIENT,date('d_m_Y_H\hi')),$this -> patternFichierSortiFiles));
		$this -> nomZipFichierSorti = $nomDuFichierZip;
		$exclusionFichiers = '';
		if(is_array($listExclusion))
		$exclusionFichiers = " -x '".implode("' '",$listExclusion)."' ";
		//$exclusionFichiers = " -x '*/redim*' '*.svn' '*.cvs' '*/split*' ".$listExclusion;

		$comm = "zip -r ".RACINE_WWW."tmp_backup/".$nomDuFichierZip." ".$repertoire.$exclusionFichiers.' '.$commandeEnPlus;
	
		$result = shell_exec($comm);
		return (empty($result))? false : true;
	}

	public static function contenuOngletPrincipal()
	{	
		if(!Cmodule_fsadmin::usr_a_droit_generique('cBackup.utilisation')) return false;

		if(usr_est_super_admin())
			CEcho::echo_jsready(file_get_contents('modules/base/www/js/cbackup.super.js'));
		else
			CEcho::echo_jsready(file_get_contents('modules/base/www/js/cbackup.user.js'));
	
		echo Cmodule :: ajoute_blocs_html_modules(file_get_contents('modules/base/www/html_fichiers/cbackup.fsadmin.main.html'));
		}
}
?>