<?php

require_once("modules/Cmodule.class.php");
class Cmodule_mobile extends Cmodule {
	var $nom = "module mobile";
	var $identifiant = "mobile" ;
	var $modules_dependants=array("base");
	private static $sousDomaine = 'm';
	private static $pathFichiersMobiles = 'm';

	private static $tabSousDomaines = array('mobile'=>'m', 'tablet'=>'www');
	private static $tabPathFichiers = array('mobile'=>'m', 'tablet'=>'www');
	private static $tabPathParentFichiers = array('tablet'=>'mobile');

	public static $url_page_mobile = "";
	public static $url_page_normal = "";

	const NOM_PARAM_GET_FORCE_VERSION = "useVersion";

	public function __init() {
		// qqe soit le script appelé, on fait bien la detection
		CSite::get_type_site();

	}

	public static function forceVersion($typeNav) {
		setcookie('useVersion', $typeNav, time()+3600);
		$_COOKIE['useVersion'] = $typeNav;
	}
	public static function isVersionForcee($typeNav) {
		return (isset($_COOKIE['useVersion']) && $_COOKIE['useVersion'] == $typeNav);
	}

	public static function detecteMedia() {
		$modClient = Cmodule::get_module(CLIENT);
		if (!in_array('mobile',$modClient->modules_dependants)) return;
		//if (Cmodule::get_module(CLIENT))


		//detecte domaine et soud domaine de l'url
		$split = explode('.',$_SERVER["HTTP_HOST"]);
		$domaine = array_pop($split);
		if ($domaine != 'localhost') $domaine = array_pop($split).".$domaine";
		$sousDomaineActuel = implode('.',$split);

		//type site existant en bdd qui vient de l'url
		$typeSiteBDD = CSite::get_type_site();


		$memeSiteReferer = preg_match("/$domaine/",$_SERVER["HTTP_REFERER"]);
		if ($memeSiteReferer) return;

		//detecte le user agent
		$typeNav = self::get_type_navigateur();

		if(isset($_GET[self :: NOM_PARAM_GET_FORCE_VERSION])) {
			self :: forceVersion($typeSiteBDD);
		}
//		echo "typeNav : $typeNav";
//		log_requete_ok('CSite::get_type_site():'.CSite::get_type_site());

//		echo "<br>--$typeNav == $typeSiteBDD--";
		if ($typeNav == $typeSiteBDD || self :: isVersionForcee($typeSiteBDD)) return;



		//le sous domaine qu'on veut pour tel user agent
		$sousDomaineUA = self::$tabSousDomaines[$typeNav];
		//print_r(self::$tabSousDomaines);

//		echo "<br>--- $sousDomaineActuel != $sousDomaineUA ---";
		// redirection si pas le mm sous domaine
		if ($sousDomaineActuel != $sousDomaineUA) {
			if (!empty($sousDomaineUA)) $sousDomaineUA .= '.';
			$redirectURL = "http://".$sousDomaineUA."$domaine".$_SERVER["REQUEST_URI"];
			/*exit( ">>". $redirectURL);*/
			CSite::redirige($redirectURL,true);
		}
		return;

		/*		// repérage version mobile et domaine
		preg_match("/^(".$sousDomaineUA."[.])?(.+)/",$_SERVER["HTTP_HOST"],$result);


		$domaine = $result[2];
//		log_requete_ok("__ $sousDomaine _ $domaine");

		if (CSite::get_type_site() != $typeNav) {
			// si le type ne correspond pas
			$memeSiteReferer = preg_match("/$domaine/",$_SERVER["HTTP_REFERER"]);
//				echo "<br>meme site : $memeSiteReferer<br>";
//				echo "<br>domaine : $domaine<br>";
			if(!$memeSiteReferer) {

				print_r($result);

				// et qu'on vient d'un site externe
				// $result
				//	[0] => m.localhost
				//	[1] => m.
				//	[2] => localhost

				//	[0] => m.e-frogg.com
				//	[1] => m.
				//	[2] => e-frogg.com

				//	[0] => e-frogg.com
				//	[1] => e-frogg
				//	[2] => .com

				foreach (Cmodule_mobile::$tabSousDomaines as $sousDom) {
					if (strpos($domaine,$sousDom.'.') === 0)
						$domaine = substr($domaine, strlen($sousDom)+1);
				}
//				log_requete_ok('apres transfo domaine='.$domaine);

				if(strlen($result[1])) {
//						echo "<br>redirige normal";
					$expl = explode('.',$domaine);
					if (count($expl) > 2) {
						$lngd = count($expl);
						$domaine = $expl[$lngd-2].'.'.$expl[$lngd-1];
//						echo "expl0 = $expl[0], expl1 = $expl[1], expl2 = $expl[2], expl3 = $expl[3]";
					}
//					echo "__ $domaine __ $sousDomaine";

					$redirectURL = "http://".$sousDomaine.".$domaine".$_SERVER["REQUEST_URI"];
					log_requete_ok('cas 1 '.$redirectURL);
				} else {
//						echo "redirige mobile";
					$expl = explode('.',$domaine);
					if (count($expl) > 2) {
						$lngd = count($expl);
						$domaine = $expl[$lngd-2].'.'.$expl[$lngd-1];
//						echo "expl0 = $expl[0], expl1 = $expl[1], expl2 = $expl[2], expl3 = $expl[3]";
					}
					$redirectURL = "http://".$sousDomaine.".$domaine".$_SERVER["REQUEST_URI"];
//					log_requete_ok('cas 2 '.$redirectURL);
//					echo "redirige vers $redirectURL";
				}
				$redirectURL = str_replace('://.','://',$redirectURL);
//				echo $redirectURL;

//				exit();
			}
		}
		// variables à réutiliser pour swich de version (intégrer dans le pied de page ?)
		self::$url_page_mobile = "http://".$sousDomaine.".$domaine".$_SERVER["REQUEST_URI"]; // http://m.locahlost/....
		self::$url_page_normal = "http://$domaine".$_SERVER["REQUEST_URI"]; // http://m.locahlost/....

		// TODO : virer !
//		echo "<br><a href='".self::$url_page_mobile."'>version mobile</a>";
//		echo "<br><a href='".self::$url_page_normal."'>version normale</a>";*/
	}

	public static function getUrlPageMobile() { return self::$url_page_mobile; }
	public static function getUrlPageStandard() { return self::$url_page_normal; }

	public static function get_type_navigateur() {
		//echo 'on passe !';
		if (preg_match("/(android|iphone|ipod)/i", $_SERVER['HTTP_USER_AGENT'])) {
			log_requete_ok("TYPE NAVIG = MOBILE !!!");
			return 'mobile';
		}
		else if (preg_match("/(ipad)/i", $_SERVER['HTTP_USER_AGENT'])) {
			log_requete_ok("TYPE NAVIG = TABLET !!!");
			return 'tablet';
		}

		log_requete_ok("TYPE NAVIG = STANDARD");
		return 'standard';
	}
	//GET type_navigateur (USER_AGENT)



	/**
	 * Permet d'utiliser les pages sur ma version mobile.
	 *
	 * NECESSITE :
	 * 	"mobile/modeles/NOMCLIENT_mobile.modele.htm"
	 *  "mobile/modeles/html_NOMCLIENT.rootmodele.htm"
	 *  "css/NOMCLIENT_mobile.css"
	 *
	 * @param string $nomClient
	 */
	public static function installePagesMobilesPourClient($nomClient)
	{
		$nomClient = strtoupper($nomClient);
		site_definit_modele_page($nomClient."_mobile",$nomClient,"mobile/modeles/".$nomClient."_mobile.modele.htm","$nomClient/".$nomClient."_mobile.css",10,"mobile/modeles/html_$nomClient.rootmodele.htm",NULL,"mobile");
		site_definit_page("accueil_mobile","(.*)",$nomClient,NULL, $nomClient."_mobile","site.CSite.pages_html_basic",'mobile',NULL,NULL,NULL,0);
	}
	public static function getIdSiteMobile()
	{
		if($res = testReq3("SELECT id_auto FROM site__sites WHERE detection = '^".self :: $sousDomaine.".'"))
		{
			return $res['id_auto'];
		}
		else
		{
			trace_erreur('CModule_mobile :: getIdSiteMobile  [Sous domaine pour mobile introuvable!]');
		}
	}
	public static function definitSousDomaine($sousDom)
	{
		if (is_array($sousDom)) {
			foreach ($sousDom as $key => $val) {
				self::$tabSousDomaines[$key] = $val;
			}
		}
		else self :: $sousDomaine['mobile'] = $sousDom;

		//self :: $sousDomaine = $path;
	}

	public static function definitCheminFichiersMobile($path)
	{
		if (is_array($path)) {
			foreach ($path as $key => $val) {
				self::$tabPathFichiers[$key] = $val;
			}
		}
		else self::$tabPathFichiers['mobile'] = $path;

		//self :: $pathFichiersMobiles = $path;
	}

	public static function definitTypeSiteParent($tab)
	{
		if (!is_array($tab)) return;

		self::$tabPathParentFichiers = $tab;
	}

	public static function installSiteSousDomaine()
	{
		CListes::insere_update("site_sites",array("detection"=>"^".self :: $sousDomaine.".","priorite"=>10,"titre"=>"Site Mobile Par Defaut","defaut"=>1,"actif"=>1,"identifiant"=>"page_mobile","type_site" => "mobile"),"identifiant='page_mobile'");
	}

	public static function getPathMobile()
	{

		if(CSite::$site_en_cours['type_site'] != 'standard') {
			//return self :: $pathFichiersMobiles.'/';
			return self::$tabPathFichiers[CSite::$site_en_cours['type_site']];
		}

		return '';
	}

	public static function getPathMobileParent()
	{

		if(CSite::$site_en_cours['type_site'] != 'standard') {
			//return self :: $pathFichiersMobiles.'/';
			return self::$tabPathFichiers[self::$tabPathParentFichiers[CSite::$site_en_cours['type_site']]];
		}

		return '';
	}
}
?>