<?php
class CFormulaire {
	protected $labels, $champs, $hidden,$descriptions;
	public $action="";
	public $target = "";
	public $method="POST";
	public $onsubmit="";
	public $hasupload=false;
	protected $valeurs_defaut;
	protected $valeurs_forcees;
	protected $prefixe="";

	//si on effectue la verif syntaxique ou pas
	protected $verif = false;

	static $RESTRICT_int="([0-9]+)";
	static $RESTRICT_num="([0-9.-]+)";
	static $RESTRICT_alpha="([0-9.- ]*)";
	static $RESTRICT_email="([0-9a-z.@_]*)";
	static $RESTRICT_tout='(.*)';

	static $VALID_email = '([\w.-_]+@[\w.-]+\.[a-zA-Z]{2,6})';
	static $VALID_tel_fr = '((0[1-9][-.\s]?(\d{2}[-.\s]?){3}\d{2})|(\+33[1-9][-.\s]?(\d{2}[-.\s]?){3}\d{2}))';
	static $VALID_date_fr = '([0-3][0-9]\/[0-1][0-9]\/[1-9][0-9]{3})';

	static $LARGEUR_DEFAUT = 200;


	public $useHelp = true;
	public function CFormulaire($action="",$method="POST",$target="") {
		$this->labels=array();
		$this->champs=array();
		$this->hidden=array();
		$this->descriptions=array();
		$this->action=$action;
		$this->method=$method;
		$this->target=$target;
		$this->valeurs_defaut=array();
		$this->valeurs_forcees=array();
	}
	public function add_onsubmit($str) {
		$this->onsubmit=$str;
	}

	/**
	 * precise seulement si il y aura génération d'une verif des champs.
	 * à exécuter au début de la création du formulaire, avant l'ajout des champs.
	 * @return unknown_type
	 */
	public function add_verif() {
		$this->verif = true;
	}

	public function set_prefixe_champs($pfx) {
		$this->prefixe=$pfx;
	}
	public function set_valeurs_defaut($valeurs_defaut) {
		//		if(is_array($valeurs_defaut))
		foreach($valeurs_defaut as $key=>$val)
		$this->valeurs_defaut[$key]=$val;
	}
	public function set_valeurs_forcees($valeurs_forcees) {
		//		if(is_array($valeurs_forcees))
		foreach($valeurs_forcees as $key=>$val)
		$this->valeurs_forcees[$key]=$val;
	}
	public function add_hidden($name,$value="", $valeur_defaut=NULL, $valeur_forcee=NULL) {
		if(!isNULL($valeur_defaut))
		$this->set_valeurs_defaut(array($name=>$valeur_defaut));
		else if(!isNULL($descriptions["valeur_defaut"]))
		$this->set_valeurs_defaut(array($name=>$descriptions["valeur_defaut"]));

		if(!isNULL($valeur_forcee))
		$this->set_valeurs_forcees(array($name=>$valeur_forcee));
			
		$this->hidden[]=$this->get_input($name,$value,"hidden");
	}
	public function add_text($label,$name,$value="",$descriptions=NULL, $valeur_defaut=NULL, $valeur_forcee=NULL) {
		$this->add_input($label,$name,$value,"text",NULL,NULL,$descriptions, $valeur_defaut, $valeur_forcee);
	}
	public function add_pass($label,$name,$value="",$descriptions=NULL, $valeur_defaut=NULL, $valeur_forcee=NULL) {
		$this->add_input($label,$name,$value,"password",NULL,NULL,$descriptions, $valeur_defaut, $valeur_forcee);
	}
	public function add_select($label,$name,$valeurs,$value="",$descriptions=NULL, $valeur_defaut=NULL, $valeur_forcee=NULL,$null_autorise = true) {
		if(!isNULL($valeur_defaut))
		$this->set_valeurs_defaut(array($name=>$valeur_defaut));
		else if(!isNULL($descriptions["valeur_defaut"]))
		$this->set_valeurs_defaut(array($name=>$descriptions["valeur_defaut"]));

		if(!isNULL($valeur_forcee))
		$this->set_valeurs_forcees(array($name=>$valeur_forcee));

		/*if($null_autorise) {
			$valeurs[]="NULL";
			$
			}*/
			
		$this->labels[]="$label";
		$this->champs[]=array("type"=>"select","label"=>$label,"name"=>$name,"valeurs"=>$valeurs,
				"value"=>$value,"descriptions"=>$descriptions);
		$this->descriptions[]=$descriptions;
	}



	public function add_bouton($texte="bouton",$name="bt",$params=NULL,$descriptions=NULL) {
		$this->add_input("",$name,$texte,"button",NULL,$params,$descriptions);
	}
	public function add_input($label,$name,$value="",$type="text",$restrict=NULL,$params=NULL,$descriptions=NULL, $valeur_defaut=NULL, $valeur_forcee=NULL, $attribut_suppl = '') {
		if(!isNULL($valeur_defaut))
		$this->set_valeurs_defaut(array($name=>$valeur_defaut));
		else if(!isNULL($descriptions["valeur_defaut"]))
		$this->set_valeurs_defaut(array($name=>$descriptions["valeur_defaut"]));

		if(!isNULL($valeur_forcee))
		$this->set_valeurs_forcees(array($name=>$valeur_forcee));
			
			
		if($type=="file" || $type=="image_upload") {
			$this->hasupload = true;
		}
		if(strpos($type,"pass")===0) {
			$type="password";
		}

		$this->labels[]=$label;
		//$this->champs[]=$this->get_input($name,$value,$type,$restrict,$params);
		$this->champs[]=array("type"=>$type,"label"=>$label,"name"=>$name,
				"value"=>$value,"descriptions"=>$descriptions,"restrict"=>$restrict,"params"=>$params, "attribut_suppl"=>$attribut_suppl);
		$this->descriptions[]=$descriptions;

	}

	public function add_upload($label,$name,$value="",$restrict=NULL,$params=NULL,$descriptions=NULL) {
		$this->labels[]=$label;
		//$this->champs[]=$this->get_input($name,$value,$type,$restrict,$params);
		$this->champs[]=array("type"=>"upload","label"=>$label,"name"=>$name,
				"value"=>$value,"descriptions"=>$descriptions,"restrict"=>$restrict,"params"=>$params);
		$this->descriptions[]=$descriptions;
	}

	public function add_checkbox($label,$name,$value="",$params=NULL,$descriptions=NULL, $valeur_defaut=NULL, $valeur_forcee=NULL) {

		if(!isNULL($valeur_defaut))
		$this->set_valeurs_defaut(array($name=>$valeur_defaut));
		else if(!isNULL($descriptions["valeur_defaut"]))
		$this->set_valeurs_defaut(array($name=>$descriptions["valeur_defaut"]));

		if(!isNULL($valeur_forcee))
		$this->set_valeurs_forcees(array($name=>$valeur_forcee));

		ifNULL($params,array());
		$this->labels[]=$label;
		$this->descriptions[]=$descriptions;
		$this->champs[]=array("type"=>"checkbox","label"=>$label,"name"=>$name,"valeurs"=>$valeurs,
				"value"=>$value,"descriptions"=>$descriptions,"params"=>$params, "statutchk_force"=>$statut_checked_force);
	}

	public function add_separateur($intitule="") {
		$this->labels[]="<br>$intitule<br>&nbsp;";
		$this->champs[]=array("type"=>"separateur");
		$this->descriptions[]="";

	}
	public function add_submit($texte="submit",$name="submit",$params=NULL,$descriptions=NULL) {
		$this->add_input("",$name,$texte,"submit",NULL,$params,$descriptions);
	}

	public function add_custom($texte="") {
		$this->add_input("",'',$texte,"custom");
	}


	/**
	 * ajoute les colonnes d'une table.
	 * @param $table
	 * @param $libelles : array("champ"=>"libelle")
	 * @param $evite : Array("ch","ch")
	 * @param $desctiprions : Array("champ"=>Array("libelle"=>...,"description"=>...,"position"=>..."regexp_validation"=>...),
	 *	 							"champ"=>Array("libelle"=>...,"description"=>...,"position"=>..."regexp_validation"=>...), ....)
	 * @return unknown_type
	 */
	public function add_colonnes_table($table,$descriptions=NULL,$evite=NULL) {
		//echo 'desc '.$table;
		$this->table = $table;
		ifNULL($evite,array());
		ifNULL($descriptions,array());

		if($q=ifReq("desc $table" )) {
			
			//$noms = mysql_fetch_column($q,"Field");
			//$types= mysql_fetch_column($q,"Type");
			while($res=mysql_fetch_assoc($q)) {
				//print_rr($res);
				$nom_colonne=$res["Field"];
				//echo "$nom_colonne";
				//print_rr($descriptions);
				$libelle=$nom_colonne;
				if(isset($descriptions[$nom_colonne])){
					$libelle=$descriptions[$nom_colonne];
					if(isset($libelle["libelle"]))
					$libelle=$libelle["libelle"];
				}
				//print_rr($evite);
				if(!in_array($nom_colonne,$evite) && !empty($descriptions[$nom_colonne]["table_lien"])) {
					//echo 'XX';
					$valeurs=CListes::getValeursCleEtrangere($descriptions[$nom_colonne]);
					if($descriptions[$nom_colonne]["null_autorise"]=="NULL") {
						//						$valeurs[$descriptions[$nom_colonne]["null_autorise"]]="NULL";
						$valeurs[""]="NULL";
					} else if($descriptions[$nom_colonne]["null_autorise"]!="") {
						$valeurs[$descriptions[$nom_colonne]["null_autorise"]]="NULL";
						//						$valeurs[""]="NULL";
					}
					//					print_rr($valeurs);
					$this->add_select($libelle,$nom_colonne,$valeurs,NULL,$descriptions[$nom_colonne]);
					array_push($evite,$nom_colonne);
				}

				if(!in_array($nom_colonne,$evite)) {
					//echo "1 COL !";
					$this->add_colonne_from_sql($res,$libelle,$descriptions[$nom_colonne]);
				}

			}
		}
	}
	public function add_colonne_from_sql($res,$libelle=NULL,$descriptions=NULL) {
		if($descriptions["type_formulaire"]=="hidden") {
			$res["Type"] = "hidden";
		} else if($descriptions["type_formulaire"]=="tinyeditor") {
			$res["Type"] = "tinyeditor";
		}
		else if($descriptions["type_formulaire"]=="longtext") {
			$res["Type"] = "longtext";
		} else if($descriptions["type_formulaire"]=="image") {
			$res["Type"] = "image";
			$id_auto_tmp = $this->get_valeur("id_auto");
			if(isset($descriptions["identifiant_liste"]) && isset($descriptions["id_auto"])) {
				//include_once 'modules/base/classes/CImages.class.php';//auto
				if($res_elem = CListes::get_elem_by_id($descriptions["identifiant_liste"],$id_auto_tmp))
				//					$descriptions["image_src"]=CImages::get_server_image_path_from_res($descriptions["identifiant_liste"],$descriptions["nom_colonne"],$res_elem,$res_elem[$descriptions["nom_colonne"]]);
				$descriptions["image_src"]=CImages::get_image_redim_public_path_from_res($descriptions["identifiant_liste"],$descriptions["nom_colonne"],$res_elem,50,50,"CROPMAX");
				else {
					//					echo "NON";
				}
			}
			//
			//print_rr($res);
			//print_rr($descriptions);
			//print_rr($res);
		} else if($descriptions["type_formulaire"]!="") {
			$split=explode(".",$descriptions["type_formulaire"]);
			//echo $descriptions["type_formulaire"].'--';
			if(count($split)>1) {
				$id_module=array_shift($split);
				if(Cmodule::module_existe($id_module)) {
					$res["Type"]=Cmodule::execute_fonction_module($descriptions["type_formulaire"]);
				}

			}
		}


		$nom=$res["Field"];
		ifNULL($libelle,$nom);
		//$res["Type"]=strtolower($res["Type"]);
		// array("int(11)","int","11")
		preg_match_all("(([a-zA-Z]*)([(](.*)[)])?)",$res["Type"],$detail);
		$ch_type=$detail[1][0];

		$ch_valeurs=$detail[3][0];

		$expValidation = '';
		switch(strtolower($ch_type)) {
			case "hidden":
				$this->add_hidden($nom);
				break;
			case "enum":
				$valeurs_tmp=explode("','",$ch_valeurs);
				$valeurs=array();
				for($i=0;$i<count($valeurs_tmp);$i++){
					$val=trim($valeurs_tmp[$i],"'");
					$val=str_replace("''", "'",$val);
					$valeurs[$val]=$val;
				}
				//FIXME: si 'coucou''' pour coucou' => coucou
				$this->add_select($libelle,$nom,$valeurs,NULL,$descriptions);
				break;
			case "int":
			case "tinyint":
			case "mediumint":
			case "longint":
				if($descriptions["type_formulaire"] == "checkbox") {
					// Booleen

					$this->add_checkbox($libelle." : ",$nom,"1",NULL,$descriptions);
				} else {
					if ($descriptions['regexp_validation'] == '') $descriptions['regexp_validation'] = CFormulaire::$RESTRICT_num;
					$this->add_input($libelle." : ",$nom,NULL,"text",$descriptions['regexp_validation'],NULL,$descriptions);
				}
				break;
			case "longtext":
				$descriptions["taille_area"]="long";
			case "text":
				$type="textarea";
				if ($descriptions['regexp_validation'] == '') $descriptions['regexp_validation'] = CFormulaire::$RESTRICT_tout;
					
				$this->add_input($libelle." : ",$nom,NULL,$type,$descriptions['regexp_validation'],NULL,$descriptions);
				break;
			case "tinyeditor":
				$type="tinyeditor";
				if ($descriptions['regexp_validation'] == '') $descriptions['regexp_validation'] = CFormulaire::$RESTRICT_tout;
					
				$this->add_input($libelle." : ",$nom,NULL,$type,$descriptions['regexp_validation'],NULL,$descriptions,NULL,NULL, 'class="textareaMCE"');
				break;
			case "image":
				$type = "image_upload";
				$this->add_input($libelle." : ",$nom,NULL,$type,$descriptions['regexp_validation'],NULL,$descriptions);
				break;
			case "varchar":
			default:
				$type="text";

				if($descriptions["type_formulaire"]!="") {
					$type=$descriptions["type_formulaire"];
				}
				if ($descriptions['regexp_validation'] == '') $descriptions['regexp_validation'] = CFormulaire::$RESTRICT_tout;
					
				$this->add_input($libelle." : ",$nom,NULL,$type,$descriptions['regexp_validation'],NULL,$descriptions);
					
		}

	}



	public function get_input($name,$value="",$type="text",$restrict=NULL,$params=NULL,$descriptions=NULL,$largeur=NULL) {
		ifNULL($largeur,CFormulaire::$LARGEUR_DEFAUT);
		ifNULL($restrict,"");
		if(!is_array($params)) echo $params;
		ifNULL($params,array());
		//$restrict=($restrict!="")?"useMap='".doubleQuottes($restrict)."'":"";
		$valeur=$this->get_valeur($name,$value);
		if($descriptions["type_formulaire"]=="pass_md5") {
			if(!empty($valeur)) {
				$valeur="no_change";
			}
		}
		if($descriptions["type_formulaire"]=="date_format_fr") {
			if(!empty($valeur)) {
				$tmp = explode('-', $valeur);
				$valeur = $tmp[2].'/'.$tmp[1].'/'.$tmp[0];
			}
		}

		if ($type =='submit')
		unset($params['onblur']);

		foreach($params as $p=>$v) {
			$str_params.="$p=\"".str_replace("\"","\\\"",$v)."\"";
		}
		//enlevé le restrict en fin du input
		//$valeur=htmlentities($valeur, ENT_QUOTES);
		$valeur=str_replace("'", "&apos;",$valeur);

		return "<input type='$type' name='".$this->prefixe."$name' value = '$valeur' autocomplete='on' $str_params >";
	}

	public function get_textarea($name,$value="",$restrict=NULL,$params=NULL,$descriptions=NULL,$largeur=NULL, $attribut_suppl = '') {
		ifNULL($largeur,CFormulaire::$LARGEUR_DEFAUT);

		$valeur=$this->get_valeur($name,$value);
		unset($params['onblur']);

		foreach($params as $p=>$v) {
			$str_params.="$p=\"".str_replace("\"","\\\"",$v)."\"";
		}
		if($descriptions["taille_area"]=="long") {
			$style="style='height:400px'";
		}
		//enlevé le restrict en fin du input
		return "<textarea $attribut_suppl $str_params name='".$this->prefixe."$name' $style>$valeur</textarea>";
		//return "<input type='$type' name='".$this->prefixe."$name' value = '$valeur' autocomplete='' $str_params>";
	}


	public function get_select($name,$valeurs,$value="",$descriptions=NULL, $params = NULL,$largeur=NULL) {
		ifNULL($largeur,CFormulaire::$LARGEUR_DEFAUT);
		ifNULL($params,array());
		unset($params['onblur']);
		$value=$this->get_valeur($name,$value);

		foreach($params as $p=>$v) {
			$str_params.="$p=\"".str_replace("\"","\\\"",$v)."\"";
		}

		$select="<select name='$name' $str_params>";
		foreach($valeurs as $valeur=>$texte) {
			$selected=($value==$valeur)?"selected='true'":"";
			$valeur=str_replace("'", "&apos;",$valeur);
			$select.="<option value='$valeur' $selected>$texte</option>";
		}
		$select.="</select>";
		return $select;
	}

	public function get_checkbox($name,$value="",$params=NULL,$descriptions=NULL, $statutchk_force=NULL,$largeur=NULL) {
		ifNULL($largeur,CFormulaire::$LARGEUR_DEFAUT);
		ifNULL($params,array());
		unset($params['onblur']);

		/*if ($statutchk_force === false) echo 'false';
		 else if ($statutchk_force === true)echo 'true';
		 else echo 'NULL i guess';*/

		//echo "<br>$value == ? ".$this->get_valeur($name);

		$checked=($value==$this->get_valeur($name))?'checked="checked"':"";

		/*if ($statutchk_force === false) $checked = "";
		 if ($statutchk_force === true) $checked = 'checked="checked"';*/

		foreach($params as $p=>$v) {
			$str_params.="$p=\"".str_replace("\"","\\\"",$v)."\"";
		}
		$value=str_replace("'", "&apos;",$value);
		return "<input type='checkbox' name='".$this->prefixe."$name' value = '$value' $checked  autocomplete='on' $str_params >";

	}

	/*public function get_upload($name,$value="",$restrict="",$params=NULL,$descriptions=NULL) {
		ifNULL($params,array());

		foreach($params as $p=>$v) {
		$str_params.="$p=\"".str_replace("\"","\\\"",$v)."\"";
		}
		return "<input type='upload' name='".$this->prefixe."$name' value = '$value' autocomplete='' $str_params >";

		}	*/

	public function get_champ($donnees_champ,$params_suppl=NULL,$largeur=NULL) {
		ifNULL($params_suppl,array());
		foreach($params_suppl as $p=>$v) {
			$donnees_champ["params"][$p]=$v;
		}

		//print_rr($donnees_champ);
		switch($donnees_champ["type"]) {
			case "checkbox":
				return $this->get_checkbox($donnees_champ["name"],$donnees_champ["value"],$donnees_champ["params"],$donnees_champ["descriptions"], $donnees_champ["statutchk_force"],$largeur);
				break;

			case "select":
				return $this->get_select($donnees_champ["name"],$donnees_champ["valeurs"],$donnees_champ["value"],$donnees_champ["descriptions"],$donnees_champ["params"],$largeur);
				break;

			case "textarea":
				return $this->get_textarea($donnees_champ["name"],$donnees_champ["value"],$donnees_champ["restrict"],$donnees_champ["params"],$donnees_champ["descriptions"],$largeur);
				break;

			case "tinyeditor":
				return $this->get_textarea($donnees_champ["name"],$donnees_champ["value"],$donnees_champ["restrict"],$donnees_champ["params"],$donnees_champ["descriptions"],$largeur, $donnees_champ["attribut_suppl"]);
				break;
					
			case "separateur":
				return '&nbsp;';
				break;

			case "image_upload":
				$retour="<img src='{$donnees_champ[descriptions][image_src]}'><br>";
				return $retour.$this->get_input($donnees_champ["name"],$donnees_champ["value"],"file",$donnees_champ["restrict"],$donnees_champ["params"],$donnees_champ["descriptions"],$largeur);
				break;
					
			case "custom":
				return $donnees_champ["value"];
				break;

			default:
				return $this->get_input($donnees_champ["name"],$donnees_champ["value"],$donnees_champ["type"],$donnees_champ["restrict"],$donnees_champ["params"],$donnees_champ["descriptions"],$largeur);
				break;
		}
	}


	public function get_valeur($name,$valeur="") {
		// valeur forcée, avec ou sans prefixe
		if(isset($this->valeurs_forcees[$this->prefixe.$name]))
		return $this->valeurs_forcees[$this->prefixe.$name];
		if(isset($this->valeurs_forcees[$name]))
		return $this->valeurs_forcees[$name];
			
		// valeur par défaut, avec ou sans prefixe
		if(empty($valeur) && (isset($this->valeurs_defaut[$this->prefixe.$name])))
		return $this->valeurs_defaut[$this->prefixe.$name];
		if(empty($valeur) && (isset($this->valeurs_defaut[$name])))
		return $this->valeurs_defaut[$name];
			
		return $valeur;
	}

	public function out($largeur=NULL, $titre = '') {
		ifNULL($largeur,CFormulaire::$LARGEUR_DEFAUT);

		global $num_form;
		$num_form++;
		if($this->onsubmit!="") {
			$this->onsubmit="onsubmit=\"".str_replace("\"","\\\"",$this->onsubmit)."\"";
			//$this->onsubmit="onsubmit=\"valideForm(this)\"";
		}
		$style="<style>
		.form$num_form input{width: {$largeur}px;}
		.form$num_form select{width: {$largeur}px;}
		.form$num_form textarea{width: {$largeur}px;}
		</style>";

		if($this->hasupload) $enc_type='enctype="multipart/form-data"';
		$retour=$style."<form class='form$num_form' $enc_type action='$this->action' method='".$this->method."' ".$this->onsubmit.">";
		foreach($this->hidden as $champ) {
			$retour.=$champ."\n";
		}
		$retour.="<table border=0>";

		$js_tab_valid = '<script type="text/javascript">tabValid = {';
		$nb_js=0;
		for($i=0;$i<count($this->champs);$i++) {

			if ($this->champs[$i]['type'] != 'custom')
			{
				$desc=$this->descriptions[$i];
				$title=$desc["description"];

				if($this->verif) {
					$params_suppl = array('onblur' => 'valideChamp(this, \''.str_replace("'","\\'",$desc["regexp_validation"]).'\')');

					if (strlen($desc["nom_colonne"]))
					{
						if ($nb_js > 0) $js_tab_valid .= ',';
						$nb_js++;
						$js_tab_valid .= '"'.$desc["nom_colonne"].'" : '.
										'"'.str_replace("'","\\'",$desc["regexp_validation"]).'"';
					}
				}
				if(strlen($title)>0) {
					$desc_ch = str_replace("\"","''",$title);
					include_once("modules/site/fonctions_html.inc.php");
					$commentaire="<img src='/images/listes/icones/16/help.png' ".ajoute_textePopup($desc_ch)."/>";
				}
				else $commentaire="";
			}
			$drapeau = $this->getDrapeauChamp($i);
				
			$retour.="<tr><td class='form_label'>".$this->labels[$i]."</td><td class='form_champs' title=\"$title\">".
			$this->get_champ($this->champs[$i], $params_suppl,$largeur).
			($this->useHelp?"</td><td>$commentaire":"").
			$drapeau."</td></tr>";
		}
		$js_tab_valid .= '}; </script>';

		$retour.="</table>";
		$retour.="</form>";
		if($this->verif) $retour .= $js_tab_valid;
		return $retour;
	}
	protected  function getDrapeauChamp($i) {
		$champ = $this->champs[$i];
//		print_rr($champ);
//		echo($champ["type"]."<br>");
		switch($champ["type"]) {
			case "text":
			case "tinyeditor":
				break;
			default:
				return "";
		}
//		echo "ok ".$this->table." -- {$champ[descriptions][nom_colonne]}--";
//							print_rr($this->champs[$i]);
//		if($this->table!="" && Cmodule::module_existe("multilingue") && CMultilingue::champEstMultilingue($this->table,$champ["descriptions"]["nom_colonne"])) {
		if($this->table!="" && Cmodule::module_existe("multilingue") && CMultilingue::champEstMultilingue($this->table,$champ["name"])) {
			$drapeau = "<img src='/icones/multilingue/png/".CMultilingue::$langue.".png' />";
		}
		return $drapeau;
	}

}

?>