<?php


class COptions {
	/**
	 * Ajoute une option en base
	 *
	 * @param string $chemin
	 * @param string $identifiant
	 * @param string $titre
	 * @param string $type
	 * @param string $type_param
	 * @param int $position
	 * @param string $valeur_defaut
	 * @param bool $maj
	 */
	public function ajouteOption($chemin,$identifiant,$titre,$type,$type_param="",$position=0,$valeur_defaut="",$maj = true, $is_constante = '0') {
		include_once 'includes/general/ini_set.inc.php';
		$donnees = array("identifiant"=>$identifiant,"titre"=>$titre,"chemin"=>$chemin,"type"=>$type,"type_param"=>$type_param,"position"=>$position,"valeur"=>$valeur_defaut, "is_constante"=>$is_constante);
		if($maj) {
			CListes::insere_update("options",$donnees,"identifiant",array("valeur"));
		} else {
			CListes::insere("options",$donnees,"identifiant");
		}

		if ($is_constante == '1') {
			if (file_exists(REP_CLIENT."includes/constantes.inc.php"))
				include_once REP_CLIENT."includes/constantes.inc.php";
			$cst_name = self::cstNameFromOptName($chemin.'_'.$identifiant);
			if(!defined($cst_name)) ini_set_client($cst_name, $valeur_defaut);
		}


		return;
		/*$split_path=explode(".",$chemin);
		 print_rr()*/
		//		if(!COptions::option_exists($identifiant)) {
		//			trace("insertion option $identifiant");
		//		}
		//			$insert_update = mysql_update_insert2("options__options",
		//				array("chemin","identifiant","titre","type","taille","multilangue","position","valeur","id_valeur"), // champs
		//				array("chemin"=>$chemin,"identifiant"=>$identifiant,"titre"=>$titre,"type"=>$type,"type_param"=>$type_param,"position"=>$position,"valeur"=>$valeur), // valeurs
		//				"identifiant='$identifiant'",																// where
		//				null, 																						// champs supplémentaires
		//				array("chemin","identifiant","valeur","id_valeur"),																					// no update
		//				array(),																					// no insert
		//				false);																						// simulation
		//			if($insert_update == "insert") {
		//				// insert si ML ou long ... ?
		//				trace("ok","vert");
		//
		//			} else if($insert_update == "update") {
		//				if(mysql_affected_rows()>0)
		//					trace("mise à jour option $identifiant","vert");
		//			}

	}

	/**
	 * déclenché qd on veut avec un maj_all ou maj_constantes ou maj_bdd, après le maj_bdd
	 * Enter description here ...
	 */
	public static function majConstantes()
	{
		$const_opts = mysql_fetch_all(ifReq("SELECT * FROM options__options WHERE is_constante = 1"));

		if($const_opts)
		{
			include_once 'includes/general/ini_set.inc.php';
			for ($i = 0; $i < count($const_opts); $i++)
				ini_set_client(self::cstNameFromOptName($const_opts[$i]['chemin'].'.'.$const_opts[$i]['identifiant']), $const_opts[$i]['valeur']);
		}
	}

	public static function cstNameFromOptName($name) {
		return strtoupper(str_replace('.', '_', $name));
	}

	function option_exists($identifiant) {
		return testReq3("SELECT id_auto FROM options__options WHERE identifiant='$identifiant'");
	}
	/**
	 * Renvoi les informations d'une option
	 *
	 * @param $cheminEtIdentifiant ( séparés par un point '.' )
	 */
	public static function recupereOption($cheminEtIdentifiant)
	{
		$tab = explode('.', $cheminEtIdentifiant);
		$identifiant = array_pop($tab);
		$chemin = implode('.',$tab);
		return testReq3("SELECT * FROM options__options WHERE identifiant='$identifiant' AND chemin = '$chemin'");
	}

	/**
	 * Renvoi certains champs en particulier d'une option
	 *
	 * @param $cheminEtIdentifiant ( séparés par un point '.' )
	 * @param $nomChamps ( séparés par une virgule ',' )
	 */
	public static function recupereChampsOption($cheminEtIdentifiant, $nomChamps = '*')
	{
		if(empty($cheminEtIdentifiant)) return false;
		$tab = explode('.', $cheminEtIdentifiant);
		$identifiant = array_pop($tab);
		$chemin = implode('.',$tab);
		return testReq3("SELECT ".$nomChamps." FROM options__options WHERE identifiant='$identifiant' AND chemin = '$chemin'");
	}

	/**
	 * Renvoi certains champs en particulier d'une option
	 *
	 * @param $cheminEtIdentifiant ( séparés par un point '.' )
	 */
	public static function recupereValeurOption($cheminEtIdentifiant, $check_constant = false)
	{
		if(empty($cheminEtIdentifiant)) return false;

		if ($check_constant) {
			if (file_exists(REP_CLIENT."includes/constantes.inc.php"))
				include_once REP_CLIENT."includes/constantes.inc.php";
			$cst_name = self::cstNameFromOptName($cheminEtIdentifiant);
			if(defined($cst_name)) {
				return constant($cst_name);
			}
		}
		$tab = explode('.', $cheminEtIdentifiant);
		$identifiant = array_pop($tab);
		$chemin = implode('.',$tab);
		$tab = testReq3("SELECT valeur FROM options__options WHERE identifiant='$identifiant' AND chemin = '$chemin'");
		return $tab['valeur'];
	}


	/**
	 * Renvoi toutes les options d'un chemin dans un fetch all
	 *
	 * @param string $chemin
	 */
	public static function getCollectionOptions($chemin)
	{
		if(empty($chemin)) return false;
		if($recup = ifReq("SELECT * FROM options__options WHERE chemin='$chemin'"))
		return mysql_fetch_all($recup);
		else
		return false;
	}

	/**
	 * Renvoi toutes les valeurs des options d'un chemin dans un tableau associatif
	 *
	 * @param string $chemin
	 */
	public static function getCollectionValeursOptions($chemin)
	{
		$tab = self::getCollectionOptions($chemin);
		$tab_retour = array();
		for ($i = 0; $i < count($tab); $i++) $tab_retour[$tab[$i]['identifiant']] = $tab[$i]['valeur'];

		return $tab_retour;
	}

	/**
	 * Met à jours des champs d'une option
	 *
	 * @param string $cheminEtIdentifiant
	 * @param array() $champ
	 * @param array() $val
	 */
	public static function setChampOption($cheminEtIdentifiant, $champ = array(), $val = array())
	{
		if(empty($cheminEtIdentifiant)) return false;
		$tab = explode('.', $cheminEtIdentifiant);
		$identifiant = array_pop($tab);
		$chemin = implode('.',$tab);
		if(sizeof($champ) != sizeof($val))
		return false;
		else
		{
			$set = 'SET ';
			$long = sizeof($champ);
			for($i = 0; $i < $long; $i++) {
				$set .= "`".$champ[$i]."` = '".$val[$i]."',";
					
				if ($champ[$i] == 'valeur') {

					$opt = self::recupereOption($cheminEtIdentifiant);
					if ($opt['is_constante'] == '1') {
						include_once 'includes/general/ini_set.inc.php';
						ini_set_client(self::cstNameFromOptName($cheminEtIdentifiant), $val[$i]);
					}

				}
			}
			$set = substr($set,0,-1);
		}
		return ifReqUnbuffered("UPDATE `options__options` ".$set." WHERE chemin = '".$chemin."' AND identifiant = '".$identifiant."';");
	}
	/**
	 * Affiche le contenu principal de l'onglet Options
	 *
	 */
	public static function contenuOngletPrincipal()
	{
		if (!self::JQcheckDroitOptions()) return;

		echo CEcho::echo_jsready(file_get_contents('modules/base/www/js/coptions.gestion.js'));
		echo str_replace('#NO_CSS_BUG#',CFSAdmin::$div_margin,Cmodule :: ajoute_blocs_html_modules(file_get_contents('modules/base/www/html_fichiers/coptions.fsadmin.modele.html')));
	}

	/**
	 * Ordonne un tableau d'option pour qu'il soit exploitatble ( arbre avec les chemins )
	 *
	 * @param array $tab
	 */
	public static function ordonneTabOption($tab)
	{
		sort($tab);

		$result=array();
		foreach($tab as &$unChemin) {
			$unChemin = explode(".",$unChemin);
			$tmp_tab = &$result;
			foreach($unChemin as $i=>$dossier) {
				$has_children = ($i<count($unChemin)-1);
				if(array_key_exists($dossier,$tmp_tab)) {
					$tmp_tab = &$tmp_tab[$dossier];
				} else {
					$tmp_tab[$dossier]=array("_nb_enfants"=>0);
					ksort($tmp_tab);
					$tmp_tab = &$tmp_tab[$dossier];
				}
				if($has_children) $tmp_tab["_nb_enfants"]++;
			}
		}
		//print_rr($result);
		return $result;
	}

	/**
	 * Affiche un arbre des chemin / identifiants d'options de maniere récursive
	 *
	 * @param array $tab
	 * @param int $padd		Padding de déplacement
	 * @param string $path
	 */
	public static function ulli($tab,$padd = 0,$path="") {
		if(empty($tab)) return "";
		$nPadd = $padd + 5;
		$html="<ul style='margin-left: 15px;'>";
		foreach($tab as $ind => $val)
		{
			if(isset($val['_nb_enfants']) && (($val['_nb_enfants'] > 0) || usr_est_super_admin()))
			{
				$uli = self::ulli($val,$nPadd,$path.$ind.".");
				$html .= '<li style="padding-left:'.$nPadd.'px"><h3 class="lienEditOption" idCheminOption="'.$path.$ind.'" style="cursor: pointer;">'.$ind.'</h3>'.$uli.'</li>';
			}
		}
		$html.="</ul>";
		return $html;
	}

	/**
	 * Renvoi une liste ul li des options classées par chemin, identifiant
	 *
	 * @param string $where
	 * @param boolean $estAjax
	 */
	public static function getListeOptionsOrdonnee($where = '', $estAjax = false)
	{
		if(!empty($_POST['estAjax']) && $_POST['estAjax'] == true) $estAjax = true;


		if(!empty($_POST['whereOptionsLike'])) $where = "WHERE chemin LIKE '%".mysql_real_escape_string($_POST['whereOptionsLike'])."%'";
		$and = (!usr_est_super_admin())? (!empty($_POST['whereOptionsLike']))? ' AND visible = 1' : ' WHERE visible = 1' : '' ;

		$tabOptions = mysql_fetch_all(ifReq("SELECT distinct concat(chemin,'.',identifiant) as idcomplet FROM options__options ".$where." ".$and." ORDER BY 1;"));


		$tabOptionsO = array();

		foreach($tabOptions as $uneOption)
		$tabOptionsO[] = $uneOption['idcomplet'];
			
		$tabOptionsO = self :: ordonneTabOption($tabOptionsO);

		$res = self::ulli($tabOptionsO);


		if($estAjax)
		echo $res;
		else
		return $res;
	}

	/**
	 * Affiche le formulaire de modification d'une option
	 *
	 */
	public static function ajaxGetFormGestionOption()
	{
		if (!self::JQcheckDroitOptions()) return;
		//		if(usr_a_droit_generique('coptions.utilisation'))
		//		{
		$idOption = $_POST['idOption'];
		$req = testReq3("SELECT count(*) as nb FROM `options__options` WHERE concat(chemin,'.',identifiant) = '".mysql_real_escape_string($idOption)."';");
		if($req['nb'] > 0)
		{
			$tabOption = COptions::recupereChampsOption($idOption);
			//print_rr($tabOption);
			$monForm = new CFormulaireFSAdmin();
			//$monForm -> add_hidden("id_auto",$tabOption['id_auto']);
			if(usr_est_super_admin())
			{
				$tabEvite = array('id_auto');
				$tabAutorise = null;
			}
			else
			{
				$tabAutorise = 'valeur';

				$tab = explode('.', $_POST['idOption']);
				$identifiant = array_pop($tab);
				$chemin = implode('.',$tab);
				$monForm -> add_hidden('chemin',$chemin);
				$monForm -> add_hidden('identifiant',$identifiant);
				$tabEvite = array('id_auto','type_option', 'chemin', 'identifiant', 'titre','type','position','type_param','visible');
			}

			$monForm -> add_colonnes_table('options__options',null,$tabEvite);
			$monForm -> set_valeurs_forcees(COptions::recupereChampsOption($_POST['idOption']));


			$bouton = '<a href="#" id="validModif" class="a_bt">Enregistrer les modifications</a>';
			$hidden .= '<input type="hidden" name="modif" value="1" />';
			echo $monForm -> out(null, $tabOption['titre']);
			echo $bouton;
			//echo CFSAdmin::$div_margin;
				
		}
		else
		{
			echo '<table>';
			echo '<legend><h2>Modification rapide d\'un groupe d\'options</h2></legend><br /><br />';
			echo '<tr>';
			echo '<th>';
			echo '<h3 style="color: grey;">Titre de l\'option</h3>';
			echo '</th>';
			echo '<th>';
			echo '<h3 style="color: grey;">Valeur</h3>';
			echo '</th>';

			if(usr_est_super_admin())
			{
				echo '<th>';
				echo '<h3 style="color: grey;">Visible</h3>';
				echo '</th>';
				echo '</tr><tr><td><br /></td></tr>';
				$tab = mysql_fetch_all(ifReq("SELECT type,type_param, titre, concat(chemin,'.',identifiant) as idComplet, valeur, visible FROM options__options WHERE concat(chemin,'.',identifiant) like '".$idOption."%' order by position; "));

				foreach($tab as $uneOption)
				echo self :: getFormModifRapideOption($uneOption);
			}
			else
			{
				echo '</tr><tr><td><br /></td></tr>';
				$tab = mysql_fetch_all(ifReq("SELECT type,type_param, titre, concat(chemin,'.',identifiant) as idComplet, valeur, visible FROM options__options WHERE visible = 1 AND concat(chemin,'.',identifiant) like '".$idOption."%'  order by position; "));

				foreach($tab as $uneOption)
				echo self :: getFormModifRapideOption($uneOption);
			}
			echo '</table><br />';
			echo '<a href="#" id="btSubmitInline" class="a_bt">Enregistrer les modifications</a>';
		}
		//	}
	}

	/**
	 * Utilisée pour parser le formulaire inline de gestion des groupes d'options
	 *
	 */
	public static function parseFormInlineAjax()
	{
		if (!self::JQcheckDroitOptions()) return;

		//$data = json_decode($_POST['jsonData']);
		$tab = $_POST['jsonData'];
		if(is_array($tab))
		{
			foreach($tab as $uneOption) {
				if(usr_est_super_admin())
				COptions :: setChampOption($uneOption['cheminComplet'],array('valeur','visible'), array($uneOption['valeur'],$uneOption['visible']));
				else
				COptions :: setChampOption($uneOption['cheminComplet'],array('valeur'), array($uneOption['valeur']));
			}

			CMessages::ajoute_message('Modifications éfféctuées avec succées!');
		}
	}

	/**
	 * Affiche un formulaire inline pour une option
	 *
	 * @param array $uneOption
	 */
	public static function getFormModifRapideOption($uneOption)
	{
		$check = ($uneOption['visible'] == 1) ? 'checked="checked"' : '';
		//$html = '<form class="editOptionInline" idChemin="'.$uneOption['idComplet'].'" action="" method="post">';
		$html .= '<tr class="editOptionInline" style="vertical-align:top;" idChemin="'.$uneOption['idComplet'].'">
			<td style="padding-bottom:10px"><label>'.$uneOption['titre'].'</label></td>';
		if($uneOption['type'] == 'ENUM')
		{
			$tab = explode(',',$uneOption['type_param']);
			if(sizeof($tab) > 0)
			{
				$html .='<td>';
				$html .= '<select class="valOption" style="margin-left: 12px; width: 130px;">';
				foreach($tab as $uneValeurePossible)
				{
					$uneValeurePossible = str_replace('\'','',$uneValeurePossible);
					$sel = ($uneValeurePossible == $uneOption['valeur'])? ' selected="selected" ' : '';
					$html .= '<option value="'.$uneValeurePossible.'" '.$sel.'>'.$uneValeurePossible.'</option>';
				}
				$html .= '</select>';
				$html .='</td>';
			}
		}
		elseif($uneOption['type'] == 'BOOLEAN')
		{
			$html .= '<td>';
			$html .= '<select class="valOption">';
			$html .= '<option value="true">Actif</option>';
			$html .= '<option value="false">Non actif</option>';
			$html .= '</select>';
			$html .='</td>';
		}
		else
		$html .= '<td><input type="text" value="'.$uneOption['valeur'].'" class="valOption" style="margin-left: 12px;display:inline;"/></td>';

		$test =(usr_est_super_admin())? 'inline' : 'none';
		$html .= '<td><input type="checkbox" selected="false" class="isVisible" style="align: center; display:'.$test.';" '.$check.'/></td>';
		$html .= '</tr>';
		return $html;



		//		$check = ($uneOption['visible'] == 1) ? 'checked="checked"' : '';
		//		$html = '<form class="editOptionInline" idChemin="'.$uneOption['idComplet'].'" action="" method="post" style="width: 600px;">';
		//		$html .= '<label><b>'.$uneOption['titre'].'</b>   -  ('.$uneOption['type_param'].')</label>';
		//		$html .= '<label style="display: inline; width: 100px;">Valeur :</label><input type="text" value="'.$uneOption['valeur'].'" class="valOption" style="margin-left: 12px;display:inline;"/>';
		//		$test =(usr_est_super_admin())? 'inline' : 'none';
		//		$html .= '<br /><br /><label style="display: '.$test.';width: 100px;">Visible ? : </label><input type="checkbox" selected="false" class="isVisible" style="display:'.$test.';" '.$check.'/>';
		//		$html .= '</form><br /><br />';
		//		return $html;
	}

	/**
	 * Parse un résultat de formulaire de modification d'options
	 *
	 */
	public static function parseFormOptionResult()
	{
		if (!self::JQcheckDroitOptions()) return;
		if(!empty($_POST['chemin']) && !empty($_POST['identifiant']))
		{
			if(isset($_POST['modif']) && $_POST['modif'] == 1)
			{
					
				if(CListes::update("options",$_REQUEST,"chemin,identifiant",array("chemin","identifiant"))) {
					echo CMessages::ajoute_message('Modifications efféctuées avec succés !');
				} else {
					echo CMessages::ajoute_message('erreur update !');
						
				}

				return;
			}
		}
	}
	/**
	 * Rajoute un droit d'autorisation pour une option
	 *
	 * @param string $cheminEtIdentifiant
	 * @param string $groupe
	 * @param bool $autorise_acces
	 * @param bool $autorise_editer
	 * @param bool $autorise_supprimer
	 * @param bool $autorise_ajout
	 * @param bool $update
	 */
	public static function autoriseOption($cheminEtIdentifiant,$groupe,$autorise_acces = 1, $autorise_editer=1, $autorise_supprimer=1, $autorise_ajout=0, $update = false)
	{
		$liste= self::recupereChampsOption($cheminEtIdentifiant, 'id_auto');
		usr_set_droit("fsa.options",$liste["id_auto"],$autorise_acces,NULL,$groupe,NULL, NULL, $update, $autorise_ajout, $autorise_editer, $autorise_supprimer);
	}

	/**
	 * Test si un utilisateur / groupe à les droits sur une option
	 * @param string $cheminEtIdentifiant
	 * @param enum $action (autorise, modifier, ajouter, supprimer)
	 */
	public static function checkDroitsOptions($cheminEtIdentifiant, $action = 'autorise')
	{
		$liste= self::recupereChampsOption($cheminEtIdentifiant, 'id_auto');
		return(!usr_a_droit("fsa.options",$liste["id_auto"],usr_identifie_get_id(),$action))? false : true;
	}

	public static function JQcheckDroitOptions() {
		return self::checkDroitOptions("JQ");
	}
	public static function checkDroitOptions($jq="") {
		return Cmodule_fsadmin::usr_a_droit_generique('coptions.utilisation');
	}
}
?>