<?php
//define('EST_EFROGG', false);

include_once 'includes/general/timer.inc.php';
//include_once 'includes/general/Crapports.class.php';//auto
include_once 'includes/general/optim_php.inc.php';
include_once 'includes/BDD/actions.inc.php';
include_once 'modules/Cmodule.class.php';


/* inclut le autoload dès le départ */
include_once('includes/general/autoload.inc.php');

/*
 * ce fichier est inclus par tous les PHP
 * il inclut le fichier de config de chaque serveur
 * c'est ici qu'on met ce qui doit etre fait par TOUS les sites, sur TOUS les serveurs
 */

header('Content-type: text/html; charset=UTF-8');

ini_set('magic_quotes_gpc', 'Off');

// récupération des variables en GET, meme apres de l'url_rewriting !!
$params_get=explode("?",$_SERVER["REQUEST_URI"]);
if(count($params_get)>1) {
	// si on a des parametres apres le ?
	array_shift($params_get);
	$params_get=urldecode(implode("?",$params_get));
	$params_get=explode("&",$params_get);
	for($i=0;$i<count($params_get);$i++) {

		$split=explode("=",$params_get[$i]);
		$nom_var=array_shift($split);
		$valeur=implode("=",$split);
		$_GET[$nom_var]=$valeur;
		$_REQUEST[$nom_var]=$valeur;
		$$nom_var=$valeur;
	}
}

if(isset($_REQUEST['no_redirect'])) define("DEBUG_REDIRECT",true);
//echo DEBUG_REDIRECT;


// alias aliaslocalhost pour voir les paquets ds les logiciels de proxy
// dans system32/drivers/etc/host
function detecteServeur() {
	$serveurs_config=array(
		array("masque"=>"siovb.en-travaux.com","serveur"=>"SIOVB_DEPLACE","client"=>"SIOVB"),
		array("masque"=>"aopvb.en-travaux.com","serveur"=>"TRAVAUX","client"=>"OLIVE"),
		array("masque"=>"aoc-lesbauxdeprovence.com","serveur"=>"SIOVB","client"=>"OLIVE"),
		array("masque"=>"soun-music(.*)","serveur"=>"SOUN","client"=>"SOUN"),
		array("masque"=>"extranet.siovb.com","serveur"=>"SIOVB","client"=>"SIOVB"),
		array("masque"=>"golfderoquebrune","serveur"=>"GOLF","client"=>"GOLF"),
		array("masque"=>"castelas.com","serveur"=>"CASTELAS","client"=>"CASTELAS"),
		array("masque"=>"point-fusion.com","serveur"=>"FUSIONPOTERIE","client"=>"FUSIONPOTERIE"),
		array("masque"=>"(v5|m).e-frogg.(com|fr)","serveur"=>"EFROGG","client"=>"EFROGG"),

		array("masque"=>"kruz.efrogg","serveur"=>"localhost","client"=>"KRUZ"),
		array("masque"=>"preprod.kruz-seafood.com","serveur"=>"KRUZ","client"=>"KRUZ"),

		array("masque"=>"(localhost)|(m.localhost)|(t.localhost)|(aliaslocalhost)|(192.168(.*))$","serveur"=>"localhost","client"=>"OLIVE"),
		array("masque"=>"darkvador","serveur"=>"darkvador","client"=>"GOLF"),
		
		array("masque"=>"^localbluf$","serveur"=>"localhost","client"=>"BLUF"),
		array("masque"=>"^localcastelas$","serveur"=>"localhost","client"=>"CASTELAS"),
		array("masque"=>"^localsiovb$","serveur"=>"localhost","client"=>"SIOVB"),
		array("masque"=>"^localsoun$","serveur"=>"localhost","client"=>"SOUN"),
		array("masque"=>"^localolive$","serveur"=>"localhost","client"=>"OLIVE"),
		array("masque"=>"^localgolf$","serveur"=>"localhost","client"=>"GOLF"),
		array("masque"=>"^localfusion$","serveur"=>"localhost","client"=>"FUSIONPOTERIE"),
		array("masque"=>"88.170.(.*)","serveur"=>"localhost","client"=>"CASTELAS"),
		array("masque"=>"brittanylebanonuniteforces","serveur"=>"BLUF","client"=>"BLUF"),
		array("masque"=>"daya.fr","serveur"=>"DAYA","client"=>"DAYA"),
		array("masque"=>"restaurant-z.delli-resort.com","serveur"=>"LEZ","client"=>"LEZ")
	//"prod"=>"([0-9]{1,3}).([0-9]{1,3}).([0-9]{1,3}).([0-9]{1,3})" // une ip n'importe laquelle
	);
//	print_rr($_SERVER);
// MOBILE VERSION
	foreach($serveurs_config as $config) {
		if(ereg($config["masque"],$_SERVER["HTTP_HOST"])) { //

			define("CLIENT",$config["client"]);
			define("SERVEUR",$config["serveur"]);
			define("REP_CLIENT","_".CLIENT."/");
			break;
		}
	}
}


detecteServeur();

if(isset($_REQUEST["maj_classes"]) || isset($_REQUEST["maj_all"])) {
	include_once 'includes/BDD/bdd_maj.inc.php';
	include("autoload_defaut.inc.php");
	$tabClasses = array_merge($tabClasses,CAutoloadConfig::parcourtDossier("."));
} else {
	$cheminFichiersClasses = REP_CLIENT.'/autoload_'.CLIENT.'.inc.php';
	if(!is_file(RACINE_WWW.$cheminFichiersClasses))
	include("autoload_defaut.inc.php");
	//throw new Exception('Configuration de l\'autoload introuvable ( ?maj_classes nécessaire ? )');
	else
	{
		include($cheminFichiersClasses);
	}
}




/*
 * configurations INCHANGEABLES
 */
define("JQ_ACTION","actionX");
define("CST_INCHANGEABLE","");
define("EST_EFROGG",preg_match("/^(127.0.0.1|88.172.112.128|88.168.109.62|192.168.(.*))$/",$_SERVER["REMOTE_ADDR"])?true:false);
if(EST_EFROGG && isset($_REQUEST["debugger"])) define("DEBUGGER",true);
if(EST_EFROGG && !isset($_REQUEST["debugStats"])) CStat_site::$stat_active=false;
//if(isset($_REQUEST["debugger"])) echo "_REQUEST !!! ".$_REQUEST["dbg"];
//if(EST_EFROGG) echo "EST_EFROGG !!! ".EST_EFROGG." --- ";
//if(EST_EFROGG) echo "DEBUGGER !!! ".DEBUGGER." --- ";
define("EMAIL_RAPPORTS","rapports@e-frogg.com");
/*
 * configurations spécifiques au serveur sur lequel on tourne
 */
include_once 'includes/config_serveur.inc.php';

//if(isset($_REQUEST["idLng"])) CMultilingue::setLangue($_REQUEST["idLng"]);

include_once 'includes/BDD/bdconnect.inc.php';
BDDconnect_utf8();

session_start();
//print_r($_SESSION);
//exit;
//if(EST_EFROGG) echo "DEBUGGER !!! ".DEBUGGER;
/*
 * configurations par défaut
 * qui peuvent être différentes sur les autres serveurs
 */


if(!defined("USE_GZIP")) define('USE_GZIP',false);

define('LARGEUR_GESTDOC','1000');
define('HAUTEUR_GESTDOC','1000');



define("ML_LANGUE_DEFAUT_INVISIBLE",true);

define("SVNCHECKOUT_PASSWORD","DEFAULT_PASSWORD");
define("SVNCHECKOUT_INTERDIT",false);
define("MODE_IMPORT_FICHIER_MANQUANTS",false);
define("STATIC_MP3_SERVER","");
define("USE_CACHE_FICHIER",false);
define("FORCE_NO_CACHE", false);
define("FORCE_LOFI",false);
define("CST_DEFAUT","");
// par défaut, on ne découpe pas la longueur des dossiers d'upload
// peut être modifié dans _CLIENT/includes/config.inc.php
// si 0, pas de découpe
if(!defined("UPLOAD_LONGUEUR_DECOUPE")) define("UPLOAD_LONGUEUR_DECOUPE",0);
if(!defined("DEBUGGER")) define("DEBUGGER",false);

//if(EST_EFROGG) echo "DEBUGGER !!! ".DEBUGGER;


// avec mise en cache de la liste des modules .... (on ne gagne rien)

//$fichier_config_modules = REP_CLIENT."/includes/modules.inc.php";
//if(EST_EFROGG === true && isset($_REQUEST["maj_modules"])) {
//
//	/*
//	 * création de la liste des serveurs
//	 */
//	include_once 'modules/Cmodule.class.php';
//	Cmodule::ajouteLigneConfigAvant("include_once 'modules/Cmodule.class.php';");
//	Cmodule::ajoute_module("base",1,"modules/"); // celui la, toujorus, et avant les autres
//	/*
//	 foreach($liste_modules_actifs as $id_module) {
//	 Cmodule::ajoute_module($id_module);
//	 }
//	 */
//	Cmodule::ajoute_module(CLIENT,1,"_");
//	file_put_contents($fichier_config_modules,Cmodule::getStrConfig());
//	//	echo Cmodule::getStrConfig();
//	exit;
//} else if(file_exists($fichier_config_modules)) eval(file_get_contents($fichier_config_modules));

// sans mise en cache
//include_once 'modules/Cmodule.class.php';//auto
Cmodule::ajoute_module("base",1,"modules/"); // celui la, toujorus, et avant les autres
Cmodule::ajoute_module(CLIENT,1,"_");
Cmodule::dispatch_fonction("__inited");

if(isset($_REQUEST["maj_classes"]) || isset($_REQUEST["maj_all"])) {
	CAutoloadConfig::nettoieClasses();
	CAutoloadConfig::sauveClasses();
}



// Evite la notice sur le timezone
date_default_timezone_set('Europe/Paris');

include_once('includes/general/rapportErreur.inc.php');

?>