/**
 * froggForm v1.0
 * (c) E-Frogg 2010 
 */
(function($){
	 	$.fn.extend({ 
	 		froggForm: function(options) {
				var defaults = {
						reg:{
								required 	: /[^.*]/,
//								alpha 		: /^[a-z ._\-]+$/i,
								
								alpha 		: /^[à-ýa-z ._\-éèêëï]+$/i,
								
								alphanum 	: /^[a-z0-9 ._\-]+$/i,
								digitSign 	: /^[\-+]?[0-9]+$/,
								digit		: /^[0-9]+$/i,
								nodigit 	: /^[^0-9]+$/,
								number 		: /^[\-+]?\d*\.?\d+$/,
								email 		: /^[a-z0-9._%\-]+@[a-z0-9.\-]+\.[a-z]{2,4}$/i,
								phone 		: /^[0-9]{2}[\s]{0,1}[0-9]{2}[\s]{0,1}[0-9]{2}[\s]{0,1}[0-9]{2}[\s]{0,1}[0-9]{2}$/,
								url 		: /^(http|https):\/\/[a-z0-9\-\.\/_]+\.[a-z]{2,3}$/i,
								date 		: /^[0-9]{1,2}.[0-9]{1,2}.[0-9]{2,4}$/,
								hexaColor 	: /#[0-9a-fA-F]{6}/,
								notEmpty 	: /^(.*[^0\s].*)$/
							}
				}
				var options =  $.extend(defaults, options);

	    		return this.each(function() {
					$(this).submit(function(){
						var formOK = true;
						$(this).find('.formElem input').each(function(){
							if(typeof($(this).attr('check')) != 'undefined')
							{
								if(typeof(options.reg[$(this).attr('check')]) != 'undefined')
								{
									if($(this).attr('type') == 'checkbox')
									{
										if($(this).attr('checked'))
										{
											$(this).parent().css('border','none');
											$(this).next().css('display','none');
										}
										else
										{
											$(this).parent().css('border','1px dashed #FF0000');
											$(this).next().css('display','block');
											formOK = false;
										}
									}
									else
									{
										if(options.reg[$(this).attr('check')].test($(this).val()))
										{
											$(this).css('border','1px solid #ccc');
											$(this).next().css('display','none');
										}
										else
										{
											$(this).css('border','1px dashed #FF0000');
											$(this).next().css('display','block');
											formOK = false;
										}
									}
								}
							}				
						});
						return formOK;
					});
	    		});
	    	}
		});
		
	})(jQuery);