<?php
// patch php <5.3
define("__DIR__",dirname(__FILE__));

define('EMAIL_DESTINATAIRES', 'commun@e-frogg.fr'); // Reception des mails cron (séparés par ',')

header("Content-type: text/html; charset=utf-8");

if(!EST_EFROGG && !(isset($_GET["token"]) && $_GET["token"] == "7bf90bd31f03eda794f9a82fa43d27d7")) {
    exit("Acces interdit");
}

ini_set("include_path","./../");
ini_set("display_errors","on");
include_once("includes/config.inc.php");
include_once("includes/BDD/bdconnect.inc.php");
include_once("includes/BDD/actions.inc.php");
BDDconnect();

class StockImporter
{
    protected $file;

    protected $separator;

    protected $columns = array();

    protected $products;

    protected $handle;

    protected $counter = array(
        'products' => 0,
        'products_found' => 0,
        'products_not_found' => 0,
        'declinaison_not_found' => 0
    );

    protected $error_log = "";

    protected $declinaison_dictionnaire = array(
        'S' => 'Small',
        'M' => 'Medium',
        'L' => 'Large'
    );

    public function __construct($file, $separator, $columns)
    {
        $this->separator = $separator;

        if(file_exists($file)) {
            $this->handle = fopen($file, "r");
            if($this->handle) {
                $row = fgetcsv($this->handle,null, $this->separator);
                if($row) {
                    foreach($row as $index => $column) {
						if(!isset($columns[trim($column)])) {
							exit("impossible de lire la colonne $column");
						}
                        $this->columns[$columns[trim($column)]] = $index;
                    }
                }
            } else {
                echo "Erreur à l'ouverture du fichier";
            }
        } else {
            echo "Erreur, le fichier $file n'existe pas";
        }
    }

    public function __destruct()
    {
        fclose($this->handle);
    }

    protected $updated_products = array();
    public function prepare()
    {
        echo "<pre>";
        while(($row = fgetcsv($this->handle, null, $this->separator)) != false) {
            $this->counter['products']++;

            $reference = $row[$this->columns['reference']];
            $product = $this->searchProductByReference($reference);

            if($product) {
                $product['stock_update'] = $row[$this->columns['stock_qty']];
                $this->products[] = $product;

                if(isset($this->updated_products[$product['product']['id']])) {
                    if(isset($product['declinaison'])) {
                        $this->updated_products[$product['product']['id']][] = $product['declinaison']['id_valeur'];
                    }
                } else {
                    $this->updated_products[$product['product']['id']] = isset($product['declinaison']) ? array($product['declinaison']['id_valeur']) : array();
                }

                $this->writeMessage("Produit: id={$product['product']['id']}", 2, "blue");
                if(isset($product['declinaison']))
                $this->writeMessage("Declinaison: id={$product['declinaison']['id_valeur']}, nom={$product['declinaison']['nom']}", 3, "blue");
                $this->writeMessage("Nouveau stock: {$product['stock_update']}", 2, "blue");
            } else {
                $this->error_log .= $this->getMessages();
            }

            $this->flushMessages();
        }

        $this->writeMessage("Lignes traitées: {$this->counter['products']}");
        $this->writeMessage("Produits trouvés: {$this->counter['products_found']}");
        $this->writeMessage("Produits non trouvés: {$this->counter['products_not_found']}");
        $this->writeMessage("Déclinaisons non trouvées: {$this->counter['declinaison_not_found']}");
        echo "</pre>";

        $this->writeMessage("<h2>Produits/Déclinaisons actifs mais non présent dans le fichier csv</h2>", 0, "black");
        $this->searchProductsNotUpdated();
        $this->error_log .= $this->getMessages();
        $this->flushMessages();

        echo "<a href='?update&token=7bf90bd31f03eda794f9a82fa43d27d7'>Effectuer la mise à jour</a><br/>";
    }

    protected function findReference(&$reference,&$prefixe = null) {
        foreach(array("","Q","P") as $prefixe) {
            if($res = testReq3("SELECT * FROM shop_articles WHERE reference = '$prefixe$reference'")) {
                $reference = $prefixe.$reference;
                return $res;
            }
        }
        return false;
    }

    protected function searchProductByReference($reference)
    {
        $this->writeMessage("Recherche d'un produit avec la reference: $reference");

        $res = $this ->findReference($reference,$pfx);
        if($res != false) {
            $this->counter['products_found']++;
            $this->writeMessage("Trouvé avec $reference ".(!empty($pfx)?"($pfx)":""), 1, "green");
            return array(
                'product' => $res,
                'declinaison' => null
            );
        }

        if(preg_match("/^(.*)(S|M|L|([0-9]{2}))$/", $reference, $matches)) {
            $res = $this ->findReference($matches[1],$pfx);

            $this -> writeMessage("Recherche avec $matches[1] ".(!empty($pfx)?"($pfx)":""), 1);
            if($res != false) {
                $this->counter['products_found']++;
                $this->writeMessage("Trouvé avec $matches[1]; détection de la déclinaison avec $matches[2]", 1, "green");

                if(($declinaison = $this->declinaisonsLookup($res['id'], $matches[2])) != false) {
                    $this->writeMessage("Déclinaison id: ${declinaison['id_valeur']}, nom: ${declinaison['nom']}", 2, "green");
                    return array(
                        'product' => $res,
                        'declinaison' => $declinaison
                    );
                } else {
                    $this->counter['declinaison_not_found']++;
                    $this->writeMessage("Aucune déclinaison ($matches[2]) trouvée pour cet article", 2, "red");
                }
            }
        }

        $this->counter['products_not_found']++;
        $this->writeMessage("Produit non trouvé", 1, "red");
        return false;
    }

    protected function declinaisonsLookup($id_article, $value)
    {
        $res = ifReq("
          SELECT sdd.id_valeur, get_traduction(sdv.valeur, 1, 2) AS nom
          FROM shop_articles sa
          JOIN shop_declinaisons_types sdt ON sdt.id_article_type = sa.id_type
          JOIN shop_declinaisons_dispo sdd ON sa.id = sdd.id_article AND sdd.id_type = sdt.id
          JOIN shop_declinaisons_valeurs sdv ON sdv.id = sdd.id_valeur
          WHERE sa.id = $id_article");

        while(($row = mysql_fetch_assoc($res)) != false) {
            if($row['nom'] == $value ||
                (isset($this->declinaison_dictionnaire[$value]) && $this->declinaison_dictionnaire[$value] == $row['nom'])) {
                return $row;
            }
        }

        return false;
    }

    protected function searchProductsNotUpdated()
    {
        $res = ifReq("
            SELECT sa.id, sa.reference, sdd.id_valeur, smt.texte AS valeur
            FROM shop_struct_elems sse
            JOIN shop_articles_virtuels sav ON sse.id = sav.id_elem
            JOIN shop_articles sa ON sav.id_article_cible = sa.id
            LEFT JOIN shop_declinaisons_types sdt ON sdt.id_article_type = sa.id_type
            LEFT JOIN shop_declinaisons_dispo sdd ON sa.id = sdd.id_article AND sdd.id_type = sdt.id
            LEFT JOIN shop_declinaisons_valeurs sdv ON sdv.id = sdd.id_valeur
            LEFT JOIN shop_ml_traductions smt ON smt.id_champs = sdv.valeur AND smt.id_langue = 1
            WHERE sse.id_structure = 1 AND actif_parentee = 1 AND sa.actif = 1
            GROUP BY sa.id, sdd.id_valeur
            ORDER BY sa.id, sdd.id_valeur");
        while(($row = mysql_fetch_assoc($res)) != false) {
            if(isset($this->updated_products[$row['id']])) {
                // Si c'est une déclinaison
                if($row['id_valeur']) {
                    if(!in_array($row['id_valeur'], $this->updated_products[$row['id']])) {
                        $this->writeMessage("Manquant: {$row['reference']} / {$row['valeur']} ($row[id]/$row[id_valeur])", 1, "#950");
                    }
                }
            } elseif($row['id_valeur']) {
                $this->writeMessage("Manquant: {$row['reference']} / {$row['valeur']} ($row[id]/$row[id_valeur])", 1, "#950");
            } else {
                $this->writeMessage("Manquant: {$row['reference']} ($row[id])", 1, "#950");
            }
        }
    }

    public function commit()
    {
        foreach($this->products as $product) {
            if(isset($product['declinaison'])) {
                ifReq("UPDATE shop_stocks_dispo SET qte_magasin = {$product['stock_update']}, qte_web = {$product['stock_update']} WHERE id_article = {$product['product']['id']} AND declinaison = {$product['declinaison']['id_valeur']}");
            } else {
                ifReq("UPDATE shop_stocks_dispo SET qte_magasin = {$product['stock_update']}, qte_web = {$product['stock_update']} WHERE id_article = {$product['product']['id']} AND declinaison = ''");
            }
        }

        if(!is_dir(__DIR__."/stocks/logs")) {
            mkdir(__DIR__."/stocks/logs");
        }
        file_put_contents(__DIR__."/stocks/logs/error_log_".date("Y-m-d_H-i-s").".log.html", $this->error_log);

        if(defined('EMAIL_DESTINATAIRES') && EMAIL_DESTINATAIRES != null) {
            envoiMail('cron_import_stock@misaki.com', EMAIL_DESTINATAIRES, '[Cron] Import des stocks', $this->error_log);
        }
    }

    protected $logs = array();
    public function writeMessage($msg, $indent = 0, $color = "grey")
    {
        $indent *= 25;
        $this->logs[] = "<div style='margin-left:${indent}px;color:$color;'>$msg</div>";
    }

    public function getMessages()
    {
        return implode("", $this->logs)."<br/>";
    }

    public function flushMessages()
    {
        echo $this->getMessages();
        $this->clearMessages();
    }

    public function clearMessages()
    {
        $this->logs = array();
    }
}

$csv_columns = array(
    "Référence" => "reference",
    "Qte en Stock" => "stock_qty",
    "Dépot" => "depot"
);

if(file_exists(__DIR__."/stocks/stocks_import.csv")) {
    $stockImporter = new StockImporter(__DIR__."/stocks/stocks_import.csv", ";", $csv_columns);
    $stockImporter->prepare();
} else {
    echo "<div style='color:red;'>Erreur, le fichier stocks_import.csv n'est pas présent</div>";
}

if(isset($_GET['update'])) {
    $stockImporter->commit();

    if(!is_dir(__DIR__.'/stocks/logs')) {
        mkdir(__DIR__.'/stocks/logs');
    }

    rename(__DIR__."/stocks/stocks_import.csv", __DIR__."/stocks/logs/stocks_import_".date("Y-m-d_H-i-s").".log.csv");
}