<?php

class SynchroSet {
	private $includeMasks = array();

	public function SynchroSet($includes) {

		if(is_null($includes)) $includes="(.*)";
		if(!is_array($includes)) $includes=array($includes);

		$this->includeMasks = $includes;
	}

	public function isIn($tableName) {
		foreach($this->includeMasks as &$unMask) {
			if(preg_match("/$unMask/",$tableName)) return true;
		}
		return false;
	}

}


class Synchro {
	private $sets = array();
	public $exportPath = "import/";
	public $importPath = "import/";
	public $backupPath = "backup/";
	private $exportSets = array();
	private $importSets = array();
	/**
	 * dfinit un groupe de tables a sauvegarder / restaurer
	 * @param unknown_type $setName
	 * @param unknown_type $includes
	 * @param unknown_type $excludes
	 */
	public function addSet($setName,SynchroSet $set)  {
		$this->sets[$setName]=$set;
	}

	public function getListeTablesFromSet($set) {
		$listeTables = array();
		if($q=ifReq("SHOW TABLES")) {
			while($r=mysql_fetch_array($q)) {
				if($this->tableIsIn($r[0],$set)) {
					$listeTables[]=$r[0];
				}
			}
			return $listeTables;
		}
	}
	public function backupBDD() {
		set_time_limit(0);
		global $mabd,$bdd_host,$bdd_login,$bdd_pass,$bdd_nombase,$bdd_pass2;
		$host=$bdd_host=="localhost"?"127.0.0.1":$bdd_host;
		$pass = $bdd_pass==""?"":"-p$bdd_pass";
		$userPort=" -u $bdd_login $pass -h $host";
		creeRepSiExistePas($this->backupPath);


		$cmd = MYSQLDUMP_PATH." $userPort -C -e -f --add-drop-table $bdd_nombase  > ".$this->backupPath."backup_".date("Y-m-d_H_i_s").".sql" ;
		echo  $cmd."<br>";
		if(isset($_REQUEST["run"])) echo  exec($cmd);
		
		$cmd = "gzip ".$this->backupPath."*";
		echo  $cmd."<br>";
		if(isset($_REQUEST["run"])) echo  exec($cmd);
		
	}
	public function export() {
		set_time_limit(0);
		$tables = implode(" ",$this->getListeTablesFromSet($this->exportSets));

		global $mabd,$bdd_host,$bdd_login,$bdd_pass,$bdd_nombase,$bdd_pass2;
		$host=$bdd_host=="localhost"?"127.0.0.1":$bdd_host;
		$pass = $bdd_pass==""?"":"-p$bdd_pass";
		$userPort=" -u $bdd_login $pass -h $host";
		creeRepSiExistePas($this->exportPath);

		$cmd = MYSQLDUMP_PATH." $userPort -C -e -f --add-drop-table $bdd_nombase $tables > ".$this->exportPath."export.sql" ;
		echo  $cmd."<br>";
		if(isset($_REQUEST["run"])) echo  exec($cmd);
	}

	public function import() {
		set_time_limit(0);
		$tables = implode(" ",$this->getListeTablesFromSet($this->importSets));

		global $mabd,$bdd_host,$bdd_login,$bdd_pass,$bdd_nombase,$bdd_pass2;
		$host=$bdd_host=="localhost"?"127.0.0.1":$bdd_host;
		$pass = $bdd_pass==""?"":"-p$bdd_pass";
		$userPort=" -u $bdd_login $pass -h $host";
		creeRepSiExistePas($this->exportPath);
		$cmd = MYSQLDUMP_PATH." $userPort -C -e -f --add-drop-table $bdd_nombase $tables > ".$this->exportPath."backup".date("Y_m_d_H_i_s").".sql" ;
		echo  $cmd."<br>";
		if(isset($_REQUEST["run"])) echo  exec($cmd);
		echo "<br><br>";
		$cmd = MYSQL_PATH." $userPort -C -f $bdd_nombase < ".$this->importPath."export.sql" ;
		echo  $cmd."<br>";
		if(isset($_REQUEST["run"])) echo  exec($cmd);
	}


	public function tableIsIn($table,$sets) {
		if(is_array($sets["exclude"])) {
			foreach($sets["exclude"] as $unSetExcludeName) {
				$unSetExclude = $this->sets[$unSetExcludeName];
				if(isset($unSetExclude)) {
					if($unSetExclude->isIn($table)) {
						return false;
					}
				}
			}
		}
		foreach($sets["include"] as $unSetIncludeName) {
			$unSetInclude = $this->sets[$unSetIncludeName];
			if(isset($unSetInclude)) {
				if($unSetInclude->isIn($table)) {
					return true;
				}
			}
		}
	}

	public function setImports($includesSets,$excludeSets=null) {
		if(is_null($excludeSets)) $excludeSets=array();
		if(!is_array($includesSets)) $includesSets=array($includesSets);
		if(!is_array($excludeSets)) $excludeSets=array($excludeSets);
		$this->importSets=array("include"=>$includesSets,"exclude"=>$excludeSets);
	}

	public function setExports($includesSets,$excludeSets=null) {
		if(is_null($excludeSets)) $excludeSets=array();
		if(!is_array($includesSets)) $includesSets=array($includesSets);
		if(!is_array($excludeSets)) $excludeSets=array($excludeSets);
		$this->exportSets=array("include"=>$includesSets,"exclude"=>$excludeSets);
	}

	public $imagePath = "";
	public $folderProd = "/homez.95/efrogg/clients/misaki/";
	public $folderDev = "/homez.95/efrogg/en-developpement/misaki/";
	public $enProd = false;

	public function getFolderLocal() {
		return $this->enProd?$this->folderProd:$this->folderDev;
	}
	public function getFolderDistant() {
		return $this->enProd?$this->folderDev:$this->folderProd;
	}

	public function importImages($folders) {
		if(is_array($folders)) {
			foreach($folders as &$folder) {
				$this->importImages($folder);
			}
		} else {
			echo "<h2>importe $folders</h2>";
			$fromFolder = $this->getFolderDistant().$this->imagePath."/".$folders;
			$toFolder = $this->getFolderLocal().$this->imagePath."/".$folders;
			echo "<h3>sync $fromFolder ===> $toFolder</h3>";
			echo "<pre>";
			$this->synchroniseFolders($fromFolder,$toFolder,true);
			echo "</pre>";
		}
	}
	public function rsyncExport() {
		$this->initSyncMask();
		$this->synchroniseFolders($this->getFolderLocal(),$this->getFolderDistant(),true,$this->getFolderDistant());
	}
	public function rsyncImport() {
		$this->initSyncMask();
		$this->synchroniseFolders($this->getFolderDistant(),$this->getFolderLocal(),true,$this->getFolderLocal());
	}
	public $inclusions = array();
	public $exclusions = array();
	public function initSyncMask() {
		$this->exclusions=array("_misaki/(download)",
		"\\.gz$","log_upload.txt","log_worldpay.txt","\\.redim","constantes.inc.php","\\.log\\.txt","\\.log",
		"exportation","/importation_BDD/",
		"/_CACHE/","/_old/","/export/","/sauvegardes_bdd/","/old/","/logs/","/videos/","/_backup(.*)/");
		
		if(!isset($_REQUEST["avec_images"])) {
			$this->exclusions[]="_misaki/images/";
		}
	}
	public function resetSyncMask() {
		$this->inclusions = array();
		$this->exclusions = array();
	}
	public function isSyncMaskExcluded($f,$fullFile) {
		if($f =="." || $f == ".." || $f == "redim") return true; // exclu
		if(in_array($f,$this->inclusions)) return false; // non exclu
		if(in_array($f,$this->exclusions)) {
			echo "<br><span style='color:blue'>evite_____ $fullFile because $f</span>";
			return true; // exclu
		}
		// en version 'mask'
		foreach($this->inclusions as $incl)
		if(preg_match("#$incl#",$fullFile))
		return false; // non exclu
		foreach($this->exclusions as $excl)
		if(preg_match("#$excl#",$fullFile)){
			echo "<br><span style='color:blue'>evite_____ $fullFile because #$excl#</span>";
			return true; // exclu
		}

		return false; // non exclu
	}

	public function synchroniseFolders($from,$to,$recursif=false,$backupFolder=null) {
		if(is_null($backupFolder)) $backupFolder = $this->getFolderLocal();
		if($d = opendir($from)) {
			if(!file_exists($to)) {
				echo "<br>mkdir    $to";
				if(isset($_REQUEST["run"])) {
					mkdir($to);
				}
			}
			while($f=readdir($d)) {
				$tofile = $to."/".$f;
				$fromfile = $from."/".$f;
				//				$readable_tofile = str_replace($this->getFolderLocal())
				if($this->isSyncMaskExcluded($f,$fromfile)) {
					continue;
				}
				if(is_dir($fromfile)) {
					if($recursif) $this->synchroniseFolders($fromfile,$tofile,$recursif,$backupFolder);
				} else {
					// un fichier
					//					$action='';
					if(!file_exists($tofile)) {
						echo "<br>_new_    cp $fromfile $tofile";
						if(isset($_REQUEST["run"])) copy($fromfile,$tofile);
					} else if(filesize($fromfile) != filesize($tofile)) {
						//						echo "<br>".md5_file($fromfile)."vs".md5_file($tofile);
						$action="cp $fromfile $tofile";
						echo "<br><span style='color:red'>_change_ S $action";
						$backupFile=str_replace($backupFolder,$backupFolder."/_backup_".date("Y_m_d"),$tofile);
						echo "<br>________ backup vers $backupFile</span>";

						if(in_array(array_pop(explode(".",$fromfile)),array("php","htm","html","htaccess","xml")))
						echo "<pre>"."differences $e[href] : <br>".self::arr_diff( explode("\n",file_get_contents($tofile)),  explode("\n",file_get_contents($fromfile)) )."</pre>";
						else
						echo "<br>".filesize($fromfile)." vs ".filesize($tofile);

						if(isset($_REQUEST["run"])) {
							creeRepSiExistePas2($backupFile);
							copy($tofile,$backupFile);
							copy($fromfile,$tofile);
						}
					} else {
//						echo "<br>________ $fromfile";
					}
					//					if($action!="" && )
					// todo  : checksum
				}
			}
		}
	}
	public static function arr_diff( $f1 , $f2 , $show_equal = 0 )
	{

		$c1         = 0 ;                   # current line of left
		$c2         = 0 ;                   # current line of right
		$max1       = count( $f1 ) ;        # maximal lines of left
		$max2       = count( $f2 ) ;        # maximal lines of right
		$outcount   = 0;                    # output counter
		$hit1       = "" ;                  # hit in left
		$hit2       = "" ;                  # hit in right

		while (
		$c1 < $max1                 # have next line in left
		and
		$c2 < $max2                 # have next line in right
		and
		($stop++) < 1000            # don-t have more then 1000 ( loop-stopper )
		and
		$outcount < 20              # output count is less then 20
		)
		{
			/**
			 *   is the trimmed line of the current left and current right line
			 *   the same ? then this is a hit (no difference)
			 */
			if ( trim( $f1[$c1] ) == trim ( $f2[$c2])  )
			{
				/**
				 *   add to output-string, if "show_equal" is enabled
				 */
				$out    .= ($show_equal==1)
				?  self::formatline ( ($c1) , ($c2), "=", $f1[ $c1 ] )
				: "" ;
				/**
				 *   increase the out-putcounter, if "show_equal" is enabled
				 *   this ist more for demonstration purpose
				 */
				if ( $show_equal == 1 )
				{
					$outcount++ ;
				}

				/**
				 *   move the current-pointer in the left and right side
				 */
				$c1 ++;
				$c2 ++;
			}

			/**
			 *   the current lines are different so we search in parallel
			 *   on each side for the next matching pair, we walk on both
			 *   sided at the same time comparing with the current-lines
			 *   this should be most probable to find the next matching pair
			 *   we only search in a distance of 10 lines, because then it
			 *   is not the same function most of the time. other algos
			 *   would be very complicated, to detect 'real' block movements.
			 */
			else
			{

				$b      = "" ;
				$s1     = 0  ;      # search on left
				$s2     = 0  ;      # search on right
				$found  = 0  ;      # flag, found a matching pair
				$b1     = "" ;
				$b2     = "" ;
				$fstop  = 0  ;      # distance of maximum search

				#fast search in on both sides for next match.
				while (
				$found == 0             # search until we find a pair
				and
				( $c1 + $s1 <= $max1 )  # and we are inside of the left lines
				and
				( $c2 + $s2 <= $max2 )  # and we are inside of the right lines
				and
				$fstop++  < 10          # and the distance is lower than 10 lines
				)
				{

					/**
					 *   test the left side for a hit
					 *
					 *   comparing current line with the searching line on the left
					 *   b1 is a buffer, which collects the line which not match, to
					 *   show the differences later, if one line hits, this buffer will
					 *   be used, else it will be discarded later
					 */
					#hit
					if ( trim( $f1[$c1+$s1] ) == trim( $f2[$c2] )  )
					{
						$found  = 1   ;     # set flag to stop further search
						$s2     = 0   ;     # reset right side search-pointer
						$c2--         ;     # move back the current right, so next loop hits
						$b      = $b1 ;     # set b=output (b)uffer
					}
					#no hit: move on
					else
					{
						/**
						 *   prevent finding a line again, which would show wrong results
						 *
						 *   add the current line to leftbuffer, if this will be the hit
						 */
						if ( $hit1[ ($c1 + $s1) . "_" . ($c2) ] != 1 )
						{
							/**
							 *   add current search-line to diffence-buffer
							 */
							$b1  .= self::formatline( ($c1 + $s1) , ($c2), "-", $f1[ $c1+$s1 ] );

							/**
							 *   mark this line as 'searched' to prevent doubles.
							 */
							$hit1[ ($c1 + $s1) . "_" . $c2 ] = 1 ;
						}
					}



					/**
					 *   test the right side for a hit
					 *
					 *   comparing current line with the searching line on the right
					 */
					if ( trim ( $f1[$c1] ) == trim ( $f2[$c2+$s2])  )
					{
						$found  = 1   ;     # flag to stop search
						$s1     = 0   ;     # reset pointer for search
						$c1--         ;     # move current line back, so we hit next loop
						$b      = $b2 ;     # get the buffered difference
					}
					else
					{
						/**
						 *   prevent to find line again
						 */
						if ( $hit2[ ($c1) . "_" . ( $c2 + $s2) ] != 1 )
						{
							/**
							 *   add current searchline to buffer
							 */
							$b2   .= self::formatline ( ($c1) , ($c2 + $s2), "+", $f2[ $c2+$s2 ] );

							/**
							 *   mark current line to prevent double-hits
							 */
							$hit2[ ($c1) . "_" . ($c2 + $s2) ] = 1;
						}

					}

					/**
					 *   search in bigger distance
					 *
					 *   increase the search-pointers (satelites) and try again
					 */
					$s1++ ;     # increase left  search-pointer
					$s2++ ;     # increase right search-pointer
				}

				/**
				 *   add line as different on both arrays (no match found)
				 */
				if ( $found == 0 )
				{
					$b  .= self::formatline ( ($c1) , ($c2), "-", $f1[ $c1 ] );
					$b  .= self::formatline ( ($c1) , ($c2), "+", $f2[ $c2 ] );
				}

				/**
				 *   add current buffer to outputstring
				 */
				$out        .= $b;
				$outcount++ ;       #increase outcounter

				$c1++  ;    #move currentline forward
				$c2++  ;    #move currentline forward

				/**
				 *   comment the lines are tested quite fast, because
				 *   the current line always moves forward
				 */

			} /*endif*/

		}/*endwhile*/

		return $out;

	}/*end func*/

	/**
	 *   callback function to format the diffence-lines with your 'style'
	 */
	public static function formatline( $nr1, $nr2, $stat, &$value )  #change to $value if problems
	{
		if ( trim( $value ) == "" )
		{
			return "";
		}

		switch ( $stat )
		{
			case "=":
				return $nr1. " : $nr2 : = ".htmlentities( $value )  ."<br>";
				break;

			case "+":
				return $nr1. " : $nr2 : + <font color='blue' >".htmlentities( $value )  ."</font><br>";
				break;

			case "-":
				return $nr1. " : $nr2 : - <font color='red' >".htmlentities( $value )  ."</font><br>";
				break;
		}

	}

}
function creeRepSiExistePas2($chemin) {
	if(!file_exists($chemin)) {
		$split=explode("/",$chemin);
		$todo=array();
		while(count($split)>0) {
			array_pop($split);
			$tests = implode("/",$split);
			if(file_exists($tests)) break;
			$todo[]=$tests;
		}
		while($path=array_pop($todo)) {
			mkdir($path);
			file_put_contents($path."/index.htm","Acces interdit");
		}
	}
}

?>