<?php
/**
 * à partir de la liste des pages découvertes dans le chemin_detaille_annexe
 * renvoie le chemin complet vers une page annexe, dans la langue en cours
 *
 * @return string
 */
function get_chemin_page_annexe_from_chemin_detaille( ) {
	global $chemin_detaille;
	include_once("includes/html/url.inc.php");
	$retour=get_url_langue();
	$retour.="/".CST_REF_chemin_annexes;
	$chemin_detaille_annexes=$chemin_detaille["PAGES_ANNEXES"];
	foreach($chemin_detaille_annexes["pages"] as $la_page) {
		$res_page=$la_page["res"];
		$nom_page=titreToLien(get_nom_page_annexe_from_res($res_page));
		$retour.="/$nom_page";
	}
	$retour.=".php";
	return $retour;
}
/**
 * renvoie le nom d'une page annexe, en fonction d'un résultat de requete struct_elem
 * exemple :
 * $res=testReq2("SELECT * FROM shop_struct_elems WHERE id=$id_page AND id_structure=$id_struct_page"); 
 * $retour=get_nom_page_annexe_from_res($res);
 *
 * @param res_mysql $res_page
 * @return string
 */
function get_nom_page_annexe_from_res($res_page) {
	global $id_boutique,$id_langue,$id_struct_page;
	$req="SELECT get_traduction(nom,$id_boutique,$id_langue) AS nom FROM shop_pages_annexes WHERE id_elem=$res_page[id] AND id_structure=$id_struct_page";
	$nom_page="";
	if($res=testReq2($req)) {
		$nom_page=($res["nom"]);	
	}
	if(strlen($nom_page)==0) {
		//print_rr($res_page);
		$nom_page=($res_page["nom"]);
	}
	return $nom_page;
}
function get_nom_page_annexe_from_id($id_page) {
	global $id_struct_page;
	if($res_page=testReq2("SELECT * FROM shop_struct_elems WHERE id=$id_page AND id_structure=$id_struct_page")) {
		return get_nom_page_annexe_from_res($res_page);
	}
	return false;
}
?>