<?php


function RESIZE_image($image_origine,$typ,$largeurFinale,$hauteurFinale,$fichierSortie,$largeurImage,$hauteurImage,$formatPng) {
	global $qualitejpeg;
	
	global $qualitepng;
	$typ=strtoupper($typ);
	if($typ=="CROPMAXHORIZONTAL") {
		$rappLHimage=$largeurImage/$hauteurImage;
		$rappLHfinal=$largeurFinale/$hauteurFinale;
		
		if($hauteurImage>$largeurImage) {
			// si img verticale => CROP hauteur x hauteur
			$typ="CROPMAX";
			$largeurFinale=$hauteurFinale;
		} else if ($rappLHimage>$rappLHfinal){
			// si image trop en largeur 
			$typ="CROPMAX";
		} else {
			// sinon, juste un MAX
			$typ="MAX";
		}
	} else if($typ=="CROPMAXVERTICAL") {
		$rappLHimage=$largeurImage/$hauteurImage;
		$rappLHfinal=$largeurFinale/$hauteurFinale;
		
		if($largeurImage>$hauteurImage) {
			// si img horizontale => CROP hauteur x hauteur
			$typ="CROPMAX";
			$hauteurFinale=$largeurFinale;
		} else if($rappLHimage<$rappLHfinal) {
			// si image trop en hauteur 
			$typ="CROPMAX";
		} else {
			// sinon, juste un MAX
			$typ="MAX";
		}
	}

	switch($typ) {
		case "CROPMAX":
			$rx=$largeurFinale/$largeurImage;
			$ry=$hauteurFinale/$hauteurImage;
			$rapp=max($rx,$ry);
			// tailles de l'image originale resamplee
			$lf=floor($largeurImage*$rapp);
			$hf=floor($hauteurImage*$rapp);
			// tailles de l'image finale resizee recropee
			$lf2=$largeurFinale;
			$hf2=$hauteurFinale;
			// tailles de l'image originale cropee
			$loc=$largeurFinale/$rapp;
			$hoc=$hauteurFinale/$rapp;
			$im = imagecreatetruecolor  ($lf2, $hf2);
			if($formatPng) {
				imagealphablending($im,false);
				imagesavealpha ($im, true);
			}
			$dx=round(($largeurImage-$loc)/2);
			$dy=round(($hauteurImage-$hoc)/2);
			imagecopyresampled ( $im , $image_origine , 0 , 0 , $dx , $dy , $lf2 , $hf2 , $loc ,$hoc );
		break;
		case "PIXELSMAX":
			$pixelsMax=$largeurFinale*$hauteurFinale;
			$pixelsActu=$largeurImage*$hauteurImage;
			$rapp=min(1,sqrt($pixelsMax/$pixelsActu));
			$lf=floor($largeurImage*$rapp);
			$hf=floor($hauteurImage*$rapp);
			$im = imagecreatetruecolor  ($lf, $hf);
			if($formatPng) {
				imagealphablending($im,false);
				imagesavealpha ($im, true);
			}
			imagecopyresampled ( $im , $image_origine , 0 , 0 , 0 , 0 , $lf , $hf , $largeurImage ,$hauteurImage );
		break;
		case "MAX":
			$rx=$largeurFinale/$largeurImage;
			$ry=$hauteurFinale/$hauteurImage;
			$rapp=min(1,$rx,$ry);
			$lf=floor($largeurImage*$rapp);
			$hf=floor($hauteurImage*$rapp);
			$im = imagecreatetruecolor  ($lf, $hf);
			if($formatPng) {
				imagealphablending($im,false);
				imagesavealpha ($im, true);
			}
			imagecopyresampled ( $im , $image_origine , 0 , 0 , 0 , 0 , $lf , $hf , $largeurImage ,$hauteurImage );
		break;
		case "EXACT":
			$im = imagecreatetruecolor  ($largeurFinale, $hauteurFinale);
			if($formatPng) {
				imagealphablending($im,false);
				imagesavealpha ($im, true);
			}
			imagecopyresampled ( $im , $image_origine , 0 , 0 , 0 , 0 , $largeurFinale , $hauteurFinale , $largeurImage ,$hauteurImage );
		break;
		case "NO":
			$im=$image_origine;
		break;
	}
	if($formatPng) {
		imagepng($im,$fichierSortie,$qualitepng);
	} else {
		imagejpeg($im,$fichierSortie,$qualitejpeg);
	}
	@chmod($fichierSortie, 0777);
}
function RESIZE_get_image($f,$extension="") {
	if($extension=="") {
		$extension=substr($f,strrpos($f,"."),strlen($f));
	}
	switch(strtoupper($extension)) {
		case ".JPG":
		case ".JPEG":
			return imagecreatefromjpeg($f);
		break;
		case ".PNG":
			return imagecreatefrompng($f);
		break;
		case ".GIF":
			return imagecreatefromgif($f);
		break;
	}
}
function RESIZE_fichier($f,$typ,$largeurFinale,$hauteurFinale,$fichierSortie) {
	$extension=substr($f,strrpos($f,"."),strlen($f));
	$formatPng=false;
	if(strtoupper($extension)==".PNG") {
		$formatPng=true;
	}
	// 1 : on lit l'image
	$image_origine=RESIZE_get_image($f);
	//
	$size = getimagesize($f);
	$largeurImage=$size[0];
	$hauteurImage=$size[1];
	
	// 2 : on la redimensionne
	RESIZE_image($image_origine,$typ,$largeurFinale,$hauteurFinale,$fichierSortie,$largeurImage,$hauteurImage,$formatPng);
}
?>