<?php
	bdd_cree_table("shop_mises_a_jour","CREATE TABLE `shop_mises_a_jour` (
`identifiant` VARCHAR( 255 ) NOT NULL ,
`faite` TINYINT NOT NULL ,
`date_maj` DATETIME NOT NULL ,
PRIMARY KEY ( `identifiant` )
) TYPE = MYISAM ;",1);
	
	bdd_cree_table("shop_modules","CREATE TABLE IF NOT EXISTS `shop_modules` (
  `id` mediumint(9) NOT NULL auto_increment,
  `identifiant` varchar(255) NOT NULL,
  `actif` tinyint(2) NOT NULL,
  `id_boutique` mediumint(9) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `identifiant` (`identifiant`,`id_boutique`),
  
  KEY `id_boutique` (`id_boutique`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;",2);


bdd_cree_table("log_triggers","CREATE TABLE `log_triggers` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`texte` TEXT NOT NULL ,
`date_maj` DATETIME NOT NULL
) ENGINE = MYISAM",1);


bdd_cree_table("shop_compteurs","CREATE TABLE `shop_compteurs` (
`id_boutique` MEDIUMINT NOT NULL ,
`compteur` VARCHAR( 255 ) NOT NULL ,
`identifiant` VARCHAR( 255 ) NOT NULL ,
`valeur` INT NOT NULL ,
PRIMARY KEY ( `id_boutique` , `compteur` , `identifiant` )
) TYPE = MYISAM COMMENT = 'permet de créer es compteurs facilement';",1);


bdd_cree_table("shop_options_valeurs","CREATE TABLE `shop_options_valeurs` (
  `id_option` mediumint(9) NOT NULL default '0',
  `id_boutique` mediumint(9) NOT NULL default '0',
  `valeur` varchar(255) NOT NULL default '',
  `site` tinyint(1) NOT NULL default '0',
  `visible` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id_option`,`id_boutique`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Les valeurs des options par boutique'",1);


bdd_cree_table("shop_options_rubriques","CREATE TABLE `shop_options_rubriques` (
  `id` mediumint(9) NOT NULL auto_increment,
  `nom` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `nom` (`nom`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Les différentes catégories d''options'",1);


bdd_cree_table("shop_options","CREATE TABLE `shop_options` (
  `id` smallint(6) NOT NULL auto_increment,
  `nom` varchar(50) default NULL,
  `variable` varchar(50) NOT NULL default '',
  `id_rubrique` mediumint(9) default NULL,
  `type` enum('booleen','numerique','texte','date','liste','couleur','image','separateur','multilangue') default NULL,
  `predef` text NOT NULL,
  `commentaire` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `classement` (`id_rubrique`),
  KEY `nom` (`nom`),
  KEY `type` (`type`),
  KEY `variable` (`variable`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1",1);


bdd_cree_table("shop_ml_champs","CREATE TABLE `shop_ml_champs` (
  `id` mediumint(9) NOT NULL auto_increment,
  `id_boutique` mediumint(9) NOT NULL default '0',
  `classement` varchar(50) default NULL,
  `id_ensemble` mediumint(9) NOT NULL default '0',
  `id_objet` mediumint(9) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `id_boutique` (`id_boutique`,`id_ensemble`,`id_objet`),
  KEY `classement` (`classement`),
  KEY `id_ensemble` (`id_ensemble`),
  KEY `id_objet` (`id_objet`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Les champs de texte multilingues'",1);

bdd_cree_table("shop_ml_langues","CREATE TABLE `shop_ml_langues` (
  `id` mediumint(9) NOT NULL auto_increment,
  `id_boutique` mediumint(9) NOT NULL default '0',
  `nom` varchar(50) NOT NULL default '',
  `drapeau` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `id_boutique` (`id_boutique`),
  KEY `drapeau` (`drapeau`),
  KEY `id` (`id`),
  KEY `nom` (`nom`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Les langues pour la traduction'",1);


bdd_cree_table("shop_ml_traductions","CREATE TABLE `shop_ml_traductions` (
  `id_boutique` mediumint(9) NOT NULL default '0',
  `id_champs` mediumint(9) NOT NULL default '0',
  `id_langue` mediumint(9) NOT NULL default '0',
  `texte` text NOT NULL,
  PRIMARY KEY  (`id_boutique`,`id_champs`,`id_langue`),
  KEY `id_champs` (`id_champs`),
  KEY `id_langue` (`id_langue`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Les traductions'",1);

bdd_cree_table("shop_droits_rubriques","CREATE TABLE `shop_droits_rubriques` (
  `id` mediumint(9) NOT NULL auto_increment,
  `nom` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `nom` (`nom`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Les rubriques du backoffice'",1);


bdd_cree_table("shop_boutiques","CREATE TABLE `shop_boutiques` (
  `id` mediumint(9) NOT NULL auto_increment,
  `nom` varchar(50) NOT NULL default '',
  `adresse` text NOT NULL,
  `tel` varchar(20) NOT NULL default '',
  `fax` varchar(20) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `nom` (`nom`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1",1);


bdd_cree_table("shop_logs","CREATE TABLE `shop_logs` (
`date` DATETIME NOT NULL ,
`type` VARCHAR( 255 ) NOT NULL ,
`texte` TEXT NOT NULL ,
INDEX ( `date` , `type` )
) ENGINE = MYISAM  COMMENT='Tous les logs utiles';",1);


bdd_cree_table("shop_export_fichiers","CREATE TABLE `shop_export_fichiers` (
		  `id` int(11) NOT NULL auto_increment,
		  `session` varchar(50) NOT NULL,
		  `fichier` text NOT NULL,
		  `fichier_zip` text NOT NULL,
		  `type` varchar(1) NOT NULL,
		  `etat` varchar(50) NOT NULL,
		  `date_efface` int(11) NOT NULL,
		  PRIMARY KEY  (`id`),
		  KEY `session` (`session`,`date_efface`)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1",1);


bdd_cree_table("shop_cron_virtuels","CREATE TABLE `shop_cron_virtuels` (
  `id` mediumint(9) NOT NULL auto_increment,
  `identifiant` varchar(255) NOT NULL,
  `id_boutique` mediumint(9) NOT NULL,
  `date_debut` datetime default NULL,
  `date_fin` datetime default NULL,
  `date_dernier` datetime NOT NULL,
  `periode` varchar(255) NOT NULL default '1 DAY',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `identifiant` (`identifiant`,`id_boutique`),
  KEY `id_boutique` (`id_boutique`)
) ENGINE=MyISAM COMMENT='lancement de taches de manière périodique'",1);


bdd_cree_table("shop_users","CREATE TABLE `shop_users` (
  `id` mediumint(9) NOT NULL auto_increment,
  `id_boutique` mediumint(9) NOT NULL default '1',
  `login` varchar(50) NOT NULL default '',
  `pass` varchar(50) NOT NULL default '',
  `id_profil` mediumint(9) NOT NULL default '0',
  `actif` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `actif` (`actif`),
  KEY `id` (`id`),
  KEY `id_profil` (`id_profil`),
  KEY `login` (`login`),
  KEY `pass` (`pass`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Les utilisateurs du site (backoffice)'",1);

bdd_cree_table("shop_users_profils","CREATE TABLE `shop_users_profils` (
  `id` mediumint(9) NOT NULL auto_increment,
  `id_boutique` mediumint(9) NOT NULL default '0',
  `titre` varchar(50) NOT NULL default '',
  `vendeur` tinyint(1) NOT NULL default '0',
  `super_admin` tinyint(1) NOT NULL default '0',
  `droits` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `droits` (`droits`),
  KEY `id_boutique` (`id_boutique`),
  KEY `super_admin` (`super_admin`),
  KEY `titre` (`titre`),
  KEY `vendeur` (`vendeur`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Les profils des utilisateurs'",1);


bdd_cree_table("shop_requetes_optimisees","CREATE TABLE `shop_requetes_optimisees` (
  `id_boutique` mediumint(9) NOT NULL default '0',
  `classe` varchar(50) NOT NULL default '',
  `id_sec` varchar(50) NOT NULL default '0',
  `params` varchar(50) NOT NULL default '',
  `resultat` longtext character set utf8 collate utf8_unicode_ci NOT NULL,
  `date_creation` datetime NOT NULL default '0000-00-00 00:00:00',
  `date_validite` datetime NOT NULL default '0000-00-00 00:00:00',
  `id_langue` mediumint(9) NOT NULL,
  PRIMARY KEY  (`id_boutique`,`classe`,`id_sec`,`params`,`id_langue`),
  KEY `classe_2` (`classe`),
  KEY `date_validite` (`date_validite`),
  KEY `id_langue` (`id_langue`),
  KEY `id_sec` (`id_sec`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1",1);



	bdd_cree_table("shop_ml_site_categories","CREATE TABLE `shop_ml_site_categories` (
`id` MEDIUMINT NOT NULL AUTO_INCREMENT ,
`nom` VARCHAR( 50 ) NOT NULL ,
PRIMARY KEY ( `id` )
) TYPE = MYISAM COMMENT = 'Les différentes catégories de textes du site'",1);
	

bdd_cree_table("shop_struct_elems","CREATE TABLE `shop_struct_elems` (
  `id_structure` mediumint(9) NOT NULL default '0',
  `id` mediumint(9) NOT NULL default '0',
  `id_parent` mediumint(9) NOT NULL default '-1',
  `liste_parents` varchar(255) NOT NULL default '',
  `liste_enfants` text NOT NULL,
  `chemin` varchar(50) NOT NULL default '',
  `position` tinyint(4) NOT NULL default '0',
  `nom` varchar(255) default NULL,
  `type` enum('dossier','raccourci','separateur') NOT NULL default 'dossier',
  `id_cible` mediumint(9) NOT NULL default '0',
  `actif` tinyint(4) NOT NULL default '0',
  `actif_parentee` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`id_structure`,`id`),
  KEY `chemin` (`chemin`),
  KEY `id_cible` (`id_cible`),
  KEY `type` (`type`),

  KEY `id_parent` (`id_parent`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Noeuds des arbres de catégorie'",1);

bdd_cree_table("shop_structures","CREATE TABLE `shop_structures` (
  `id` mediumint(9) NOT NULL auto_increment,
  `id_boutique` mediumint(9) NOT NULL default '0',
  `type` enum('article', 'page', 'partenaire', 'magasin', 'option') NOT NULL default 'article',
  `max_id` mediumint(9) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `id_boutique` (`id_boutique`),
  KEY `max_id` (`max_id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Structures des arbres de catégorie'",1);



bdd_cree_table("shop_log__ml_traductions","CREATE TABLE `shop_log__ml_traductions`  ENGINE = ARCHIVE ( SELECT * FROM shop_ml_traductions LIMIT 0,0)",1);
bdd_ajoute_champs_archive("shop_log__ml_traductions");
bdd_cree_table("shop_log__ml_champs","CREATE TABLE `shop_log__ml_champs`  ENGINE = ARCHIVE ( SELECT * FROM shop_ml_champs LIMIT 0,0)",1);
bdd_ajoute_champs_archive("shop_log__ml_champs");


	// structure pour les options
	global $id_structure_options;
	$id_structure_options=bdd_get_structure(0,"option");

//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
//bdd_cree_table("","",1);
	
?>