<?php
require_once("includes/modules/Cmodule.class.php");
class Cmodule_boutique extends Cmodule {
	var $nom = "boutique en ligne";
	var $identifiant = "boutique" ;
	var $modules_dependants=array("arborescence","emails");
	function Cmodule_boutique() {
		parent::Cmodule();
		require_once("includes/general/structure.inc.php");
		shop_get_id_structure_articles(); // calcule une fois pour toutes l'id_structure du marchand
		
	}
	function __install_options() {
		
		//ok
		bdd_ajoute_option4("MENU_clients","Clients","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Clients");
		bdd_ajoute_option4("MENU_commandes","Commandes","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Commandes");
		bdd_ajoute_option4("MENU_marques","Les Marques","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Les Marques");
		bdd_ajoute_option4("MENU_structure","Structure","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Structure");
		bdd_ajoute_option4("MENU_paiements","Paiement","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Paiement");
		bdd_ajoute_option4("MENU_gammes","Réappro.","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Réappro.");
		bdd_ajoute_option4("MENU_fournisseurs","Fournisseur","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Fournisseur");
		bdd_ajoute_option4("MENU_transporteurs","Transporteurs","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Transporteurs");
		bdd_ajoute_option4("MENU_stocks","Stocks","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Stocks");
		bdd_ajoute_option4("MENU_Promotions","Promos !","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Promos !");
		bdd_ajoute_option4("MENU_prix","Prix","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Prix");
		bdd_ajoute_option4("MENU_zones","Zones","Admin.Menu","booleen","","Rendre visible dans le menu le bouton Zones");

		//ok
	
		bdd_ajoute_option4("TVA_defaut","TVA par défaut","Boutique.TVA","numerique","","Valeur de la TVA par défaut",2);
		bdd_ajoute_option4("TVA_export","Gestion de la TVA pour l'export","Boutique.TVA","booleen","","Permet de définir une TVA différente pour chaque pays à l'exportation",3);
		bdd_ajoute_option4("TVA_reduction","les réductions sont soumises a TVA ","Boutique.TVA","booleen","","Les commandes avec réduction auront une TVA totale réduite",4,false);
		bdd_ajoute_option4("TVA_export_RRP","Gestion de la TVA 'recommended retail price'","Boutique.TVA","booleen","","Politique de prix 'recommended retail price' : Le prix de vente est le même avec ou sans TVA.",4);
	//	bdd_ajoute_option3("TVA_transporteur_fixe","TVA du transporteur fixe","Boutique.TVA","booleen","","La TVA sera dûe sur le transporteur, même pour un pays avec une TVA à 0",1,1,0,5);
		bdd_ajoute_option4("TVA_transporteur","TVA du transporteur","Boutique.TVA","liste","normal||fixe||RRP","Méthode de calcul de la TVA transporteur : \nnormal : 0% pour l'export\nfixe : TVA a 19,6% pour tout le monde (même export)\nRRP : même prix payé, quelle que soit la TVA",5);
		bdd_supprime_option("TVA_transporteur_fixe");
		bdd_ajoute_option4("LIVR_offerte_mini","Livraison offerte à partir de","Boutique","numerique","","La livraison sera offerte si le panier dépasse la valeur indiquée.\n-1 pour ne jamais offrir la livraison",4);
		
		bdd_ajoute_option4("GES_prix","Gestion des prix","Boutique.Fonctionnalités","booleen","","La boutique gère les prix");
		bdd_ajoute_option4("CAT_sous_categorie_NB_art","Nombre d'articles par sous-catégorie","Article","numerique","","Définit le nombre d'articles visible pour chaque sous-catégorie (0 pour toutes)");
	
		bdd_ajoute_option4("MAIL_titre_comm_PAYEE","Titre mail commande PAYEE","Textes.Mails","multilangue","","Titre du mail commande PAYEE \$COM_REF remplacera la référence commande");
		bdd_ajoute_option4("MAIL_titre_comm_VALIDEE","Titre mail commande VALIDEE","Textes.Mails","multilangue","","Titre du mail commande VALIDEE \$COM_REF remplacera la référence commande");
		bdd_ajoute_option4("MAIL_titre_comm_EN_PREPARATION","Titre mail commande EN_PREPARATION","Textes.Mails","multilangue","","Titre du mail commande EN_PREPARATION \$COM_REF remplacera la référence commande");
		bdd_ajoute_option4("MAIL_titre_comm_EXPEDIEE","Titre mail commande EXPEDIEE","Textes.Mails","multilangue","","Titre du mail commande EXPEDIEE \$COM_REF remplacera la référence commande");
		bdd_ajoute_option4("MAIL_titre_comm_ANNULEE","Titre mail commande ANNULEE","Textes.Mails","multilangue","","Titre du mail commande ANNULEE \$COM_REF remplacera la référence commande");
		bdd_ajoute_option4("MAIL_titre_comm_REFUSEE","Titre mail commande REFUSEE","Textes.Mails","multilangue","","Titre du mail commande REFUSEE \$COM_REF remplacera la référence commande");
		bdd_ajoute_option4("MAIL_titre_comm_ATTENTE_PAIEMENT","Titre mail commande ATTENTE_PAIEMENT","Textes.Mails","multilangue","","Titre du mail commande ATTENTE_PAIEMENT \$COM_REF remplacera la référence commande");
		bdd_ajoute_option4("MAIL_titre_nouveau_pass","Titre mail commande nouveau mot de passe","Textes.Mails","multilangue","","Titre du mail envoyé lorsque le client a oublié son mot de passe");

		bdd_ajoute_option4("MAIL_envoie_comm_AAA","emails envoyés", "mails.envois", "separateur", "", "");
		bdd_ajoute_option4("MAIL_envoie_comm_PAYEE","envoi email commande PAYEE", "mails.envois", "booleen", "", "Un email sera envoyé au client lorsque sa commande passera en état 'PAYEE' (automatique par CB, action administrateur par chèque / virement)");
		bdd_ajoute_option4("MAIL_envoie_comm_VALIDEE","envoi email commande VALIDEE", "mails.envois", "booleen", "", "Un email sera envoyé au client lorsque sa commande passera en état 'VALIDEE'");
		bdd_ajoute_option4("MAIL_envoie_comm_EN_PREPARATION","envoi email commande EN_PREPARATION", "mails.envois", "booleen", "", "Un email sera envoyé au client lorsque sa commande passera en état 'EN_PREPARATION'");
		bdd_ajoute_option4("MAIL_envoie_comm_EXPEDIEE","envoi email commande EXPEDIEE", "mails.envois", "booleen", "", "Un email sera envoyé au client lorsque sa commande passera en état 'EXPEDIEE'");
		bdd_ajoute_option4("MAIL_envoie_comm_ANNULEE","envoi email commande ANNULEE", "mails.envois", "booleen", "", "Un email sera envoyé au client lorsque sa commande passera en état 'ANNULEE' (action administrateur)");
		bdd_ajoute_option4("MAIL_envoie_comm_REFUSEE","envoi email commande REFUSEE", "mails.envois", "booleen", "", "Un email sera envoyé au client lorsque sa commande passera en état 'REFUSEE'");
		bdd_ajoute_option4("MAIL_envoie_comm_ATTENTE_PAIEMENT","envoi email commande ATTENTE_PAIEMENT", "mails.envois", "booleen", "", "Un email sera envoyé au client lorsque sa commande passera en état 'ATTENTE_PAIEMENT' (passage de commande par chèque / virement)");
		//ok		
		bdd_ajoute_option4("MAIL_commentaire_comm_AAA","commentaires à la commande", "mails.commentaires", "separateur", "", "");
		bdd_ajoute_option4("MAIL_commentaire_comm_PAYEE","commentaire mail commande PAYEE", "mails.commentaires", "booleen", "", "L'administrateur pourra saisir un message destiné au client lorsque la commande sera passée en état 'PAYEE'");
		bdd_ajoute_option4("MAIL_commentaire_comm_VALIDEE","commentaire mail commande VALIDEE", "mails.commentaires", "booleen", "", "L'administrateur pourra saisir un message destiné au client lorsque la commande sera passée en état 'VALIDEE'");
		bdd_ajoute_option4("MAIL_commentaire_comm_EN_PREPARATION","commentaire mail commande EN_PREPARATION", "mails.commentaires", "booleen", "", "L'administrateur pourra saisir un message destiné au client lorsque la commande sera passée en état 'EN_PREPARATION'");
		bdd_ajoute_option4("MAIL_commentaire_comm_EXPEDIEE","commentaire mail commande EXPEDIEE", "mails.commentaires", "booleen", "", "L'administrateur pourra saisir un message destiné au client lorsque la commande sera passée en état 'EXPEDIEE'");
		bdd_ajoute_option4("MAIL_commentaire_comm_ANNULEE","commentaire mail commande ANNULEE", "mails.commentaires", "booleen", "", "L'administrateur pourra saisir un message destiné au client lorsque la commande sera passée en état 'ANNULEE'");
		bdd_ajoute_option4("MAIL_commentaire_comm_REFUSEE","commentaire mail commande REFUSEE", "mails.commentaires", "booleen", "", "L'administrateur pourra saisir un message destiné au client lorsque la commande sera passée en état 'REFUSEE'");
		bdd_ajoute_option4("MAIL_commentaire_comm_ATTENTE_PAIEMENT","commentaire mail commande ATTENTE_PAIEMENT", "mails.commentaires", "booleen", "", "L'administrateur pourra saisir un message destiné au client lorsque la commande sera passée en état 'ATTENTE_PAIEMENT'");
		//ok
		// -------------------
		bdd_ajoute_option4("COORDBQ__","Coordonnées bancaires","Boutique.Banque","separateur","","");
		// -------------	
		bdd_ajoute_option4("COORDBQ_CODE_BQ","Code banque","Boutique.Banque","texte","","Code banque");
		bdd_ajoute_option4("COORDBQ_CODE_GUI","Code guichet","Boutique.Banque","texte","","Code guichet");
		bdd_ajoute_option4("COORDBQ_COMPTE","Numéro de compte","Boutique.Banque","texte","","Numéro de compte");
		bdd_ajoute_option4("COORDBQ_CLE","Clé","Boutique.Banque","texte","","Clé");
		bdd_ajoute_option4("COORDBQ_DOMICILIATION","Domiciliation","Boutique.Banque","texte","","Domiciliation");
		bdd_ajoute_option4("COORDBQ_IBAN","identification internationale","Boutique.Banque","texte","","identification internationale");
		bdd_ajoute_option4("COORDBQ_BIC","BIC","Boutique.Banque","texte","","Identifiant international de la banque (BIC)");
//ok
		// pour le référencement
		bdd_ajoute_option4("FLV_ACCES_catalogue","FlashVars accès catalogue","Référencement","texte","","Format des données passées au flash pour un accès direct au catalogue (famille sans vente)");
		bdd_ajoute_option4("FLV_ACCES_categorie","FlashVars accès catégorie","Référencement","texte","","Format des données passées au flash pour un accès direct à la catégorie (famille avec vente)");
		bdd_ajoute_option4("FLV_ACCES_article","FlashVars accès article","Référencement","texte","","Format des données passées au falsh pour un accès direct à un article");
		bdd_ajoute_option4("REF_articles_vente","Référencement produits (vente)","Référencement","booleen","","Référence une page pour chaque article AVEC vente");
		bdd_ajoute_option4("REF_articles_sans_vente","Référencement produits (sans vente)","Référencement","booleen","","Référence une page pour chaque article SANS vente\n format variables : [\$variable]\nvariables disponibles : \$id_elem...");
		bdd_ajoute_option4("REF_catalogue","Référencement familles catalogue (sans vente)","Référencement","booleen","","Référence une page pour chaque famille du catalogue (SANS vente)\n format variables : [\$variable]\nvariables disponibles : \$id_elem...");
		bdd_ajoute_option4("REF_categories","Référencement familles (avec vente)","Référencement","booleen","","Référence une page pour chaque famille du catalogue (SANS vente). \n format variables : [\$variable]\nvariables disponibles : \$id, \$id_elem...");
	
		//ok
		bdd_ajoute_option4("REF_CAT_VTE_aaa","", "Référencement", "separateur", "", "");
		bdd_ajoute_option4("REF_CAT_VTE_f_titre","format titre catégorie vente", "Référencement", "multilangue", "", "format de la balise META title d'une page catégorie AVEC vente");
		bdd_ajoute_option4("REF_CAT_VTE_f_desc","format descr catégorie vente", "Référencement", "multilangue", "", "format de la balise META description d'une page catégorie AVEC vente");
		bdd_ajoute_option4("REF_CAT_VTE_f_keyword","format mots clés catégorie vente", "Référencement", "multilangue", "", "format de la balise META keywords d'une page catégorie AVEC vente");	
		bdd_ajoute_option4("REF_CAT_SSVTE_aaa","", "Référencement", "separateur", "", "");
		bdd_ajoute_option4("REF_CAT_SSVTE_f_titre","format titre catégorie sans vente", "Référencement", "multilangue", "", "format de la balise META title d'une page catégorie SANS vente");
		bdd_ajoute_option4("REF_CAT_SSVTE_f_desc","format descr catégorie sans vente", "Référencement", "multilangue", "", "format de la balise META description d'une page catégorie SANS vente");
		bdd_ajoute_option4("REF_CAT_SSVTE_f_keyword","format mots clés catégorie sans vente", "Référencement", "multilangue", "", "format de la balise META keywords d'une page catégorie SANS vente");
		bdd_ajoute_option4("REF_ART_VTE_aaa","", "Référencement", "separateur", "", "");
		bdd_ajoute_option4("REF_ART_VTE_f_titre","format titre article vente", "Référencement", "multilangue", "", "format de la balise META title d'une page article AVEC vente");
		bdd_ajoute_option4("REF_ART_VTE_f_desc","format descr article vente", "Référencement", "multilangue", "", "format de la balise META description d'une page article AVEC vente");
		bdd_ajoute_option4("REF_ART_VTE_f_keyword","format mots clés article vente", "Référencement", "multilangue", "", "format de la balise META keywords d'une page article AVEC vente");		
		bdd_ajoute_option4("REF_ART_SSVTE_aaa","", "Référencement", "separateur", "", "");
		bdd_ajoute_option4("REF_ART_SSVTE_f_titre","format titre article sans vente", "Référencement", "multilangue", "", "format de la balise META title d'une page article SANS vente");
		bdd_ajoute_option4("REF_ART_SSVTE_f_desc","format descr article sans vente", "Référencement", "multilangue", "", "format de la balise META description d'une page article SANS vente");
		bdd_ajoute_option4("REF_ART_SSVTE_f_keyword","format mots clés article sans vente", "Référencement", "multilangue", "", "format de la balise META keywords d'une page article SANS vente");
		bdd_ajoute_option4("REF_TIT_art_vente","format titre article vendable","Référencement","multilangue","","format du titre d'un article en vente.\nformat des variables : [\$variable]\nvariables disponibles : nom, marque, ref, type");
		bdd_ajoute_option4("REF_TIT_art_ss_vente","format titre article non vendable","Référencement","multilangue","","format du titre d''un article non vendable.\nformat des variables : [\$variable]\nvariables disponibles : nom, marque, ref, type");
		bdd_ajoute_option4("REF_TIT_fam_vente","format titre famille vendable","Référencement","multilangue","","format du titre d'une famille en vente.\nformat des variables : [\$variable]\nvariables disponibles : nom");
		bdd_ajoute_option4("REF_TIT_fam_ss_vente","format titre famille non vendable","Référencement","multilangue","","format du titre d'une famille non vendable.\nformat des variables : [\$variable]\nvariables disponibles : nom");
		//bdd_ajoute_option("REF_KW_fam_aaa","INSERT INTO `shop_options` ( `nom`, `variable`, `id_rubrique`, `type`, `predef`, `commentaire`) VALUES ( 'Mots clés des familles', 'REF_KW_fam_aaa', 17, 'separateur_titre', '', 'Importance de la marque pour générer les mots clés de la famille');");
		bdd_ajoute_option4("REF_KW_fam_imp_marque","importance de la MARQUE","Référencement","liste","0||1||2||3","Importance de la marque pour générer les mots clés de la famille");
		bdd_ajoute_option4("REF_KW_fam_imp_type","importance du TYPE","Référencement","liste","0||1||2||3","Importance du type de produit pour générer les mots clés de la famille");
		bdd_ajoute_option4("REF_KW_fam_imp_nom","importance du NOM","Référencement","liste","0||1||2||3","Importance du nom du produit  pour générer les mots clés de la famille");
		bdd_ajoute_option4("REF_KW_fam_supp","mots clés supplémentaires","Référencement","multilangue_long","","Ajoute ces mots clés pour générer les mots clés de la famille (importance maxi)");
		bdd_ajoute_option4("REF_KW_fam_imp_supp","importance des MOTS CLES SUPPLEMENTAIRES","Référencement","liste","0||1||2||3","Ajoute ces mots clés pour générer les mots clés de la famille (importance maxi)");
		bdd_ajoute_option4("REF_KW_fam_imp_def","importance des MOTS CLES PAR DEFAUT","Référencement","liste","0||1||2||3","Importance des mots clés par défaut pour générer les mots clés de la famille");
		bdd_ajoute_option4("REF_KW_fam_imp_perso","importance des MOTS CLES PERSONNALISES","Référencement","liste","0||1||2||3","Importance des mots clés personnalisés (personnaliser famille) pour générer les mots clés");

		// inscription
		bdd_ajoute_option4("IDENT_QUE_1","Question secrète 1","Textes.Identification","multilangue","","Une des questions secrète en cas de perte de mot de passe");
		bdd_ajoute_option4("IDENT_QUE_2","Question secrète 2","Textes.Identification","multilangue","","Une des questions secrète en cas de perte de mot de passe");
		bdd_ajoute_option4("IDENT_QUE_3","Question secrète 3","Textes.Identification","multilangue","","Une des questions secrète en cas de perte de mot de passe");
	
		// adresse
		bdd_ajoute_option4("FORM_adr_ppale","titre adresse principale","Textes.Identification","multilangue","","Titre de l'adresse principale dans la combo");
		
	
		bdd_ajoute_option4("FORM_insc_saisie_tel_ou_gsm","alert - aucun tel renseigné","Textes.Identification","multilangue","","Formulaire - alerte - au moins un num. de tel doit etre renseigne");
		bdd_ajoute_option4("FORM_insc_pass_court","alert - mot de passe trop court","Textes.Identification","multilangue","","le mot de passe doit faire au moins 5 carac");
		bdd_ajoute_option4("FORM_compte_perso_cree","alert - Compte Créé","Textes.Identification","multilangue","","alerte - le compte a bien été créé cliquez sur ok ");
		bdd_ajoute_option4("FORM_compte_perso_modifie","alert - Compte modifié","Textes.Identification","multilangue","","alerte - le compte a bien été changé cliquez sur ok ");
		bdd_ajoute_option4("FORM_insc_civilite","Civilité","Textes.Identification","multilangue","","Formulaire d'inscription - Civilité du nouveau Client");
		bdd_ajoute_option4("FORM_insc_civilite_choix1","M.","Textes.Identification","multilangue","","Formulaire d'inscription - Civilité du nouveau Client : M. pour Monsieur");
		bdd_ajoute_option4("FORM_insc_civilite_choix2","Mme","Textes.Identification","multilangue","","Formulaire d'inscription - Civilité du nouveau Client : Mme. pour Madame");
		bdd_ajoute_option4("FORM_insc_civilite_choix3","Mlle","Textes.Identification","multilangue","","Formulaire d'inscription - Civilité du nouveau Client : Mlle. pour Mademoiselle");
		bdd_ajoute_option4("FORM_insc_nom","Nom","Textes.Identification","multilangue","","Formulaire d'inscription -  votre nom");
		bdd_ajoute_option4("FORM_insc_prenom","Prénom","Textes.Identification","multilangue","","Formulaire d'inscription - Votre prénom");
		bdd_ajoute_option4("FORM_insc_societe","Société","Textes.Identification","multilangue","","Formulaire d'inscription - Votre Societe");
		bdd_ajoute_option4("FORM_insc_email","E-mail","Textes.Identification","multilangue","","Formulaire d'inscription - Votre email");
		bdd_ajoute_option4("FORM_insc_code_postal","Code postal","Textes.Identification","multilangue","","Formulaire d'inscription - Votre code postal");
		bdd_ajoute_option4("FORM_insc_ville","Ville","Textes.Identification","multilangue","","Formulaire d'inscription - Votre ville");
		bdd_ajoute_option4("FORM_insc_pays","Pays","Textes.Identification","multilangue","","Formulaire d'inscription - Votre pays");
		bdd_ajoute_option4("FORM_insc_region","Région","Textes.Identification","multilangue","","Formulaire d'inscription - Votre Région");
		bdd_ajoute_option4("FORM_insc_adresse","Adresse","Textes.Identification","multilangue","","Formulaire d'inscription - Votre adresse");
		bdd_ajoute_option4("FORM_insc_telephone","Téléphone","Textes.Identification","multilangue","","Formulaire d'inscription - Votre téléphone");
		bdd_ajoute_option4("FORM_insc_mobile","GSM","Textes.Identification","multilangue","","Formulaire d'inscription - votre mobile");
		bdd_ajoute_option4("FORM_insc_passe","Passe","Textes.Identification","multilangue","","Formulaire d'inscription - Mot de passe");
		bdd_ajoute_option4("FORM_insc_confirm","Confirmer","Textes.Identification","multilangue","","Formulaire d'inscription - Confirmer");
		bdd_ajoute_option4("FORM_insc_naissance","Date de naissance","Textes.Identification","multilangue","","Formulaire d'inscription - Naissance");
		bdd_ajoute_option4("FORM_insc_texte_qst_secrete","Question Secrète","Textes.Identification","multilangue","","Formulaire d'inscription - Texte question secrete");
		bdd_ajoute_option4("FORM_insc_reponse","Réponse","Textes.Identification","multilangue","","Formulaire d'inscription - Votre réponse");
		bdd_ajoute_option4("FORM_insc_newsletter","M'inscrire à la newsletter","Textes.Identification","multilangue","","Formulaire d'inscription - Inscrivez vous a la newsletter");
		bdd_ajoute_option4("ALERT_invalid_user","alert mauvais loggin","Textes.Identification","multilangue","","alert loggin et mot de passe invalide lors de la connexion");
	
		bdd_ajoute_option4("CAT_couleurs","Couleurs des catégories personnalisables","Catégorie","booleen","","");
		bdd_ajoute_option4("ACCUEIL_nb_articles","Nombre d'articles en page d'accueil","Accueil","numerique","","Indique le nombre d'articles qui sera affiché en page d'accueil.");
		bdd_ajoute_option4("ACCUEIL_affiche_CAT","Catégorie en page d'accueil","Accueil","booleen","","Indique si les catégories d'articles seront affichées sur la page d'accueil.");
		bdd_ajoute_option4("ACCUEIL_mise_en_avant","Catégorie mise en avant en page d'accueil","Accueil","booleen","","");
		bdd_ajoute_option4("ACCUEIL_message_occasionnel","Message occasionnel","Accueil","multilangue_long","","Ce texte apparait au lancement du site - ex : car inventaire, les commandes seront traitees... ");
		bdd_ajoute_option4("CAT_perso_modele","Modèle des catégories personnalisable","Catégorie","booleen","","");
		bdd_ajoute_option_image("ART","la vignette article");
		bdd_ajoute_option_image("CAT","la vignette catégorie");
		bdd_ajoute_option_image("TRA","le visuel transporteur");
		bdd_ajoute_option_image("MARQ","les logos de marque");
		bdd_ajoute_option_image("PAIE","les moyens de paiement");
		bdd_ajoute_option_image("GAM","les visuels des gammes");
		
		bdd_ajoute_option4("NB_ART_terminés","Nombre d'articles terminés affichés","Accueil","numerique","","");
		bdd_ajoute_option4("ACCUEIL_NB_CAT","Nombre de catégories en page d'accueil","Accueil","numerique","","Indique le nombre de catégories qui sera affiché en page d'accueil.");
		bdd_ajoute_option4("ACCUEIL_NB_articles_par_categories","Nombre d'articles par catégorie sur l'accueil","Accueil","numerique","","Indique le nombre d'articles qui sera affiché pour chaque catégorie en page d'accueil.");
		bdd_ajoute_option4("CAT_sous_categorie","Aperçu des sous catégories","Catégorie","booleen","","Pour chaque catégorie, on affiche ses sous catégories");
		bdd_ajoute_option4("CAT_sous_categorie_NB","Nombre de sous catégories affiché","Catégorie","numerique","","Le nombre de sous catégories affiché pour chaque catégorie");
		
		bdd_ajoute_option4("ART_typ_reappro","Type de réapprovisionnement par défaut","Article","liste","categorie||fournisseur||article","Ce type de réapprovisionnent sera sélectionné par défaut sur la fiche article");
		bdd_ajoute_option4("STO_MAJ","Mise à jour du stock avec les commandes","Stock","liste","auto||manuel||question","Mise à jour du stock avec les commandes");
	
		bdd_ajoute_option4("COM_ref","modèle de référence commande","Commandes","texte","","méthode pour générer les références commandes (\$A\$MM\$JJ\$NNNN)");
	
		bdd_ajoute_option4("GES_stocks","Gestion du stock","Boutique.Fonctionnalités","booleen","","La boutique gère le stock");
		bdd_ajoute_option4("GES_ventes","Gestion des ventes","Boutique.Fonctionnalités","booleen","","La boutique gère les ventes");
		bdd_ajoute_option4("GES_zones","Zones géographiques","Boutique.Fonctionnalités","booleen","","La boutique gère les zones géographiques");
		bdd_ajoute_option4("GES_zones_region","Zones géographiques par régions","Boutique.Fonctionnalités","booleen","","La boutique gère les zones géographiques par régions (pays -> région)");
	
		bdd_ajoute_option4("GAM_VISU","Visualisation des gammes de réappro","Stock","liste","aucun||image||sigle","Manière de réprésenter chaque gamme de réapprovisionnement. Le sigle utilise un texte et une couleur.");
		bdd_ajoute_option4("CAT_presentation","Présentation de catégorie","Catégorie","booleen","","Pouvoir définir une présentation (texte+image) pour chaque catégorie");
		bdd_ajoute_option4("ART_ecopart","Ecopart","Article","booleen","","Possibilité de définir l'écopart pour les articles");
		bdd_ajoute_option4("ART_poids","Poids et encombrement","Article","booleen","","Définir les poids et encombrements des articles pour les livraisons");
		bdd_ajoute_option4("ART_SPEC","Spécifications","Article","booleen","","Possibilité de définir les spécifications des articles");
		bdd_ajoute_option4("ART_SPEC_constructeur","Spécifications constructeur","Article","booleen","","Possibilité de définir directement le texte des spécifications constructeurs");
		bdd_ajoute_option3("ART_DECL","Déclinaisons","Article","booleen","","Possibilité de définir des déclinaisons d'articles");
		bdd_ajoute_option_image("CATFOND","le fond des catégories");
		// titres des commandes
		bdd_ajoute_option4("TXT_com_titre_ANNULEE","Titre commande ANNULEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_titre_ATTENTE_PAIEMENT","Titre commande ATTENTE_PAIEMENT","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_titre_EN_PREPARATION","Titre commande EN_PREPARATION","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_titre_EXPEDIEE","Titre commande EXPEDIEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_titre_PAYEE","Titre commande PAYEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_titre_REFUSEE","Titre commande REFUSEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_titre_VERIFIER","Titre commande VERIFIER","Textes","multilangue","","Affiché dans le suivi de commande");	
		bdd_ajoute_option4("TXT_com_titre_CONTACTER","Titre commande CONTACTER","Textes","multilangue","","Affiché dans le suivi de commande");	
		bdd_ajoute_option4("TXT_com_titre_TERMINEE","Titre commande TERMINEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_titre_VALIDEE","Titre commande VALIDEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_titre_ZZZ","","Textes","separateur","","Affiché dans le suivi de commande");	
		// descs des commandes
		bdd_ajoute_option4("TXT_com_desc_ANNULEE","Description commande ANNULEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_desc_ATTENTE_PAIEMENT","Description commande ATTENTE_PAIEMENT","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_desc_EN_PREPARATION","Description commande EN_PREPARATION","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_desc_EXPEDIEE","Description commande EXPEDIEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_desc_PAYEE","Description commande PAYEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_desc_REFUSEE","Description commande REFUSEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_desc_VERIFIER","Description commande VERIFIER","Textes","multilangue","","Affiché dans le suivi de commande");	
		bdd_ajoute_option4("TXT_com_desc_CONTACTER","Description commande CONTACTER","Textes","multilangue","","Affiché dans le suivi de commande");	
		bdd_ajoute_option4("TXT_com_desc_TERMINEE","Description commande TERMINEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_desc_VALIDEE","Description commande VALIDEE","Textes","multilangue","","Affiché dans le suivi de commande");
		bdd_ajoute_option4("TXT_com_desc_ZZZ","","Textes","separateur","","Affiché dans le suivi de commande");			
	
		bdd_ajoute_option4("GES_marques","Gestion des marques","Boutique.Fonctionnalités","booleen","","La boutique gère les marques");

		// options de recherche normale
		bdd_ajoute_option4("RECH_catalogue","étendue de la recherche","Recherche","liste","tout||boutique||catalogue","La recherche s'étendra aux articles en vente, ou non, ou les deux");
		bdd_ajoute_option4("RECH_reference","recherche dans la référence","Recherche","booleen","","La recherche d'un texte ira chercher dans la référence");
		bdd_ajoute_option4("RECH_arbo","recherche dans l'arborescence","Recherche","booleen","","La recherche d'un texte ira chercher le nom de l'arborescence contenant les articles (dossier principal de l'article, pas l'arborescence, ni la personnalisation)");
		
		bdd_ajoute_option4("RECH_titre","recherche dans le titre","Recherche","booleen","","La recherche d''un texte ira chercher dans le titre");
		bdd_ajoute_option4("RECH_soustitre","recherche dans le sous-titre","Recherche","booleen","","La recherche d''un texte ira chercher dans le sous-titre");
		bdd_ajoute_option4("RECH_marque","recherche dans la marque","Recherche","booleen","","La recherche d'un texte ira chercher dans la marque");
		bdd_ajoute_option4("RECH_description","recherche dans la description","Recherche","booleen","","La recherche d''un texte ira chercher dans la description");
		bdd_ajoute_option4("RECH_type","recherche dans le type d'article","Recherche","booleen","","La recherche d'un texte ira chercher dans l'intitulé du type d'article des produits");
		bdd_ajoute_option4("RECH_motscles","recherche dans les mots clés","Recherche","booleen","","La recherche d'un texte ira chercher dans les mots clés de l'article");
		bdd_ajoute_option4("RECH_maxres","Nombre de résultats maxi","Recherche","numerique","","Nombre maximum de résultats lors d'une recherche (-1 = infini)");
		// options de recerche avancée
		bdd_ajoute_option4("RECH_AV_active","recherche avancée","Recherche","booleen","","Active ou non la recherche avancée");
		bdd_ajoute_option4("RECH_AV_type","recherche avancée par type","Recherche","booleen","","Ajout des champs de recherche par spécidications détaillées dans la recherche avancée.");
		bdd_ajoute_option4("RECH_AV_spec","recherche avancée par specifications","Recherche","booleen","","Ajout d'un champ de recherche par type de produit dans la recherche avancée");
		bdd_ajoute_option4("RECH_AV_declin","recherche avancée par déclinaisons","Recherche","booleen","","Ajout d'un champ de recherche par déclinaison de produit\n(la recherche par type de produits doit être cochée");
		bdd_ajoute_option4("RECH_AV_zzz","","Recherche","separateur","","");
		// fin options recherche avancée
		
		bdd_ajoute_option4("GES_catalogue","Gestion d'un catalogue","Boutique.Fonctionnalités","booleen","","La boutique gère un catalogue de produits, sans vente");
	
		//
		bdd_ajoute_option3("PRO_BONS_affiche_site","Activer les bons dans le site","Promotions","booleen",1,"Affiche ou non les bons de reduction dans le site,dans mon compte, dans le panier...",0,1,0,1);
		bdd_ajoute_option4("PRO_operations","Gestion des opérations","Promotions","booleen","","Les bons de réduction sont regroupés en plusieurs opérations");
		bdd_ajoute_option4("PRO_BONS_attribues","Suivi des bons","Promotions","booleen","","Les bons de réduction sont attribués");
		bdd_ajoute_option4("PRO_BONS_clients","Bons associés à un client","Promotions","booleen","","Les bons de réduction peuvent être associés à un client");
		bdd_ajoute_option3("PRO_BONS_cumulables","Bons cumulables","Promotions","booleen",1,"Les bons de réduction peuvent être cumulés",1,1,0,3) ;
		bdd_ajoute_option3("PRO_BONS_nb_maxi","Nombre de bons maxi","Promotions","numerique",99,"nombre maximum de bons (si cumulables)",1,1,0,4) ;
		//
	
		bdd_ajoute_option4("ZON_pays_defaut","id du pays sélectionné par défaut","Textes.Identification","numerique","","Modifiable par la page des Zones");
		//
		bdd_ajoute_option4("COMMANDE_ALERT_enregistree","alert - commande enregistree","Commandes","numerique","","texte d'enregistrement de votre commande");
		bdd_ajoute_option4("ART_GAL","Galerie","Article","booleen","","Galerie d'image pour les articles");
		//
		//
		
		bdd_ajoute_option4("COMMANDE_mail_suivi","email prévenu des commandes","Commandes","texte","","Email qui sera averti des commandes passées sur le site.");
		bdd_ajoute_option4("REF_article_format_url","format de l'url d'un article","Référencement","texte","","format d'affichage de l'url d'un article\nformat des variables : [\$variable]\nvariables disponibles : nom, marque, ref, type");
	
	
		bdd_ajoute_option4("ART_ASSO","Associations d'articles","Article","booleen","","Possibilité de définir des associations entre les articles");
		bdd_ajoute_option4("ART_ASSO_liste","Association dans les listes","Article","booleen","","Les articles associés sont visibles au niveau des listes");
		bdd_ajoute_option4("ART_ASSO_reciproque","Association réciproque","Article","booleen","","Les associations d''articles sont créées dans les deux sens");
		bdd_ajoute_option4("ART_DECL_stock","Stock des déclinaisons obligatoire","Stock","booleen","","Le stock de chaque déclinaison est toujours défini");
		bdd_ajoute_option4("ART_TRI_vendeur","Tri du vendeur","Article","booleen","","Le tri des articles peut être personnalisé");
		bdd_ajoute_option4("STO_reappro","Stock avec réapprovisionnement","Stock","booleen","","Le site gère un réapprovisionnement des articles, avec différentes gammes");
		bdd_ajoute_option4("STO_aff_termines","Stock affiche articles terminés","Stock","booleen","","Les articles sans stock, sans réapprovisionnement apparaîtront sur le site");
		bdd_ajoute_option4("ART_SPEC_fiche_visible","l'article recupere les specs","Article","booleen","","La fiche article recupere les specs si il y en a");
		
	
		
		bdd_ajoute_option4("GES_prix_promo","Gestion des prix promo","Boutique.Fonctionnalités","booleen","","La boutique gère les prix promo");
		bdd_ajoute_option4("SCR_pan_etape_paiement","script a l'étape du paiement", "Script", "texte", "", "Script à appeler lorsqu'on arrive sur la page du choix des paiements (ex. : google conversion)");
	
	
		// reduction par commande
		bdd_ajoute_option4("PRM_reduct_com_","","Commandes","separateur","","");
		bdd_ajoute_option4("PRM_reduct_com_type","Réduction par commande","Commandes","liste","aucune||pourcentage||euros","cette réduction est appliquée en fin de panier");
		bdd_ajoute_option4("PRM_reduct_com_valeur","Valeur réduction par commande","Commandes","numerique","","Valeur de la réduction appliquée en fin de panier");
		bdd_ajoute_option4("PRM_reduct_com_incl_port","Réduction inclut port","Commandes","booleen","","la réduction portera aussi sur les frais de port");
		bdd_ajoute_option4("PRM_reduct_com_nb_com_mini","Réduction nombre commandes mini","Commandes","numerique","","Nombre de commandes mini du client pour appliquer la réduction");
		bdd_ajoute_option4("PRM_reduct_com_nb_com_maxi","Réduction nombre commandes maxi","Commandes","numerique","","Nombre de commandes maxi du client pour appliquer la réduction");
		bdd_ajoute_option4("PRM_reduct_description","Description de la réduction","Commandes","multilangue","","Apparaît dans le panier quand la réduction s'applique.");
		bdd_ajoute_option4("PRM_reduct_com_ZZZ","","Commandes","separateur","","");
		
			/////////////////////////////////////////////////////////////////MODIFICATION JM/////////////////////////////////////////////////////////////
		//HTML
		
		
		//Structure de la fiche article
		bdd_ajoute_option4("HTML_struct_fa", "Structure de la fiche article", "HTML", "liste", "Normale||Onglets", "Structure de la page html de la fiche article",0);
///...		
		//Différents modules de la fiche article
		bdd_ajoute_option4("HTML_fa_aff_specs","Affichage des specifications","HTML.Fiche article","booleen","","Affichage des specifications d'un article",0);
		bdd_ajoute_option4("HTML_fa_nb_assoc", "Nombre d'articles associés", "HTML.Fiche article", "liste", "0||1||2||3||4||5||6||7||8", "Nombre d'articles associés affiché(au max.)",0);
		bdd_ajoute_option4("HTML_fa_prix", "Affichage du prix", "HTML.Fiche article", "booleen", "", "Affichage du prix de l'article",0);
		bdd_ajoute_option4("HTML_fa_promo", "Affichage de la promotion", "HTML.Fiche article", "booleen", "", "Affichage de la promotion actuelle sur l'article",0);	
		bdd_ajoute_option4("HTML_fa_declinaison", "Affichage des déclinaisons", "HTML.Fiche article", "booleen", "", "Affichage des différentes déclinaisons",0);
		bdd_ajoute_option4("HTML_fa_btn_ajout", "Affichage du bouton 'Acheter' ", "HTML.Fiche article", "booleen", "", "Affichage du bouton 'Acheter'",0);
		bdd_ajoute_option4("HTML_fa_mon_panier", "Affichage du panier", "HTML.Fiche article", "booleen", "", "Affichage de la petite icône du panier",0);
		bdd_ajoute_option4("HTML_fa_chemin", "Affichage du chemin", "HTML.Fiche article", "booleen", "", "Affichage du chemin permettant d'accéder à l'article",0);
		bdd_ajoute_option4("HTML_fa_reappro", "Affichage de la gamme de réappro.", "HTML.Fiche article", "booleen", "", "Affichage de la gamme de réapprovisionnement",0);
		bdd_ajoute_option4("HTML_fa_galerie", "Affichage de la galerie", "HTML.Fiche article", "booleen", "", "Affichage de la galerie associée à l'article",0);
		bdd_ajoute_option4("HTML_fa_eco-part", "Affichage de l'éco-participation", "HTML.Fiche article", "booleen", "", "Affichage du montant de l'éco-participation",0);
		bdd_ajoute_option4("HTML_fa_stock", "Affichage des stocks", "HTML.Fiche article", "booleen", "", "Affichage des stocks pour un article",0);
		bdd_ajoute_option4("HTML_fa_max_stock", "Stock maximal affiché", "HTML.Fiche article", "numerique", "", "Stock maximal autorisé à être affiché");
		bdd_ajoute_option4("HTML_fa_marque", "Affichage de la marque", "HTML.Fiche article", "liste", "Aucun||Texte||Image", "Type d'affichage de la marque", 0);
		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//ok	
	//	bdd_ajoute_option3("STO_decl_non_vides", "stock déclinaisons non vides", "Stock", "booleen", "","Les déclinaisons non renseignées seront automatiquement mises à un stock de 0",0,0,0,0);
		bdd_ajoute_option4("STO_decl_independant", "stock déclinaisons indépendant", "Stock", "booleen", "","Si non coché, le stock de l'article nu sera toujours égal à la somme de ses déclinaisons",0);
		bdd_supprime_option("STO_decl_non_vides");

		bdd_ajoute_option4("SCR_enquete_satisfaction","script enquete de satisfaction", "Script", "texte", "", "Script à appeler lorsqu'on arrive sur la page du rappel de commande (ex. : shopzilla satisfaction)");
		
	}
	
	/**
	 * installation de tous les textes administrables et multilangue nécessaires au module
	 *
	 */
	function __textes() {
		//bdd_installe_options_XML("includes/modules/boutique/options_boutique.xml");
		//bdd_installe_textes_XML("includes/modules/boutique/textes_boutique.xml");

		/*bdd_ajoute_texte_boutique("html_lien_voir_collection","Voir l'intégralité de la collection >","html") ;	
		bdd_ajoute_texte_boutique("html_art_voir_detail","Voir en détail","html") ;
		bdd_ajoute_texte_boutique("html_art_commentaire","Pour commander cet article et vérifier les disponibilités, cliquez sur Ajouter au panier","html") ;	 
		bdd_ajoute_texte_boutique("html_acheter","Acheter","html") ;
		bdd_ajoute_texte_boutique("html_plus_details","+ de détails","html") ;	
		bdd_ajoute_texte_boutique("ALERT_emailDejaUtilise","Cet email est déjà utilisé","alerte",0,1,1) ;
		bdd_ajoute_texte_boutique("ALERT_bon_aj_pan","Le bon de réduction a été ajouté à votre panier.","alerte") ;
		bdd_ajoute_texte_boutique("BON_REDUC_alerte_permanante","Profitez de vos [\$total_BDR] de réduction","autres") ;

		bdd_ajoute_texte_boutique("RECH_av_type","Type d'article","recherche") ;
		bdd_ajoute_texte_boutique("RECH_av_prix","Prix","recherche") ;
		bdd_ajoute_texte_boutique("RECH_av_min","min","recherche") ;
		bdd_ajoute_texte_boutique("RECH_av_max","max","recherche") ;
		bdd_ajoute_texte_boutique("RECH_mots_cles","Mots clé","recherche") ;
		bdd_ajoute_texte_boutique("RECH_lancer","Rechercher","recherche") ;
	
		bdd_ajoute_texte_boutique("RECH_max_atteint","Vous avez atteint le nombre maximum d'articles pour une recherche.\nVeuillez affiner votre recherche.","recherche",0,3,1) ;
	
		bdd_ajoute_texte_boutique("RECH_nom_page","Votre recherche","recherche") ;
		bdd_ajoute_texte_boutique("PAN_port_NC","NC","panier",0,1,1) ;

		bdd_ajoute_texte_boutique("ADR_nouv_adr","Nouvelle adresse","texte",0,1,1) ;
		
		bdd_ajoute_texte_boutique("html_titre_description","Description","html",0,1,1) ;
		bdd_ajoute_texte_boutique("html_titre_galerie","Galerie","html",0,1,1) ;
		bdd_ajoute_texte_boutique("html_titre_spec","Spécifications","html",0,1,1) ;
		bdd_ajoute_texte_boutique("html_msg_no_specs","Pas de spécifications","html",0,1,1) ;
		bdd_ajoute_texte_boutique("html_btn_ajout_panier","Ajouter au panier","html",0,1,1) ;
		bdd_ajoute_texte_boutique("html_stock","Stock","html",0,1,1) ;
		bdd_ajoute_texte_boutique("html_remise","de remise","html",0,1,1) ;
		bdd_ajoute_texte_boutique("html_select_declinaison","Versions disponibles","html",0,1,1) ;
		bdd_ajoute_texte_boutique("html_msg_no_galerie","Pas d'images","html",0,1,1) ;
		*/
		/*bdd_ajoute_texte_boutique("html_stock4",
			array("fr"=>"Stock",
			"en"=>"stocken",
			"es"=>"stockfr",
			"de"=>"stockde")
			,"html",0,1,1) ;
		*/
	/*{$html_titre_galerie}
	html_titre_spec
	html_msg_no_specs
	html_btn_ajout_panier
	html_stock
	- - {$html_select_declinaison} - -
	html_remise
	*/
	}
	
	/**
	 * données a l'identification sur l'admin...
	 *
	 */
	function login_admin() {
		global $id_structure;
		// arborescence
		//$id_boutique=$resUser["id_boutique"];
		//print("</br>id_structure : $id_structure</br>");
		$res=affReqUnique("SELECT id,max_id FROM shop_structures WHERE id = $id_structure","STRUCT","auto");
		//$id_structure=$res["id"];
		affReq("SELECT id, chemin, type, nom,id_cible,actif,id_parent  FROM shop_struct_elems WHERE id_structure=$id_structure","ARB","auto");
	}
	/**
	 * données initiales pour la boutique
	 *
	 */
	function init_site() {
		global $id_structure,$id_boutique,$id_langue_defaut,$id_langue;
		//ACCUEIL_liste_articles();
		$mode_optim=3;
		// les articles en accueil
		if(demarre_requete_optimisee_ML("art","init","accueil",DUREE_CACHE_BDD)) {
			ART_recuperer_accueil($mode_optim);
		}
		print_requete(termine_requete_optimisee());

		//la structure	
		if(demarre_requete_optimisee_ML("struct","init","articles")) {
			
			if($res=testReq2("SELECT id,max_id FROM shop_structures WHERE id_boutique=$id_boutique")) { 
				$id_structure=$res["id"];	
				print_requete("&id_boutique=$id_boutique&id_structure=$id_structure&");
				affReq("SELECT id,chemin,nom,type,id_cible,actif,id_parent  FROM shop_struct_elems WHERE id_structure=$id_structure AND actif_parentee=1","ARBO","auto",false,$mode_optim);
				// familles
				affReq("SELECT id_elem,id_gamme, t_nom.texte as nom, t_texte.texte AS texte, vignette, couleur, fond, mise_en_avant, accueil, image_fond,vendable,perso
							, get_traduction(nom_referencement,$id_boutique,$id_langue_defaut) AS nom_referencement
							FROM shop_categories AS cat
							INNER JOIN shop_ml_traductions AS t_nom ON t_nom.id_champs = cat.nom AND t_nom.id_langue = $id_langue_defaut
							INNER JOIN shop_ml_traductions AS t_texte ON t_texte.id_champs = cat.texte AND t_texte.id_langue = $id_langue_defaut
							WHERE id_structure=$id_structure","CAT","auto",false,$mode_optim);
			}
		}
		print_requete(termine_requete_optimisee());	
		// marques
		affReq("SELECT * FROM shop_marques WHERE id_boutique=$id_boutique","MARQ","auto",false,$mode_optim);
		// types articles
		affReq("SELECT typ.id,t_type.texte as nom FROM shop_articles_types AS typ
				INNER JOIN shop_ml_traductions AS t_type ON t_type.id_champs = typ.nom AND t_type.id_langue = $id_langue_defaut
				WHERE typ.id_boutique=$id_boutique","TYP","auto",false,$mode_optim);
		// les pages annexes
		//print_requete("<br><br>");
		if(demarre_requete_optimisee_ML("struct","init","annexes")) {
			if($resStructPages=testReq2("SELECT id FROM shop_structures WHERE id_boutique=$id_boutique AND type='page'")) {
				if(get_option("ANX_recup_comm")) {
					$ajout_variables=", get_traduction(page.commentaire,$id_boutique,$id_langue_defaut) AS commentaire";
				} 
				affReq("SELECT page.id_elem, trad_page.texte AS nom $ajout_variables, page.fichier, page.acces_direct  FROM shop_pages_annexes as page
							INNER JOIN shop_ml_traductions AS trad_page ON trad_page.id_champs = page.nom AND trad_page.id_langue = $id_langue_defaut
							WHERE id_structure=$resStructPages[id]","ANX","auto",false,$mode_optim);
				//print_requete("<br><br>");
				affReq("SELECT id,id_parent,chemin,type FROM shop_struct_elems WHERE id_structure=$resStructPages[id] AND actif_parentee=1","STANX","auto",false,$mode_optim);
			}
		}
		print_requete(termine_requete_optimisee());			
		//print_requete("<br><br>");
		
		// les specs
		if(demarre_requete_optimisee_ML("spec","init")) {

			affReq("SELECT spc.id ,spc.id_famille , t_nom.texte AS nom,spc.triable ,spc.comparable, spc.recherche, spc.filtrable , spc.affiche_liste , spc.affiche_fiche , spc.affiche_famille , spc.separateur
						FROM shop_specs_elems as spc
						INNER JOIN shop_ml_traductions AS t_nom ON t_nom.id_champs = spc.nom AND t_nom.id_langue = $id_langue_defaut
						WHERE spc.id_boutique=$id_boutique
						ORDER BY spc.numero","SPC","auto",false,$mode_optim);
		}
		print_requete(termine_requete_optimisee());		
		
		affReq("SELECT fam.id ,get_traduction(fam.nom,$id_boutique,$id_langue) AS nom 
					FROM shop_specs_familles as fam
					WHERE fam.id_boutique=$id_boutique
					ORDER BY fam.numero","FAM_SPC","auto",false,$mode_optim);
		affReq("SELECT * FROM shop_zones_format_adresse
					WHERE id_boutique=$id_boutique","FMT_ADR","auto",false,$mode_optim);
					
		if(demarre_requete_optimisee_ML("val_spc","init")) {
		// les valeurs des specs possibles (prédéfinies uniquement) pour les specs "famille"
			$continue_requete="debut";
			if((get_option("RECH_AV_active") && get_option("RECH_AV_spec")) || (get_option("ART_SPEC"))) {
				$or_recherche="OR recherche=1";
			}
			$req="SELECT id FROM shop_specs_elems WHERE id_boutique=$id_boutique AND (affiche_famille=1 OR affiche_liste=1) $or_recherche";
			if($query=ifReq($req)) {
				while($res=mysql_fetch_array($query)) {
					$id_spc=$res[0];
					$req="SELECT pdf.id,pdf.id_spec, get_traduction(pdf.valeur,$id_boutique,$id_langue) AS valeur
						FROM shop_specs_predef AS pdf
						WHERE pdf.id_spec=$id_spc";
					affReq($req,"VALSPC","auto",$continue_requete);
					//TODO: finir mode_optim pour les requetes multiples !!
					$continue_requete="suite";
				}
			}
			termineRequeteMultiple("VALSPC");
		}
		print_requete(termine_requete_optimisee());
		// les types de déclinaisons
		affReq("SELECT decl.id , decl.id_article_type, t_nom.texte AS nom
					FROM shop_declinaisons_types AS decl
					INNER JOIN shop_ml_traductions AS t_nom ON t_nom.id_champs = decl.nom AND t_nom.id_langue = $id_langue_defaut
					WHERE decl.id_boutique=$id_boutique ORDER BY t_nom.texte ASC","DECTYP","auto",false,$mode_optim);
		// les valeurs possibles des déclinaisons
		if(demarre_requete_optimisee_ML("decl","init")) {
			affReq("SELECT decl.id , decl.id_type, t_val.texte AS valeur
						FROM shop_declinaisons_valeurs as decl
						INNER JOIN shop_ml_traductions AS t_val ON t_val.id_champs = decl.valeur AND t_val.id_langue = $id_langue_defaut
						WHERE decl.id_boutique=$id_boutique  ORDER BY t_val.texte ASC","DECVAL","auto",false,$mode_optim);
		}
		print_requete(termine_requete_optimisee());
		//
		// les transporteurs
		affReq("SELECT * FROM shop_transporteurs WHERE actif=1 AND id_boutique=$id_boutique","TRS","auto",false,$mode_optim);
		affReq("SELECT tranches.* FROM shop_transporteurs AS trs
					INNER JOIN shop_transporteurs_tranches AS tranches ON tranches.id_transporteur=trs.id
					WHERE actif=1 AND id_boutique=1","TRCH","auto",false,$mode_optim);
		/*affReq("SELECT zones.* FROM shop_transporteurs AS trs
					INNER JOIN shop_transporteurs_tranches AS tranches ON tranches.id_transporteur=trs.id
					INNER JOIN shop_transporteurs_zones AS zones ON zones.id_tranche=tranches.id
					WHERE actif=1 AND id_boutique=1","ZON","auto");*/
		//
		// les gammes de réappro
		affReq("SELECT * FROM shop_gamme_reappro WHERE id_boutique=$id_boutique","GAM","auto",false,$mode_optim);
		// fournisseurs
		affReq("SELECT * FROM shop_fournisseurs WHERE id_boutique=$id_boutique","FOU","auto",false,$mode_optim);
		if(demarre_requete_optimisee_ML("pays","init")) {
			$p_tva=(get_option("TVA_export")?", p.tva":"");
			$req="SELECT p.id,p.format_adresse, tr.texte AS pays$p_tva FROM shop_zones_pays as p
					LEFT JOIN shop_ml_traductions AS tr ON p.pays=tr.id_champs AND tr.id_langue=$id_langue_defaut
					INNER JOIN shop_zones_couverture AS couv ON couv.id_pays = p.id
					INNER JOIN shop_transporteurs_tranches AS trch ON trch.id_zone = couv.id_zone
					INNER JOIN shop_transporteurs AS trans ON trans.id = trch.id_transporteur
					WHERE p.id_boutique=$id_boutique GROUP BY p.id ORDER BY tr.texte ASC";
					
			affReq($req,"PAYS","auto",false,$mode_optim);
			if(get_option("GES_zones_region")) {
				$r_tva=(get_option("TVA_export")?", r.tva":"");
				$req="SELECT r.id,r.id_pays,r.code,get_traduction(region,$id_boutique,$id_langue_defaut) AS region$r_tva FROM shop_zones_regions as r
					INNER JOIN shop_zones_couverture AS couv ON ((couv.id_pays = r.id_pays AND couv.id_region=0) OR couv.id_region = r.id )
					INNER JOIN shop_transporteurs_tranches AS trch ON trch.id_zone = couv.id_zone
					INNER JOIN shop_transporteurs AS trans ON trans.id = trch.id_transporteur
					WHERE r.id_boutique=$id_boutique GROUP BY r.id ORDER BY region ASC";
				affReq($req,"REGI","auto",false,$mode_optim);
			}
		}
		
		print_requete(termine_requete_optimisee());
	}
	
	function switch_admin($action) {
		global $repIncludes,$id_boutique,$id_langue_defaut,$id_structure;
		include "includes/general/parse_request_ici.php"; // récupère tout le _GET et _POST en variables locales
		
		include $repIncludes."actions_articles/switch_articles.inc.php";
		include $repIncludes."actions_gammes/switch_gammes.inc.php";
		include $repIncludes."actions_fournisseurs/switch_fournisseurs.inc.php";
		include $repIncludes."actions_transporteurs/switch_transporteurs.inc.php";
		include $repIncludes."actions_paiement/switch_paiement.inc.php";
		include $repIncludes."actions_marques/switch_marques.inc.php";
		include $repIncludes."actions_stocks/switch_stocks.inc.php";
		include $repIncludes."actions_commandes/switch_commandes.inc.php";
		include $repIncludes."actions_prix/switch_prix.inc.php";
		include $repIncludes."actions_zones/switch_zones.inc.php";
		include $repIncludes."actions_clients/switch_clients.inc.php";
		include $repIncludes."actions_promotions/switch_promotions.inc.php";
		
	}
	function switch_site($action) {
		global $id_boutique,$id_langue_defaut,$id_structure,$id_langue;
		include "includes/general/parse_request_ici.php"; // récupère tout le _GET et _POST en variables locales
		
		include "includes/site/actions_articles/switch_site_articles.inc.php";
		include "includes/site/actions_login/switch_site_login.inc.php";
		include "includes/site/actions_transporteurs/switch_site_transporteurs.inc.php";
		include "includes/site/actions_paiements/switch_site_paiements.inc.php";
		include "includes/site/actions_commandes/switch_site_commandes.inc.php";
		include "includes/site/actions_promotions/switch_site_promotions.inc.php";
		//include_once("includes/modules/".$this->identifiant."/switch_site_".$this->identifiant.".inc.php");
	}
	function detaille_chemin(&$chemin_detaille,&$dossiers,&$fichier,&$params) {
		global $id_structure,$id_boutique,$id_langue;
		$id_cat_parent=0; // on part de la racine
		$cherche_categorie=true;
		$page_en_cours=$fichier;//substr($fichier,0,strrpos($fichier,"."));
		$split_chemin=$dossiers;
		
		if($split_chemin[0]==BOUTIQUE_REP_RACINE) {
			array_shift($split_chemin);
		}
		
		while($cherche_categorie AND (count($split_chemin)>0)) {
			$nom_cherche=str_replace("-","%",$split_chemin[0]);
			// 1 cherche par le nom_referencement person de la cat (ML)
			$nb_res=0; // le nombre de dossiers trouvés
			$query=ifReq("SELECT s.* FROM shop_struct_elems AS s
								LEFT JOIN shop_categories AS c ON c.id_elem=s.id 
								WHERE s.actif=1 AND s.id_structure=$id_structure AND s.id_parent=$id_cat_parent AND titre_to_lien(get_traduction(c.nom_referencement,$id_boutique,$id_langue)) LIKE '$nom_cherche' COLLATE utf8_unicode_ci");
			$nb_res=mysql_num_rows($query);
			if($nb_res>1) {
				if(isset($_REQUEST["stats"])) {
					print("plusieurs dossiers ont un nom referencement a $nom_cherche!!<br>");
				}
			}
			// 2 recherche par nom de perso
			if(($nb_res!=1) && get_option("REF_chemin_nom")) { 
				// plusieurs résultats possibles, ou non trouvé
				$req="SELECT s.* FROM shop_struct_elems AS s
								LEFT JOIN shop_categories AS c ON c.id_elem=s.id 
								WHERE s.actif=1 AND s.id_structure=$id_structure AND s.id_parent=$id_cat_parent AND titre_to_lien(get_traduction(c.nom_referencement,$id_boutique,$id_langue)) ='' AND titre_to_lien(get_traduction(c.nom,$id_boutique,$id_langue)) LIKE '$nom_cherche' COLLATE utf8_unicode_ci";
				$query=ifReq($req);
				$nb_res=mysql_num_rows($query);
				if($nb_res>1) {
					$id_trouve=-1;
					if(isset($_REQUEST["stats"])) {
						print("plusieurs dossiers ont un nom perso a $nom_cherche!!<br>");
					}
				}
			}
			if($nb_res!=1) {
				//if(!$res=testReq2($req)) {
					//2 cherche par la structure de l'arborescence
				$req="SELECT * FROM shop_struct_elems WHERE actif=1 AND id_parent=$id_cat_parent AND id_structure=$id_structure AND nom LIKE '$nom_cherche'";

				$query=ifReq($req);
				//}
			}
			$res=mysql_fetch_array($query);
			//
			if($res) {
				$chemin_detaille["categories"][]=array("res"=>$res);
				array_shift($split_chemin);
				$id_cat_parent=$res["id"];
				$type_page="categorie";
			} else if(($res_langue=testReq2("SELECT * FROM shop_ml_langues WHERE id_boutique=$id_boutique AND drapeau='$nom_cherche'")) && ($id_cat_parent==0)) {
				// 3 cherche dans les langues
				$chemin_detaille["langue"]=$res_langue;
				$id_langue=$id_langue_defaut=$res_langue["id"];
				$code_langue=$nom_cherche;
				array_shift($split_chemin);
				$chemin_detaille["url_sans_langue"]="/".implode("/",$split_chemin)."/".$page_en_cours;
				
			} else {
				$cherche_categorie=false;
			}
		}
		//
		$profondeur_arborescence=count($chemin_detaille["categories"]);
		if($profondeur_arborescence>0) {
			$chemin_detaille["categorie"]=$chemin_detaille["categories"][$profondeur_arborescence-1]["res"];
			$chemin_detaille["perso_categorie"]=testReq2("SELECT *, get_traduction(nom,$id_boutique,$id_langue) AS nom, get_traduction( texte,$id_boutique,$id_langue) AS texte ,get_traduction(mots_cles,$id_boutique,$id_langue) AS mots_cles FROM shop_categories WHERE id_structure=$id_structure AND id_elem=".$chemin_detaille["categorie"]["id"]);
//			print_r($chemin_detaille["perso_categorie"]);
		}
		//		
		if(($profondeur_arborescence>0) && (count($split_chemin)==0)) {
			// si on est dans un dossier, et qu'on n'a pas de sous-dossiers restant
			// on verifie si on n'est pas direct dans un article
			$separateur_ref="--";
			if(($pos_ref=strpos($page_en_cours,$separateur_ref))>0) {
				$pos_ref+=strlen($separateur_ref);
				$pos_ext=strrpos($page_en_cours,".");
				$ref=substr($page_en_cours,$pos_ref,$pos_ext-$pos_ref);
				$like=str_replace("-","_",$ref);
				if(!$res_article=testReq2("SELECT * FROM shop_articles WHERE reference LIKE '$like'")) {
					$like=str_replace("_","%",$like);
					$res_article=testReq2("SELECT * FROM shop_articles WHERE reference LIKE '$like'");
				}
				if($res_article) {
					$type_page="article";
					$chemin_detaille["article"]=$res_article;
				}
				
			}
		}
		if(isset($type_page)) {
			$chemin_detaille["type_page"]=$type_page;
			$chemin_detaille["termine"]=true;
		}
	}
	function get_arborescence_html($id_parent=0,$nom_classe="classe",$chemin="/chemin") {
		require_once("includes/html/url.inc.php");
		
		global $id_structure,$id_boutique,$id_langue;
		$retour="";
		if($query=ifReq("SELECT get_traduction(cat.nom,$id_boutique,$id_langue) AS nom_ml, se.* FROM shop_struct_elems AS se
							LEFT JOIN shop_categories AS cat ON se.id=cat.id_elem AND cat.id_structure=$id_structure WHERE id_parent=$id_parent AND actif=1 AND se.id_structure=$id_structure ORDER BY position ASC")) {
			if(mysql_num_rows($query)>0) {


					$retour=($id_parent==0?"":"<ul".($id_parent==0?" id='$nom_classe' class='$nom_classe'":"").">");
					
					while($res = mysql_fetch_array($query)) 
					{
						//GESTION DE L'AFFICHAGE DU '>'
						//vérification qu'au moins un enfant est actif 
						$test_actif_enfant = false;
						$res_enfant = testReq3("SELECT liste_enfants FROM shop_struct_elems WHERE nom LIKE '$res[nom]' AND id_parent = $id_parent AND id_structure = $id_structure ");
						
						if(!empty($res_enfant['liste_enfants']) && strcmp("--", $res_enfant['liste_enfants']) != 0)
						{
							$tab_enfants = explode("-", $res_enfant['liste_enfants']);
							
							for($i=0; $i<count($tab_enfants) && $test_actif_enfant == false; $i++)
							{
								if(!empty($tab_enfants[$i]))
								{
									$res_actif = testReq3("SELECT actif FROM shop_struct_elems WHERE id = $tab_enfants[$i] AND id_structure = $id_structure ");
									if($res_actif['actif'] == 1)
										$test_actif_enfant = true;
								}
							}
						}
						$class_li=$res["type"];
						$retour .= "<li class=\"$class_li\">";
						
						if($res["type"]=="separateur") 
							$retour.="<span><a href='javascript:void()'>";
						else		
							$retour .= "<a href='".lien_absolu(get_lien_famille_from_res($res))."'> ";
		
						if(strlen($res["nom_ml"])>0) 
							$retour.=$res["nom_ml"];
						else 
							$retour.=$res["nom"];
						
						if($test_actif_enfant  && strcmp($res["liste_enfants"], "--") != 0)			
							$retour .= " &raquo; </a>";
						else
							$retour .= "</a>";
						
						if($res["type"]=="separateur")
							$retour.="</span>";
						
						if($res["type"]=="raccourci")
							$retour.=$this->get_arborescence_html($res["id_cible"],$nom_classe);
						else if($res["type"]=="dossier")
							$retour.=$this->get_arborescence_html($res["id"],$nom_classe);
		
						$retour.="</li>";
					}
					
					$retour.=($id_parent==0?"":"</ul>");

				
			}
			
		}
		
		return $retour;
	
	}
	function get_arborescence_array($id_parent=0,$profondeur=0) {
		require_once("includes/html/url.inc.php");
		global $id_structure;
		$retour=array();
		if($query=ifReq("SELECT * FROM shop_struct_elems WHERE id_parent=$id_parent AND actif=1 AND id_structure=$id_structure ORDER BY position ASC")) {
	
			if(mysql_num_rows($query)>0) {
				while($res=mysql_fetch_array($query)) {
					$lien=($res["type"]=="separateur")?"":lien_absolu(get_lien_famille_from_res($res));
	
					$elem=array("lien"=>$lien,"titre"=>$res["nom"],"id"=>$res["id"]);
					array_push($retour,$elem);
					if($res["type"]=="raccourci") {
						$retour=array_merge($retour,$this->get_arborescence_array($res["id_cible"],$profondeur+1));
					} else if($res["type"]=="dossier") {
						$retour=array_merge($retour,$this->get_arborescence_array($res["id"],$profondeur+1));
					} 
				}
				if($id_parent==0) {
					// on rajoute les reclassements
	//				$retour.="<li><span><a href='javascript:void()'>reclassements</a></span></li><li><a href='#'>coucou</a></li>";
				}
			}
			
		}
		return $retour;
	}

}

?>