<?php
include_once 'includes/general/str_url.inc.php';
include_once 'includes/general/nombres.inc.php';
//include_once 'modules/listes/classes/CListes.class.php';//auto


class CFichiers {

	static $last_infos;
	static $tab_desc_uploads;
	static function get_fichier_public_path_from_res($prefixe,$identifiant_liste,$nom_colonne,$res_elem) {
		if($res_desc_img = CFichiers::getDescUpload($identifiant_liste,$nom_colonne)) {
			$colonne_url = $res_elem[$res_desc_img["url_colonne_path"]];
		}
		return ($prefixe."$identifiant_liste/".titreToLien($colonne_url)."/$nom_colonne/".($res_elem[$nom_colonne]));
	}

	static function getDescUpload($identifiant_liste,$nom_colonne) {
		if(!isset(CFichiers::$tab_desc_uploads["$identifiant_liste,$nom_colonne"])) {
			$retour = testReq3("SELECT * FROM lis__desc_uploads WHERE id_liste='$identifiant_liste' AND nom_colonne = '$nom_colonne'");
			CFichiers::$tab_desc_uploads["$identifiant_liste,$nom_colonne"] = $retour;
		}
		return CFichiers::$tab_desc_uploads["$identifiant_liste,$nom_colonne"];
	}
	public static function gereCacheEnFonctionDeLextension($ext)
	{
		switch(strtolower($ext))
		{
			case 'jpg':
			case 'jpeg':
			case 'png':
			case 'gif':
				return self :: gereCacheEnFonctionDuType('image');
			break;
		}
	}
	public static function gereCacheEnFonctionDuFichier($ext)
	{
		$ext = split_fichier($ext);
		return self :: gereCacheEnFonctionDeLextension($ext['extension']);
	}

	public static function gereCacheEnFonctionDuType($type)
	{
		$isCachable = false;
		if($type == 'image')
		{
			$duree = SITE_OPTIMISE_DUREE_CACHE_IMAGE;
			$isCachable = true;
			
		}
		elseif($type == 'font')
		{
			$duree = SITE_OPTIMISE_DUREE_CACHE_FONTS;
			$isCachable = true;
		}
		elseif($type == 'css' || $type == 'js')
		{
			
			$duree = SITE_OPTIMISE_DUREE_CACHE_CSS_JS;
			$isCachable = true;
		}
	// On désactive le cache image et tout pour le dev
//		if(EST_EFROGG) $isCachable = false;
	
		if($isCachable)
		{
			if($duree > 0)
			{
				header("Pragma: public");
				header("Cache-Control: public, maxage=".$duree);
				header('Expires: ' . gmdate('D, d M Y H:i:s', time()+$duree) . ' GMT');
			}
		}
		else
		{
			header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
			header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date dans le passé
		}
		
	}
	/**
	 *
	 * @param $identifiant_liste
	 * @param $nom_colonne
	 * @param $valeur
	 * @param $fichier
	 * @param $secure_override : true si on veut passer
	 * @return unknown_type
	 */
	static function get_server_fichier_path($identifiant_liste,$nom_colonne,$valeur,$fichier,$secure_override=false) {
		if(!$liste=CListes::get_liste($identifiant_liste,false)) {
			if (DEBUGGER) echo "liste non trouvée";
			return false;
		}
		//include_once 'modules/base/classes/CFichiers.class.php';//auto
		if(!($res_desc_img = CFichiers::getDescUpload($identifiant_liste,$nom_colonne))) {
			if (DEBUGGER) echo "description non trouvée";
			return false;
		}
		if($res_desc_img["secure"] && !$secure_override) {
			if (DEBUGGER) echo "non car fichier sécurisé";
			return false;
		}
		$valeur=str_replace("-","_",$valeur);
		$req="SELECT * FROM `$liste[table]` WHERE $res_desc_img[url_colonne_path] LIKE '$valeur' LIMIT 0,1 ";
		if($res=testReq3($req)) {
			CFichiers::$last_infos=array("liste"=>$liste,"identifiant_liste"=>$identifiant_liste,"nom_colonne"=>$nom_colonne,"desc_upload"=>$res_desc_img,"donnees_element"=>$res);
			return CFichiers::get_server_fichier_path_from_res($liste,$res_desc_img,$res,$fichier);
		}
	}

	static function getLastFichierInfos() {
		return CFichiers::$last_infos;

	}


	static function get_server_fichier_path_from_res($res_liste,$res_desc_img,$res_elem,$fichier) {
		$fichier  = titreToFichier($fichier);
		if($res_elem) {

			$longueur_chemin=$res_desc_img["serv_longueur_path"];
			if($longueur_chemin == 0) {
				$dossier_serveur = $res_elem[$res_desc_img["serv_colonne_path"]];
			} else {
				$dossier_serveur = toNch($res_elem[$res_desc_img["serv_colonne_path"]],$longueur_chemin);
				if(UPLOAD_LONGUEUR_DECOUPE > 0) {
					// decoupe en "00/00/00/02
					$split=str_split($dossier_serveur,UPLOAD_LONGUEUR_DECOUPE);
					$dossier_serveur = implode("/",$split);
				}
			}
			/// remplace
			$rep_cible=REP_CLIENT."www/__".$res_liste["dossier"];
			$rep_cible.=$dossier_serveur."/";
			$fichier_complet = $rep_cible.$fichier;

			/*
			 * Si le fichier n'existe pas, et qu'on est en mode "transition", les fichiers seront téléchargés sur une autre URL
			 */
			if(MODE_IMPORT_FICHIER_MANQUANTS === true) {
				if(!file_exists($fichier_complet)) {
					creeRepSiExistePas($fichier_complet);
					$contenu=file_get_contents(URL_IMPORT_FICHIERS_MANQUANTS."?path=$fichier_complet");
					if(strlen($contenu)>0)
					file_put_contents($fichier_complet,$contenu);
				}
			}
				
			if(file_exists($fichier_complet)) {

				// "ok, trouvé le fichier direct";
				return $fichier_complet;
			} else {
				// pas redim, mais fichier existe pas
				return $fichier_complet;
				if (DEBUGGER) echo "no match preg_match";
				return false;

			}

		} else {
			if (DEBUGGER) echo "fichier non trouvé";
			return false;

		}
	}

	static function readFichier($identifiant_liste,$nom_colonne,$valeur,$fichier) {
		if($path=CFichiers::get_server_fichier_path($identifiant_liste,$nom_colonne,$valeur,$fichier)) {
			header("Content-type: ".CFichiers::get_mime(get_extension($fichier)));
			// test if image cache
			header("Content-length: ".filesize($path));

			CFichiers::gereCacheEnFonctionDuFichier($fichier);
			
			@readfile($path);
			//echo $path;
			exit;
		} else {
			//include_once 'modules/site/classes/CSite.class.php';//auto
			CSite::erreur404();
		}
	}
	static function get_mime($extension) {
		$extension = strtolower($extension);


		$tous_les_mimes = array(
		"ez" => "application/andrew-inset",
		"hqx" => "application/mac-binhex40",
		"cpt" => "application/mac-compactpro",
		"doc" => "application/msword",
		"xls" => "application/vnd.ms-excel",
		"dms" => "application/octet-stream",
		"lha" => "application/octet-stream",
		"lzh" => "application/octet-stream",
		"class" => "application/octet-stream",
		"so" => "application/octet-stream",
		"oda" => "application/oda",
		"pdf" => "application/pdf",
		"ai" => "application/postscript",
		"eps" => "application/postscript",
		"ps" => "application/postscript",
		"smi" => "application/smil",
		"smil" => "application/smil",
		"wbxml" => "application/vnd.wap.wbxml",
		"wmlc" => "application/vnd.wap.wmlc",
		"wmlsc" => "application/vnd.wap.wmlscriptc",
		"bcpio" => "application/x-bcpio",
		"vcd" => "application/x-cdlink",
		"pgn" => "application/x-chess-pgn",
		"cpio" => "application/x-cpio",
		"csh" => "application/x-csh",
		"dcr" => "application/x-director",
		"dir" => "application/x-director",
		"dxr" => "application/x-director",
		"dvi" => "application/x-dvi",
		"spl" => "application/x-futuresplash",
		"gtar" => "application/x-gtar",
		"hdf" => "application/x-hdf",
		"js" => "application/x-javascript",
		"skp" => "application/x-koan",
		"skd" => "application/x-koan",
		"skt" => "application/x-koan",
		"skm" => "application/x-koan",
		"latex" => "application/x-latex",
		"nc" => "application/x-netcdf",
		"cdf" => "application/x-netcdf",
		"sh" => "application/x-sh",
		"shar" => "application/x-shar",
		"swf" => "application/x-shockwave-flash",
		"sit" => "application/x-stuffit",
		"sv4cpio" => "application/x-sv4cpio",
		"sv4crc" => "application/x-sv4crc",
		"tar" => "application/x-tar",
		"tcl" => "application/x-tcl",
		"tex" => "application/x-tex",
		"texinfo" => "application/x-texinfo",
		"texi" => "application/x-texinfo",
		"t" => "application/x-troff",
		"tr" => "application/x-troff",
		"roff" => "application/x-troff",
		"man" => "application/x-troff-man",
		"me" => "application/x-troff-me",
		"ms" => "application/x-troff-ms",
		"ustar" => "application/x-ustar",
		"src" => "application/x-wais-source",
		"xhtml" => "application/xhtml+xml",
		"xht" => "application/xhtml+xml",
		"zip" => "application/x-zip-compressed",
		"au" => "audio/basic",
		"XM" => "audio/fasttracker",
		"snd" => "audio/basic",
		"mid" => "audio/midi",
		"midi" => "audio/midi",
		"kar" => "audio/midi",
		"mpga" => "audio/mpeg",
		"mp2" => "audio/mpeg",
		"mp3" => "audio/mpeg",
		"aif" => "audio/x-aiff",
		"aiff" => "audio/x-aiff",
		"aifc" => "audio/x-aiff",
		"m3u" => "audio/x-mpegurl",
		"ram" => "audio/x-pn-realaudio",
		"rm" => "audio/x-pn-realaudio",
		"rpm" => "audio/x-pn-realaudio-plugin",
		"ra" => "audio/x-realaudio",
		"wav" => "audio/x-wav",
		"wax" => "audio/x-windows-media",
		"pdb" => "chemical/x-pdb",
		"xyz" => "chemical/x-xyz",
		        "bmp" => "image/bmp",
		"gif" => "image/gif",
		"ief" => "image/ief",
		        "jpeg" => "image/jpeg",
		"jpg" => "image/jpeg",
		"jpe" => "image/jpeg",
		"png" => "image/x-png",
		"tiff" => "image/tiff",
		"tif" => "image/tif",
		"ico" => "image/icon",
		"djvu" => "image/vnd.djvu",
		"djv" => "image/vnd.djvu",
		"wbmp" => "image/vnd.wap.wbmp",
		"ras" => "image/x-cmu-raster",
		"pnm" => "image/x-portable-anymap",
		"pbm" => "image/x-portable-bitmap",
		"pgm" => "image/x-portable-graymap",
		"ppm" => "image/x-portable-pixmap",
		"rgb" => "image/x-rgb",
		"xbm" => "image/x-xbitmap",
		"xpm" => "image/x-xpixmap",
		"xwd" => "image/x-windowdump",
		"igs" => "model/iges",
		"iges" => "model/iges",
		"msh" => "model/mesh",
		"mesh" => "model/mesh",
		"silo" => "model/mesh",
		"wrl" => "model/vrml",
		"vrml" => "model/vrml",
		"css" => "text/css",
		"html" => "text/html",
		"htm" => "text/html",
		"asc" => "text/plain",
		"txt" => "text/plain",
		"log" => "text/plain",
		"rtx" => "text/richtext",
		"rtf" => "text/rtf",
		"sgml" => "text/sgml",
		"sgm" => "text/sgml",
		"tsv" => "text/tab-seperated-values",
		"wml" => "text/vnd.wap.wml",
		"wmls" => "text/vnd.wap.wmlscript",
		"etx" => "text/x-setext",
		"xml" => "text/xml",
		"xsl" => "text/xml",
		"mpeg" => "video/mpeg",
		"mpg" => "video/mpeg",
		"mpe" => "video/mpeg",
		"qt" => "video/quicktime",
		"mov" => "video/quicktime",
		"mxu" => "video/vnd.mpegurl",
		"avi" => "video/x-msvideo",
		"movie" => "video/x-sgi-movie",
		"ice" => "x-conference-xcooltalk",
		);
		if(isset($tous_les_mimes[$extension])) {
			return $tous_les_mimes[$extension];

		}
		echo "type interdit $extension";
		exit;
	}



	static $prefixe_mp3 = "mp3/";
	static function get_mp3_public_path_from_res($identifiant_liste,$nom_colonne,$res_elem) {
		return CFichiers::get_fichier_public_path_from_res(CFichiers::$prefixe_mp3,$identifiant_liste,$nom_colonne,$res_elem);
	}

	public static function file_force_contents($dir, $contents, $flags = null){
		creeRepSiExistePas($dir);
		file_put_contents("$dir", $contents, $flags );
	}


}
?>