<?php
//include_once 'modules/listes/classes/CTypeAffichage.class.php';//auto
class CAffichageListe {

	private $identifiant_liste;
	private $id_externe; // old
	private $champs_masques;
	public $editable;

	public $editable_force;

	public $autorise_editer = true;
	public $autorise_ajouter = true;
	public $autorise_supprimer = true;

	public $use_fausse_liste = false;


	private $fetch_transforme = false;
	private $fetch = array();

	private $descriptions;
	public $colonnes_supp;
	private $type_affichage;
	public $colonnes_cachees=array();
	public $affiche_filtre_sorttable;

	/** resultat de la liste */
	private $liste;

	/** filtre pour la requete */
	private $where="";
	private $select="";


	/** liste des colonnes sélectionnées (pour optimiser) */
	public $colonnes=array();

	public $liste_champs_aol = NULL;

	public $nb_resultats;
	public $num_page = 2;
	public $nb_par_page = 5;

	public function CAffichageListe() {

	}

	public function set_id_liste($identifiant) {
		$this->identifiant_liste=$identifiant;
		$this->liste= CListes::get_liste($identifiant);
		$this->descriptions = CListes::get_description_colonnes($identifiant);
	}

	public function set_type_affichage_par_identifiant($identifiant) {
		$this->type_affichage = CTypeAffichage::get_type_by_identifiant($identifiant);
	}

	public function set_type_affichage($type) {
		$this->type_affichage = $type;
	}

	public function render() {
		if($this->type_affichage && $this->type_affichage->old_methode) {
			$req=$this->construit_requete();
			$query=ifReq($req);
			$formatHTML=$this->type_affichage->toformatHTML();
			return CListes::affiche_resultat_table($this->identifiant_liste,$this->id_externe,$query,$this->champs_masques,$this->editable,$this->descriptions,$this->colonnes_supp, NULL,$formatHTML,NULL,$this->colonnes_cachees, $this->affiche_filtre_sorttable);
		}
		return $this->renderType($this->type_affichage);
	}

	public function renderType(CTypeAffichage $type ) {

		if (!$type->isTypeValide()) {
			return '';
		}

		if (! $this->fetch_transforme) {
			$all=$this->get_fetch();
		}
		else $all = $this->fetch;
//		print_rr($all);
		$this->formate_donnees($type,$all);
//		print_rr($all);
		$type->init($all);
		$type->set_editable_aol($this->editable_aol());


		$tab_layout = array();

		$tab_layout['entete'] = $type->get_entete();

		$tab_layout['debut'] = $this->afficheNumPage($type->get_debut($all));
//		$retour=$this->afficheNumPage($type->get_debut($all));

		if(Cmodule::module_existe("aol") && !$this->use_fausse_liste) {
			if(Cmodule_aol::aol_user()) {
				$type->init_aol($this->identifiant_liste,$this->descriptions,$this->liste_champs_aol);
			}
		}

		$tab_layout['liste'] = '';
		foreach($all as $i=>$elem) {
			$tab_layout['liste'] .=$type->get_element_rempli($elem,$i);
		}

//		$retour.=$this->afficheNumPage($type->get_fin());
		$tab_layout['fin'] = $this->afficheNumPage($type->get_fin());




		$bt_ajouter=($this->editable_aol() && $this->autorise_ajouter)?$type->get_ajouter():"";
		$bt_ajouter=str_replace(array("#ID_LISTE#","#ID_EXT#"),array($this->identifiant_liste,$this->id_externe),$bt_ajouter);

		$tab_layout['bt_ajouter'] = $bt_ajouter;

//		if ($type->position_bt_ajouter == CTypeAffichage::POS_DEBUT) $retour = $bt_ajouter.$retour;
//		else $retour.=$bt_ajouter;

		$retour =  remplace_tous_blocs($type->layout, $tab_layout);
		$retour = remplace_tous_blocs($retour, $type->getVariablesListe(),"#LIS_");
//		echo htmlentities($retour );
		return $retour;
	}

	private function afficheNumPage($layout)
	{
		$nb_page = ceil($this->nb_resultats/$this->nb_par_page);
		if ($bloc_num_page=recherche_element_par_balise($layout,"BLOC_NUMPAGE"))
		{
			$liste_num_page="";
			for($i=1;$i<$nb_page+1;$i++) {
				$liste_num_page.=remplace_tous_blocs($bloc_num_page,array("num_page"=>$i,"classe_actif"=>$i==$this->num_page?"actif":""));
			}
			$layout = remplace_element_par_balise($layout,"BLOC_NUMPAGE",$liste_num_page);
		}
		return $layout;
	}

	private function editable_aol() {
		return $this->editable_force || ($this->editable && Cmodule_aol::aol_user());
	}
	//
	private function formate_donnees(CTypeAffichage $type,&$all) {
		if(empty($all)) return;

		$bt_edit=($this->editable_aol() && $this->autorise_editer)?$type->get_editer():"";
		$bt_edit=str_replace(array("#ID_LISTE#","#ID_EXT#"),array($this->identifiant_liste,$this->id_externe),$bt_edit);

		$bt_efface=($this->editable_aol() && $this->autorise_supprimer)?$type->get_supprimer():"";
		$bt_efface=str_replace(array("#ID_LISTE#","#ID_EXT#"),array($this->identifiant_liste,$this->id_externe),$bt_efface);

		$bt_active=($this->editable_aol() && $this->autorise_editer)?$type->get_activer():"";
		$bt_active=str_replace(array("#ID_LISTE#","#ID_EXT#"),array($this->identifiant_liste,$this->id_externe),$bt_active);

		foreach($all as $i=>&$elem) {
			$str_ligne_paire = $type->get_ligne_paire();
			if($str_ligne_paire != "") {
				$elem["ligne_paire"]=$i%2==0?$str_ligne_paire:"";
			}
			$elem["bt_edit"]=remplace_tous_blocs(remplace_tous_blocs($bt_edit,$type->getVariablesListe(),"#LIS_"),$elem);
			$elem["bt_efface"]=remplace_tous_blocs(remplace_tous_blocs($bt_efface,$type->getVariablesListe(),"#LIS_"),$elem);
			$elem["bt_activable"]=remplace_tous_blocs(remplace_tous_blocs($bt_active,$type->getVariablesListe(),"#LIS_"),$elem);

//			$elem["bt_efface"]=remplace_tous_blocs($bt_efface,$elem);
		}
		$all=$type->init_images($this->identifiant_liste,$this->descriptions,$all);
		//		$all=CListes::get_res_images_multiples_for_str($type->el)
		//		CListes::parse_res_pour_images_multiples($this->identifiant_liste,$this->descriptions,$all);

	}
	//
	//	private function render_debut($debut,&$fetch) {
	//		if($str_colonne=recherche_element_par_balise($debut,"COLONNE")) {
	//			$colonnes = "";
	//			foreach($fetch[0] as $nom_colonne=>$val) {
	//				$colonnes.=str_replace("#NOM_COLONNE#",$nom_colonne,$str_colonne);
	//			}
	//			return remplace_element_par_balise($debut,"COLONNE",$colonnes);
	//			// multiplie colonne par le nombre de colonnes
	//		}
	//		return $debut;
	//	}
	//	private function init_element($elem,&$fetch) {
	//		if($str_colonne=recherche_element_par_balise($elem,"COLONNE")) {
	//			$colonnes = "";
	//			foreach($fetch[0] as $nom_colonne=>$val) {
	//				$colonnes.=str_replace("#NOM_COLONNE#",strtoupper("#$nom_colonne#"),$str_colonne);
	//			}
	//			return remplace_element_par_balise($elem,"COLONNE",$colonnes);
	//			// multiplie colonne par le nombre de colonnes
	//		}
	//		return $elem;
	//	}

	public function construit_requete() {
		$where_req = '';
		$select_supp = '';
		if ($this->where != '') $where_req = 'WHERE '.$this->where;
		if ($this->select != '') $select_supp = ', '.$this->select;
		return "SELECT SQL_CALC_FOUND_ROWS * FROM ".$this->liste["table"]." $where_req";
	}

	public function test() {
		$affichage = new CAffichageListe();
		$affichage->set_id_liste("recette");
		$affichage->editable = true;
		//		$affichage->liste_champs_aol=array("texte");
		//		$affichage->
		$affichage->set_type_affichage_par_identifiant("icones");
		return $affichage->render();
	}

	public function set_where($s) { $this->where = $s; }
	public function get_where() { return $this->where; }

	public function set_select($s) { $this->select = $s; }
	public function get_select() { return $this->select; }

	public function set_fetch($fetch)
	{
		$this->fetch = $fetch;
		$this->fetch_transforme = true;
	}
	public function get_fetch()
	{
		$req=$this->construit_requete();
		$all=mysql_fetch_all(ifReq($req));
		if ($res = testReq3('SELECT FOUND_ROWS() AS nb_res')) {
			$this->nb_resultats = $res['nb_res'];
		}
		return $all;
	}

	public static function afficheListe($id_liste, $type_aff, $where = '1')
	{
		$aff = new CAffichageListe();
		$aff->set_id_liste($id_liste);
		$aff->set_type_affichage_par_identifiant($id_liste.'__'.$type_aff);
		$aff->set_where($where);
		return $aff->render();
	}
	public static function afficheListeAvecFetch($id_liste, $type_aff, $fetch)
	{
		$aff = new CAffichageListe();
		$aff->set_id_liste($id_liste);
		$aff->set_type_affichage_par_identifiant($id_liste.'__'.$type_aff);
		$aff -> set_fetch($fetch);
		return $aff->render();
	}

}
?>