<?php
/**
 * Classe qui comptabilise des dur�es (plusieurs compteurs);
 * @author raph
 *
 */
class CStat {
	var $liste = array();
	var $liste_vue = array();
	var $last_stat = "";
	var $last_timer = 0;

	public function debutStat($nom) {
		$this->finStat();
		$this->last_stat = $nom;
		$this->last_timer = microtime(true);
	}

	public function finStat() {
		if($this->last_stat != "") {
			$time_fin = microtime(true);
			$duree = max(0,$time_fin-$this->last_timer);
			
			if(!array_key_exists($this->last_stat,$this->liste)) $this->liste[$this->last_stat] = array("duree_totale"=>0,"nb"=>0);
			$this->liste[$this->last_stat]["duree_totale"]+=$duree*1000;
			$this->liste[$this->last_stat]["nb"]++;
			
			if(!array_key_exists($this->last_stat,$this->liste_vue)) $this->liste_vue[$this->last_stat] = array("nb"=>0);
			$this->liste_vue[$this->last_stat]["nb"]++;
			$this->liste_vue[$this->last_stat]["duree totale"]=CStat::mstotime($this->liste[$this->last_stat]["duree_totale"]);
			$this->liste_vue[$this->last_stat]["duree moyenne"]=CStat::mstotime($this->liste[$this->last_stat]["duree_totale"]/$this->liste[$this->last_stat]["nb"]);

			$this->last_stat = "";
		}
	}

	public static function mstotime($ms) {
		if($ms>1000) {
			return round($ms/1000,2)." sec";
		}
		return round($ms,2)." ms";
	}
	public function out($renvoie = false) {
		return print_rr($this->liste_vue,$renvoie);
	}

	/*
	 * static
	 */
	private static $stat = null;

	public static function SDebutStat($nom) {
		if(CStat::$stat == null) CStat::$stat = new CStat();
		CStat::$stat->debutStat($nom);
	}
	public static function SFinStat() {
		CStat::$stat->finStat();
	}
	public static function SOut($renvoie = false) {
		if(CStat::$stat == null) CStat::$stat = new CStat();
		return CStat::$stat->out($renvoie);
	}
}
?>