<?php

class CMail{

	private $message_lu = "";

	private $balise_corps = "#CORPS";
	private $enveloppe = "<html><body>#CORPS</body></html>";

	private $liste_cherche = array();
	private $liste_remplace = array();
	private $liste_remplace_balises = array();
	private $liste_affiche_balise = array();
	private $liste_multiplie_balise = array();
	private $liste_remplace_tous_blocs = array();

	private $destinataires;
	private $sujet="-- sans titre --";


	private $pieces_jointes;
	private $mime = false;

	public $destinataires_separes=true;
	private $utf8=false;

	private $html_texte = false;
	private $copie_texte_brut = false;

	private $from="";
	
	private $no_copie = false;

	private $separateurMime;

	public function CMail($msg="") {
		$this->separateurMime = "______BoundaryOfDocument______";
		$this->destinataires=array();
		$this->pieces_jointes=array();
		$this->ajoute_message($msg);
	}

	/**
	 * permet de d�finir l'enveloppe HTML (commune a plusieurs mails), ind�pendamment du contenu
	 * @param $enveloppe
	 * @param $balise_corps
	 * @return unknown_type
	 */
	public function set_enveloppe($enveloppe,$balise_corps="#CORPS") {
		$this->enveloppe = $enveloppe;
		$this->balise_corps = $balise_corps;
	}

	/**
	 * d�finit un nouveau bloc commun, en rempalcement de la balise corps de l'enveloppe g�n�rale
	 * @param $enveloppe
	 * @param $balise_corps
	 * @return unknown_type
	 */
	public function set_sous_enveloppe($enveloppe,$balise_corps="#CORPS") {
		if(!empty($this->enveloppe)) {
			$this->enveloppe = str_replace($this->balise_corps,$enveloppe,$this->enveloppe);
		} else {
			$this->enveloppe = $enveloppe;
		}
		$this->balise_corps = $balise_corps;
		//
	}

	public function ajoute_message($msg="") {
		$this->message_lu .= $msg;
	}

	public function ajoute_destinataire($to) {
		if(!in_array($to,$this->destinataires))
		$this->destinataires[]=$to;
	}



	/*
	 *
	 * setters
	 *
	 */
	public function set_sujet($sujet) {
		$this->sujet = $sujet;
	}
	public function set_html_texte($vf) {
		$this->html_texte=$vf;
		if($this->html_texte && $this->copie_texte_brut) $this->mime = true;
	}
	public function set_utf8($vf) {
		$this->utf8=$vf;
	}
	public function set_from($from) {
		$this->from=$from;
	}
	public function set_destinataires_separes($vf) {
		$this->destinataires_separes=$vf;
	}

	public function set_copie_texte_brut($vf) {
		$this->copie_texte_brut = $vf;
		if($this->html_texte && $this->copie_texte_brut) $this->mime = true;
	}
	
	public function set_no_copie($vf) {
		$this->no_copie = $vf;
	}

	public function remplace_tous_blocs($donnees,$pfx="#")  {
		$this->liste_remplace_tous_blocs[]=func_get_args();
	}

	public function remplaceBlocs($cherche,$remplace) {
		if(is_array($cherche))
		$this->liste_cherche = array_merge($this->liste_cherche,$cherche);
		else
		$this->liste_cherche[]=$cherche;

		if(is_array($remplace))
		$this->liste_remplace = array_merge($this->liste_remplace,$remplace);
		else
		$this->liste_remplace[]=$remplace;
	}

	public function remplace_balise($balise,$remplacer) {
		$this->liste_remplace_balises[$balise]=func_get_args();

	}
	public function affiche_balise($balise,$affiche=true,$str_recherche=false,$str_replace=false) {
		$this->liste_affiche_balise[$balise]=func_get_args();
	}
	
	public function multiplie_balise($balise,$donnees, $prefixe = '#', $nb = 9999999) {
		$this->liste_multiplie_balise[$balise]=func_get_args();
	}

	private function appliqueRemplacements($str) {
		// remplacement de blocs
		include_once 'includes/general/recherche_remplace.inc.php';
		foreach($this->liste_remplace_balises as $balise=>$params) {
			array_unshift($params,$str);
			$str = call_user_func_array(remplace_element_par_balise,$params);
		}

		// affichage de blocs , avec un �ventuel rempalcement
		foreach($this->liste_affiche_balise as $balise=>$params) {
			array_unshift($params,$str);
			$str = call_user_func_array(affiche_element_par_balise,$params);
		}
		
		foreach($this->liste_multiplie_balise as $balise=>$params) {
			array_unshift($params,$str);
			$str = call_user_func_array(remplace_tous_elements_multiples,$params);
		}
		
		// affichage de blocs , avec un �ventuel rempalcement
		foreach($this->liste_remplace_tous_blocs as $tous_blocs) {
			$str = remplace_tous_blocs($str,$tous_blocs[0],$tous_blocs[1]);
		}
		
		

		// remplacements dans la chaine de balises directes #VARIABLE
		$str= str_replace(array_reverse($this->liste_cherche),array_reverse($this->liste_remplace),$str);

		// retire tous les balises [#toto][/#toto], mais garde leur contenu
		$str=ereg_replace("[[][/]?#([a-zA-Z_]+)[]]","",$str);
		return $str;
	}


	public function get_sujet() {
		return $this->appliqueRemplacements($this->sujet);
	}
	public function envoie($to="") {
		if($to!="") {
			$this->ajoute_destinataire($to);
		}

		$header = $this->get_header();
		$corps = $this->get_corps();
		$sujet = $this->get_sujet();

		if($this->destinataires_separes) {
			foreach($this->destinataires as $to) {
				$this->maile($to,$sujet,$corps,$header);
			}
		} else {
			$liste_to=implode(", ",$this->destinataires);
			$this->maile($liste_to,$sujet,$corps,$header);
		}

	}



	public function maile($to,$sujet,$corps,$header) {
		if(CMail::$DEBUG === true) echo "mail $to<br/>$sujet<br/>$corps<hr>$header";
		//echo $corps;

		if((CMail::$ENVOI_MAIL_PRINCIPAL !== false) && (CMail::$ENVOI !== false))
		mail($to,$sujet,$corps,$header);

		if(CMail::$ENVOI === false || $this->no_copie===true) return;
		if(!empty(CMail::$destinataires_tests)) {
			foreach(CMail::$destinataires_tests as $destinataire_test) {
				mail($destinataire_test,"[COPIE] ".$sujet,$corps,$header);
			}
		}
	}
	public function ajoute_fichier_from_file($nom_fichier,$url,$encoding="base64") {
		$extension=substr($url,strrpos($url,".")+1);
		echo $extension;
		switch(strtoupper($extension)) {
			case "JPG":
				$type="image/jpeg";
				break;
		}
		$this->ajoute_piece_jointe($nom_fichier,$type,file_get_contents($url),$encoding);
	}


	public function ajoute_fichier_texte($nom_fichier,$texte,$encoding="base64") {
		$this->ajoute_piece_jointe($nom_fichier,"text/plain",$texte,$encoding);
	}
	public function ajoute_piece_jointe($nom_fichier,$type,$contenu,$encoding="base64") {
		$this->pieces_jointes[]=array("nom_fichier"=>$nom_fichier,"type"=>$type,"contenu"=>$contenu,"encoding"=>$encoding);
		$this->mime=true;
	}
	public function get_corps() {
		if($this->mime) {
			$retour= $this->get_corps_mime();
		} else {
			$retour= $this->get_message_lu();
		}
		return $retour;
	}
	
	public function get_corps_html() {
		$retour= $this->get_message_lu();
		return $this->appliqueRemplacements($retour);
	}

	private function get_message_lu() {
		if(!empty($this->enveloppe)) {
			$retour= str_replace($this->balise_corps,$this->message_lu,$this->enveloppe);
		} else {
			$retour = "<html><body>$this->message_lu</body></html>";
		}
		return $this->appliqueRemplacements($retour);
	}

	private function get_message_lu_plain() {
		return $this->retire_html($this->get_message_lu());
	}
	
	public function retire_html($str) {
		return ereg_replace("<[^>]*>", "", $str);
	}
	
	private function get_corps_mime() {
		$retour="";

		
		
		// le message brut si necessaire
		if($this->html_texte && $this->copie_texte_brut) {
			$retour.="\n\n--$this->separateurMime\n".
				$this->get_header_contenu_plain().$this->get_message_lu_plain();
		}
		
		// le message a lire
		$retour.="\n\n--$this->separateurMime\n".
			$this->get_header_contenu().$this->get_message_lu();
		

		// les pieces jointes
		//$this->pieces_jointes[]=array("nom_fichier"=>$nom_fichier,"type"=>$type,"contenu"=>$contenu,"encoding"=>$encoding);
		foreach($this->pieces_jointes as $pj) {
			$encoding=$this->get_titre_encoding_pj($pj["encoding"]);
			$str_pj="
			
--$this->separateurMime\n".
"Content-Type: {$pj[type]}; name=\"{$pj[nom_fichier]}\";\n".
"Content-Transfer-Encoding: ".$encoding."\n".
"Content-Disposition: attachment\n\n".
$this->get_contenu_encoding_pj($encoding,$pj["contenu"]);

			$retour.=$str_pj;
		}
		$retour.="\n".
"--$this->separateurMime--";
		return $retour;
	}

	private function get_header() {
		$header="";
		if(!empty($this->from)) $header.= "From: $this->from\r\n";
		if($this->mime) {
			$header.= "MIME-Version: 1.0\n".
			"Content-Type: multipart/alternative; boundary=\"$this->separateurMime\"\n";
		} else {
			$header.=$this->get_header_contenu();
		}
		return $header;
	}
	private function get_header_contenu($forme_force="") {
		if($forme_force!= "") $forme_texte = $forme_force;
		else $forme_texte=($this->html_texte?"html":"plain");
		if($forme_texte=="html") return $this->get_header_contenu_html();
		return $this->get_header_contenu_plain();
	}

	
	private function get_header_contenu_html() {
		return "Content-Type: text/html; charset=".$this->get_encoding()."\n".
		"Content-Transfer-Encoding: 7bit\n\n";
	}
	private function get_header_contenu_plain() {
		return "Content-Type: text/plain; charset=iso-8859-1\n".
		"Content-Transfer-Encoding: 7bit\n\n";
	}
	
	private function get_encoding() {
		if($this->utf8) {
			return "UTF-8";
		} else {
			return "ISO-8859-1";
		}
	}

	private function get_titre_encoding_pj($str_encoding) {
		switch($str_encoding) {
			case "base64":
				// tous ceux acceptés
				return $str_encoding;
		}
		// par défaut
		return "base64";
	}
	private function get_contenu_encoding_pj($str_encoding,$contenu) {
		switch($str_encoding) {
			// tous ceux acceptés
			case "base64":
				return base64_encode($contenu);
				break;
		}
		return "erreur";
	}

	public static function ajoute_destinataire_test($email) {
		CMail::$destinataires_tests[]=$email;
	}
	private static $destinataires_tests = array();
	public static $DEBUG = false;
	public static $ENVOI = true;
	public static $ENVOI_MAIL_PRINCIPAL = true;

	/**
	 *
	 * @param $to
	 * @param $sujet
	 * @param $message
	 * @param $encoding = "iso" | "utf"
	 * @return unknown_type
	 */
	static public function envoie_email($to,$sujet,$message,$utf=false) {
		$tmp_email=new CMail($message);
		$tmp_email->utf8=$utf;
		$tmp_email->set_sujet($sujet);
		$tmp_email->envoie($to);
		//mail($to,$sujet,$message,$header);
	}

}

/*

//CMail::envoie_email("support.ubaldi@e-frogg.fr","coucou","message",false);
$mail1=new CMail();
$mail1->ajoute_destinataire("support.ubaldi@e-frogg.fr");
$mail1->ajoute_destinataire("teq444@gmail.com");
$mail1->ajoute_destinataire("lila@e-frogg.fr");
$mail1->ajoute_destinataire("teq4@msn.com");

//$mail1->destinataires_separes=false;

$mail1->ajoute_message("coucou lé petits ");
$mail1->ajoute_message("<b>a toi</b>");

$mail1->set_sujet("mon sujet");

$mail1->set_html_texte(true);
$mail1->set_destinataires_separes(false);


$mail1->set_utf8(true);

$mail1->ajoute_fichier_texte("toto.txt","oui oui");

$mail1->ajoute_fichier_from_file("imag2e.jpg","_old/image.jpg");
$mail1->ajoute_fichier_from_file("image1.jpg","_old/image.jpg");
$mail1->ajoute_fichier_from_file("image3.jpg","_old/image.jpg");
$mail1->ajoute_fichier_from_file("image4.jpg","_old/image.jpg");

$mail1->envoie();
*/
/*
 $header="MIME-Version: 1.0
 Content-Type: multipart/mixed; boundary=\"==mimepart0001==\";
 Content-Transfer-Encoding: 7bit";

 $msg="C'est un message MIME, si vous voyez ce texte, il n'y a plus d'espoir pour vous ...

 --==mimepart0001==
 Content-Type: text/plain; charset=\"iso-8859-1\"
 Content-Transfer-Encoding: 7bit

 Voici un email text avec un fichier joint, encod� en base64.
 /hth

 --==mimepart0001==
 Content-Type: text/plain; name=\"whatever.txt\";
 Content-Transfer-Encoding: base64
 Content-Disposition: attachment

 ".base64_encode("le contenu texte")."

 --==mimepart0001==--";

 echo"coucou";
 mail("support.ubaldi@e-frogg.fr","coucou",$msg,$header);
 */
?>