<?php 
class Importation
{
	private static $tabAttr = array();
	public static function cleanProduct()
	{
		BDD :: execIUReq("
			TRUNCATE TABLE `ps_product`;
			TRUNCATE TABLE `ps_product_lang`;
			TRUNCATE TABLE `ps_category_product`;
			TRUNCATE TABLE `ps_product_tag`;
			TRUNCATE TABLE `ps_image`;
			TRUNCATE TABLE `ps_image_lang`;
			TRUNCATE TABLE `ps_discount_quantity`;
			TRUNCATE TABLE `ps_product_attribute`;
			TRUNCATE TABLE `ps_attribute_impact`;
			TRUNCATE TABLE `ps_product_attribute_combination`;
		");

	}
	public static function cleanAttributes()
	{
		BDD :: execIUReq("
			TRUNCATE TABLE `ps_attribute`;
			TRUNCATE TABLE `ps_attribute_group`;
			TRUNCATE TABLE `ps_attribute_group_lang`;
			TRUNCATE TABLE `ps_attribute_impact`;
			TRUNCATE TABLE `ps_attribute_lang`;
		");
	}
	public static function cleanProductFromCateg($idCateg)
	{
		
	}
	
	public static function importeProduits($fichier)
	{
		$tabRetour = array();
		$tabRetour['produits'] = 0;
		$tabRetour['degressif'] = 0;
		$tabRetour['declinaison'] = 0;
		
		$tabFichier = explode("\n",file_get_contents($fichier));
		array_shift($tabFichier);
		$tabFichier = array_reverse($tabFichier);
		array_shift($tabFichier);
		$tabFichier = array_reverse($tabFichier);
//		print_r($tabFichier);
		
		$pos = 0;
		$oldCateg = 0;
		foreach($tabFichier as $uneLigne)
		{
			
			list($typeLigne,$nom,$categ,$pHT, $ref,$poids,$qteStock,$libCond,$uniteCond, $condi, $desc) = explode('|',$uneLigne);
			$poids = str_replace(',','.',$poids);
			$pHT = str_replace(',','.',$pHT);
			
			switch($typeLigne)
			{
				case 'prod':
					
					if($oldCateg != $categ)
					{
						$pos = 0;
						$oldCateg = $categ;
					}
					//	echo BDD :: getRewritedText($nom);continue;
					$prixNewProduct = str_replace(',','.',$pHT);
					$tab = BDD :: execIUReq("INSERT INTO `ps_product` (`id_product` ,`id_supplier` ,`id_manufacturer` ,`id_tax` ,`id_category_default` ,
						`id_color_default` ,`on_sale` ,`ean13` ,`ecotax` ,`quantity` ,`price` ,`wholesale_price` ,`reduction_price` ,
						`reduction_percent` ,`reduction_from` ,`reduction_to` ,`reference` ,`supplier_reference` ,`location` ,
						`weight` ,`conditionnement` ,`labelconditionnement` ,`uniteconditionnement` ,`out_of_stock` ,`quantity_discount` ,
						`customizable` ,`uploadable_files` ,`text_fields` ,`active` ,`indexed` ,`date_add` ,`date_upd`)
						VALUES (
						NULL , 0 , 0 , 0, ?, 0 , '0', '' , '0.00', ?, ?, '0.000000', 0 , 0 , '1942-01-01' , '1942-01-01' , ?, '' , '' , ?, ?, ?, ?, '2', '0', '0', '0', '0', '1', '0', NOW(), NOW()
						);",array($categ,$qteStock,$pHT,$ref,$poids,$condi,$libCond,$uniteCond));
//					print_r($tab);
					$newId = BDD :: getInstance() -> lastInsertId();
					
					BDD :: execIUReq("INSERT INTO `ps_product_lang` (`id_product` ,`id_lang` ,`description` ,`description_short` ,
						`link_rewrite` ,`meta_description` ,`meta_keywords` ,`meta_title` ,`name` ,`available_now` ,`available_later`
						)
						VALUES (
						?, '2', ?, '', ?, '' , '' , '' , ?, '' , ''
						);",array($newId,$desc,BDD :: getRewritedText($nom),$nom));



					BDD :: execIUReq("INSERT INTO `ps_category_product` (`id_category`, `id_product`, `position`) VALUES (?,?,?);",array($categ,$newId,$pos));

					$pos++;
					$tabRetour['produits']++;
				break;
				case 'degress':
					$newPrixDegre = $prixNewProduct - doubleval($pHT);
//					echo $newPrixDegre.' = '.$prixNewProduct.' - '.str_replace(',','.',$pHT).'<br />';
					BDD :: execIUReq("INSERT INTO `ps_discount_quantity` (`id_discount_type`,`id_product`,`id_product_attribute`,`quantity`,`value`) VALUES ('2',?,'0',?,?)",array($newId,$qteStock,$newPrixDegre));
					$tabRetour['degressif']++;
					break;
				case 'declin':
				case 'declindef':
					$def = ($typeLigne == 'declindef')? 1 : 0;
//					echo $def;
					$tabAttr = self :: getInfosAttribut($nom,$categ);
					BDD :: execIUReq("INSERT INTO `ps_attribute_impact` (`id_product`, `id_attribute`, `price`, `weight`) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE `price`=VALUES(price), `weight`=VALUES(weight)",array($newId,$tabAttr['idAttr'],$pHT,$poids));
					BDD :: execIUReq("INSERT INTO `ps_product_attribute` (`id_product`, `price`, `weight`, `quantity`, `reference`, `default_on`) VALUES (?, ?, ?, ?, ?, ?)",array($newId,$pHT,$poids,$qteStock,$ref,$def));
					BDD :: execIUReq("INSERT INTO `ps_product_attribute_combination` (`id_product_attribute`, `id_attribute`) VALUES (?,?)",array(BDD :: getInstance() -> lastInsertId(),$tabAttr['idAttr']));
					$tabRetour['declinaison']++;
					break;
			}
				
		}
		return $tabRetour;
//		return '<pre>'.print_r($tabFichier,true).'</pre>';
	}
	
	public static function getInfosAttribut($nomCateg, $nomAttribut)
	{
		$nomMD5 = md5($nomCateg.$nomAttribut);
		if(!empty(self :: $tabAttr[$nomMD5]))
		{
			return self :: $tabAttr[$nomMD5];
		}
		else
		{
			$res = BDD :: execSimpleReq('SELECT a.id_attribute_group as idGroupe,c.id_attribute as idAttr
				FROM ps_attribute_group_lang a,
				ps_attribute_group b,
				ps_attribute c,
				ps_attribute_lang d
				WHERE a.id_attribute_group = b.id_attribute_group
				AND c.id_attribute = d.id_attribute
				AND c.id_attribute_group = a.id_attribute_group
				AND a.public_name = ?
				AND d.name = ?;',array($nomCateg,$nomAttribut));
			if($res)
				$retour = $res;
			else
				$retour = self :: createInfosAttributs($nomCateg, $nomAttribut);
				
			self :: $tabAttr[$nomMD5] = $retour;
			return $retour;
		}
	}
	
	public static function createInfosAttributs($nomCateg, $nomAttribut)
	{	
		$res = BDD :: execSimpleReq("SELECT a.id_attribute_group as idGroupe
			FROM ps_attribute_group_lang a,
			ps_attribute_group b
			WHERE a.id_attribute_group = b.id_attribute_group
			AND a.public_name = ? ;",array($nomCateg));
		
		
		
		if($res)
		{
			$idNewGroupe = $res['idGroupe'];
		}
		else
		{
			$idNewGroupe = self :: createAttributeGroup($nomCateg);
		}
		
		$idNewAttri = self :: createAttribute($idNewGroupe,$nomAttribut);
		
		
		return array('idGroupe' => $idNewGroupe, 'idAttr' => $idNewAttri);
	}
	public static function createAttribute($idGroupe,$nomAttribut)
	{
		BDD :: execIUReq("INSERT INTO `ps_attribute` (`id_attribute_group`,`color`) VALUES (?,'#000000')",array($idGroupe));
		$idA = BDD :: getInstance() -> lastInsertId();
		BDD :: execIUReq("INSERT INTO `ps_attribute_lang` (`id_lang`,`id_attribute`,`name`) VALUES ('2',?,?)",array($idA,$nomAttribut));
		return $idA;
	}
	public static function createAttributeGroup($nom,$couleur = '0')
	{
		BDD :: execIUReq("INSERT INTO `ps_attribute_group` (`is_color_group`) VALUES (?)",array($couleur));
		$idGroupe = BDD :: getInstance() -> lastInsertId();
		BDD :: execIUReq("INSERT INTO `ps_attribute_group_lang` (`id_lang`,`id_attribute_group`,`name`,`public_name`) VALUES ('2',?,?,?)",array($idGroupe,$nom,$nom));
		return $idGroupe;
	}
}
?>