<?php
class CronManager {
	/*
	 * désactivation temporaire, pour tous les "NON e-FROGG"
	 * true => seul e-frogg peut lancer les crons à la main
	 */
	public static $cronDesactive = false;

	
	public static $crons = array();
	public static $indexCrons = array();

	public static function verifEtatCrons() {
		foreach(self::$crons as $fichier=>&$infos) {
			$res = testReq3("SELECT prochaine_execution<NOW() as todo,prochaine_execution FROM cron__master WHERE fichier='$fichier'  ");
			$infos["todo"]=($res["todo"]==1);
			$infos["next"]=($res["prochaine_execution"]);
		}
		//		print_rr(self::$crons);
	}
	public static function ajouteCron($fichier,$delai,$type="cron", $path = '') {
		self::$indexCrons[]=$fichier;
		self::$crons[$fichier]=array("delai"=>$delai,todo=>false,"type"=>$type, 'path'=>$path);
	}

	public static function init() {
		
		include_once('modules/Cmodule.class.php');
		Cmodule::dispatch_fonction("getCrons");
		
//		self::ajouteCron("cron_reset_optim","1 MINUTE");
//		self::ajouteCron("cron_file_commandes","1 MINUTE");
//		self::ajouteCron("cron_commandes","5 MINUTE");
//		self::ajouteCron("cron_recherche","5 MINUTE");
//		self::ajouteCron("cron_reset_optim_horaire","1 HOUR");
//		self::ajouteCron("cron_recherche_horaire","1 HOUR");
//		self::ajouteCron("cron_nuit","1 DAY");
//		self::ajouteCron("cron_cache","1 DAY");
//		self::ajouteCron("cron_mois","1 MONTH");

		//		self::ajouteCron("cron_parrainage","1 MINUTE");
//		self::ajouteCron("------ dans cron_nuit -----","","separateur");
//		self::ajouteCron("cron_popularite","1 DAY");
//		self::ajouteCron("cron_promos","1 DAY");
//		self::ajouteCron("cron_stats_recherche","1 DAY");
		//		self::ajouteCron("cron_tradedoubler","1 MINUTE");
	}
	public static function install() {
		foreach(self::$crons as $fichier=>$infos) {
			if($infos["type"]=="cron") {
				$delai = $infos["delai"];
				$path = $infos['path'];
				if(ifReq("INSERT INTO cron__master SET fichier='$fichier', delai='$delai', path='$path' ON DUPLICATE KEY UPDATE delai='$delai' ")) {
					if(mysql_affected_rows()>0) {
						$retour .= "cron <i>$fichier</i> ($delai) installé<br>";
					}
				} else {
					return $retour."Erreur ".mysql_error();
				}
			}
		}

		if(ifReq("DELETE FROM cron__master WHERE fichier NOT IN('".implode("','",self::$indexCrons)."')")) {
			$nbEfface = mysql_affected_rows();
			if($nbEfface>0) {
				$retour .= "Suppression de $nbEfface cron".($nbEfface>1?"s":"")."<br>";
			}
		} else {
			return $retour."Erreur ".mysql_error();
		}
		return $retour;
	}

	private static $cronEnCours,$idCronEnCours;
	private static $dateStart,$dateEnd;
	private static $timeStart,$timeEnd;
	private static $logFilePath,$data,$logFileTmp,$logFilePathTmp;

	/**
	 * démarre un cron, met les includes, config la BDD, connecte, etc ...
	 * @param unknown_type $fichier
	 */
	public static function cronBegin($fichier) {
		define("NO_SESSION",true);

//		include_once "includes/config_cron.inc.php";
//		$_SERVER["HTTP_HOST"] = DOMAINE_COURANT;
		include_once "includes/config.inc.php";
		include_once "includes/BDD/actions.inc.php";
		include_once "includes/general/str_url.inc.php";

//		include_once("includes/commun/Crapports.class.php");
//		Crapport::$additional_parameters=PARAMS_MAILS;
//		CMail::$additional_parameters=PARAMS_MAILS;

		self::cronStart($fichier);
	}
	
	public static function cronStart($fichier) {
		self::$cronEnCours = $fichier;
		self::cronSetRun($fichier);
		self::$dateStart=date("Y-m-d H:i:s");
		self::$timeStart=microtime(true);
		//		self::$logFilePath = implode("/",explode("-",array_shift(explode(" ",self::$dateStart))));
		self::$logFilePath = self::getCronFileName(self::$cronEnCours,self::$dateStart);
		creeRepSiExistePas(self::$logFilePath);
		self::$logFilePathTmp = self::getCronFilepath(self::$cronEnCours,self::$dateStart)."temp_".strtr(self::$dateStart," -:","___");
		self::$logFileTmp = fopen(self::$logFilePathTmp,"w");
		if($q=ifReq("INSERT INTO cron__run SET fichier='$fichier',debut='".self::$dateStart."'")) {
			self::$idCronEnCours = mysql_insert_id();
		}

		if(!self::$cronDesactive) {
			ob_start("CronManager::OBCron");
		} else if(EST_EFROGG !== true) {
			echo "cron désactivé (CronManager.class.php)";
			//			print_rr($_SERVER);
			self::cronEnd();
			exit;
		}
	}
	public static function cronEnd() {
		self::$dateEnd=date("Y-m-d H:i:s");
		self::$timeEnd=microtime(true);
		$duree = round((self::$timeEnd-self::$timeStart)*1000);
		ob_end_flush();

		if(self::$logFileTmp) fclose(self::$logFileTmp);
//				creeRepSiExistePas(self::$logFilePath);
		//		echo "self::$logFilePath = ".self::$logFilePath;
		if($fp=gzopen(self::$logFilePath,"a")) {
			gzwrite($fp,"<div id='".strtr(self::$dateEnd," :-","___")."' date='".self::$dateEnd."' duree='$duree' class='log_block'>".file_get_contents(self::$logFilePathTmp)."</div>");
			gzclose($fp);
			unlink(self::$logFilePathTmp);
			echo "ok, fichier '".self::$logFilePath."' écrit";
		} else {
			echo "Erreur : pas le droit d'écrire le fichier";
		}

		//		return "ok, log sauvegardé dans ".self::$logFilePath;
		if($q=ifReq("UPDATE cron__run SET fin='".self::$dateEnd."',duree=".$duree." WHERE id=".self::$idCronEnCours)) {
			return true;
		}
	}
	public static function getCronFilepath($fichier,$dateDebut) {
		$jour = array_shift(explode(" ",$dateDebut));
		$split_YMD=explode("-",$jour);
		return RACINE_WWW."logs/cron/$fichier/$split_YMD[0]/$split_YMD[1]/";
	}
	public static function getCronFileName($fichier,$dateDebut) {
		$jour = array_shift(explode(" ",$dateDebut));
		return self::getCronFilepath($fichier,$dateDebut).strtr($jour,"- :","___")."_$fichier.log.html.gz";
	}
	public static function OBCron($data) {
		if(self::$logFileTmp) fputs(self::$logFileTmp,$data);
		//		self::$data.=$data;
		return $data;

	}
	public static function cronSetRun($fichier) {
		$delai = self::$crons[$fichier]["delai"];
		ifReq("UPDATE cron__master SET prochaine_execution = NOW() + INTERVAL $delai WHERE fichier='$fichier' ");
		//		ifReq("INSERT INTO cron__master_log SET fichier='$fichier', date_execution=NOW(),resultat ='".mysql_real_escape_string($retour)."'","My1");
	}

	public static function msToHMS($ms) {
		//if($ms<1000) return $ms." ms";
		$sec=floor($ms/1000);
		$ms%=1000;
		$min=floor($sec/60);
		$sec%=60;
		$heures=floor($min/60);
		$min%=60;
		$jours=floor($min/24);
		$heures%=24;
		return ($jours>0?"$jours j ":"").($heures>0?"$heures h ":"").($min>0?"$min m ":"").($sec>0?"$sec s ":"").round($ms,2)." ms ";
	}
	public static function getLogCron($fichier,$dateDebut=null,$dateFin=null) {
		
		include_once('includes/general/fichiers.inc.php');
		
		if(empty($dateDebut)) $dateDebut=date("Y-m-d");
		if(empty($dateFin)) $dateFin=$dateDebut;

		$dd=strtotime($dateDebut);
		$df=strtotime($dateFin);

		$retour = '';
		while($dd<=$df) {
			$jour = date("Y-m-d",$dd);
			$dd+=60*60*24;

			$fileName=self::getCronFileName($fichier,$jour);
			$retour.=gzfile_get_contents($fileName);
		}

		//		return $fichier;
		//$f=gzfile($fichier);
		//return htmlentities(print_rr($f,true));
		return $retour ;
		//		$rapp = new Crapport();
		//		$rapp = new CrapportSansDate();
		//		if($q=master_ifReq("SELECT * FROM cron__run WHERE fichier='$fichier' ORDER BY debut DESC LIMIT $start,$nb")) {
		//			while($res=mysql_fetch_assoc($q)) {
		//				$rapp->Add_trace("Execution $fichier à $res[debut] (".self::msToHMS($res["duree"]).")",0,"important");
		//				$rapp->Add_trace(,0,"normal",3);
		//			}
		//		}
		//		return $rapp->out("CRON $fichier",false,false);
	}
}
CronManager::init();
?>