<?php
class FroggForm
{
	private $idForm = '';
	private $tabInput = array();
	private $corpsForm = '';
	private $scriptTest = '';
	private $submitText = '';


	private $tabRegValidation = array(
					'required' 	=> '/[^.*]/',
					'alpha' 	=> '/^[à-ýa-z ._\-éèêëï]+$/i',
					
					'alphanum' 	=> '/^[a-z0-9 ._\-]+$/i',
					'digitSign' => '/^[\-+]?[0-9]+$/',
					'digit'		=> '/^[0-9]+$/i',
					'nodigit' 	=> '/^[^0-9]+$/',
					'number' 	=> '/^[\-+]?\d*\.?\d+$/',
					'email'		=> '/^[a-z0-9._%\-]+@[a-z0-9.\-]+\.[a-z]{2,6}$/i',
					'phone' 	=> '/^[0-9]{2}[\s]{0,1}[0-9]{2}[\s]{0,1}[0-9]{2}[\s]{0,1}[0-9]{2}[\s]{0,1}[0-9]{2}$/',
					'url' 		=> '/^(http|https):\/\/[a-z0-9\-\.\/_]+\.[a-z]{2,3}$/i',
					'date' 		=> '/^[0-9]{1,2}.[0-9]{1,2}.[0-9]{2,4}$/',
					'hexaColor' => '/#[0-9a-fA-F]{6}/',
					'notEmpty' 	=> '/^(.*[^0\s].*)$/'
					);
					public function __construct($idForm, $submitTexte = 'Submit')
					{
						$this -> idForm = $idForm;
						$this -> submitText = $submitTexte;
					}
					public function getScriptTest()
					{
						return '<script>'.$this -> scriptTest.'</script>';
					}
					public function outputHTML()
					{
						$this -> genereCorpsForm();
						return '
			<form action="" method="POST" id="'.$this -> idForm.'">
				'.$this -> corpsForm.'
				<p class="formElem"><input type="submit" id="btSubmit" value="'.$this -> submitText.'" /></p>
			</form>
			<script>
				$("#'.$this -> idForm.'").froggForm();
			</script>
			';
					}
					public function getInputHTML($prop, $label = '')
					{
						$param = '';
						foreach($prop as $keyProp => $valProp)
						{
							$param .= ' '.$keyProp.'="'.$valProp.'"';
						}
						return $label.'<input '.$param.'/>';
					}
					public function getUnElement($label, $champ,$messageErreur)
					{
						return '<p class="formElem">
						<label>'.$label.'</label>
						'.$champ.'
						<span class="messageErreur">'.$messageErreur.'</span>
					</p>';
					}
					public function genereCorpsForm()
					{
						foreach($this -> tabInput as $unInput)
						{
							$prop = $unInput[0];
							$label = $unInput[1];
							$messageErreur = $unInput[2];

							if(isset($prop['type']) && $prop['type'] == 'radio' && isset($prop['value']))
							{
								$radioElement = '<br />';
								$i = 0;
								foreach($prop['value'] as $uneValeur)
								{
									$propTempo = array('type' => 'radio', 'value' => $uneValeur, 'name' => $prop['name']);
									if($i == 0) $propTempo['checked'] = 'checked';
									$i++;
									$radioElement .= $this -> getInputHTML($propTempo,'<span>'.ucfirst(strtolower($uneValeur)).'</span>');
								}
								$this -> corpsForm .= $this -> getUnElement($label,$radioElement,$messageErreur);
							}
							else
							{
								$this -> corpsForm .= $this -> getUnElement($label,$this -> getInputHTML($prop),$messageErreur);
							}
						}
					}
					public function addInput($prop = null, $label, $messageErreur)
					{
						if(!is_array($prop)) return false;
						$this -> tabInput[] = array($prop,$label,$messageErreur);
					}
					public static function xss_clean($data)
					{
						$data = urldecode($data);
						$data = str_replace(array('&amp;','&lt;','&gt;'), array('&amp;amp;','&amp;lt;','&amp;gt;'), $data);
						$data = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $data);
						$data = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $data);
						$data = html_entity_decode($data, ENT_COMPAT, 'UTF-8');
						$data = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+>#iu', '$1>', $data);
						$data = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $data);
						$data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $data);
						$data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $data);
						$data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
						$data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
						$data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:*[^>]*+>#iu', '$1>', $data);
						$data = preg_replace('#</*\w+:\w[^>]*+>#i', '', $data);
						do
						{
							$old_data = $data;
							$data = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $data);
						}
						while ($old_data !== $data);
						return $data;
					}

					public function isFormValide()
					{
						foreach($this -> tabInput as &$unInput)
						{
							$prop = $unInput[0];
							$label = $unInput[1];
							$messageErreur = $unInput[2];
							if(isset($prop['name']) AND isset($_POST[$prop['name']]))
							{
								if(isset($unInput[0]['value']))
								{
									if(!is_array($unInput[0]['value']))
									{
										$unInput[0]['value'] = $this -> xss_clean($_POST[$prop['name']]);
									}
								}
								if(isset($prop['check']))
								{
									if(!preg_match($this -> tabRegValidation[$prop['check']],$_POST[$prop['name']]))
									{
										$unInput[0]['style'] = 'border: 1px solid red;';
											
										$this -> scriptTest .= "
							$('#".$this -> idForm." input[name=".$prop['name']."]').css('border','1px solid #FF0000');
							$('#".$this -> idForm." input[name=".$prop['name']."]').next().css('display','block');
							";
											
										return false;
									}
									else
									continue;
								}
									
							}
							else
							{
								return false;
							}
						}
						return true;
					}
}
?>