<?php

class CMail2 {

	public static $additional_parameters = "";
	private $message_lu = "";

	private $balise_corps = "";
	private $enveloppe = "";

	private $liste_cherche = array();
	private $liste_remplace = array();
	private $liste_remplace_balises = array();
	private $liste_affiche_balise = array();

	private $destinataires;
	private $sujet="-- sans titre --";


	private $pieces_jointes;
	private $mime = false;

	public $destinataires_separes=true;
	private $utf8=false;

	private $html_texte = false;

	private $from="";
	
	public static $racine_www = "";

	public function CMail2($msg="") {
		$this->destinataires=array();
		$this->pieces_jointes=array();
		$this->ajoute_message($msg);
	}

	/**
	 * permet de définir l'enveloppe HTML (commune a plusieurs mails), indépendamment du contenu
	 * @param $enveloppe
	 * @param $balise_corps
	 * @return unknown_type
	 */
	public function set_enveloppe($enveloppe,$balise_corps="#CORPS") {
		$this->enveloppe = $enveloppe;
		$this->balise_corps = $balise_corps;
	}

	/**
	 * définit un nouveau bloc commun, en rempalcement de la balise corps de l'enveloppe générale
	 * @param $enveloppe
	 * @param $balise_corps
	 * @return unknown_type
	 */
	public function set_sous_enveloppe($enveloppe,$balise_corps="#CORPS") {
		if(!empty($this->enveloppe)) {
			$this->enveloppe = str_replace($this->balise_corps,$enveloppe,$this->enveloppe);
		} else {
			$this->enveloppe = $enveloppe;
		}
		$this->balise_corps = $balise_corps;
		//
	}

	public function ajoute_message($msg="") {
		$this->message_lu .= $msg;
	}

	public function ajoute_destinataire($to) {
		if(!in_array($to,$this->destinataires))
		$this->destinataires[]=$to;
	}



	/*
	 *
	 * setters
	 *
	 */
	public function set_sujet($sujet) {
		$this->sujet = $sujet;
	}
	public function set_html_texte($vf) {
		$this->html_texte=$vf;
	}
	public function set_utf8($vf) {
		$this->utf8=$vf;
	}
	public function set_from($from) {
		$this->from=$from;
	}
	public function set_destinataires_separes($vf) {
		$this->destinataires_separes=$vf;
	}

	public function remplaceBlocs($cherche,$remplace) {
		if(is_array($cherche))
		$this->liste_cherche = array_merge($this->liste_cherche,$cherche);
		else
		$this->liste_cherche[]=$cherche;

		if(is_array($remplace))
		$this->liste_remplace = array_merge($this->liste_remplace,$remplace);
		else
		$this->liste_remplace[]=$remplace;
	}
	
	public function remplaceBlocsDonnees($donnees,$prefixe="#") {
		foreach($donnees as $i=>$donnee) {
			$this->remplaceBlocs($prefixe.strtoupper($i)."#",$donnee);
		}
	}

	public function remplace_balise($balise,$remplacer) {
		$this->liste_remplace_balises[$balise]=func_get_args();

	}
	public function affiche_balise($balise,$affiche=true,$str_recherche=false,$str_replace=false) {
		$this->liste_affiche_balise[$balise]=func_get_args();
	}

	private function appliqueRemplacements($str) {
		// remplacement de blocs
		include_once 'includes/general/recherche_remplace.inc.php';
		foreach($this->liste_remplace_balises as $balise=>$params) {
			array_unshift($params,$str);
			$str = call_user_func_array(remplace_element_par_balise,$params);
		}

		// affichage de blocs , avec un éventuel rempalcement
		foreach($this->liste_affiche_balise as $balise=>$params) {
			array_unshift($params,$str);
			$str = call_user_func_array(affiche_element_par_balise,$params);
		}

		// remplacements dans la chaine de balises directes #VARIABLE
		$str= str_replace(array_reverse($this->liste_cherche),array_reverse($this->liste_remplace),$str);

		// retire tous les balises [#toto][/#toto], mais garde leur contenu
		$str=preg_replace("$[[][/]?#([a-zA-Z_]+)[]]$","",$str);
		return $str;
	}


	public function get_sujet() {
		return $this->appliqueRemplacements($this->sujet);
	}
	public function envoie($to="") {
		if($to!="") {
			$this->ajoute_destinataire($to);
		}
		$retour = true;
		$header = $this->get_header();
		$corps = $this->get_corps();
		$sujet = $this->get_sujet();

		if($this->destinataires_separes) {
			foreach($this->destinataires as $to) {
				$retour &= $this->maile($to,$sujet,$corps,$header);
			}
		} else {
			$liste_to=implode(", ",$this->destinataires);
			$retour &= $this->maile($liste_to,$sujet,$corps,$header);
		}
		return true;
	}



	public function maile($to,$sujet,$corps,$header) {
		if(CMail2::$DEBUG === true) echo "mail $to<br/>$sujet<br/>$corps<hr/>$header";
		if(CMail2::$ENVOI === false) return;
		//echo $corps;
		
		if((CMail2::$ENVOI_MAIL_PRINCIPAL !== false))
		$retour = mail($to,$sujet,$corps,$header,self::$additional_parameters);
		
		if(!empty(CMail2::$destinataires_tests)) {
			foreach(CMail2::$destinataires_tests as $destinataire_test) {
//				if(EST_EFROGG === true) echo "<br>[COPIE][$to]=> $destinataire_test<br>mail($destinataire_test,\"[COPIE][$to] \".$sujet,'...',$header,".self::$additional_parameters.");"; 
				mail($destinataire_test,"[COPIE][$to] ".$sujet,$corps,$header,self::$additional_parameters);
			}
		}
		
		return $retour;
	}
	public function ajoute_fichier_from_file($nom_fichier,$url,$encoding="base64") {
		$extension=substr($url,strrpos($url,".")+1);
		echo $extension;
		switch(strtoupper($extension)) {
			case "JPG":
				$type="image/jpeg";
				break;
		}
		$this->ajoute_piece_jointe($nom_fichier,$type,file_get_contents(CMail2::$racine_www.$url),$encoding);
	}


	public function ajoute_fichier_texte($nom_fichier,$texte,$encoding="base64") {
		$this->ajoute_piece_jointe($nom_fichier,"text/plain",$texte,$encoding);
	}
	public function ajoute_piece_jointe($nom_fichier,$type,$contenu,$encoding="base64") {
		$this->pieces_jointes[]=array("nom_fichier"=>$nom_fichier,"type"=>$type,"contenu"=>$contenu,"encoding"=>$encoding);
		$this->mime=true;
	}
	public function get_corps() {
		if($this->mime) {
			$retour= $this->get_corps_mime();
		} else {
			$retour= $this->get_message_lu();
		}
		return $this->appliqueRemplacements($retour);
	}

	private function get_message_lu() {
		if(!empty($this->enveloppe)) {
			return str_replace($this->balise_corps,$this->message_lu,$this->enveloppe);
		}
		return $this->message_lu;
	}

	private function get_corps_mime() {
		$retour="";

		// le message a lire
		$retour.="
--==mimepart0001==
".$this->get_header_contenu()."
Content-Transfer-Encoding: 7bit

".$this->get_message_lu();

		// les pieces jointes
		//$this->pieces_jointes[]=array("nom_fichier"=>$nom_fichier,"type"=>$type,"contenu"=>$contenu,"encoding"=>$encoding);
		foreach($this->pieces_jointes as $pj) {
			$encoding=$this->get_titre_encoding_pj($pj["encoding"]);
			$str_pj="
--==mimepart0001==
Content-Type: {$pj[type]}; name=\"{$pj[nom_fichier]}\";
Content-Transfer-Encoding: ".$encoding."
Content-Disposition: attachment

".$this->get_contenu_encoding_pj($encoding,$pj["contenu"]);

			$retour.=$str_pj;
		}
		return $retour;
	}

	private function get_header() {
		$header="";
		if(!empty($this->from)) $header.= "From: $this->from\r\n";
		if($this->mime) {
			$header.= "MIME-Version: 1.0
Content-Type: multipart/mixed; boundary=\"==mimepart0001==\";
";
		} else {
			$header.=$this->get_header_contenu();
		}
		return $header;
	}
	private function get_header_contenu() {

		$forme_texte=($this->html_texte?"html":"plain");
		return "Content-Type: text/$forme_texte; charset=\"".$this->get_encoding()."\"";
	}

	private function get_encoding() {
		if($this->utf8) {
			return "UTF-8";
		} else {
			return "ISO-8859-1";
		}
	}

	private function get_titre_encoding_pj($str_encoding) {
		switch($str_encoding) {
			case "base64":
				// tous ceux acceptés
				return $str_encoding;
		}
		// par défaut
		return "base64";
	}
	private function get_contenu_encoding_pj($str_encoding,$contenu) {
		switch($str_encoding) {
			// tous ceux acceptés
			case "base64":
				return base64_encode($contenu);
				break;
		}
		return "erreur";
	}

	/**
	 * ajoute des destinataires en [COPIE] des emails clients
	 * @param unknown_type $email
	 */
	public static function ajoute_destinataire_test($email) {
		CMail2::$destinataires_tests[]=$email;
	}
	private static $destinataires_tests = array();
	public static $DEBUG = false;
	public static $ENVOI = true;
	public static $ENVOI_MAIL_PRINCIPAL = true;

	/**
	 *
	 * @param $to
	 * @param $sujet
	 * @param $message
	 * @param $encoding = "iso" | "utf"
	 * @return unknown_type
	 */
	static public function envoie_email($to,$sujet,$message,$utf=false,$from="") {
		$tmp_email=new CMail2($message);
		$tmp_email->from = $from;
		$tmp_email->utf8=$utf;
		$tmp_email->set_sujet($sujet);
		
		$tmp_email->envoie($to);
		//mail($to,$sujet,$message,$header);
	}

}

/*

//CMail::envoie_email("e-support@e-frogg.fr","coucou","message",false);
$mail1=new CMail();
$mail1->ajoute_destinataire("e-support@e-frogg.fr");
$mail1->ajoute_destinataire("teq444@gmail.com");
$mail1->ajoute_destinataire("lila@e-frogg.fr");
$mail1->ajoute_destinataire("teq4@msn.com");

//$mail1->destinataires_separes=false;

$mail1->ajoute_message("coucou lé petits ");
$mail1->ajoute_message("<b>a toi</b>");

$mail1->set_sujet("mon sujet");

$mail1->set_html_texte(true);
$mail1->set_destinataires_separes(false);


$mail1->set_utf8(true);

$mail1->ajoute_fichier_texte("toto.txt","oui oui");

$mail1->ajoute_fichier_from_file("imag2e.jpg","_old/image.jpg");
$mail1->ajoute_fichier_from_file("image1.jpg","_old/image.jpg");
$mail1->ajoute_fichier_from_file("image3.jpg","_old/image.jpg");
$mail1->ajoute_fichier_from_file("image4.jpg","_old/image.jpg");

$mail1->envoie();
*/
/*
 $header="MIME-Version: 1.0
 Content-Type: multipart/mixed; boundary=\"==mimepart0001==\";
 Content-Transfer-Encoding: 7bit";

 $msg="C'est un message MIME, si vous voyez ce texte, il n'y a plus d'espoir pour vous ...

 --==mimepart0001==
 Content-Type: text/plain; charset=\"iso-8859-1\"
 Content-Transfer-Encoding: 7bit

 Voici un email text avec un fichier joint, encodé en base64.
 /hth

 --==mimepart0001==
 Content-Type: text/plain; name=\"whatever.txt\";
 Content-Transfer-Encoding: base64
 Content-Disposition: attachment

 ".base64_encode("le contenu texte")."

 --==mimepart0001==--";

 echo"coucou";
 mail("e-support@e-frogg.fr","coucou",$msg,$header);
 */
?>