<?php
class TFSelectList extends TFormElement
{
	protected $options;
	
	public function options(Array $options)
	{
		$this->options = $options;
		
		return $this;
	}
	
	public function getHtml()
	{
                $js = "";
                if(!is_null($this->onJS)){
                    foreach($this->onJS as $e => $a){
                        $js .= ' '.$e.'="'.$a.'();" ';
                    }
                }
            
		if(empty($this->options)) return NULL;
		$out = '<label for="'.$this->name.'">'.$this->label.' </label>  <select name="'.$this->name.'" id="'.$this->name.'" '.$this->readOnly.' '.$js.' >'."\n";
		foreach($this->options as $opt=>$opt2)
		{
			if(is_array($opt2))
			{
				$out .= '<optgroup label="'.$opt.'">'."\n";
				foreach($opt2 as $opt=>$value)
				{
					$selected = ($this->defaultChoice == $opt) ? ('selected="selected"') : '';
					$out .= '<option value="'.$value.'" '.$selected.'>'.$opt.'</option>'."\n";
				}
				$out .= '</optgroup>'."\n";
				
			}
			else
			{
				$selected = ($this->defaultChoice == $opt) ? ('selected="selected"') : '';
				$out .= '<option value="'.$opt.'" '.$selected.'>'.$opt2.'</option>'."\n";
			}
		}
		$out .= '</select>'."\n";
		
		return $out;
	}
}