<?php


/*
 * idType :
 * 6  = identification admin
 * 7  = telechargement visiteur
 * 8  = newsletter inscription
 * 9  = newsletter desinscription
 * 10 = inscription client
 * 11 = identification client
 * 12 = action admin
 * 13 = Visiteurs Uniques
 * 14 = chiffre d'affaire
 * 15 = commande moyenne 
 * 16 = nb commandes
 * 17 = etat des commandes
*/

//include_once("includes/general/timer.inc.php");

function compile_stats($verbeux=false)
{
	$duree_exec=min(60,ini_get("max_execution_time")); // secondes


	$timer=time()+microtime();
	$timer_fin=$timer+($duree_exec/2); // la moitiÃ© du temps d'execution, pour laisser le temps de copier le reste du fichier

	
	if($verbeux) print("compile_identification_admin... ");
	flush();
	compile_identification_admin();
	if($verbeux) print("ok<br>");
	if($verbeux) print("compile_telechargement_visiteur... ");
	flush();
	compile_telechargement_visiteur();
	if($verbeux) print("ok<br>");
	if($verbeux) print("compile_newsletter_inscription... ");
	flush();
	compile_newsletter_inscription();
	if($verbeux) print("ok<br>");
	if($verbeux) print("compile_newsletter_desinscription... ");
	flush();
	compile_newsletter_desinscription();
	if($verbeux) print("ok<br>");
	if($verbeux) print("compile_inscription_client... ");
	flush();
	compile_inscription_client();
	if($verbeux) print("ok<br>");
	if($verbeux) print("compile_identification_client... ");
	flush();
	compile_identification_client();
	if($verbeux) print("ok<br>");
	if($verbeux) print("compile_action_admin... ");
	flush();
	compile_action_admin();
	if($verbeux) print("ok<br>");
	if($verbeux) print("compile_chiffre_affaire... ");
	flush();
	compile_chiffre_affaire();
	if($verbeux) print("ok<br>");
	if($verbeux) print("compile_stats_operations... ");
	flush();
	compile_stats_operations();
	if($verbeux) print("ok<br>");
	
	
	if($verbeux) print("compile_generique... <br>");
	if($query_stat=ifReq("SELECT * FROM shop_stats__types WHERE generique=1")) {
		while($res_stat=mysql_fetch_assoc($query_stat)) {
			if($verbeux) print("$res_stat[id_type_vrac]... ");
			flush();
			compile_generique($res_stat["idType"],$res_stat["id_type_vrac"],$res_stat["group_by"]);
			if($verbeux) print("ok<br>");
		}
	}
	

	
	
	$timer=time()+microtime();
	if($timer<$timer_fin) {
		// il reste du temps
		$requ=ifReq('SELECT * FROM (SELECT DISTINCT LEFT(date_stat, 10) AS jour FROM shop_stats__vrac_visites) as t WHERE jour < \''.date('Y-m-d').'\'');
		while($res_date=mysql_fetch_array($requ))
		{
			$timer=time()+microtime();
			if($timer<$timer_fin) {
				if($verbeux) print("compile_visites ".$res_date['jour']."... ");
				flush();
				compile_visites($res_date['jour']);
				if($verbeux) print("ok<br>");
			} else {
				print("délai dépassé !!");
				return;
			}
		}
	}
	ifReq("OPTIMIZE TABLE `shop_stats__vrac` , `shop_stats__vrac_visites` , `shop_requetes_optimisees`  ");
	
}


/*
 * FONCTIONS POUR LA TABLE shop_stats__vrac
 */
function compile_generique($id_type_stat,$type_stat_vrac,$group_by=false) {
	
	$group_by=($group_by==false?"":", $group_by");
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 10) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = '$type_stat_vrac' group by jour $group_by");
	
	while($res=mysql_fetch_array($r))
	{
		$txt = $res['texte'];

		$res2=testReq2("SELECT id FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = $id_type_stat AND date = '".$res['jour']."' and cat1 = '".$txt."'");
		
		//si pas encore de tuple propre, creation
		if($res2 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, cat1, nb)
			       values ($id_type_stat, '".$res['jour']."', ".$GLOBALS['id_boutique'].", '".$txt."', ".$res['total'].")");
		}
		//sinon mise a jour du tuple propre
		else 
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res2['id']);
		}
		
	}
	
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 7) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = '$type_stat_vrac'group by jour $group_by");
	
	while($res=mysql_fetch_array($r))
	{
		$txt = $res['texte'];
		
		$res3=testReq2("SELECT id FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = $id_type_stat AND cumulmois = '".$res['jour']."' and cat1 = '".$txt."'");
		
		//si pas encore de tuple pour le mois, creation
		if($res3 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
			       values ($id_type_stat, '0000-00-00', '".$res['jour']."', ".$GLOBALS['id_boutique'].", '".$txt."', ".$res['total'].")");
		}
		//sinon mise a jour du tuple pour le mois propre
		else
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res3['id']);
		}
	}
	
	//on supprime tous les tuples en vrac
	ifReq("DELETE FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
		  " AND type_stat = '$type_stat_vrac'");	
}
//IDENTIFICATION - ADMIN (idType = 6)
function compile_identification_admin()
{	
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 10) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'identification' AND type_client = 'admin' group by jour, texte");
	
	while($res=mysql_fetch_array($r))
	{
		$txt = $res['texte'];

		$res2=testReq2("SELECT id FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 6 AND date = '".$res['jour']."' and cat1 = '".$txt."'");
		
		//si pas encore de tuple propre, creation
		if($res2 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, cat1, nb)
			       values (6, '".$res['jour']."', ".$GLOBALS['id_boutique'].", '".$txt."', ".$res['total'].")");
		}
		//sinon mise a jour du tuple propre
		else 
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res2['id']);
		}
		
	}
	
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 7) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'identification' AND type_client = 'admin' group by jour, texte");
	
	while($res=mysql_fetch_array($r))
	{
		$txt = $res['texte'];
		
		$res3=testReq2("SELECT id FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 6 AND cumulmois = '".$res['jour']."' and cat1 = '".$txt."'");
		
		//si pas encore de tuple pour le mois, creation
		if($res3 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
			       values (6, '0000-00-00', '".$res['jour']."', ".$GLOBALS['id_boutique'].", '".$txt."', ".$res['total'].")");
		}
		//sinon mise a jour du tuple pour le mois propre
		else
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res3['id']);
		}
	}
	
	//on supprime tous les tuples en vrac
	ifReq("DELETE FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
		  " AND type_stat = 'identification' AND type_client = 'admin'");
}

//TELECHARGEMENT - VISITEUR (idType = 7)
function compile_telechargement_visiteur()
{
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 10) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'telechargement' group by jour, texte");
	
	while($res=mysql_fetch_array($r))
	{
		$txt = $res['texte'];

		$res2=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 7 AND date = '".$res['jour']."' and cat1 = '".$txt."'");
		
		//si pas encore de tuple
		if($res2 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, cat1, nb)
			       values (7, '".$res['jour']."', ".$GLOBALS['id_boutique'].", '".$txt."', ".$res['total'].")");
		}
		//mise a jour du tuple propre
		else
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res2['id']);
		}
	}
	
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 7) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'telechargement' group by jour, texte");

	while($res=mysql_fetch_array($r))
	{
		$txt = $res['texte'];
		
		$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 7 AND cumulmois = '".$res['jour']."' and cat1 = '".$txt."'");
		
		//si pas encore de tuple pour le mois
		if($res3 == false)
		{
				ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
				       values (7, '0000-00-00', '".$res['jour']."', ".$GLOBALS['id_boutique'].", '".$txt."', ".$res['total'].")");
		}
		else
		{
			//mise a jour du tuple pour le mois propre
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res3['id']);
		}	
	}
	//on supprime tous les tuples en vrac
	ifReq("DELETE FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
		  " AND type_stat = 'telechargement'");
}

//NEWSLETTER - INSCRIPTION (idType = 8)
function compile_newsletter_inscription()
{
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 10) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'newsletter' and valeur = 1 group by jour");
	
	while($res=mysql_fetch_array($r))
	{
		$res2=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 8 AND date = '".$res['jour']."'");
		
		//si pas encore de tuple
		if($res2 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, nb)
			       values (8, '".$res['jour']."', ".$GLOBALS['id_boutique'].", ".$res['total'].")");
		}
		//mise a jour du tuple propre
		else
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res2['id']);
		}
	}
	
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 7) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'newsletter' and valeur = 1 group by jour");

	while($res=mysql_fetch_array($r))
	{
		$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 8 AND cumulmois = '".$res['jour']."'");
		
		//si pas encore de tuple pour le mois
		if($res3 == false)
		{
				ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, nb)
				       values (8, '0000-00-00', '".$res['jour']."', ".$GLOBALS['id_boutique'].", ".$res['total'].")");
		}
		else
		{
			//mise a jour du tuple pour le mois propre
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res3['id']);
		}	
	}
	//on supprime tous les tuples en vrac
	ifReq("DELETE FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
		  " AND type_stat = 'newsletter' AND valeur=1");
}

//NEWSLETTER - DESINSCRIPTION (idType = 9)
function compile_newsletter_desinscription()
{
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 10) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'newsletter' and valeur = 0 group by jour");
	
	while($res=mysql_fetch_array($r))
	{
		$res2=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 9 AND date = '".$res['jour']."'");
		
		//si pas encore de tuple
		if($res2 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, nb)
			       values (9, '".$res['jour']."', ".$GLOBALS['id_boutique'].", ".$res['total'].")");
		}
		//mise a jour du tuple propre
		else
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res2['id']);
		}
	}
	
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 7) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'newsletter' and valeur = 0 group by jour");

	while($res=mysql_fetch_array($r))
	{
		$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 9 AND cumulmois = '".$res['jour']."'");
		
		//si pas encore de tuple pour le mois
		if($res3 == false)
		{
				ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, nb)
				       values (9, '0000-00-00', '".$res['jour']."', ".$GLOBALS['id_boutique'].", ".$res['total'].")");
		}
		else
		{
			//mise a jour du tuple pour le mois propre
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res3['id']);
		}	
	}
	//on supprime tous les tuples en vrac
	ifReq("DELETE FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
		  " AND type_stat = 'newsletter' AND valeur=0");
}

//INSCRIPTION - CLIENT (idType = 10)
function compile_inscription_client()
{
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 10) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'inscription' group by jour");
	
	while($res=mysql_fetch_array($r))
	{
		$res2=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 10 AND date = '".$res['jour']."'");
		
		//si pas encore de tuple
		if($res2 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, nb)
			       values (10, '".$res['jour']."', ".$GLOBALS['id_boutique'].", ".$res['total'].")");
		}
		//mise a jour du tuple propre
		else
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res2['id']);
		}
	}
	
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 7) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'inscription' group by jour");

	while($res=mysql_fetch_array($r))
	{
		$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 10 AND cumulmois = '".$res['jour']."'");
		
		//si pas encore de tuple pour le mois
		if($res3 == false)
		{
				ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, nb)
				       values (10, '0000-00-00', '".$res['jour']."', ".$GLOBALS['id_boutique'].", ".$res['total'].")");
		}
		else
		{
			//mise a jour du tuple pour le mois propre
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res3['id']);
		}	
	}
	//on supprime tous les tuples en vrac
	ifReq("DELETE FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
		  " AND type_stat = 'inscription'");
}

//IDENTIFICATION - CLIENT (idType = 11)
function compile_identification_client()
{
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 10) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'identification' AND type_client = 'client' group by jour");
	
	while($res=mysql_fetch_array($r))
	{
		$tmp = explode('-', $res['jour']);
		$mois = $tmp[0].'-'.$tmp[1];

		$res2=testReq2("SELECT id FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 11 AND date = '".$res['jour']."'");
		
		//si pas encore de tuple propre, creation
		if($res2 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, nb)
			       values (11, '".$res['jour']."', ".$GLOBALS['id_boutique'].", ".$res['total'].")");
		}
		//sinon mise a jour du tuple propre
		else 
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res2['id']);
		}
		
	}
	
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 7) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'identification' AND type_client = 'client' group by jour");
	
	while($res=mysql_fetch_array($r))
	{
		$txt = $res['texte'];
		
		$res3=testReq2("SELECT id FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 11 AND cumulmois = '".$res['jour']."'");
		
		//si pas encore de tuple pour le mois, creation
		if($res3 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, nb)
			       values (11, '0000-00-00', '".$res['jour']."', ".$GLOBALS['id_boutique'].", ".$res['total'].")");
		}
		//sinon mise a jour du tuple pour le mois propre
		else
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res3['id']);
		}
	}
	
	//on supprime tous les tuples en vrac
	ifReq("DELETE FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
		  " AND type_stat = 'identification' AND type_client = 'client'");
}

//ACTION - ADMIN (idType = 12)
function compile_action_admin()
{
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 10) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'action' AND type_client = 'admin' group by jour, texte");
	
	while($res=mysql_fetch_array($r))
	{
		$txt = $res['texte'];

		$res2=testReq2("SELECT id FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 12 AND date = '".$res['jour']."' and cat1 = '".$txt."'");
		
		//si pas encore de tuple propre, creation
		if($res2 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, cat1, nb)
			       values (12, '".$res['jour']."', ".$GLOBALS['id_boutique'].", '".$txt."', ".$res['total'].")");
		}
		//sinon mise a jour du tuple propre
		else 
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res2['id']);
		}
		
	}
	
	$r=ifReq("SELECT *,count(nb) AS total, LEFT( date_stat, 7) AS jour FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
			 " AND type_stat = 'action' AND type_client = 'admin' group by jour, texte");
	
	while($res=mysql_fetch_array($r))
	{
		$txt = $res['texte'];
		
		$res3=testReq2("SELECT id FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 12 AND cumulmois = '".$res['jour']."' and cat1 = '".$txt."'");
		
		//si pas encore de tuple pour le mois, creation
		if($res3 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
			       values (12, '0000-00-00', '".$res['jour']."', ".$GLOBALS['id_boutique'].", '".$txt."', ".$res['total'].")");
		}
		//sinon mise a jour du tuple pour le mois propre
		else
		{
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$res['total']." WHERE id=".$res3['id']);
		}
	}
	
	//on supprime tous les tuples en vrac
	ifReq("DELETE FROM shop_stats__vrac WHERE id_boutique=".$GLOBALS['id_boutique'].
		  " AND type_stat = 'action' AND type_client = 'admin'");
}

/*
 * FONCTIONS POUR LA TABLE shop_stats__vrac_visites (idType, 1, 2, 4, 5, 13)
 */

//VISITES - ROBOTS
function compile_visites($hier)
{
	$tabRobots = recup_robots();
	$tabMoteurs = recup_moteurs();
	
	$tabVisitesRobots = array();
	$tabVisitesReferants = array();
	$tabVisitesMotsCles = array();
	
	$nbVisites = 0;
	$nbVisiteurs = 0;
	
	$robotEnCours = '';
	
	$itvVisites = 3600;
	$isRobot = false;
	//$hier = date('Y-m-d', mktime(0,0,0,date('m'),date('d')-1,date('Y')));
	
	$r=ifReq("SELECT * FROM shop_stats__vrac_visites WHERE id_boutique=".$GLOBALS['id_boutique']." AND date_stat >= '".$hier." 00:00:00' AND date_stat <= '".$hier." 23:59:59' ORDER BY IP, date_stat");
	//$r=ifReq("SELECT * FROM shop_stats__vrac_visites WHERE id_boutique=".$GLOBALS['id_boutique']." ORDER BY IP, date_stat");
	
	while($res=mysql_fetch_array($r))
	{
		if($ip != $res['IP'])
		{
			$isRobot = false;
			$ip = $res['IP'];
			$tmp = explode(' ', $res['date_stat']);
			$date2 = explode('-', $tmp[0]);
			$heure2 = explode(':', $tmp[1]);
			$mk1 = mktime($heure2[0], $heure2[1], $heure2[2], $date2[1], $date2[2], $date2[0]);
			
			if (visite_robot($res, $tabRobots, $tabVisitesRobots, $robotEnCours))
			{
				$isRobot = true;
			}
			else
			{
				$isRobot = false;
				teste_provenance($res, $tabMoteurs, $tabVisitesReferants, $tabVisitesMotsCles);
				++$nbVisites;
				++$nbVisiteurs;
			}
		}
		else
		{
			if ($isRobot)
			{
				++$tabVisitesRobots[$robotEnCours];
			}
			$tmp = explode(' ', $res['date_stat']);
			$date = explode('-', $tmp[0]);
			$heure = explode(':', $tmp[1]);
			$mk2 = mktime($heure[0], $heure[1], $heure[2], $date[1], $date[2], $date[0]);
			
			if($mk2-$mk1 > $itvVisites && !$isRobot)
			{
				teste_provenance($res, $tabMoteurs, $tabVisitesReferants, $tabVisitesMotsCles);
				++$nbVisites;
			}
			
			$mk1 = mktime($heure[0], $heure[1], $heure[2], $date[1], $date[2], $date[0]);
		}
	}

	insere_stats_visites($tabVisitesRobots, $tabVisitesReferants, $tabVisitesMotsCles, $nbVisites, $nbVisiteurs, $hier);
}

function visite_robot($res, $robotab, &$visites, &$robotactuel)
{
	$orthsRobot = array('robot', 'ROBOT', 'Robot');
	$orthsBot = array('bot', 'BOT', 'Bot');
	$orthsCrawl = array('crawl', 'CRAWL', 'Crawl');
	$orthsSpider = array('spider', 'SPIDER', 'Spider');
	$orthsHtml = array('.html', '.htm');
	$orthsAutre = array('Yahoo! Slurp', 'Yandex', 'wauuu', 'libwww-perl');
	
	//Robots reconnus par la base
	for($j = 0; $j < count($robotab); $j++)
	{
		if($res['ip1'] != '')
		{
			if(substr_count(long2ip($res['IP']), $robotab[$j]['ip1']) > 0)
			{
				if(isset($visites[$robotab[$j]['nom']])) ++$visites[$robotab[$j]['nom']];
				else $visites[$robotab[$j]['nom']] = 1;
				$robotactuel = $robotab[$j]['nom'];
				return true;
			}
		}
		if($res['ip2'] != '')
		{
			if(substr_count(long2ip($res['IP']), $robotab[$j]['ip2']) > 0)
			{
				if(isset($visites[$robotab[$j]['nom']])) ++$visites[$robotab[$j]['nom']];
				else $visites[$robotab[$j]['nom']] = 1;
				$robotactuel = $robotab[$j]['nom'];
				return true;
			}
		}
		if($res['user_agent'] != '')
		{
			
			if(substr_count($res['user_agent'], $robotab[$j]['user_agent']) > 0)
			{
				if(isset($visites[$robotab[$j]['nom']])) ++$visites[$robotab[$j]['nom']];
				else $visites[$robotab[$j]['nom']] = 1;
				$robotactuel = $robotab[$j]['nom'];
				return true;
			}
		}
	}
	
	//Autres robots
	for ($i = 0; $i < count($orthsRobot); $i++)
	if(substr_count($res['user_agent'], $orthsRobot[$i]) > 0)
	{
		if(isset($visites['Autres'])) ++$visites['Autres'];
		else $visites['Autres'] = 1;
		$robotactuel = 'Autres';
		return true;
	}
	for ($i = 0; $i < count($orthsBot); $i++)
	if(substr_count($res['user_agent'], $orthsBot[$i]) > 0)
	{
		if(isset($visites['Autres'])) ++$visites['Autres'];
		else $visites['Autres'] = 1;
		$robotactuel = 'Autres';
		return true;
	}
	for ($i = 0; $i < count($orthsCrawl); $i++)
	if(substr_count($res['user_agent'], $orthsCrawl[$i]) > 0)
	{
		if(isset($visites['Autres'])) ++$visites['Autres'];
		else $visites['Autres'] = 1;
		$robotactuel = 'Autres';
		return true;
	}
	for ($i = 0; $i < count($orthsSpider); $i++)
	if(substr_count($res['user_agent'], $orthsSpider[$i]) > 0)
	{
		if(isset($visites['Autres'])) ++$visites['Autres'];
		else $visites['Autres'] = 1;
		$robotactuel = 'Autres';
		return true;
	}		
	for ($i = 0; $i < count($orthsHtml); $i++)
	if(substr_count($res['user_agent'], $orthsHtml[$i]) > 0)
	{
		if(isset($visites['Autres'])) ++$visites['Autres'];
		else $visites['Autres'] = 1;
		$robotactuel = 'Autres';
		return true;
	}
	for ($i = 0; $i < count($orthsAutre); $i++)
	if(substr_count($res['user_agent'], $orthsAutre[$i]) > 0)
	{
		if(isset($visites['Autres'])) ++$visites['Autres'];
		else $visites['Autres'] = 1;
		$robotactuel = 'Autres';
		return true;
	}
	return false;
}

function teste_provenance($res, $moteurtab, &$tabreferants, &$tabmotscles)
{
	if($res['referer'] != '')
	{
		//Provenance : moteur de recherche
		for($j = 0; $j < count($moteurtab); $j++)
		{
			if(substr_count($res['referer'], $moteurtab[$j]['nom']) > 0)
			{
				$aVirer = array('+', '"', '\'', '^', '`', '*', '#');
				
				if(isset($tabreferants[$moteurtab[$j]['nom_affich']])) ++$tabreferants[$moteurtab[$j]['nom_affich']];
				else $tabreferants[$moteurtab[$j]['nom_affich']] = 1;
				
				$tmpua = explode($moteurtab[$j]['tag_requete'], $res['referer']);
				if ($moteurtab[$j]['tag_fin_requete'] != '')
				{
					$tmpua2 = explode($moteurtab[$j]['tag_fin_requete'], $tmpua[1]);
					$la_recherche = $tmpua2[0];
				}
				else $la_recherche = $tmpua[1];
				
				$la_recherche = str_replace($aVirer, '', trim(urldecode($la_recherche)));
    			$la_recherche = utf8_decode($la_recherche);
    			$la_recherche = strtolower($la_recherche);
    			$la_recherche = utf8_encode($la_recherche);
    			$la_recherche = str_replace('?', '', $la_recherche);
    			$la_recherche = rtrim($la_recherche, "./");
    			
				if ($la_recherche != '' && strlen($la_recherche) > 1 && !is_numeric($la_recherche))
				{
					if(isset($tabmotscles[$la_recherche])) ++$tabmotscles[$la_recherche];
					else $tabmotscles[$la_recherche] = 1;
				}
				
				return;
			}
		}
		//Provenance : site referant
		if(isset($tabreferants['site_referent'])) ++$tabreferants['site_referent'];
		else $tabreferants['site_referent'] = 1;
	}
	//Provenance : acces direct
	else
	{
		if(isset($tabreferants['acces_direct'])) ++$tabreferants['acces_direct'];
		else $tabreferants['acces_direct'] = 1;
	}
}

function recup_robots()
{
	$lr=ifReq("SELECT ip1, ip2, user_agent, nom FROM shop_stats__robots");
	$tab= array();
	while($lres=mysql_fetch_assoc($lr))
	{
		$tab[] = $lres;
	}	
	return $tab;
}

function recup_moteurs()
{
	$lr=ifReq("SELECT nom, nom_affich, tag_requete, tag_fin_requete FROM shop_stats__moteurs");
	$tab= array();
	while($lres=mysql_fetch_assoc($lr))
	{
		$tab[] = $lres;
	}	
	return $tab;
}

function insere_stats_visites($robots, $referants, $motscles, $nbvisites, $nbvisiteurs, $date)
{

	$tmp = explode('-', $date);
	$mois = $tmp[0].'-'.$tmp[1];
	
	//PAGES VUES - ROBOTS (idType = 4)
	while ($case = current($robots))
	{
    	ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, cat1, nb)
			   values (4, '".$date."', ".$GLOBALS['id_boutique'].", '".key($robots)."', ".current($robots).")");
    	
    	$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 4 AND cumulmois = '".$mois."' and cat1 = '".key($robots)."'");
		
		if($res3 == false)
		{
				ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
				       values (4, '0000-00-00', '".$mois."', ".$GLOBALS['id_boutique'].", '".key($robots)."', ".current($robots).")");
		}
		else
		{
			//mise a jour du tuple pour le mois propre
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".current($robots)." WHERE id=".$res3['id']);
		}	
    	
    	next($robots);
	}
	
	while ($case = current($referants))
	{
		//VISITES - SITES REFERANTS (idType = 1)
		if (key($referants) == 'site_referent')
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, cat1, nb)
				   values (1, '".$date."', ".$GLOBALS['id_boutique'].", 'Sites referents', ".current($referants).")");
			
			$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
						   " AND idType = 1 AND cumulmois = '".$mois."' and cat1 = 'Sites referents'");
			
			if($res3 == false)
			{
					ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
					       values (1, '0000-00-00', '".$mois."', ".$GLOBALS['id_boutique'].", 'Sites referents', ".current($referants).")");
			}
			else
			{
				//mise a jour du tuple pour le mois propre
				ifReq("UPDATE shop_stats__compilees SET nb = nb+".current($referants)." WHERE id=".$res3['id']);
			}
			
	    	next($referants);
		}
		
		//VISITES - ACCES DIRECTS (idType = 1)
		if (key($referants) == 'acces_direct')
		{
	    	ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, cat1, nb)
				   values (1, '".$date."', ".$GLOBALS['id_boutique'].", 'Acces directs', ".current($referants).")");
	    	
			$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
						   " AND idType = 1 AND cumulmois = '".$mois."' and cat1 = 'Acces directs'");
			
			if($res3 == false)
			{
					ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
					       values (1, '0000-00-00', '".$mois."', ".$GLOBALS['id_boutique'].", 'Acces directs', ".current($referants).")");
			}
			else
			{
				//mise a jour du tuple pour le mois propre
				ifReq("UPDATE shop_stats__compilees SET nb = nb+".current($referants)." WHERE id=".$res3['id']);
			}
	    	
	    	next($referants);
		}
		
		//MOTEURS - LISTE(idType = 5)
		else
		{
	    	ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, cat1, nb)
				   values (5, '".$date."', ".$GLOBALS['id_boutique'].", '".key($referants)."', ".current($referants).")");
	    	
			$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
						   " AND idType = 5 AND cumulmois = '".$mois."' and cat1 = '".key($referants)."'");
			
			if($res3 == false)
			{
					ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
					       values (5, '0000-00-00', '".$mois."', ".$GLOBALS['id_boutique'].", '".key($referants)."', ".current($referants).")");
			}
			else
			{
				//mise a jour du tuple pour le mois propre
				ifReq("UPDATE shop_stats__compilees SET nb = nb+".current($referants)." WHERE id=".$res3['id']);
			}
	    	next($referants);
		}
	}

	$nbvm = $nbvisites - $referants['acces_direct'] - $referants['site_referent'];
	
	//VISITEURS - UNIQUES (idType = 13)
	ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, nb)
		   values (13, '".$date."', ".$GLOBALS['id_boutique'].", ".$nbvisiteurs.")");
	
	$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
				   " AND idType = 13 AND cumulmois = '".$mois."'");
			
	if($res3 == false)
	{
		ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, nb)
			   values (13, '0000-00-00', '".$mois."', ".$GLOBALS['id_boutique'].", ".$nbvisiteurs.")");
	}
	else
	{
		//mise a jour du tuple pour le mois propre
		ifReq("UPDATE shop_stats__compilees SET nb = nb+".$nbvisiteurs." WHERE id=".$res3['id']);
	}
	
	//VISITES - MOTEURS (idType = 1)
	if ($nbvm > 0)
	{
		ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, cat1, nb)
			   values (1, '".$date."', ".$GLOBALS['id_boutique'].", 'Moteurs de recherche', ".$nbvm.")");
		
		$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 1 AND cumulmois = '".$mois."' AND cat1 = 'Moteurs de recherche'");
				
		if($res3 == false)
		{
			ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
				   values (1, '0000-00-00', '".$mois."', ".$GLOBALS['id_boutique'].", 'Moteurs de recherche', ".$nbvm.")");
		}
		else
		{
			//mise a jour du tuple pour le mois propre
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".$nbvm." WHERE id=".$res3['id']);
		}
	}
	
	while ($case = current($motscles))
	{
		
		//MOTEURS - MOTS CLES (idType = 2)
		ifReq("INSERT INTO shop_stats__compilees (idType, date, id_boutique, cat1, nb)
			   values (2, '".$date."', ".$GLOBALS['id_boutique'].", '".key($motscles)."', ".current($motscles).")");
		
		$res3=testReq2("SELECT * FROM shop_stats__compilees WHERE id_boutique=".$GLOBALS['id_boutique'].
					   " AND idType = 2 AND cumulmois = '".$mois."' and cat1 = '".key($motscles)."'");
		
		if($res3 == false)
		{
				ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
				       values (2, '0000-00-00', '".$mois."', ".$GLOBALS['id_boutique'].", '".key($motscles)."', ".current($motscles).")");
		}
		else
		{
			//mise a jour du tuple pour le mois propre
			ifReq("UPDATE shop_stats__compilees SET nb = nb+".current($motscles)." WHERE id=".$res3['id']);
		}
    	next($motscles);
	}
	
	ifReq("DELETE FROM shop_stats__vrac_visites WHERE date_stat LIKE '".$date."%'");
	
}

function compile_chiffre_affaire() {
	ifReq("DELETE FROM shop_stats__compilees WHERE idType IN (14,15,16,17)");
	/*
	 * 14 = chiffre d'affaire
	 * 15 = commande moyenne 
	 * 16 = nb commandes
	*/
	
	/* 
	 * TERMINEE
	 * VALIDEE
	 * EN_PREPARATION
	 * EXPEDIEE
	 * 
	 * ANNULEE
	 * REFUSEE
	 * 
	 * ABANDONNEE
	 * 
	 * ATTENTE_PAIEMENT
	 * VERIFIER
	 * CONTACTER
	 * PAYEE
*/
	$tab_etats=array("validees"=>"'TERMINEE','VALIDEE','EN_PREPARATION','EXPEDIEE'",
				"annulees"=>"'ANNULEE','REFUSEE'",
				"abandonees"=>"'ABANDONNEE'",
				"attente"=>"'ATTENTE_PAIEMENT','VERIFIER','CONTACTER','PAYEE'");
	
	/*
	 * jour par jour 
	 */
	foreach($tab_etats as $etat=>$liste_etats) {
		if($query_total=ifReq("SELECT sum(total) as total,count(total) AS nombre,AVG(total) AS moyenne, jour 
			FROM (
				SELECT *,LEFT(date_commande, 10) AS jour  FROM `shop_commandes`
				WHERE etat IN($liste_etats)
			) as new_table GROUP BY jour ORDER BY jour")) {
			while($res=mysql_fetch_array($query_total,MYSQL_ASSOC )) {
			//	print_r($res);
			//	print(" $etat <br>");
				$insert_CA="";
				if($etat=="validees") {
//					$insert_CA="(14, '$res[jour]', '', ".$GLOBALS['id_boutique'].", '$res[source]', ".$res["total"]."),
			   		$insert_CA="(15, '$res[jour]', '', ".$GLOBALS['id_boutique'].", '$etat', ".$res["moyenne"]."),
			   		(16, '$res[jour]', '', ".$GLOBALS['id_boutique'].", '$etat', ".$res["nombre"]."),
			   		";
				}
				ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
					   values 
					   		$insert_CA
							(17, '$res[jour]', '', ".$GLOBALS['id_boutique'].", '$etat', ".$res["nombre"].")
					   		");
			}
		}
		
		//AJOUT POLO 17/08/2010
		//bloc du dessus simplifié, il fallait refaire la requete juste pour la stat 14 avec un GROUP BY source
		///////////////////////
		if($etat=="validees")
		if($query_total=ifReq("SELECT sum(total) as total,count(total) AS nombre,AVG(total) AS moyenne, jour, source 
			FROM (
				SELECT *,LEFT(date_commande, 10) AS jour  FROM `shop_commandes`
				WHERE etat IN($liste_etats)
			) as new_table GROUP BY jour, source ORDER BY jour")) {
			while($res=mysql_fetch_array($query_total,MYSQL_ASSOC )) {
				if ($res['source'] == '') $res["source"] = 'n/a';
				
				
					ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
					   values 
							(14, '$res[jour]', '', ".$GLOBALS['id_boutique'].", '$res[source]', ".$res["total"].")
					   		");
				
				
			}
		}
		///////////////////////
		
	}
	/*
	 * mois par mois
	 */
	foreach($tab_etats as $etat=>$liste_etats) {
		//print("<br>$etat => $liste_etats <br>");
		if($query_total=ifReq("SELECT sum(total) as total,count(total) AS nombre,AVG(total) AS moyenne, mois 
			FROM (
				SELECT *,LEFT(date_commande, 7) AS mois  FROM `shop_commandes`
				WHERE etat IN($liste_etats)
			) as new_table GROUP BY mois ORDER BY mois")) {
			while($res=mysql_fetch_array($query_total,MYSQL_ASSOC )) {
			//	print_r($res);
			//	print(" $etat <br>");
				$insert_CA="";
				if($etat=="validees") {
					//$insert_CA="(14, '0000-00-00', '$res[mois]', ".$GLOBALS['id_boutique'].", '', ".$res["total"]."),
					$insert_CA="(15, '0000-00-00', '$res[mois]', ".$GLOBALS['id_boutique'].", '$etat', ".$res["moyenne"]."),
			   		(16, '0000-00-00', '$res[mois]', ".$GLOBALS['id_boutique'].", '$etat', ".$res["nombre"]."),";
				}
				ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
					   values 
					   		$insert_CA
					   		(17, '0000-00-00', '$res[mois]', ".$GLOBALS['id_boutique'].", '$etat', ".$res["nombre"].")
					   ");
			}
		}
		
		//AJOUT POLO 01/12/2010 (qui aurait du être fait comme l'autre le 17/08/2010 !)
		//bloc du dessus simplifié, il fallait refaire la requete juste pour la stat 14 avec un GROUP BY source
		///////////////////////
		if($etat=="validees")
		if($query_total=ifReq("SELECT sum(total) as total,count(total) AS nombre,AVG(total) AS moyenne, mois, source
			FROM (
				SELECT *,LEFT(date_commande, 7) AS mois  FROM `shop_commandes`
				WHERE etat IN($liste_etats)
			) as new_table GROUP BY mois, source ORDER BY mois")) {
			while($res=mysql_fetch_array($query_total,MYSQL_ASSOC )) {
			//	print_r($res);
			//	print(" $etat <br>");
				if ($res['source'] == '') $res["source"] = 'n/a';
				
					ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
					   values 
							(14, '0000-00-00', '$res[mois]', ".$GLOBALS['id_boutique'].", '$res[source]', ".$res["total"].")
					   		");
				

			}
		}
	}
}


//AJOUT POLO 01/12/2010 : stats operations (promos)
function compile_stats_operations() {
	ifReq("DELETE FROM shop_stats__compilees WHERE idType IN (18,19)");
	/*
	 * 18 = chiffre d'affaire / operation promo
	 * 19 = nb commandes / operation promo
	*/
	
	/* 
	 * TERMINEE
	 * VALIDEE
	 * EN_PREPARATION
	 * EXPEDIEE
*/
	global $langue_defaut;
	
	$tabOPS = array();
	if ($qOPS = ifReq("SELECT id, get_traduction(titre,1,(SELECT id FROM shop_ml_langues WHERE drapeau = '$langue_defaut')) as titre_op FROM shop_operations")) {
		$tabOPS = array();
		while($resOPS=mysql_fetch_array($qOPS,MYSQL_ASSOC )) {
			$tabOPS[$resOPS['id']] = $resOPS['titre_op'];
		}
		$tabOPS[0] = 'n/a';
	}
	else $tabOPS[0] = 'n/a';
	
//	$tab_etats=array("validees"=>"'TERMINEE','VALIDEE','EN_PREPARATION','EXPEDIEE'",
//				"annulees"=>"'ANNULEE','REFUSEE'",
//				"abandonees"=>"'ABANDONNEE'",
//				"attente"=>"'ATTENTE_PAIEMENT','VERIFIER','CONTACTER','PAYEE'");
	
	$str_etatOK = "'TERMINEE','VALIDEE','EN_PREPARATION','EXPEDIEE'";
	
	if($query_total=ifReq("SELECT sum(total) as total,count(total) AS nombre,AVG(total) AS moyenne, jour, IFNULL(id_operation,0) AS id_op
		FROM (
			SELECT *,LEFT(date_commande, 10) AS jour  FROM `shop_commandes`
			WHERE etat IN($str_etatOK)
		) as new_table 
		LEFT JOIN `shop_commandes_bons` ON shop_commandes_bons.id_commande = new_table.id
		GROUP BY jour, id_op ORDER BY jour")) {
		while($res=mysql_fetch_array($query_total,MYSQL_ASSOC )) {
			//if ($res['source'] == '') $res["source"] = 'n/a';
			$res['id_op'] = $tabOPS[$res['id_op']];
			
			ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
			   values 
					(18, '$res[jour]', '', ".$GLOBALS['id_boutique'].", '$res[id_op]', ".$res["total"]."), 
					(19, '$res[jour]', '', ".$GLOBALS['id_boutique'].", '$res[id_op]', ".$res["nombre"].")
			   		");
			
		}
	}

	/*
	 * mois par mois
	 */
	
	if($query_total=ifReq("SELECT sum(total) as total,count(total) AS nombre,AVG(total) AS moyenne, mois, IFNULL(id_operation,0) AS id_op
		FROM (
			SELECT *,LEFT(date_commande, 7) AS mois  FROM `shop_commandes`
			WHERE etat IN($str_etatOK)
		) as new_table 
		LEFT JOIN `shop_commandes_bons` ON shop_commandes_bons.id_commande = new_table.id
		GROUP BY mois, id_op ORDER BY mois")) {
		while($res=mysql_fetch_array($query_total,MYSQL_ASSOC )) {
			//if ($res['source'] == '') $res["source"] = 'n/a';
			$res['id_op'] = $tabOPS[$res['id_op']];
			
			ifReq("INSERT INTO shop_stats__compilees (idType, date, cumulmois, id_boutique, cat1, nb)
			   values 
					(18, '0000-00-00', '$res[mois]', ".$GLOBALS['id_boutique'].", '$res[id_op]', ".$res["total"]."), 
					(19, '0000-00-00', '$res[mois]', ".$GLOBALS['id_boutique'].", '$res[id_op]', ".$res["nombre"].")
			   		");
			
		}
	}
	
}
?>