<?php
include_once("includes/html/mots_cles.inc.php"); 
include_once("includes/html/classes/Cpage_html.class.php");
include_once("includes/html/classes/Cpage_html_panier.class.php");
include_once("includes/general/recherche_remplace.inc.php");

class Cpage_html_article extends Cpage_html {
	var $Cpage_html;
	var $vendable;
	var $res_meta;
	var $id_article;
	function Cpage_html_article() 
	{
		global $chemin_detaille,$id_boutique,$id_langue;
		
		parent::Cpage_html();
		
		$this->type="article";
		
		///////////////////////////////////////////////////MODIFICATION JM//////////////////////////////////////////////////////////////////////
		
		//Thickbox (ajout au panier)
		$this->ajoute_JS("thickbox.js"); 
		$this->ajoute_CSS("thickbox.css");
		
		//Script pour la gestion des déclinaisons
		if(get_option("HTML_fa_declinaison"))
			$this->ajoute_JS("declinaison.js"); 
		
		//Scripts pour la gestion de la galerie
		if(get_option("HTML_fa_galerie"))
		{
			$this->ajoute_JS("galerie.js");
			$this->ajoute_JS("carroussel.js");
		}
		
		
		//Fiche article normale
		if(strcmp(get_option("HTML_struct_fa"), "Normale") == 0)
		{
			$this->ajoute_CSS("fa_normal.css");
		}
		
		//Fiche article avec des onglets
		if(strcmp(get_option("HTML_struct_fa"), "Onglets") == 0)
		{
			$this->ajoute_CSS("onglet.css");
			$this->ajoute_CSS("fa_onglet.css");
			$this->ajoute_JS("jquery-ui-core.js");
			$this->ajoute_JS("jquery-ui-tabs.js");
			$this->ajoute_JS("onglets.js");
		}
		
		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		
		//////////////////
		// préparation des variables pour les metas
		$this->vendable=est_vendable($chemin_detaille["article"]["vendable"]);
		if($this->vendable) {
			$this->options_ref=get_options_array("REF_ART_VTE_");
		} else {
			$this->options_ref=get_options_array("REF_ART_SSVTE_");
		}
		$this->id_article=$chemin_detaille["article"]["id"];
		$this->res_meta=testReq2("SELECT get_traduction(nom,$id_boutique,$id_langue) AS nom, reference, get_nom_marque(id_marque) AS marque, get_nom_type(id_type, $id_boutique,$id_langue) AS type,  get_traduction(description,$id_boutique,$id_langue) AS description FROM shop_articles WHERE id=".$this->id_article);
		//////////////////////
	}
	//
	function get_optim() {
		$this->nom_optim="page_html";
		$this->id_optim=$this->id_article;
		$this->params_optim="article";
		$this->duree_optim="1 HOUR";
		$this->niv_optim=2;
		return true;
	}
	
	function getTitre() {
		$retour=str_replace_variables(array_keys($this->res_meta),$this->res_meta,$this->options_ref["f_titre"]);
		return $retour;
	}
	
	function getDescription() {
		$retour=str_replace_variables(array_keys($this->res_meta),$this->res_meta,$this->options_ref["f_desc"]);
		return $retour;
	}
	function getKeywords() {
		$retour=str_replace_variables(array_keys($this->res_meta),$this->res_meta,$this->options_ref["f_keyword"]);
		// les mots clés perso de la famille

		global $chemin_detaille;
		$retour.=", ".trad_get_from_id($chemin_detaille["article"]["mots_cles"]);
		$retour.=",".$this->decoupe_keywords($retour);

		return $retour;
		
		// ancienne m�thode, mixeur de mots cl�s
		
		
		global $chemin_detaille;
		require_once("includes/html/articles.inc.php");
		$article_detaille=ART_detaille($chemin_detaille["article"]["id"]);
		$options_kw=get_options_array("REF_KW_fam_");
		$liste_n1=array();
		$liste_n2=array();
		$liste_n3=array();
		if($options_kw["imp_def"]>0) {
			//array_push(${"liste_n".$options_kw["imp_def"]},get_option("REF_mots_cles")); 
		}
		if($options_kw["imp_nom"]>0) {
			array_push(${"liste_n".$options_kw["imp_nom"]},"$article_detaille[nom],$article_detaille[reference]"); 
		}
		if($options_kw["imp_perso"]>0) {
			//array_push(${"liste_n".$options_kw["imp_perso"]},$chemin_detaille["perso_categorie"]["mots_cles"]); 
			// pas encore de mots cl�s perso par article
		}
		if($options_kw["imp_marque"]>0) {
			array_push(${"liste_n".$options_kw["imp_marque"]},$article_detaille["marque"]); 
		}
		if($options_kw["imp_supp"]>0) {
			array_push(${"liste_n".$options_kw["imp_supp"]},$options_kw["supp"]); 
		}
		if($options_kw["imp_type"]>0) {
			array_push(${"liste_n".$options_kw["imp_type"]},$article_detaille["type"]); 
		}
		return genere_mots_cles(implode(",",$liste_n3),implode(",",$liste_n2),implode(",",$liste_n1));
		// + mots cles article ?
		/*global $chemin_detaille;
		require_once("includes/html/articles.inc.php");
		$article_detaille=ART_detaille($chemin_detaille["article"]["id"]);
		return $article_detaille["nom"].", ".$article_detaille["type"].", ".$article_detaille["marque"].", ".$article_detaille["reference"];*/
	}
	function getUrlAttendue() {
		global $chemin_detaille,$langue_defaut;
		if($chemin_detaille["langue"]["active"]==="0") {
			include_once("includes/html/url.inc.php");
			if(change_langue_tempo_drapeau($langue_defaut)) {
				return get_lien_article_from_id($chemin_detaille["article"]["id"]);
			} else {
				return "/";
			}
		}
		
		include_once("includes/html/url.inc.php");
		if($chemin_detaille["article"]["actif"]!=1) {
			// l'article n'est pas actif.
			// 1 - on cherche la famille visible (au cas ou il soit dans la corbeille)
			// 2 - on redirige vers la famille en question
			return get_lien_famille_from_id(get_id_famille_article_visible($chemin_detaille["article"]));
		}
		$retour=get_lien_article_from_res($chemin_detaille["article"]);
		return $retour;
	}
	function getContenuPage() {
		require_once("includes/html/articles.inc.php");
	
		global $chemin_detaille;
		$res_article=$chemin_detaille["article"];
		
		
		
		//////////////////////////////////////////////////////////MODIFICATION JM////////////////////////////////////////////////////////////////
		if(strcmp(get_option("HTML_struct_fa"), "Normale") == 0)
			$contenu = file_get_contents_boutique_ML("html_fichiers/fiche_artiche.contenu.htm");
		else
			if(strcmp(get_option("HTML_struct_fa"), "Onglets") == 0)
				$contenu = file_get_contents_boutique_ML("html_fichiers/fiche_artiche_onglet.contenu.htm");
		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		$contenu = str_replace("#LARGEUR_FICHE","100%",$contenu);
		
		$contenu_chemin = "";
		if(get_option("HTML_fa_chemin"))
		{
			$contenu_chemin = recherche_element_par_balise($contenu, "LE_CHEMIN");
			$contenu_chemin = str_replace("#CHEMIN", get_chemin_navigation_html_article($res_article," > "), $contenu_chemin);
		}
		$contenu = remplace_element_par_balise($contenu, "LE_CHEMIN", $contenu_chemin); 

		$contenu=ART_HTML_remplit_fiche($contenu,$res_article,false,"<br>");

		
		
		//////////////////////////////////////////////////////////MODIFICATION JM////////////////////////////////////////////////////////////////
		

		/*POUR LE PANIER
		 
		 if (!isset($_SESSION['panier'])) 
		{
			echo "le if<br />";
			session_register("panier");
			$var = new Cpage_html_panier();
		}
		else 
		{
			echo "le else<br />";
			$var = unserialize($_SESSION['panier']);
		}
		
		$var->tab_article[$res_article['id']]['ref'] = $res_article['reference'];
		$var->tab_article[$res_article['id']]['nom'] = $res_article['nom'];
		$var->tab_article[$res_article['id']]['prix'] = $res_article['prix'];
		
		
		
		$_SESSION['panier'] = serialize($var);	
		echo $_SESSION['panier']."<br />";
		
		//print_rr($GLOBALS);*/
		
		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		return $contenu;
	}
}
?>